/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.village.fletching;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import shadows.apotheosis.village.VillageModule;

public class FletchingRecipe
implements IRecipe<CraftingInventory> {
    protected final ResourceLocation id;
    protected final ItemStack output;
    protected final List<Ingredient> inputs = NonNullList.func_191197_a((int)3, (Object)Ingredient.field_193370_a);

    public FletchingRecipe(ResourceLocation id, ItemStack output, List<Ingredient> inputs) {
        this.id = id;
        this.output = output;
        for (int i = 0; i < Math.min(3, inputs.size()); ++i) {
            this.inputs.set(i, inputs.get(i));
        }
    }

    public boolean matches(CraftingInventory inv, World world) {
        for (int i = 0; i < 3; ++i) {
            if (this.inputs.get(i).test(inv.func_70301_a(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width == 1 && height == 3;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return VillageModule.FLETCHING_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return VillageModule.FLETCHING;
    }

    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FletchingRecipe> {
        public static final ResourceLocation NAME = new ResourceLocation("apotheosis", "fletching");

        public FletchingRecipe read(ResourceLocation recipeId, JsonObject json) {
            NonNullList<Ingredient> nonnulllist = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for fletching recipe");
            }
            if (nonnulllist.size() > 3) {
                throw new JsonParseException("Too many ingredients for fletching recipe, max 3");
            }
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new FletchingRecipe(recipeId, itemstack, (List<Ingredient>)nonnulllist);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public FletchingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)3, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new FletchingRecipe(recipeId, itemstack, (List<Ingredient>)nonnulllist);
        }

        public void write(PacketBuffer buffer, FletchingRecipe recipe) {
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.output);
        }
    }
}

