/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.village.fletching.arrows;

import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.util.BlockUtil;

public class MiningArrowEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    protected int blocksBroken = 0;
    protected UUID playerId = null;
    protected ItemStack breakerItem = ItemStack.field_190927_a;
    protected Type field_200606_g = Type.IRON;

    public MiningArrowEntity(EntityType<? extends AbstractArrowEntity> t, World world) {
        super(t, world);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
    }

    public MiningArrowEntity(World world) {
        this(ApotheosisObjects.MN_ARROW_ENTITY, world);
    }

    public MiningArrowEntity(LivingEntity shooter, World world, ItemStack breakerItem, Type type) {
        super(ApotheosisObjects.MN_ARROW_ENTITY, shooter, world);
        this.breakerItem = breakerItem;
        this.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
        this.field_200606_g = type;
        this.playerId = shooter.func_110124_au();
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
        boolean noClip = this.func_203047_q();
        Vector3d motion = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)MiningArrowEntity.func_213296_b((Vector3d)motion));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)motion.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = this.func_233580_cy_())).isAir((IBlockReader)this.field_70170_p, blockpos) || noClip || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            Vector3d vector3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vector3d1)) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70254_i) {
            this.func_70106_y();
        } else {
            BlockRayTraceResult traceResult;
            this.field_184552_b = 0;
            Vector3d pos = this.func_213303_ch();
            Vector3d posNextTick = pos.func_178787_e(motion);
            int iterations = 0;
            while (!this.field_70170_p.field_72995_K && this.func_70089_S() && (traceResult = this.field_70170_p.func_217299_a(new RayTraceContext(pos, posNextTick, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this))).func_216346_c() != RayTraceResult.Type.MISS) {
                if (traceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    this.func_70227_a((RayTraceResult)traceResult);
                }
                if (iterations++ <= 10) continue;
                break;
            }
            motion = this.func_213322_ci();
            double velX = motion.field_72450_a;
            double velY = motion.field_72448_b;
            double velZ = motion.field_72449_c;
            if (this.func_70241_g()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_() + velX * (double)i / 4.0, this.func_226278_cu_() + velY * (double)i / 4.0, this.func_226281_cx_() + velZ * (double)i / 4.0, -velX, -velY + 0.2, -velZ);
                }
            }
            double nextTickX = this.func_226277_ct_() + velX;
            double nextTickY = this.func_226278_cu_() + velY;
            double nextTickZ = this.func_226281_cx_() + velZ;
            float f1 = MathHelper.func_76133_a((double)MiningArrowEntity.func_213296_b((Vector3d)motion));
            this.field_70177_z = noClip ? (float)(MathHelper.func_181159_b((double)(-velX), (double)(-velZ)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)velX, (double)velZ) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)velY, (double)f1) * 57.2957763671875);
            this.field_70125_A = MiningArrowEntity.func_234614_e_((float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = MiningArrowEntity.func_234614_e_((float)this.field_70126_B, (float)this.field_70177_z);
            float f2 = 0.99f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, nextTickX - velX * 0.25, nextTickY - velY * 0.25, nextTickZ - velZ * 0.25, velX, velY, velZ);
                }
                f2 = this.func_203044_p();
            }
            this.func_213317_d(motion.func_186678_a((double)f2));
            if (!this.func_189652_ae() && !noClip) {
                Vector3d vector3d4 = this.func_213322_ci();
                this.func_213293_j(vector3d4.field_72450_a, vector3d4.field_72448_b - (double)0.05f, vector3d4.field_72449_c);
            }
            this.func_70107_b(nextTickX, nextTickY, nextTickZ);
        }
    }

    protected void func_230299_a_(BlockRayTraceResult res) {
        this.breakBlock(res.func_216350_a());
    }

    public boolean func_189652_ae() {
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("blocks_broken", this.blocksBroken);
        if (this.playerId != null) {
            compound.func_186854_a("player_id", this.playerId);
        }
        compound.func_218657_a("breaker_item", (INBT)this.breakerItem.serializeNBT());
        compound.func_74774_a("arrow_type", (byte)this.field_200606_g.ordinal());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.blocksBroken = compound.func_74762_e("blocks_broken");
        if (compound.func_74764_b("player_id")) {
            this.playerId = compound.func_186857_a("player_id");
        }
        this.breakerItem = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("breaker_item"));
        this.field_200606_g = Type.values()[compound.func_74771_c("arrow_type")];
    }

    public void writeSpawnData(PacketBuffer buf) {
        buf.writeByte(this.field_200606_g.ordinal());
    }

    public void readSpawnData(PacketBuffer buf) {
        this.field_200606_g = Type.values()[buf.readByte()];
    }

    protected void breakBlock(BlockPos pos) {
        if (!this.field_70170_p.field_72995_K && !this.field_70170_p.func_180495_p(pos).isAir((IBlockReader)this.field_70170_p, pos)) {
            if (BlockUtil.breakExtraBlock((ServerWorld)this.field_70170_p, pos, this.breakerItem, this.playerId)) {
                if (++this.blocksBroken >= 12) {
                    this.func_70106_y();
                }
            } else {
                this.func_184185_a(SoundEvents.field_187692_g, 1.0f, 1.5f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.func_70106_y();
            }
        }
    }

    public static enum Type {
        IRON(new ResourceLocation("apotheosis", "textures/entity/iron_mining_arrow.png")),
        DIAMOND(new ResourceLocation("apotheosis", "textures/entity/diamond_mining_arrow.png"));

        private final ResourceLocation texture;

        private Type(ResourceLocation texture) {
            this.texture = texture;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }
    }
}

