/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;

public abstract class AbstractButtonBlock
extends HorizontalFaceBlock {
    public static final BooleanProperty field_176584_b = BlockStateProperties.field_208194_u;
    protected static final VoxelShape field_196370_b = Block.func_208617_a(6.0, 14.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape field_196371_c = Block.func_208617_a(5.0, 14.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape field_196376_y = Block.func_208617_a(6.0, 0.0, 5.0, 10.0, 2.0, 11.0);
    protected static final VoxelShape field_196377_z = Block.func_208617_a(5.0, 0.0, 6.0, 11.0, 2.0, 10.0);
    protected static final VoxelShape field_185622_d = Block.func_208617_a(5.0, 6.0, 14.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape field_185624_e = Block.func_208617_a(5.0, 6.0, 0.0, 11.0, 10.0, 2.0);
    protected static final VoxelShape field_185626_f = Block.func_208617_a(14.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape field_185628_g = Block.func_208617_a(0.0, 6.0, 5.0, 2.0, 10.0, 11.0);
    protected static final VoxelShape field_196372_E = Block.func_208617_a(6.0, 15.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape field_196373_F = Block.func_208617_a(5.0, 15.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape field_196374_G = Block.func_208617_a(6.0, 0.0, 5.0, 10.0, 1.0, 11.0);
    protected static final VoxelShape field_196375_H = Block.func_208617_a(5.0, 0.0, 6.0, 11.0, 1.0, 10.0);
    protected static final VoxelShape field_185623_D = Block.func_208617_a(5.0, 6.0, 15.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape field_185625_E = Block.func_208617_a(5.0, 6.0, 0.0, 11.0, 10.0, 1.0);
    protected static final VoxelShape field_185627_F = Block.func_208617_a(15.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape field_185629_G = Block.func_208617_a(0.0, 6.0, 5.0, 1.0, 10.0, 11.0);
    private final boolean field_150047_a;

    protected AbstractButtonBlock(boolean p_i48436_1_, AbstractBlock.Properties p_i48436_2_) {
        super(p_i48436_2_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_185512_D, Direction.NORTH)).func_206870_a(field_176584_b, false)).func_206870_a(field_196366_M, AttachFace.WALL));
        this.field_150047_a = p_i48436_1_;
    }

    private int func_235471_c_() {
        return this.field_150047_a ? 30 : 20;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        Direction direction = (Direction)((Object)p_220053_1_.func_177229_b(field_185512_D));
        boolean flag = (Boolean)p_220053_1_.func_177229_b(field_176584_b);
        switch ((AttachFace)p_220053_1_.func_177229_b(field_196366_M)) {
            case FLOOR: {
                if (direction.func_176740_k() == Direction.Axis.X) {
                    return flag ? field_196374_G : field_196376_y;
                }
                return flag ? field_196375_H : field_196377_z;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return flag ? field_185629_G : field_185628_g;
                    }
                    case WEST: {
                        return flag ? field_185627_F : field_185626_f;
                    }
                    case SOUTH: {
                        return flag ? field_185625_E : field_185624_e;
                    }
                }
                return flag ? field_185623_D : field_185622_d;
            }
        }
        if (direction.func_176740_k() == Direction.Axis.X) {
            return flag ? field_196372_E : field_196370_b;
        }
        return flag ? field_196373_F : field_196371_c;
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (((Boolean)p_225533_1_.func_177229_b(field_176584_b)).booleanValue()) {
            return ActionResultType.CONSUME;
        }
        boolean powered = (Boolean)p_225533_1_.func_177229_b(field_176584_b);
        org.bukkit.block.Block block = p_225533_2_.getWorld().getBlockAt(p_225533_3_.func_177958_n(), p_225533_3_.func_177956_o(), p_225533_3_.func_177952_p());
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
        p_225533_2_.getCBServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0 != !powered) {
            return ActionResultType.SUCCESS;
        }
        this.func_226910_d_(p_225533_1_, p_225533_2_, p_225533_3_);
        this.func_196367_a(p_225533_4_, p_225533_2_, p_225533_3_, true);
        return ActionResultType.func_233537_a_((boolean)p_225533_2_.field_72995_K);
    }

    public void func_226910_d_(BlockState p_226910_1_, World p_226910_2_, BlockPos p_226910_3_) {
        p_226910_2_.func_180501_a(p_226910_3_, (BlockState)p_226910_1_.func_206870_a(field_176584_b, true), 3);
        this.func_196368_e(p_226910_1_, p_226910_2_, p_226910_3_);
        p_226910_2_.func_205220_G_().func_205360_a(p_226910_3_, (Object)this, this.func_235471_c_());
    }

    protected void func_196367_a(@Nullable PlayerEntity p_196367_1_, IWorld p_196367_2_, BlockPos p_196367_3_, boolean p_196367_4_) {
        p_196367_2_.func_184133_a(p_196367_4_ ? p_196367_1_ : null, p_196367_3_, this.func_196369_b(p_196367_4_), SoundCategory.BLOCKS, 0.3f, p_196367_4_ ? 0.6f : 0.5f);
    }

    protected abstract SoundEvent func_196369_b(boolean var1);

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_5_ && !p_196243_1_.func_203425_a(p_196243_4_.func_177230_c())) {
            if (((Boolean)p_196243_1_.func_177229_b(field_176584_b)).booleanValue()) {
                this.func_196368_e(p_196243_1_, p_196243_2_, p_196243_3_);
            }
            super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public int func_180656_a(BlockState p_180656_1_, IBlockReader p_180656_2_, BlockPos p_180656_3_, Direction p_180656_4_) {
        return (Boolean)p_180656_1_.func_177229_b(field_176584_b) != false ? 15 : 0;
    }

    public int func_176211_b(BlockState p_176211_1_, IBlockReader p_176211_2_, BlockPos p_176211_3_, Direction p_176211_4_) {
        return (Boolean)p_176211_1_.func_177229_b(field_176584_b) != false && AbstractButtonBlock.func_196365_i((BlockState)p_176211_1_) == p_176211_4_ ? 15 : 0;
    }

    public boolean func_149744_f(BlockState p_149744_1_) {
        return true;
    }

    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        if (((Boolean)p_225534_1_.func_177229_b(field_176584_b)).booleanValue()) {
            if (this.field_150047_a) {
                this.func_185616_e(p_225534_1_, p_225534_2_, p_225534_3_);
            } else {
                org.bukkit.block.Block block = p_225534_2_.getWorld().getBlockAt(p_225534_3_.func_177958_n(), p_225534_3_.func_177956_o(), p_225534_3_.func_177952_p());
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, 15, 0);
                p_225534_2_.getCBServer().getPluginManager().callEvent((Event)eventRedstone);
                if (eventRedstone.getNewCurrent() > 0) {
                    return;
                }
                p_225534_2_.func_180501_a(p_225534_3_, (BlockState)p_225534_1_.func_206870_a(field_176584_b, false), 3);
                this.func_196368_e(p_225534_1_, p_225534_2_, p_225534_3_);
                this.func_196367_a(null, p_225534_2_, p_225534_3_, false);
            }
        }
    }

    public void func_196262_a(BlockState p_196262_1_, World p_196262_2_, BlockPos p_196262_3_, Entity p_196262_4_) {
        if (!p_196262_2_.field_72995_K && this.field_150047_a && !((Boolean)p_196262_1_.func_177229_b(field_176584_b)).booleanValue()) {
            this.func_185616_e(p_196262_1_, p_196262_2_, p_196262_3_);
        }
    }

    private void func_185616_e(BlockState p_185616_1_, World p_185616_2_, BlockPos p_185616_3_) {
        List list = p_185616_2_.func_217357_a(AbstractArrowEntity.class, p_185616_1_.func_196954_c((IBlockReader)((Object)p_185616_2_), p_185616_3_).func_197752_a().func_186670_a(p_185616_3_));
        boolean flag = !list.isEmpty();
        boolean flag1 = (Boolean)p_185616_1_.func_177229_b(field_176584_b);
        if (flag1 != flag && flag) {
            org.bukkit.block.Block block = p_185616_2_.getWorld().getBlockAt(p_185616_3_.func_177958_n(), p_185616_3_.func_177956_o(), p_185616_3_.func_177952_p());
            boolean allowed = false;
            for (Object object : list) {
                if (object == null) continue;
                EntityInteractEvent event = new EntityInteractEvent((org.bukkit.entity.Entity)((Entity)object).getBukkitEntity(), block);
                p_185616_2_.getCBServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                return;
            }
        }
        if (flag != flag1) {
            boolean powered = flag1;
            org.bukkit.block.Block block = p_185616_2_.getWorld().getBlockAt(p_185616_3_.func_177958_n(), p_185616_3_.func_177956_o(), p_185616_3_.func_177952_p());
            int old = powered ? 15 : 0;
            int current = !powered ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
            p_185616_2_.getCBServer().getPluginManager().callEvent((Event)eventRedstone);
            if (flag && eventRedstone.getNewCurrent() <= 0 || !flag && eventRedstone.getNewCurrent() > 0) {
                return;
            }
            p_185616_2_.func_180501_a(p_185616_3_, (BlockState)p_185616_1_.func_206870_a(field_176584_b, flag), 3);
            this.func_196368_e(p_185616_1_, p_185616_2_, p_185616_3_);
            this.func_196367_a(null, p_185616_2_, p_185616_3_, flag);
        }
        if (flag) {
            p_185616_2_.func_205220_G_().func_205360_a(new BlockPos(p_185616_3_), (Object)this, this.func_235471_c_());
        }
    }

    private void func_196368_e(BlockState p_196368_1_, World p_196368_2_, BlockPos p_196368_3_) {
        p_196368_2_.func_195593_d(p_196368_3_, (Block)((Object)this));
        p_196368_2_.func_195593_d(p_196368_3_.func_177972_a(AbstractButtonBlock.func_196365_i((BlockState)p_196368_1_).func_176734_d()), (Block)((Object)this));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_185512_D, field_176584_b, field_196366_M});
    }
}

