/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.EntitySize;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftPortalEvent;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalSize {
    private static final AbstractBlock.IPositionPredicate field_242962_a = (p_242966_0_, p_242966_1_, p_242966_2_) -> p_242966_0_.isPortalFrame(p_242966_1_, p_242966_2_);
    private final IWorld field_150867_a;
    private final Direction.Axis field_150865_b;
    private final Direction field_150866_c;
    private int field_150864_e;
    @Nullable
    private BlockPos field_150861_f;
    private int field_150862_g;
    private int field_150868_h;
    List<org.bukkit.block.BlockState> blocks = new ArrayList<org.bukkit.block.BlockState>();

    public static Optional<PortalSize> func_242964_a(IWorld p_242964_0_, BlockPos p_242964_1_, Direction.Axis p_242964_2_) {
        return PortalSize.func_242965_a(p_242964_0_, p_242964_1_, p_242968_0_ -> p_242968_0_.func_150860_b() && p_242968_0_.field_150864_e == 0, p_242964_2_);
    }

    public static Optional<PortalSize> func_242965_a(IWorld p_242965_0_, BlockPos p_242965_1_, Predicate<PortalSize> p_242965_2_, Direction.Axis p_242965_3_) {
        Optional<PortalSize> optional = Optional.of(new PortalSize(p_242965_0_, p_242965_1_, p_242965_3_)).filter(p_242965_2_);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis direction$axis = p_242965_3_ == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(new PortalSize(p_242965_0_, p_242965_1_, direction$axis)).filter(p_242965_2_);
    }

    public PortalSize(IWorld p_i48740_1_, BlockPos p_i48740_2_, Direction.Axis p_i48740_3_) {
        this.field_150867_a = p_i48740_1_;
        this.field_150865_b = p_i48740_3_;
        this.field_150866_c = p_i48740_3_ == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        this.field_150861_f = this.func_242971_a(p_i48740_2_);
        if (this.field_150861_f == null) {
            this.field_150861_f = p_i48740_2_;
            this.field_150868_h = 1;
            this.field_150862_g = 1;
        } else {
            this.field_150868_h = this.func_242974_d();
            if (this.field_150868_h > 0) {
                this.field_150862_g = this.func_242975_e();
            }
        }
    }

    @Nullable
    private BlockPos func_242971_a(BlockPos p_242971_1_) {
        int i = Math.max(0, p_242971_1_.func_177956_o() - 21);
        while (p_242971_1_.func_177956_o() > i && PortalSize.func_196900_a(this.field_150867_a.func_180495_p(p_242971_1_.func_177977_b()))) {
            p_242971_1_ = p_242971_1_.func_177977_b();
        }
        Direction direction = this.field_150866_c.func_176734_d();
        int j = this.func_242972_a(p_242971_1_, direction) - 1;
        return j < 0 ? null : p_242971_1_.func_177967_a(direction, j);
    }

    private int func_242974_d() {
        int i = this.func_242972_a(this.field_150861_f, this.field_150866_c);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int func_242972_a(BlockPos p_242972_1_, Direction p_242972_2_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i <= 21; ++i) {
            blockpos$mutable.func_189533_g(p_242972_1_).func_189534_c(p_242972_2_, i);
            BlockState blockstate = this.field_150867_a.func_180495_p(blockpos$mutable);
            if (!PortalSize.func_196900_a(blockstate)) {
                if (!field_242962_a.test(blockstate, (IBlockReader)((Object)this.field_150867_a), blockpos$mutable)) break;
                this.blocks.add(CraftBlock.at((IWorld)this.field_150867_a, (BlockPos)blockpos$mutable).getState());
                return i;
            }
            BlockState blockstate1 = this.field_150867_a.func_180495_p(blockpos$mutable.func_189536_c(Direction.DOWN));
            if (!field_242962_a.test(blockstate1, (IBlockReader)((Object)this.field_150867_a), blockpos$mutable)) break;
        }
        return 0;
    }

    private int func_242975_e() {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int i = this.func_242969_a(blockpos$mutable);
        return i >= 3 && i <= 21 && this.func_242970_a(blockpos$mutable, i) ? i : 0;
    }

    private boolean func_242970_a(BlockPos.Mutable p_242970_1_, int p_242970_2_) {
        for (int i = 0; i < this.field_150868_h; ++i) {
            BlockPos.Mutable blockpos$mutable = p_242970_1_.func_189533_g(this.field_150861_f).func_189534_c(Direction.UP, p_242970_2_).func_189534_c(this.field_150866_c, i);
            if (field_242962_a.test(this.field_150867_a.func_180495_p(blockpos$mutable), (IBlockReader)((Object)this.field_150867_a), blockpos$mutable)) continue;
            return false;
        }
        return true;
    }

    private int func_242969_a(BlockPos.Mutable p_242969_1_) {
        for (int i = 0; i < 21; ++i) {
            p_242969_1_.func_189533_g(this.field_150861_f).func_189534_c(Direction.UP, i).func_189534_c(this.field_150866_c, -1);
            if (!field_242962_a.test(this.field_150867_a.func_180495_p(p_242969_1_), (IBlockReader)((Object)this.field_150867_a), p_242969_1_)) {
                return i;
            }
            p_242969_1_.func_189533_g(this.field_150861_f).func_189534_c(Direction.UP, i).func_189534_c(this.field_150866_c, this.field_150868_h);
            if (!field_242962_a.test(this.field_150867_a.func_180495_p(p_242969_1_), (IBlockReader)((Object)this.field_150867_a), p_242969_1_)) {
                return i;
            }
            for (int j = 0; j < this.field_150868_h; ++j) {
                p_242969_1_.func_189533_g(this.field_150861_f).func_189534_c(Direction.UP, i).func_189534_c(this.field_150866_c, j);
                BlockState blockstate = this.field_150867_a.func_180495_p(p_242969_1_);
                if (!PortalSize.func_196900_a(blockstate)) {
                    return i;
                }
                if (!blockstate.func_203425_a(Blocks.field_150427_aO)) continue;
                ++this.field_150864_e;
            }
        }
        return 21;
    }

    private static boolean func_196900_a(BlockState p_196900_0_) {
        return p_196900_0_.func_196958_f() || p_196900_0_.func_235714_a_(BlockTags.field_232872_am_) || p_196900_0_.func_203425_a(Blocks.field_150427_aO);
    }

    public boolean func_150860_b() {
        return this.field_150861_f != null && this.field_150868_h >= 2 && this.field_150868_h <= 21 && this.field_150862_g >= 3 && this.field_150862_g <= 21;
    }

    public boolean placePortalBlocks() {
        CraftWorld bworld = this.field_150867_a.getMinecraftWorld().getWorld();
        BlockState blockstate = (BlockState)Blocks.field_150427_aO.func_176223_P().func_206870_a(NetherPortalBlock.field_176550_a, this.field_150865_b);
        BlockPos.func_218278_a(this.field_150861_f, this.field_150861_f.func_177967_a(Direction.UP, this.field_150862_g - 1).func_177967_a(this.field_150866_c, this.field_150868_h - 1)).forEach(p_242967_2_ -> {
            CraftBlockState state = CraftBlockState.getBlockState((World)this.field_150867_a.getMinecraftWorld(), (BlockPos)((Object)p_242967_2_), (int)18);
            state.setData(blockstate);
            this.blocks.add((org.bukkit.block.BlockState)state);
        });
        PortalCreateEvent event = new PortalCreateEvent(this.blocks, (org.bukkit.World)bworld, null, PortalCreateEvent.CreateReason.FIRE);
        this.field_150867_a.getMinecraftWorld().func_73046_m().server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        BlockPos.func_218278_a(this.field_150861_f, this.field_150861_f.func_177967_a(Direction.UP, this.field_150862_g - 1).func_177967_a(this.field_150866_c, this.field_150868_h - 1)).forEach(p_242967_2_ -> this.field_150867_a.func_180501_a((BlockPos)((Object)p_242967_2_), blockstate, 18));
        return true;
    }

    public boolean func_208508_f() {
        return this.func_150860_b() && this.field_150864_e == this.field_150868_h * this.field_150862_g;
    }

    public static Vector3d func_242973_a(TeleportationRepositioner.Result p_242973_0_, Direction.Axis p_242973_1_, Vector3d p_242973_2_, EntitySize p_242973_3_) {
        double d4;
        double d2;
        double d0 = (double)p_242973_0_.field_243680_b - (double)p_242973_3_.field_220315_a;
        double d1 = (double)p_242973_0_.field_243681_c - (double)p_242973_3_.field_220316_b;
        BlockPos blockpos = p_242973_0_.field_243679_a;
        if (d0 > 0.0) {
            float f = (float)blockpos.func_243648_a(p_242973_1_) + p_242973_3_.field_220315_a / 2.0f;
            d2 = MathHelper.func_151237_a((double)MathHelper.func_233020_c_((double)(p_242973_2_.func_216370_a(p_242973_1_) - (double)f), (double)0.0, (double)d0), (double)0.0, (double)1.0);
        } else {
            d2 = 0.5;
        }
        if (d1 > 0.0) {
            Direction.Axis direction$axis = Direction.Axis.Y;
            d4 = MathHelper.func_151237_a((double)MathHelper.func_233020_c_((double)(p_242973_2_.func_216370_a(direction$axis) - (double)blockpos.func_243648_a(direction$axis)), (double)0.0, (double)d1), (double)0.0, (double)1.0);
        } else {
            d4 = 0.0;
        }
        Direction.Axis direction$axis1 = p_242973_1_ == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        double d3 = p_242973_2_.func_216370_a(direction$axis1) - ((double)blockpos.func_243648_a(direction$axis1) + 0.5);
        return new Vector3d(d2, d4, d3);
    }

    public static PortalInfo func_242963_a(ServerWorld p_242963_0_, TeleportationRepositioner.Result p_242963_1_, Direction.Axis p_242963_2_, Vector3d p_242963_3_, EntitySize p_242963_4_, Vector3d p_242963_5_, float p_242963_6_, float p_242963_7_) {
        return PortalSize.createPortalInfo(p_242963_0_, p_242963_1_, p_242963_2_, p_242963_3_, p_242963_4_, p_242963_5_, p_242963_6_, p_242963_7_, null);
    }

    public static PortalInfo createPortalInfo(ServerWorld world, TeleportationRepositioner.Result result, Direction.Axis axis, Vector3d offsetVector, EntitySize size, Vector3d motion, float rotationYaw, float rotationPitch, CraftPortalEvent portalEventInfo) {
        BlockPos blockpos = result.field_243679_a;
        BlockState blockstate = world.func_180495_p(blockpos);
        Direction.Axis direction$axis = (Direction.Axis)blockstate.func_177229_b(BlockStateProperties.field_208199_z);
        double d0 = result.field_243680_b;
        double d1 = result.field_243681_c;
        int i = axis == direction$axis ? 0 : 90;
        Vector3d vector3d = axis == direction$axis ? motion : new Vector3d(motion.field_72449_c, motion.field_72448_b, -motion.field_72450_a);
        double d2 = (double)size.field_220315_a / 2.0 + (d0 - (double)size.field_220315_a) * offsetVector.func_82615_a();
        double d3 = (d1 - (double)size.field_220316_b) * offsetVector.func_82617_b();
        double d4 = 0.5 + offsetVector.func_82616_c();
        boolean flag = direction$axis == Direction.Axis.X;
        Vector3d vector3d1 = new Vector3d((double)blockpos.func_177958_n() + (flag ? d2 : d4), (double)blockpos.func_177956_o() + d3, (double)blockpos.func_177952_p() + (flag ? d4 : d2));
        PortalInfo portalInfo = new PortalInfo(vector3d1, vector3d, rotationYaw + (float)i, rotationPitch);
        portalInfo.putCB(world, portalEventInfo);
        return portalInfo;
    }
}

