/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class RedstoneWireBlock
extends Block {
    public static final EnumProperty<RedstoneSide> field_176348_a = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> field_176347_b = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> field_176349_M = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> field_176350_N = BlockStateProperties.field_208162_O;
    public static final IntegerProperty field_176351_O = BlockStateProperties.field_208136_ak;
    public static final Map<Direction, EnumProperty<RedstoneSide>> field_196498_A = Maps.newEnumMap((Map)ImmutableMap.of((Object)((Object)Direction.NORTH), field_176348_a, (Object)((Object)Direction.EAST), field_176347_b, (Object)((Object)Direction.SOUTH), field_176349_M, (Object)((Object)Direction.WEST), field_176350_N));
    private static final VoxelShape field_235538_g_ = Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final Map<Direction, VoxelShape> field_235539_h_ = Maps.newEnumMap((Map)ImmutableMap.of((Object)((Object)Direction.NORTH), (Object)Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), (Object)((Object)Direction.SOUTH), (Object)Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), (Object)((Object)Direction.EAST), (Object)Block.func_208617_a(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), (Object)((Object)Direction.WEST), (Object)Block.func_208617_a(0.0, 0.0, 3.0, 13.0, 1.0, 13.0)));
    private static final Map<Direction, VoxelShape> field_235540_i_ = Maps.newEnumMap((Map)ImmutableMap.of((Object)((Object)Direction.NORTH), (Object)VoxelShapes.func_197872_a(field_235539_h_.get((Object)Direction.NORTH), Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 16.0, 1.0)), (Object)((Object)Direction.SOUTH), (Object)VoxelShapes.func_197872_a(field_235539_h_.get((Object)Direction.SOUTH), Block.func_208617_a(3.0, 0.0, 15.0, 13.0, 16.0, 16.0)), (Object)((Object)Direction.EAST), (Object)VoxelShapes.func_197872_a(field_235539_h_.get((Object)Direction.EAST), Block.func_208617_a(15.0, 0.0, 3.0, 16.0, 16.0, 13.0)), (Object)((Object)Direction.WEST), (Object)VoxelShapes.func_197872_a(field_235539_h_.get((Object)Direction.WEST), Block.func_208617_a(0.0, 0.0, 3.0, 1.0, 16.0, 13.0))));
    private final Map<BlockState, VoxelShape> field_235541_j_ = Maps.newHashMap();
    private static final Vector3f[] field_235542_k_ = new Vector3f[16];
    private final BlockState field_235543_o_;
    private boolean field_150181_a = true;

    public RedstoneWireBlock(AbstractBlock.Properties p_i48344_1_) {
        super(p_i48344_1_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176348_a, RedstoneSide.NONE)).func_206870_a(field_176347_b, RedstoneSide.NONE)).func_206870_a(field_176349_M, RedstoneSide.NONE)).func_206870_a(field_176350_N, RedstoneSide.NONE)).func_206870_a(field_176351_O, 0));
        this.field_235543_o_ = (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(field_176348_a, RedstoneSide.SIDE)).func_206870_a(field_176347_b, RedstoneSide.SIDE)).func_206870_a(field_176349_M, RedstoneSide.SIDE)).func_206870_a(field_176350_N, RedstoneSide.SIDE);
        for (BlockState blockstate : this.func_176194_O().func_177619_a()) {
            if (blockstate.func_177229_b(field_176351_O) != 0) continue;
            this.field_235541_j_.put(blockstate, this.func_235554_l_(blockstate));
        }
    }

    private VoxelShape func_235554_l_(BlockState p_235554_1_) {
        VoxelShape voxelshape = field_235538_g_;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)p_235554_1_.func_177229_b((Property)field_196498_A.get((Object)direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = VoxelShapes.func_197872_a(voxelshape, field_235539_h_.get((Object)direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = VoxelShapes.func_197872_a(voxelshape, field_235540_i_.get((Object)direction));
        }
        return voxelshape;
    }

    @Override
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return this.field_235541_j_.get(p_220053_1_.func_206870_a(field_176351_O, 0));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        return this.func_235544_a_((IBlockReader)((Object)p_196258_1_.func_195991_k()), this.field_235543_o_, p_196258_1_.func_195995_a());
    }

    private BlockState func_235544_a_(IBlockReader p_235544_1_, BlockState p_235544_2_, BlockPos p_235544_3_) {
        boolean flag6;
        boolean flag = RedstoneWireBlock.func_235556_n_(p_235544_2_);
        p_235544_2_ = this.func_235551_b_(p_235544_1_, (BlockState)this.func_176223_P().func_206870_a(field_176351_O, p_235544_2_.func_177229_b(field_176351_O)), p_235544_3_);
        if (flag && RedstoneWireBlock.func_235556_n_(p_235544_2_)) {
            return p_235544_2_;
        }
        boolean flag1 = p_235544_2_.func_177229_b(field_176348_a).func_235921_b_();
        boolean flag2 = p_235544_2_.func_177229_b(field_176349_M).func_235921_b_();
        boolean flag3 = p_235544_2_.func_177229_b(field_176347_b).func_235921_b_();
        boolean flag4 = p_235544_2_.func_177229_b(field_176350_N).func_235921_b_();
        boolean flag5 = !flag1 && !flag2;
        boolean bl = flag6 = !flag3 && !flag4;
        if (!flag4 && flag5) {
            p_235544_2_ = (BlockState)p_235544_2_.func_206870_a(field_176350_N, RedstoneSide.SIDE);
        }
        if (!flag3 && flag5) {
            p_235544_2_ = (BlockState)p_235544_2_.func_206870_a(field_176347_b, RedstoneSide.SIDE);
        }
        if (!flag1 && flag6) {
            p_235544_2_ = (BlockState)p_235544_2_.func_206870_a(field_176348_a, RedstoneSide.SIDE);
        }
        if (!flag2 && flag6) {
            p_235544_2_ = (BlockState)p_235544_2_.func_206870_a(field_176349_M, RedstoneSide.SIDE);
        }
        return p_235544_2_;
    }

    private BlockState func_235551_b_(IBlockReader p_235551_1_, BlockState p_235551_2_, BlockPos p_235551_3_) {
        boolean flag = !p_235551_1_.func_180495_p(p_235551_3_.func_177984_a()).func_215686_e(p_235551_1_, p_235551_3_);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)p_235551_2_.func_177229_b((Property)field_196498_A.get((Object)direction))).func_235921_b_()) continue;
            RedstoneSide redstoneside = this.func_235545_a_(p_235551_1_, p_235551_3_, direction, flag);
            p_235551_2_ = (BlockState)p_235551_2_.func_206870_a((Property)field_196498_A.get((Object)direction), redstoneside);
        }
        return p_235551_2_;
    }

    @Override
    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (p_196271_2_ == Direction.DOWN) {
            return p_196271_1_;
        }
        if (p_196271_2_ == Direction.UP) {
            return this.func_235544_a_((IBlockReader)((Object)p_196271_4_), p_196271_1_, p_196271_5_);
        }
        RedstoneSide redstoneside = this.func_208074_a((IBlockReader)((Object)p_196271_4_), p_196271_5_, p_196271_2_);
        return redstoneside.func_235921_b_() == ((RedstoneSide)p_196271_1_.func_177229_b((Property)field_196498_A.get((Object)p_196271_2_))).func_235921_b_() && !RedstoneWireBlock.func_235555_m_(p_196271_1_) ? (BlockState)p_196271_1_.func_206870_a((Property)field_196498_A.get((Object)p_196271_2_), redstoneside) : this.func_235544_a_((IBlockReader)((Object)p_196271_4_), (BlockState)((BlockState)this.field_235543_o_.func_206870_a(field_176351_O, p_196271_1_.func_177229_b(field_176351_O))).func_206870_a((Property)field_196498_A.get((Object)p_196271_2_), redstoneside), p_196271_5_);
    }

    private static boolean func_235555_m_(BlockState p_235555_0_) {
        return p_235555_0_.func_177229_b(field_176348_a).func_235921_b_() && p_235555_0_.func_177229_b(field_176349_M).func_235921_b_() && p_235555_0_.func_177229_b(field_176347_b).func_235921_b_() && p_235555_0_.func_177229_b(field_176350_N).func_235921_b_();
    }

    private static boolean func_235556_n_(BlockState p_235556_0_) {
        return !p_235556_0_.func_177229_b(field_176348_a).func_235921_b_() && !p_235556_0_.func_177229_b(field_176349_M).func_235921_b_() && !p_235556_0_.func_177229_b(field_176347_b).func_235921_b_() && !p_235556_0_.func_177229_b(field_176350_N).func_235921_b_();
    }

    @Override
    public void func_196248_b(BlockState p_196248_1_, IWorld p_196248_2_, BlockPos p_196248_3_, int p_196248_4_, int p_196248_5_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)p_196248_1_.func_177229_b((Property)field_196498_A.get((Object)direction));
            if (redstoneside == RedstoneSide.NONE || p_196248_2_.func_180495_p(blockpos$mutable.func_239622_a_(p_196248_3_, direction)).func_203425_a(this)) continue;
            blockpos$mutable.func_189536_c(Direction.DOWN);
            BlockState blockstate = p_196248_2_.func_180495_p(blockpos$mutable);
            if (!blockstate.func_203425_a(Blocks.field_190976_dk)) {
                BlockPos blockpos = blockpos$mutable.func_177972_a(direction.func_176734_d());
                BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), p_196248_2_.func_180495_p(blockpos), p_196248_2_, blockpos$mutable, blockpos);
                RedstoneWireBlock.func_241468_a_(blockstate, blockstate1, p_196248_2_, blockpos$mutable, p_196248_4_, p_196248_5_);
            }
            blockpos$mutable.func_239622_a_(p_196248_3_, direction).func_189536_c(Direction.UP);
            BlockState blockstate3 = p_196248_2_.func_180495_p(blockpos$mutable);
            if (blockstate3.func_203425_a(Blocks.field_190976_dk)) continue;
            BlockPos blockpos1 = blockpos$mutable.func_177972_a(direction.func_176734_d());
            BlockState blockstate2 = blockstate3.func_196956_a(direction.func_176734_d(), p_196248_2_.func_180495_p(blockpos1), p_196248_2_, blockpos$mutable, blockpos1);
            RedstoneWireBlock.func_241468_a_(blockstate3, blockstate2, p_196248_2_, blockpos$mutable, p_196248_4_, p_196248_5_);
        }
    }

    private RedstoneSide func_208074_a(IBlockReader p_208074_1_, BlockPos p_208074_2_, Direction p_208074_3_) {
        return this.func_235545_a_(p_208074_1_, p_208074_2_, p_208074_3_, !p_208074_1_.func_180495_p(p_208074_2_.func_177984_a()).func_215686_e(p_208074_1_, p_208074_2_));
    }

    private RedstoneSide func_235545_a_(IBlockReader p_235545_1_, BlockPos p_235545_2_, Direction p_235545_3_, boolean p_235545_4_) {
        boolean flag;
        BlockPos blockpos = p_235545_2_.func_177972_a(p_235545_3_);
        BlockState blockstate = p_235545_1_.func_180495_p(blockpos);
        if (p_235545_4_ && (flag = this.func_235552_b_(p_235545_1_, blockpos, blockstate)) && RedstoneWireBlock.canConnectTo(p_235545_1_.func_180495_p(blockpos.func_177984_a()), p_235545_1_, blockpos.func_177984_a(), null)) {
            if (blockstate.func_224755_d(p_235545_1_, blockpos, p_235545_3_.func_176734_d())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !RedstoneWireBlock.canConnectTo(blockstate, p_235545_1_, blockpos, p_235545_3_) && (blockstate.func_215686_e(p_235545_1_, blockpos) || !RedstoneWireBlock.canConnectTo(p_235545_1_.func_180495_p(blockpos.func_177977_b()), p_235545_1_, blockpos.func_177977_b(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    @Override
    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        BlockPos blockpos = p_196260_3_.func_177977_b();
        BlockState blockstate = p_196260_2_.func_180495_p(blockpos);
        return this.func_235552_b_((IBlockReader)((Object)p_196260_2_), blockpos, blockstate);
    }

    private boolean func_235552_b_(IBlockReader p_235552_1_, BlockPos p_235552_2_, BlockState p_235552_3_) {
        return p_235552_3_.func_224755_d(p_235552_1_, p_235552_2_, Direction.UP) || p_235552_3_.func_203425_a(Blocks.field_150438_bZ);
    }

    private void func_235547_a_(World p_235547_1_, BlockPos p_235547_2_, BlockState p_235547_3_) {
        int i = this.func_235546_a_(p_235547_1_, p_235547_2_);
        int oldPower = p_235547_3_.func_177229_b(field_176351_O);
        if (oldPower != i) {
            BlockRedstoneEvent event = new BlockRedstoneEvent(p_235547_1_.getWorld().getBlockAt(p_235547_2_.func_177958_n(), p_235547_2_.func_177956_o(), p_235547_2_.func_177952_p()), oldPower, i);
            p_235547_1_.getCBServer().getPluginManager().callEvent((Event)event);
            i = event.getNewCurrent();
        }
        if (oldPower != i) {
            if (p_235547_1_.func_180495_p(p_235547_2_) == p_235547_3_) {
                p_235547_1_.func_180501_a(p_235547_2_, (BlockState)p_235547_3_.func_206870_a(field_176351_O, i), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(p_235547_2_);
            for (Direction direction : Direction.values()) {
                set.add(p_235547_2_.func_177972_a(direction));
            }
            for (BlockPos blockpos : set) {
                p_235547_1_.func_195593_d(blockpos, this);
            }
        }
    }

    private int func_235546_a_(World p_235546_1_, BlockPos p_235546_2_) {
        this.field_150181_a = false;
        int i = p_235546_1_.func_175687_A(p_235546_2_);
        this.field_150181_a = true;
        int j = 0;
        if (i < 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = p_235546_2_.func_177972_a(direction);
                BlockState blockstate = p_235546_1_.func_180495_p(blockpos);
                j = Math.max(j, this.func_235557_o_(blockstate));
                BlockPos blockpos1 = p_235546_2_.func_177984_a();
                if (blockstate.func_215686_e((IBlockReader)((Object)p_235546_1_), blockpos) && !p_235546_1_.func_180495_p(blockpos1).func_215686_e((IBlockReader)((Object)p_235546_1_), blockpos1)) {
                    j = Math.max(j, this.func_235557_o_(p_235546_1_.func_180495_p(blockpos.func_177984_a())));
                    continue;
                }
                if (blockstate.func_215686_e((IBlockReader)((Object)p_235546_1_), blockpos)) continue;
                j = Math.max(j, this.func_235557_o_(p_235546_1_.func_180495_p(blockpos.func_177977_b())));
            }
        }
        return Math.max(i, j - 1);
    }

    private int func_235557_o_(BlockState p_235557_1_) {
        return p_235557_1_.func_203425_a(this) ? p_235557_1_.func_177229_b(field_176351_O) : 0;
    }

    private void func_176344_d(World p_176344_1_, BlockPos p_176344_2_) {
        if (p_176344_1_.func_180495_p(p_176344_2_).func_203425_a(this)) {
            p_176344_1_.func_195593_d(p_176344_2_, this);
            for (Direction direction : Direction.values()) {
                p_176344_1_.func_195593_d(p_176344_2_.func_177972_a(direction), this);
            }
        }
    }

    @Override
    public void func_220082_b(BlockState p_220082_1_, World p_220082_2_, BlockPos p_220082_3_, BlockState p_220082_4_, boolean p_220082_5_) {
        if (!p_220082_4_.func_203425_a(p_220082_1_.func_177230_c()) && !p_220082_2_.field_72995_K) {
            this.func_235547_a_(p_220082_2_, p_220082_3_, p_220082_1_);
            for (Direction direction : Direction.Plane.VERTICAL) {
                p_220082_2_.func_195593_d(p_220082_3_.func_177972_a(direction), this);
            }
            this.func_235553_d_(p_220082_2_, p_220082_3_);
        }
    }

    @Override
    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_5_ && !p_196243_1_.func_203425_a(p_196243_4_.func_177230_c())) {
            super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
            if (!p_196243_2_.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    p_196243_2_.func_195593_d(p_196243_3_.func_177972_a(direction), this);
                }
                this.func_235547_a_(p_196243_2_, p_196243_3_, p_196243_1_);
                this.func_235553_d_(p_196243_2_, p_196243_3_);
            }
        }
    }

    private void func_235553_d_(World p_235553_1_, BlockPos p_235553_2_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.func_176344_d(p_235553_1_, p_235553_2_.func_177972_a(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_235553_2_.func_177972_a(direction1);
            if (p_235553_1_.func_180495_p(blockpos).func_215686_e((IBlockReader)((Object)p_235553_1_), blockpos)) {
                this.func_176344_d(p_235553_1_, blockpos.func_177984_a());
                continue;
            }
            this.func_176344_d(p_235553_1_, blockpos.func_177977_b());
        }
    }

    @Override
    public void func_220069_a(BlockState p_220069_1_, World p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (!p_220069_2_.field_72995_K) {
            if (p_220069_1_.func_196955_c((IWorldReader)((Object)p_220069_2_), p_220069_3_)) {
                this.func_235547_a_(p_220069_2_, p_220069_3_, p_220069_1_);
            } else {
                RedstoneWireBlock.func_220075_c(p_220069_1_, p_220069_2_, p_220069_3_);
                p_220069_2_.func_217377_a(p_220069_3_, false);
            }
        }
    }

    @Override
    public int func_176211_b(BlockState p_176211_1_, IBlockReader p_176211_2_, BlockPos p_176211_3_, Direction p_176211_4_) {
        return !this.field_150181_a ? 0 : p_176211_1_.func_185911_a(p_176211_2_, p_176211_3_, p_176211_4_);
    }

    @Override
    public int func_180656_a(BlockState p_180656_1_, IBlockReader p_180656_2_, BlockPos p_180656_3_, Direction p_180656_4_) {
        if (this.field_150181_a && p_180656_4_ != Direction.DOWN) {
            int i = p_180656_1_.func_177229_b(field_176351_O);
            if (i == 0) {
                return 0;
            }
            return p_180656_4_ != Direction.UP && !((RedstoneSide)this.func_235544_a_(p_180656_2_, p_180656_1_, p_180656_3_).func_177229_b((Property)field_196498_A.get((Object)p_180656_4_.func_176734_d()))).func_235921_b_() ? 0 : i;
        }
        return 0;
    }

    protected static boolean canConnectTo(BlockState p_176343_0_, IBlockReader world, BlockPos pos, @Nullable Direction p_176343_1_) {
        if (p_176343_0_.func_203425_a(Blocks.field_150488_af)) {
            return true;
        }
        if (p_176343_0_.func_203425_a(Blocks.field_196633_cV)) {
            Direction direction = (Direction)((Object)p_176343_0_.func_177229_b(RepeaterBlock.field_185512_D));
            return direction == p_176343_1_ || direction.func_176734_d() == p_176343_1_;
        }
        if (p_176343_0_.func_203425_a(Blocks.field_190976_dk)) {
            return p_176343_1_ == p_176343_0_.func_177229_b(ObserverBlock.field_176387_N);
        }
        return p_176343_0_.canConnectRedstone(world, pos, p_176343_1_) && p_176343_1_ != null;
    }

    @Override
    public boolean func_149744_f(BlockState p_149744_1_) {
        return this.field_150181_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int func_235550_b_(int p_235550_0_) {
        Vector3f vector3f = field_235542_k_[p_235550_0_];
        return MathHelper.func_180183_b((float)vector3f.func_195899_a(), (float)vector3f.func_195900_b(), (float)vector3f.func_195902_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void func_235549_a_(World p_235549_1_, Random p_235549_2_, BlockPos p_235549_3_, Vector3f p_235549_4_, Direction p_235549_5_, Direction p_235549_6_, float p_235549_7_, float p_235549_8_) {
        float f = p_235549_8_ - p_235549_7_;
        if (!(p_235549_2_.nextFloat() >= 0.2f * f)) {
            float f1 = 0.4375f;
            float f2 = p_235549_7_ + f * p_235549_2_.nextFloat();
            double d0 = 0.5 + (double)(0.4375f * (float)p_235549_5_.func_82601_c()) + (double)(f2 * (float)p_235549_6_.func_82601_c());
            double d1 = 0.5 + (double)(0.4375f * (float)p_235549_5_.func_96559_d()) + (double)(f2 * (float)p_235549_6_.func_96559_d());
            double d2 = 0.5 + (double)(0.4375f * (float)p_235549_5_.func_82599_e()) + (double)(f2 * (float)p_235549_6_.func_82599_e());
            p_235549_1_.func_195594_a((IParticleData)new RedstoneParticleData(p_235549_4_.func_195899_a(), p_235549_4_.func_195900_b(), p_235549_4_.func_195902_c(), 1.0f), (double)p_235549_3_.func_177958_n() + d0, (double)p_235549_3_.func_177956_o() + d1, (double)p_235549_3_.func_177952_p() + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState p_180655_1_, World p_180655_2_, BlockPos p_180655_3_, Random p_180655_4_) {
        int i = p_180655_1_.func_177229_b(field_176351_O);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)p_180655_1_.func_177229_b((Property)field_196498_A.get((Object)direction));
                switch (redstoneside) {
                    case UP: {
                        this.func_235549_a_(p_180655_2_, p_180655_4_, p_180655_3_, field_235542_k_[i], direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.func_235549_a_(p_180655_2_, p_180655_4_, p_180655_3_, field_235542_k_[i], Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.func_235549_a_(p_180655_2_, p_180655_4_, p_180655_3_, field_235542_k_[i], Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    @Override
    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        switch (p_185499_2_) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_185499_1_.func_206870_a(field_176348_a, p_185499_1_.func_177229_b(field_176349_M))).func_206870_a(field_176347_b, p_185499_1_.func_177229_b(field_176350_N))).func_206870_a(field_176349_M, p_185499_1_.func_177229_b(field_176348_a))).func_206870_a(field_176350_N, p_185499_1_.func_177229_b(field_176347_b));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_185499_1_.func_206870_a(field_176348_a, p_185499_1_.func_177229_b(field_176347_b))).func_206870_a(field_176347_b, p_185499_1_.func_177229_b(field_176349_M))).func_206870_a(field_176349_M, p_185499_1_.func_177229_b(field_176350_N))).func_206870_a(field_176350_N, p_185499_1_.func_177229_b(field_176348_a));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_185499_1_.func_206870_a(field_176348_a, p_185499_1_.func_177229_b(field_176350_N))).func_206870_a(field_176347_b, p_185499_1_.func_177229_b(field_176348_a))).func_206870_a(field_176349_M, p_185499_1_.func_177229_b(field_176347_b))).func_206870_a(field_176350_N, p_185499_1_.func_177229_b(field_176349_M));
            }
        }
        return p_185499_1_;
    }

    @Override
    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        switch (p_185471_2_) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)p_185471_1_.func_206870_a(field_176348_a, p_185471_1_.func_177229_b(field_176349_M))).func_206870_a(field_176349_M, p_185471_1_.func_177229_b(field_176348_a));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)p_185471_1_.func_206870_a(field_176347_b, p_185471_1_.func_177229_b(field_176350_N))).func_206870_a(field_176350_N, p_185471_1_.func_177229_b(field_176347_b));
            }
        }
        return super.func_185471_a(p_185471_1_, p_185471_2_);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_176348_a, field_176347_b, field_176349_M, field_176350_N, field_176351_O});
    }

    @Override
    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (!p_225533_4_.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        if (RedstoneWireBlock.func_235555_m_(p_225533_1_) || RedstoneWireBlock.func_235556_n_(p_225533_1_)) {
            BlockState blockstate = RedstoneWireBlock.func_235555_m_(p_225533_1_) ? this.func_176223_P() : this.field_235543_o_;
            blockstate = (BlockState)blockstate.func_206870_a(field_176351_O, p_225533_1_.func_177229_b(field_176351_O));
            if ((blockstate = this.func_235544_a_((IBlockReader)((Object)p_225533_2_), blockstate, p_225533_3_)) != p_225533_1_) {
                p_225533_2_.func_180501_a(p_225533_3_, blockstate, 3);
                this.func_235548_a_(p_225533_2_, p_225533_3_, p_225533_1_, blockstate);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private void func_235548_a_(World p_235548_1_, BlockPos p_235548_2_, BlockState p_235548_3_, BlockState p_235548_4_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_235548_2_.func_177972_a(direction);
            if (((RedstoneSide)p_235548_3_.func_177229_b((Property)field_196498_A.get((Object)direction))).func_235921_b_() == ((RedstoneSide)p_235548_4_.func_177229_b((Property)field_196498_A.get((Object)direction))).func_235921_b_() || !p_235548_1_.func_180495_p(blockpos).func_215686_e((IBlockReader)((Object)p_235548_1_), blockpos)) continue;
            p_235548_1_.func_175695_a(blockpos, p_235548_4_.func_177230_c(), direction.func_176734_d());
        }
    }

    static {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float f1 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = MathHelper.func_76131_a((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float f3 = MathHelper.func_76131_a((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            RedstoneWireBlock.field_235542_k_[i] = new Vector3f(f1, f2, f3);
        }
    }
}

