/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

public class VineBlock
extends Block
implements IForgeShearable {
    public static final BooleanProperty field_176277_a = SixWayBlock.field_196496_z;
    public static final BooleanProperty field_176273_b = SixWayBlock.field_196488_a;
    public static final BooleanProperty field_176278_M = SixWayBlock.field_196490_b;
    public static final BooleanProperty field_176279_N = SixWayBlock.field_196492_c;
    public static final BooleanProperty field_176280_O = SixWayBlock.field_196495_y;
    public static final Map<Direction, BooleanProperty> field_196546_A = SixWayBlock.field_196491_B.entrySet().stream().filter(p_199782_0_ -> p_199782_0_.getKey() != Direction.DOWN).collect(Util.func_199749_a());
    private static final VoxelShape field_185757_g = Block.func_208617_a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape field_185754_C = Block.func_208617_a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape field_185753_B = Block.func_208617_a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape field_185756_E = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape field_185755_D = Block.func_208617_a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<BlockState, VoxelShape> field_242684_o;

    public VineBlock(AbstractBlock.Properties p_i48303_1_) {
        super(p_i48303_1_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176277_a, false)).func_206870_a(field_176273_b, false)).func_206870_a(field_176278_M, false)).func_206870_a(field_176279_N, false)).func_206870_a(field_176280_O, false));
        this.field_242684_o = ImmutableMap.copyOf(this.field_176227_L.func_177619_a().stream().collect(Collectors.toMap(Function.identity(), VineBlock::func_242685_h)));
    }

    private static VoxelShape func_242685_h(BlockState p_242685_0_) {
        VoxelShape voxelshape = VoxelShapes.func_197880_a();
        if (((Boolean)p_242685_0_.func_177229_b(field_176277_a)).booleanValue()) {
            voxelshape = field_185757_g;
        }
        if (((Boolean)p_242685_0_.func_177229_b(field_176273_b)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a(voxelshape, field_185756_E);
        }
        if (((Boolean)p_242685_0_.func_177229_b(field_176279_N)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a(voxelshape, field_185755_D);
        }
        if (((Boolean)p_242685_0_.func_177229_b(field_176278_M)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a(voxelshape, field_185753_B);
        }
        if (((Boolean)p_242685_0_.func_177229_b(field_176280_O)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a(voxelshape, field_185754_C);
        }
        return voxelshape;
    }

    @Override
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return this.field_242684_o.get(p_220053_1_);
    }

    @Override
    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        return this.func_196543_i(this.func_196545_h(p_196260_1_, (IBlockReader)((Object)p_196260_2_), p_196260_3_));
    }

    private boolean func_196543_i(BlockState p_196543_1_) {
        return this.func_208496_w(p_196543_1_) > 0;
    }

    private int func_208496_w(BlockState p_208496_1_) {
        int i = 0;
        for (BooleanProperty booleanproperty : field_196546_A.values()) {
            if (!((Boolean)p_208496_1_.func_177229_b(booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean func_196541_a(IBlockReader p_196541_1_, BlockPos p_196541_2_, Direction p_196541_3_) {
        if (p_196541_3_ == Direction.DOWN) {
            return false;
        }
        BlockPos blockpos = p_196541_2_.func_177972_a(p_196541_3_);
        if (VineBlock.func_196542_b(p_196541_1_, blockpos, p_196541_3_)) {
            return true;
        }
        if (p_196541_3_.func_176740_k() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = field_196546_A.get((Object)p_196541_3_);
        BlockState blockstate = p_196541_1_.func_180495_p(p_196541_2_.func_177984_a());
        return blockstate.func_203425_a(this) && (Boolean)blockstate.func_177229_b(booleanproperty) != false;
    }

    public static boolean func_196542_b(IBlockReader p_196542_0_, BlockPos p_196542_1_, Direction p_196542_2_) {
        BlockState blockstate = p_196542_0_.func_180495_p(p_196542_1_);
        return Block.func_208061_a(blockstate.func_196952_d(p_196542_0_, p_196542_1_), p_196542_2_.func_176734_d());
    }

    private BlockState func_196545_h(BlockState p_196545_1_, IBlockReader p_196545_2_, BlockPos p_196545_3_) {
        BlockPos blockpos = p_196545_3_.func_177984_a();
        if (((Boolean)p_196545_1_.func_177229_b(field_176277_a)).booleanValue()) {
            p_196545_1_ = (BlockState)p_196545_1_.func_206870_a(field_176277_a, VineBlock.func_196542_b(p_196545_2_, blockpos, Direction.DOWN));
        }
        AbstractBlock.AbstractBlockState blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = VineBlock.func_176267_a(direction);
            if (!((Boolean)p_196545_1_.func_177229_b(booleanproperty)).booleanValue()) continue;
            boolean flag = this.func_196541_a(p_196545_2_, p_196545_3_, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = p_196545_2_.func_180495_p(blockpos);
                }
                flag = blockstate.func_203425_a(this) && (Boolean)blockstate.func_177229_b(booleanproperty) != false;
            }
            p_196545_1_ = (BlockState)p_196545_1_.func_206870_a(booleanproperty, flag);
        }
        return p_196545_1_;
    }

    @Override
    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (p_196271_2_ == Direction.DOWN) {
            return super.func_196271_a(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
        }
        BlockState blockstate = this.func_196545_h(p_196271_1_, (IBlockReader)((Object)p_196271_4_), p_196271_5_);
        return !this.func_196543_i(blockstate) ? Blocks.field_150350_a.func_176223_P() : blockstate;
    }

    @Override
    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        if (p_225542_2_.field_73012_v.nextInt(Math.max(1, (int)(100.0f / (float)p_225542_2_.spigotConfig.vineModifier) * 4)) == 0 && p_225542_2_.isAreaLoaded(p_225542_3_, 4)) {
            Direction direction = Direction.func_239631_a_(p_225542_4_);
            BlockPos blockpos = p_225542_3_.func_177984_a();
            if (direction.func_176740_k().func_176722_c() && !((Boolean)p_225542_1_.func_177229_b(VineBlock.func_176267_a(direction))).booleanValue()) {
                if (this.func_196539_a((IBlockReader)((Object)p_225542_2_), p_225542_3_)) {
                    BlockPos blockpos4 = p_225542_3_.func_177972_a(direction);
                    BlockState blockstate4 = p_225542_2_.func_180495_p(blockpos4);
                    if (blockstate4.isAir((IBlockReader)((Object)p_225542_2_), blockpos4)) {
                        Direction direction3 = direction.func_176746_e();
                        Direction direction4 = direction.func_176735_f();
                        boolean flag = (Boolean)p_225542_1_.func_177229_b(VineBlock.func_176267_a(direction3));
                        boolean flag1 = (Boolean)p_225542_1_.func_177229_b(VineBlock.func_176267_a(direction4));
                        BlockPos blockpos2 = blockpos4.func_177972_a(direction3);
                        BlockPos blockpos3 = blockpos4.func_177972_a(direction4);
                        BlockPos source = p_225542_3_;
                        if (flag && VineBlock.func_196542_b((IBlockReader)((Object)p_225542_2_), blockpos2, direction3)) {
                            CraftEventFactory.handleBlockSpreadEvent((World)p_225542_2_, (BlockPos)source, (BlockPos)blockpos4, (BlockState)((BlockState)this.func_176223_P().func_206870_a(VineBlock.func_176267_a(direction3), true)), (int)2);
                        } else if (flag1 && VineBlock.func_196542_b((IBlockReader)((Object)p_225542_2_), blockpos3, direction4)) {
                            CraftEventFactory.handleBlockSpreadEvent((World)p_225542_2_, (BlockPos)source, (BlockPos)blockpos4, (BlockState)((BlockState)this.func_176223_P().func_206870_a(VineBlock.func_176267_a(direction4), true)), (int)2);
                        } else {
                            Direction direction1 = direction.func_176734_d();
                            if (flag && p_225542_2_.func_175623_d(blockpos2) && VineBlock.func_196542_b((IBlockReader)((Object)p_225542_2_), p_225542_3_.func_177972_a(direction3), direction1)) {
                                CraftEventFactory.handleBlockSpreadEvent((World)p_225542_2_, (BlockPos)source, (BlockPos)blockpos2, (BlockState)((BlockState)this.func_176223_P().func_206870_a(VineBlock.func_176267_a(direction1), true)), (int)2);
                            } else if (flag1 && p_225542_2_.func_175623_d(blockpos3) && VineBlock.func_196542_b((IBlockReader)((Object)p_225542_2_), p_225542_3_.func_177972_a(direction4), direction1)) {
                                CraftEventFactory.handleBlockSpreadEvent((World)p_225542_2_, (BlockPos)source, (BlockPos)blockpos3, (BlockState)((BlockState)this.func_176223_P().func_206870_a(VineBlock.func_176267_a(direction1), true)), (int)2);
                            } else if ((double)p_225542_2_.field_73012_v.nextFloat() < 0.05 && VineBlock.func_196542_b((IBlockReader)((Object)p_225542_2_), blockpos4.func_177984_a(), Direction.UP)) {
                                CraftEventFactory.handleBlockSpreadEvent((World)p_225542_2_, (BlockPos)source, (BlockPos)blockpos4, (BlockState)((BlockState)this.func_176223_P().func_206870_a(field_176277_a, true)), (int)2);
                            }
                        }
                    } else if (VineBlock.func_196542_b((IBlockReader)((Object)p_225542_2_), blockpos4, direction)) {
                        p_225542_2_.func_180501_a(p_225542_3_, (BlockState)p_225542_1_.func_206870_a(VineBlock.func_176267_a(direction), true), 2);
                    }
                }
            } else {
                BlockState blockstate2;
                BlockState blockstate1;
                BlockPos blockpos1;
                BlockState blockstate;
                boolean isAir;
                if (direction == Direction.UP && p_225542_3_.func_177956_o() < 255) {
                    if (this.func_196541_a((IBlockReader)((Object)p_225542_2_), p_225542_3_, direction)) {
                        p_225542_2_.func_180501_a(p_225542_3_, (BlockState)p_225542_1_.func_206870_a(field_176277_a, true), 2);
                        return;
                    }
                    if (p_225542_2_.func_175623_d(blockpos)) {
                        if (!this.func_196539_a((IBlockReader)((Object)p_225542_2_), p_225542_3_)) {
                            return;
                        }
                        BlockState blockstate3 = p_225542_1_;
                        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                            if (!p_225542_4_.nextBoolean() && VineBlock.func_196542_b((IBlockReader)((Object)p_225542_2_), blockpos.func_177972_a(direction2), Direction.UP)) continue;
                            blockstate3 = (BlockState)blockstate3.func_206870_a(VineBlock.func_176267_a(direction2), false);
                        }
                        if (this.func_196540_x(blockstate3)) {
                            CraftEventFactory.handleBlockSpreadEvent((World)p_225542_2_, (BlockPos)p_225542_3_, (BlockPos)blockpos, (BlockState)blockstate3, (int)2);
                        }
                        return;
                    }
                }
                if (p_225542_3_.func_177956_o() > 0 && ((isAir = (blockstate = p_225542_2_.func_180495_p(blockpos1 = p_225542_3_.func_177977_b())).isAir((IBlockReader)((Object)p_225542_2_), blockpos1)) || blockstate.func_203425_a(this)) && (blockstate1 = isAir ? this.func_176223_P() : blockstate) != (blockstate2 = this.func_196544_a(p_225542_1_, blockstate1, p_225542_4_)) && this.func_196540_x(blockstate2)) {
                    CraftEventFactory.handleBlockSpreadEvent((World)p_225542_2_, (BlockPos)p_225542_3_, (BlockPos)blockpos1, (BlockState)blockstate2, (int)2);
                }
            }
        }
    }

    private BlockState func_196544_a(BlockState p_196544_1_, BlockState p_196544_2_, Random p_196544_3_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty;
            if (!p_196544_3_.nextBoolean() || !((Boolean)p_196544_1_.func_177229_b(booleanproperty = VineBlock.func_176267_a(direction))).booleanValue()) continue;
            p_196544_2_ = (BlockState)p_196544_2_.func_206870_a(booleanproperty, true);
        }
        return p_196544_2_;
    }

    private boolean func_196540_x(BlockState p_196540_1_) {
        return (Boolean)p_196540_1_.func_177229_b(field_176273_b) != false || (Boolean)p_196540_1_.func_177229_b(field_176278_M) != false || (Boolean)p_196540_1_.func_177229_b(field_176279_N) != false || (Boolean)p_196540_1_.func_177229_b(field_176280_O) != false;
    }

    private boolean func_196539_a(IBlockReader p_196539_1_, BlockPos p_196539_2_) {
        int i = 4;
        Iterable<BlockPos> iterable = BlockPos.func_191531_b(p_196539_2_.func_177958_n() - 4, p_196539_2_.func_177956_o() - 1, p_196539_2_.func_177952_p() - 4, p_196539_2_.func_177958_n() + 4, p_196539_2_.func_177956_o() + 1, p_196539_2_.func_177952_p() + 4);
        int j = 5;
        for (BlockPos blockpos : iterable) {
            if (!p_196539_1_.func_180495_p(blockpos).func_203425_a(this) || --j > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean func_196253_a(BlockState p_196253_1_, BlockItemUseContext p_196253_2_) {
        BlockState blockstate = p_196253_2_.func_195991_k().func_180495_p(p_196253_2_.func_195995_a());
        if (blockstate.func_203425_a(this)) {
            return this.func_208496_w(blockstate) < field_196546_A.size();
        }
        return super.func_196253_a(p_196253_1_, p_196253_2_);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        BlockState blockstate = p_196258_1_.func_195991_k().func_180495_p(p_196258_1_.func_195995_a());
        boolean flag = blockstate.func_203425_a(this);
        BlockState blockstate1 = flag ? blockstate : this.func_176223_P();
        for (Direction direction : p_196258_1_.func_196009_e()) {
            boolean flag1;
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanproperty = VineBlock.func_176267_a(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.func_177229_b(booleanproperty) != false;
            if (flag1 || !this.func_196541_a((IBlockReader)((Object)p_196258_1_.func_195991_k()), p_196258_1_.func_195995_a(), direction)) continue;
            return (BlockState)blockstate1.func_206870_a(booleanproperty, true);
        }
        return flag ? blockstate1 : null;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_176277_a, field_176273_b, field_176278_M, field_176279_N, field_176280_O});
    }

    @Override
    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        switch (p_185499_2_) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_185499_1_.func_206870_a(field_176273_b, (Boolean)p_185499_1_.func_177229_b(field_176279_N))).func_206870_a(field_176278_M, (Boolean)p_185499_1_.func_177229_b(field_176280_O))).func_206870_a(field_176279_N, (Boolean)p_185499_1_.func_177229_b(field_176273_b))).func_206870_a(field_176280_O, (Boolean)p_185499_1_.func_177229_b(field_176278_M));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_185499_1_.func_206870_a(field_176273_b, (Boolean)p_185499_1_.func_177229_b(field_176278_M))).func_206870_a(field_176278_M, (Boolean)p_185499_1_.func_177229_b(field_176279_N))).func_206870_a(field_176279_N, (Boolean)p_185499_1_.func_177229_b(field_176280_O))).func_206870_a(field_176280_O, (Boolean)p_185499_1_.func_177229_b(field_176273_b));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_185499_1_.func_206870_a(field_176273_b, (Boolean)p_185499_1_.func_177229_b(field_176280_O))).func_206870_a(field_176278_M, (Boolean)p_185499_1_.func_177229_b(field_176273_b))).func_206870_a(field_176279_N, (Boolean)p_185499_1_.func_177229_b(field_176278_M))).func_206870_a(field_176280_O, (Boolean)p_185499_1_.func_177229_b(field_176279_N));
            }
        }
        return p_185499_1_;
    }

    @Override
    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        switch (p_185471_2_) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)p_185471_1_.func_206870_a(field_176273_b, (Boolean)p_185471_1_.func_177229_b(field_176279_N))).func_206870_a(field_176279_N, (Boolean)p_185471_1_.func_177229_b(field_176273_b));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)p_185471_1_.func_206870_a(field_176278_M, (Boolean)p_185471_1_.func_177229_b(field_176280_O))).func_206870_a(field_176280_O, (Boolean)p_185471_1_.func_177229_b(field_176278_M));
            }
        }
        return super.func_185471_a(p_185471_1_, p_185471_2_);
    }

    public static BooleanProperty func_176267_a(Direction p_176267_0_) {
        return field_196546_A.get((Object)p_176267_0_);
    }
}

