/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Function4;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.WorldOptimizer;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class OptimizeWorldScreen
extends Screen {
    private static final Logger field_239024_a_ = LogManager.getLogger();
    private static final Object2IntMap<RegistryKey<World>> field_212348_a = (Object2IntMap)Util.func_200696_a(new Object2IntOpenCustomHashMap(Util.func_212443_g()), p_212346_0_ -> {
        p_212346_0_.put(World.field_234918_g_, -13408734);
        p_212346_0_.put(World.field_234919_h_, -10075085);
        p_212346_0_.put(World.field_234920_i_, -8943531);
        p_212346_0_.defaultReturnValue(-2236963);
    });
    private final BooleanConsumer field_214332_b;
    private final WorldOptimizer field_212203_f;

    @Nullable
    public static OptimizeWorldScreen func_239025_a_(Minecraft p_239025_0_, BooleanConsumer p_239025_1_, DataFixer p_239025_2_, SaveFormat.LevelSave p_239025_3_, boolean p_239025_4_) {
        DynamicRegistries.Impl dynamicregistries$impl = DynamicRegistries.func_239770_b_();
        Minecraft.PackManager minecraft$packmanager = p_239025_0_.func_238189_a_(dynamicregistries$impl, Minecraft::func_238180_a_, (Function4<SaveFormat.LevelSave, DynamicRegistries.Impl, IResourceManager, DatapackCodec, IServerConfiguration>)((Function4)Minecraft::func_238181_a_), false, p_239025_3_);
        try {
            IServerConfiguration iserverconfiguration = minecraft$packmanager.func_238226_c_();
            p_239025_3_.func_237287_a_(dynamicregistries$impl, iserverconfiguration);
            ImmutableSet<RegistryKey<World>> immutableset = iserverconfiguration.func_230418_z_().func_236226_g_();
            OptimizeWorldScreen optimizeWorldScreen = new OptimizeWorldScreen(p_239025_1_, p_239025_2_, p_239025_3_, iserverconfiguration.func_230408_H_(), p_239025_4_, immutableset);
            if (minecraft$packmanager != null) {
                minecraft$packmanager.close();
            }
            return optimizeWorldScreen;
        }
        catch (Throwable throwable) {
            try {
                if (minecraft$packmanager != null) {
                    try {
                        minecraft$packmanager.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception exception) {
                field_239024_a_.warn("Failed to load datapacks, can't optimize world", (Throwable)exception);
                return null;
            }
        }
    }

    private OptimizeWorldScreen(BooleanConsumer p_i232319_1_, DataFixer p_i232319_2_, SaveFormat.LevelSave p_i232319_3_, WorldSettings p_i232319_4_, boolean p_i232319_5_, ImmutableSet<RegistryKey<World>> p_i232319_6_) {
        super((ITextComponent)((Object)new TranslationTextComponent("optimizeWorld.title", p_i232319_4_.func_234947_a_())));
        this.field_214332_b = p_i232319_1_;
        this.field_212203_f = new WorldOptimizer(p_i232319_3_, p_i232319_2_, null, p_i232319_5_);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 150, 200, 20, DialogTexts.field_240633_d_, p_214331_1_ -> {
            this.field_212203_f.func_212217_a();
            this.field_214332_b.accept(false);
        }));
    }

    @Override
    public void func_231023_e_() {
        if (this.field_212203_f.func_212218_b()) {
            this.field_214332_b.accept(true);
        }
    }

    @Override
    public void func_231175_as__() {
        this.field_214332_b.accept(false);
    }

    @Override
    public void func_231164_f_() {
        this.field_212203_f.func_212217_a();
    }

    @Override
    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.func_230446_a_(p_230430_1_);
        OptimizeWorldScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        int i = this.field_230708_k_ / 2 - 150;
        int j = this.field_230708_k_ / 2 + 150;
        int k = this.field_230709_l_ / 4 + 100;
        int l = k + 10;
        OptimizeWorldScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_212203_f.func_212215_m(), (int)(this.field_230708_k_ / 2), (int)(k - 9 - 2), (int)0xA0A0A0);
        if (this.field_212203_f.func_212211_j() > 0) {
            OptimizeWorldScreen.func_238467_a_((MatrixStack)p_230430_1_, (int)(i - 1), (int)(k - 1), (int)(j + 1), (int)(l + 1), (int)-16777216);
            OptimizeWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)((Object)new TranslationTextComponent("optimizeWorld.info.converted", this.field_212203_f.func_212208_k())), (int)i, (int)40, (int)0xA0A0A0);
            OptimizeWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)((Object)new TranslationTextComponent("optimizeWorld.info.skipped", this.field_212203_f.func_212209_l())), (int)i, (int)52, (int)0xA0A0A0);
            OptimizeWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)((Object)new TranslationTextComponent("optimizeWorld.info.total", this.field_212203_f.func_212211_j())), (int)i, (int)64, (int)0xA0A0A0);
            int i1 = 0;
            for (RegistryKey registrykey : this.field_212203_f.func_233533_c_()) {
                int j1 = MathHelper.func_76141_d((float)(this.field_212203_f.func_233531_a_(registrykey) * (float)(j - i)));
                OptimizeWorldScreen.func_238467_a_((MatrixStack)p_230430_1_, (int)(i + i1), (int)k, (int)(i + i1 + j1), (int)l, (int)field_212348_a.getInt((Object)registrykey));
                i1 += j1;
            }
            int k1 = this.field_212203_f.func_212208_k() + this.field_212203_f.func_212209_l();
            OptimizeWorldScreen.func_238471_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (String)(k1 + " / " + this.field_212203_f.func_212211_j()), (int)(this.field_230708_k_ / 2), (int)(k + 18 + 2), (int)0xA0A0A0);
            OptimizeWorldScreen.func_238471_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (String)(MathHelper.func_76141_d((float)(this.field_212203_f.func_212207_i() * 100.0f)) + "%"), (int)(this.field_230708_k_ / 2), (int)(k + (l - k) / 2 - 4), (int)0xA0A0A0);
        }
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }
}

