/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen.inventory;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public abstract class ContainerScreen<T extends Container>
extends Screen
implements IHasContainer<T> {
    public static final ResourceLocation field_147001_a = new ResourceLocation("textures/gui/container/inventory.png");
    protected int field_146999_f = 176;
    protected int field_147000_g = 166;
    protected int field_238742_p_;
    protected int field_238743_q_;
    protected int field_238744_r_;
    protected int field_238745_s_;
    protected final T field_147002_h;
    protected final PlayerInventory field_213127_e;
    @Nullable
    protected Slot field_147006_u;
    @Nullable
    private Slot field_147005_v;
    @Nullable
    private Slot field_146989_A;
    @Nullable
    private Slot field_146985_D;
    @Nullable
    private Slot field_146998_K;
    protected int field_147003_i;
    protected int field_147009_r;
    private boolean field_147004_w;
    private ItemStack field_147012_x = ItemStack.field_190927_a;
    private int field_147011_y;
    private int field_147010_z;
    private long field_146990_B;
    private ItemStack field_146991_C = ItemStack.field_190927_a;
    private long field_146986_E;
    protected final Set<Slot> field_147008_s = Sets.newHashSet();
    protected boolean field_147007_t;
    private int field_146987_F;
    private int field_146988_G;
    private boolean field_146995_H;
    private int field_146996_I;
    private long field_146997_J;
    private int field_146992_L;
    private boolean field_146993_M;
    private ItemStack field_146994_N = ItemStack.field_190927_a;
    protected int slotColor = -2130706433;

    public ContainerScreen(T p_i51105_1_, PlayerInventory p_i51105_2_, ITextComponent p_i51105_3_) {
        super(p_i51105_3_);
        this.field_147002_h = p_i51105_1_;
        this.field_213127_e = p_i51105_2_;
        this.field_146995_H = true;
        this.field_238742_p_ = 8;
        this.field_238743_q_ = 6;
        this.field_238744_r_ = 8;
        this.field_238745_s_ = this.field_147000_g - 94;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_147003_i = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_230709_l_ - this.field_147000_g) / 2;
    }

    @Override
    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        ItemStack itemstack;
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_230450_a_(p_230430_1_, p_230430_4_, p_230430_2_, p_230430_3_);
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawBackground(this, p_230430_1_, p_230430_2_, p_230430_3_));
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)i, (float)j, (float)0.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        this.field_147006_u = null;
        int k = 240;
        int l = 240;
        RenderSystem.glMultiTexCoord2f((int)33986, (float)240.0f, (float)240.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i1 = 0; i1 < ((Container)this.field_147002_h).field_75151_b.size(); ++i1) {
            Slot slot = ((Container)this.field_147002_h).field_75151_b.get(i1);
            if (slot.func_111238_b()) {
                this.func_238746_a_(p_230430_1_, slot);
            }
            if (!this.func_195362_a(slot, p_230430_2_, p_230430_3_) || !slot.func_111238_b()) continue;
            this.field_147006_u = slot;
            RenderSystem.disableDepthTest();
            int j1 = slot.field_75223_e;
            int k1 = slot.field_75221_f;
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int slotColor = this.getSlotColor(i1);
            this.func_238468_a_(p_230430_1_, j1, k1, j1 + 16, k1 + 16, slotColor, slotColor);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
        this.func_230451_b_(p_230430_1_, p_230430_2_, p_230430_3_);
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawForeground(this, p_230430_1_, p_230430_2_, p_230430_3_));
        PlayerInventory playerinventory = this.field_230706_i_.field_71439_g.field_71071_by;
        ItemStack itemStack = itemstack = this.field_147012_x.func_190926_b() ? playerinventory.func_70445_o() : this.field_147012_x;
        if (!itemstack.func_190926_b()) {
            int j2 = 8;
            int k2 = this.field_147012_x.func_190926_b() ? 8 : 16;
            String s = null;
            if (!this.field_147012_x.func_190926_b() && this.field_147004_w) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(MathHelper.func_76123_f((float)((float)itemstack.func_190916_E() / 2.0f)));
            } else if (this.field_147007_t && this.field_147008_s.size() > 1) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(this.field_146996_I);
                if (itemstack.func_190926_b()) {
                    s = TextFormatting.YELLOW + "0";
                }
            }
            this.func_146982_a(itemstack, p_230430_2_ - i - 8, p_230430_3_ - j - k2, s);
        }
        if (!this.field_146991_C.func_190926_b()) {
            float f = (float)(Util.func_211177_b() - this.field_146990_B) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.field_146991_C = ItemStack.field_190927_a;
            }
            int l2 = this.field_146989_A.field_75223_e - this.field_147011_y;
            int i3 = this.field_146989_A.field_75221_f - this.field_147010_z;
            int l1 = this.field_147011_y + (int)((float)l2 * f);
            int i2 = this.field_147010_z + (int)((float)i3 * f);
            this.func_146982_a(this.field_146991_C, l1, i2, null);
        }
        RenderSystem.popMatrix();
        RenderSystem.enableDepthTest();
    }

    protected void func_230459_a_(MatrixStack p_230459_1_, int p_230459_2_, int p_230459_3_) {
        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            this.func_230457_a_(p_230459_1_, this.field_147006_u.func_75211_c(), p_230459_2_, p_230459_3_);
        }
    }

    private void func_146982_a(ItemStack p_146982_1_, int p_146982_2_, int p_146982_3_, String p_146982_4_) {
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.func_230926_e_(200);
        this.field_230707_j_.field_77023_b = 200.0f;
        FontRenderer font = p_146982_1_.func_77973_b().getFontRenderer(p_146982_1_);
        if (font == null) {
            font = this.field_230712_o_;
        }
        this.field_230707_j_.func_180450_b(p_146982_1_, p_146982_2_, p_146982_3_);
        this.field_230707_j_.func_180453_a(font, p_146982_1_, p_146982_2_, p_146982_3_ - (this.field_147012_x.func_190926_b() ? 0 : 8), p_146982_4_);
        this.func_230926_e_(0);
        this.field_230707_j_.field_77023_b = 0.0f;
    }

    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
        this.field_230712_o_.func_243248_b(p_230451_1_, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
        this.field_230712_o_.func_243248_b(p_230451_1_, this.field_213127_e.func_145748_c_(), (float)this.field_238744_r_, (float)this.field_238745_s_, 0x404040);
    }

    protected abstract void func_230450_a_(MatrixStack var1, float var2, int var3, int var4);

    private void func_238746_a_(MatrixStack p_238746_1_, Slot p_238746_2_) {
        Pair<ResourceLocation, ResourceLocation> pair;
        int i = p_238746_2_.field_75223_e;
        int j = p_238746_2_.field_75221_f;
        ItemStack itemstack = p_238746_2_.func_75211_c();
        boolean flag = false;
        boolean flag1 = p_238746_2_ == this.field_147005_v && !this.field_147012_x.func_190926_b() && !this.field_147004_w;
        ItemStack itemstack1 = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
        String s = null;
        if (p_238746_2_ == this.field_147005_v && !this.field_147012_x.func_190926_b() && this.field_147004_w && !itemstack.func_190926_b()) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_190920_e(itemstack.func_190916_E() / 2);
        } else if (this.field_147007_t && this.field_147008_s.contains(p_238746_2_) && !itemstack1.func_190926_b()) {
            if (this.field_147008_s.size() == 1) {
                return;
            }
            if (Container.func_94527_a(p_238746_2_, itemstack1, true) && ((Container)this.field_147002_h).func_94531_b(p_238746_2_)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a(this.field_147008_s, this.field_146987_F, itemstack, p_238746_2_.func_75211_c().func_190926_b() ? 0 : p_238746_2_.func_75211_c().func_190916_E());
                int k = Math.min(itemstack.func_77976_d(), p_238746_2_.func_178170_b(itemstack));
                if (itemstack.func_190916_E() > k) {
                    s = TextFormatting.YELLOW.toString() + k;
                    itemstack.func_190920_e(k);
                }
            } else {
                this.field_147008_s.remove(p_238746_2_);
                this.func_146980_g();
            }
        }
        this.func_230926_e_(100);
        this.field_230707_j_.field_77023_b = 100.0f;
        if (itemstack.func_190926_b() && p_238746_2_.func_111238_b() && (pair = p_238746_2_.func_225517_c_()) != null) {
            TextureAtlasSprite textureatlassprite = this.field_230706_i_.func_228015_a_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            this.field_230706_i_.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
            ContainerScreen.func_238470_a_((MatrixStack)p_238746_1_, (int)i, (int)j, (int)this.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                ContainerScreen.func_238467_a_((MatrixStack)p_238746_1_, (int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            RenderSystem.enableDepthTest();
            this.field_230707_j_.func_184391_a(this.field_230706_i_.field_71439_g, itemstack, i, j);
            this.field_230707_j_.func_180453_a(this.field_230712_o_, itemstack, i, j, s);
        }
        this.field_230707_j_.field_77023_b = 0.0f;
        this.func_230926_e_(0);
    }

    private void func_146980_g() {
        ItemStack itemstack = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
        if (!itemstack.func_190926_b() && this.field_147007_t) {
            if (this.field_146987_F == 2) {
                this.field_146996_I = itemstack.func_77976_d();
            } else {
                this.field_146996_I = itemstack.func_190916_E();
                for (Slot slot : this.field_147008_s) {
                    ItemStack itemstack1 = itemstack.func_77946_l();
                    ItemStack itemstack2 = slot.func_75211_c();
                    int i = itemstack2.func_190926_b() ? 0 : itemstack2.func_190916_E();
                    Container.func_94525_a(this.field_147008_s, this.field_146987_F, itemstack1, i);
                    int j = Math.min(itemstack1.func_77976_d(), slot.func_178170_b(itemstack1));
                    if (itemstack1.func_190916_E() > j) {
                        itemstack1.func_190920_e(j);
                    }
                    this.field_146996_I -= itemstack1.func_190916_E() - i;
                }
            }
        }
    }

    @Nullable
    private Slot func_195360_a(double p_195360_1_, double p_195360_3_) {
        for (int i = 0; i < ((Container)this.field_147002_h).field_75151_b.size(); ++i) {
            Slot slot = ((Container)this.field_147002_h).field_75151_b.get(i);
            if (!this.func_195362_a(slot, p_195360_1_, p_195360_3_) || !slot.func_111238_b()) continue;
            return slot;
        }
        return null;
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (super.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_)) {
            return true;
        }
        InputMappings.Input mouseKey = InputMappings.Type.MOUSE.func_197944_a(p_231044_5_);
        boolean flag = this.field_230706_i_.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey);
        Slot slot = this.func_195360_a(p_231044_1_, p_231044_3_);
        long i = Util.func_211177_b();
        this.field_146993_M = this.field_146998_K == slot && i - this.field_146997_J < 250L && this.field_146992_L == p_231044_5_;
        this.field_146995_H = false;
        if (p_231044_5_ != 0 && p_231044_5_ != 1 && !flag) {
            this.func_241609_a_(p_231044_5_);
        } else {
            int j = this.field_147003_i;
            int k = this.field_147009_r;
            boolean flag1 = this.func_195361_a(p_231044_1_, p_231044_3_, j, k, p_231044_5_);
            if (slot != null) {
                flag1 = false;
            }
            int l = -1;
            if (slot != null) {
                l = slot.field_75222_d;
            }
            if (flag1) {
                l = -999;
            }
            if (this.field_230706_i_.field_71474_y.field_85185_A && flag1 && this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                this.field_230706_i_.func_147108_a(null);
                return true;
            }
            if (l != -1) {
                if (this.field_230706_i_.field_71474_y.field_85185_A) {
                    if (slot != null && slot.func_75216_d()) {
                        this.field_147005_v = slot;
                        this.field_147012_x = ItemStack.field_190927_a;
                        this.field_147004_w = p_231044_5_ == 1;
                    } else {
                        this.field_147005_v = null;
                    }
                } else if (!this.field_147007_t) {
                    if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                        if (this.field_230706_i_.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey)) {
                            this.func_184098_a(slot, l, p_231044_5_, ClickType.CLONE);
                        } else {
                            boolean flag2 = l != -999 && (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344));
                            ClickType clicktype = ClickType.PICKUP;
                            if (flag2) {
                                this.field_146994_N = slot != null && slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
                                clicktype = ClickType.QUICK_MOVE;
                            } else if (l == -999) {
                                clicktype = ClickType.THROW;
                            }
                            this.func_184098_a(slot, l, p_231044_5_, clicktype);
                        }
                        this.field_146995_H = true;
                    } else {
                        this.field_147007_t = true;
                        this.field_146988_G = p_231044_5_;
                        this.field_147008_s.clear();
                        if (p_231044_5_ == 0) {
                            this.field_146987_F = 0;
                        } else if (p_231044_5_ == 1) {
                            this.field_146987_F = 1;
                        } else if (this.field_230706_i_.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey)) {
                            this.field_146987_F = 2;
                        }
                    }
                }
            }
        }
        this.field_146998_K = slot;
        this.field_146997_J = i;
        this.field_146992_L = p_231044_5_;
        return true;
    }

    private void func_241609_a_(int p_241609_1_) {
        if (this.field_147006_u != null && this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            if (this.field_230706_i_.field_71474_y.field_186718_X.func_197984_a(p_241609_1_)) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, 40, ClickType.SWAP);
                return;
            }
            for (int i = 0; i < 9; ++i) {
                if (!this.field_230706_i_.field_71474_y.field_151456_ac[i].func_197984_a(p_241609_1_)) continue;
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, i, ClickType.SWAP);
            }
        }
    }

    protected boolean func_195361_a(double p_195361_1_, double p_195361_3_, int p_195361_5_, int p_195361_6_, int p_195361_7_) {
        return p_195361_1_ < (double)p_195361_5_ || p_195361_3_ < (double)p_195361_6_ || p_195361_1_ >= (double)(p_195361_5_ + this.field_146999_f) || p_195361_3_ >= (double)(p_195361_6_ + this.field_147000_g);
    }

    public boolean func_231045_a_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        Slot slot = this.func_195360_a(p_231045_1_, p_231045_3_);
        ItemStack itemstack = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
        if (this.field_147005_v != null && this.field_230706_i_.field_71474_y.field_85185_A) {
            if (p_231045_5_ == 0 || p_231045_5_ == 1) {
                if (this.field_147012_x.func_190926_b()) {
                    if (slot != this.field_147005_v && !this.field_147005_v.func_75211_c().func_190926_b()) {
                        this.field_147012_x = this.field_147005_v.func_75211_c().func_77946_l();
                    }
                } else if (this.field_147012_x.func_190916_E() > 1 && slot != null && Container.func_94527_a(slot, this.field_147012_x, false)) {
                    long i = Util.func_211177_b();
                    if (this.field_146985_D == slot) {
                        if (i - this.field_146986_E > 500L) {
                            this.func_184098_a(this.field_147005_v, this.field_147005_v.field_75222_d, 0, ClickType.PICKUP);
                            this.func_184098_a(slot, slot.field_75222_d, 1, ClickType.PICKUP);
                            this.func_184098_a(this.field_147005_v, this.field_147005_v.field_75222_d, 0, ClickType.PICKUP);
                            this.field_146986_E = i + 750L;
                            this.field_147012_x.func_190918_g(1);
                        }
                    } else {
                        this.field_146985_D = slot;
                        this.field_146986_E = i;
                    }
                }
            }
        } else if (this.field_147007_t && slot != null && !itemstack.func_190926_b() && (itemstack.func_190916_E() > this.field_147008_s.size() || this.field_146987_F == 2) && Container.func_94527_a(slot, itemstack, true) && slot.func_75214_a(itemstack) && ((Container)this.field_147002_h).func_94531_b(slot)) {
            this.field_147008_s.add(slot);
            this.func_146980_g();
        }
        return true;
    }

    public boolean func_231048_c_(double p_231048_1_, double p_231048_3_, int p_231048_5_) {
        super.func_231048_c_(p_231048_1_, p_231048_3_, p_231048_5_);
        Slot slot = this.func_195360_a(p_231048_1_, p_231048_3_);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        boolean flag = this.func_195361_a(p_231048_1_, p_231048_3_, i, j, p_231048_5_);
        if (slot != null) {
            flag = false;
        }
        InputMappings.Input mouseKey = InputMappings.Type.MOUSE.func_197944_a(p_231048_5_);
        int k = -1;
        if (slot != null) {
            k = slot.field_75222_d;
        }
        if (flag) {
            k = -999;
        }
        if (this.field_146993_M && slot != null && p_231048_5_ == 0 && ((Container)this.field_147002_h).func_94530_a(ItemStack.field_190927_a, slot)) {
            if (ContainerScreen.func_231173_s_()) {
                if (!this.field_146994_N.func_190926_b()) {
                    for (Slot slot2 : ((Container)this.field_147002_h).field_75151_b) {
                        if (slot2 == null || !slot2.func_82869_a(this.field_230706_i_.field_71439_g) || !slot2.func_75216_d() || !slot2.isSameInventory(slot) || !Container.func_94527_a(slot2, this.field_146994_N, true)) continue;
                        this.func_184098_a(slot2, slot2.field_75222_d, p_231048_5_, ClickType.QUICK_MOVE);
                    }
                }
            } else {
                this.func_184098_a(slot, k, p_231048_5_, ClickType.PICKUP_ALL);
            }
            this.field_146993_M = false;
            this.field_146997_J = 0L;
        } else {
            if (this.field_147007_t && this.field_146988_G != p_231048_5_) {
                this.field_147007_t = false;
                this.field_147008_s.clear();
                this.field_146995_H = true;
                return true;
            }
            if (this.field_146995_H) {
                this.field_146995_H = false;
                return true;
            }
            if (this.field_147005_v != null && this.field_230706_i_.field_71474_y.field_85185_A) {
                if (p_231048_5_ == 0 || p_231048_5_ == 1) {
                    if (this.field_147012_x.func_190926_b() && slot != this.field_147005_v) {
                        this.field_147012_x = this.field_147005_v.func_75211_c();
                    }
                    boolean flag2 = Container.func_94527_a(slot, this.field_147012_x, false);
                    if (k != -1 && !this.field_147012_x.func_190926_b() && flag2) {
                        this.func_184098_a(this.field_147005_v, this.field_147005_v.field_75222_d, p_231048_5_, ClickType.PICKUP);
                        this.func_184098_a(slot, k, 0, ClickType.PICKUP);
                        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                            this.field_146991_C = ItemStack.field_190927_a;
                        } else {
                            this.func_184098_a(this.field_147005_v, this.field_147005_v.field_75222_d, p_231048_5_, ClickType.PICKUP);
                            this.field_147011_y = MathHelper.func_76128_c((double)(p_231048_1_ - (double)i));
                            this.field_147010_z = MathHelper.func_76128_c((double)(p_231048_3_ - (double)j));
                            this.field_146989_A = this.field_147005_v;
                            this.field_146991_C = this.field_147012_x;
                            this.field_146990_B = Util.func_211177_b();
                        }
                    } else if (!this.field_147012_x.func_190926_b()) {
                        this.field_147011_y = MathHelper.func_76128_c((double)(p_231048_1_ - (double)i));
                        this.field_147010_z = MathHelper.func_76128_c((double)(p_231048_3_ - (double)j));
                        this.field_146989_A = this.field_147005_v;
                        this.field_146991_C = this.field_147012_x;
                        this.field_146990_B = Util.func_211177_b();
                    }
                    this.field_147012_x = ItemStack.field_190927_a;
                    this.field_147005_v = null;
                }
            } else if (this.field_147007_t && !this.field_147008_s.isEmpty()) {
                this.func_184098_a(null, -999, Container.func_94534_d(0, this.field_146987_F), ClickType.QUICK_CRAFT);
                for (Slot slot1 : this.field_147008_s) {
                    this.func_184098_a(slot1, slot1.field_75222_d, Container.func_94534_d(1, this.field_146987_F), ClickType.QUICK_CRAFT);
                }
                this.func_184098_a(null, -999, Container.func_94534_d(2, this.field_146987_F), ClickType.QUICK_CRAFT);
            } else if (!this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                if (this.field_230706_i_.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey)) {
                    this.func_184098_a(slot, k, p_231048_5_, ClickType.CLONE);
                } else {
                    boolean flag1;
                    boolean bl = flag1 = k != -999 && (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344));
                    if (flag1) {
                        this.field_146994_N = slot != null && slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
                    }
                    this.func_184098_a(slot, k, p_231048_5_, flag1 ? ClickType.QUICK_MOVE : ClickType.PICKUP);
                }
            }
        }
        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            this.field_146997_J = 0L;
        }
        this.field_147007_t = false;
        return true;
    }

    private boolean func_195362_a(Slot p_195362_1_, double p_195362_2_, double p_195362_4_) {
        return this.func_195359_a(p_195362_1_.field_75223_e, p_195362_1_.field_75221_f, 16, 16, p_195362_2_, p_195362_4_);
    }

    protected boolean func_195359_a(int p_195359_1_, int p_195359_2_, int p_195359_3_, int p_195359_4_, double p_195359_5_, double p_195359_7_) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        return (p_195359_5_ -= (double)i) >= (double)(p_195359_1_ - 1) && p_195359_5_ < (double)(p_195359_1_ + p_195359_3_ + 1) && (p_195359_7_ -= (double)j) >= (double)(p_195359_2_ - 1) && p_195359_7_ < (double)(p_195359_2_ + p_195359_4_ + 1);
    }

    protected void func_184098_a(Slot p_184098_1_, int p_184098_2_, int p_184098_3_, ClickType p_184098_4_) {
        if (p_184098_1_ != null) {
            p_184098_2_ = p_184098_1_.field_75222_d;
        }
        this.field_230706_i_.field_71442_b.func_187098_a(((Container)this.field_147002_h).field_75152_c, p_184098_2_, p_184098_3_, p_184098_4_, this.field_230706_i_.field_71439_g);
    }

    @Override
    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)p_231046_1_, (int)p_231046_2_);
        if (super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_)) {
            return true;
        }
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.func_231175_as__();
            return true;
        }
        boolean handled = this.func_195363_d(p_231046_1_, p_231046_2_);
        if (this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            if (this.field_230706_i_.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey)) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, 0, ClickType.CLONE);
                handled = true;
            } else if (this.field_230706_i_.field_71474_y.field_74316_C.isActiveAndMatches(mouseKey)) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, ContainerScreen.func_231172_r_() ? 1 : 0, ClickType.THROW);
                handled = true;
            }
        } else if (this.field_230706_i_.field_71474_y.field_74316_C.isActiveAndMatches(mouseKey)) {
            handled = true;
        }
        return handled;
    }

    protected boolean func_195363_d(int p_195363_1_, int p_195363_2_) {
        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null) {
            if (this.field_230706_i_.field_71474_y.field_186718_X.isActiveAndMatches(InputMappings.func_197954_a((int)p_195363_1_, (int)p_195363_2_))) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, 40, ClickType.SWAP);
                return true;
            }
            for (int i = 0; i < 9; ++i) {
                if (!this.field_230706_i_.field_71474_y.field_151456_ac[i].isActiveAndMatches(InputMappings.func_197954_a((int)p_195363_1_, (int)p_195363_2_))) continue;
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, i, ClickType.SWAP);
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_231164_f_() {
        if (this.field_230706_i_.field_71439_g != null) {
            ((Container)this.field_147002_h).func_75134_a(this.field_230706_i_.field_71439_g);
        }
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (!this.field_230706_i_.field_71439_g.func_70089_S() || this.field_230706_i_.field_71439_g.field_70128_L) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
    }

    public T func_212873_a_() {
        return this.field_147002_h;
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        return this.field_147006_u;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public int getXSize() {
        return this.field_146999_f;
    }

    public int getYSize() {
        return this.field_147000_g;
    }

    public int getSlotColor(int index) {
        return this.slotColor;
    }

    @Override
    public void func_231175_as__() {
        this.field_230706_i_.field_71439_g.func_71053_j();
        super.func_231175_as__();
    }
}

