/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.CreativeCraftingListener;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.settings.CreativeSettings;
import net.minecraft.client.settings.HotbarSnapshot;
import net.minecraft.client.util.IMutableSearchTree;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class CreativeScreen
extends DisplayEffectsScreen<CreativeContainer> {
    private static final ResourceLocation field_147061_u = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final Inventory field_195378_x = new Inventory(45);
    private static final ITextComponent field_243345_D = new TranslationTextComponent("inventory.binSlot");
    private static int field_147058_w = ItemGroup.field_78030_b.func_78021_a();
    private float field_147067_x;
    private boolean field_147066_y;
    private TextFieldWidget field_147062_A;
    @Nullable
    private List<Slot> field_147063_B;
    @Nullable
    private Slot field_147064_C;
    private CreativeCraftingListener field_147059_E;
    private boolean field_195377_F;
    private static int tabPage = 0;
    private int maxPages = 0;
    private boolean field_199506_G;
    private final Map<ResourceLocation, ITag<Item>> field_214085_w = Maps.newTreeMap();

    public CreativeScreen(PlayerEntity p_i1088_1_) {
        super(new CreativeContainer(p_i1088_1_), p_i1088_1_.field_71071_by, StringTextComponent.field_240750_d_);
        p_i1088_1_.field_71070_bA = this.field_147002_h;
        this.field_230711_n_ = true;
        this.field_147000_g = 136;
        this.field_146999_f = 195;
    }

    @Override
    public void func_231023_e_() {
        if (!this.field_230706_i_.field_71442_b.func_78758_h()) {
            this.field_230706_i_.func_147108_a((Screen)new InventoryScreen((PlayerEntity)this.field_230706_i_.field_71439_g));
        } else if (this.field_147062_A != null) {
            this.field_147062_A.func_146178_a();
        }
    }

    @Override
    protected void func_184098_a(@Nullable Slot p_184098_1_, int p_184098_2_, int p_184098_3_, ClickType p_184098_4_) {
        if (this.func_208018_a(p_184098_1_)) {
            this.field_147062_A.func_146202_e();
            this.field_147062_A.func_146199_i(0);
        }
        boolean flag = p_184098_4_ == ClickType.QUICK_MOVE;
        ClickType clickType = p_184098_4_ = p_184098_2_ == -999 && p_184098_4_ == ClickType.PICKUP ? ClickType.THROW : p_184098_4_;
        if (p_184098_1_ == null && field_147058_w != ItemGroup.field_78036_m.func_78021_a() && p_184098_4_ != ClickType.QUICK_CRAFT) {
            PlayerInventory playerinventory1 = this.field_230706_i_.field_71439_g.field_71071_by;
            if (!playerinventory1.func_70445_o().func_190926_b() && this.field_199506_G) {
                if (p_184098_3_ == 0) {
                    this.field_230706_i_.field_71439_g.func_71019_a(playerinventory1.func_70445_o(), true);
                    this.field_230706_i_.field_71442_b.func_78752_a(playerinventory1.func_70445_o());
                    playerinventory1.func_70437_b(ItemStack.field_190927_a);
                }
                if (p_184098_3_ == 1) {
                    ItemStack itemstack6 = playerinventory1.func_70445_o().func_77979_a(1);
                    this.field_230706_i_.field_71439_g.func_71019_a(itemstack6, true);
                    this.field_230706_i_.field_71442_b.func_78752_a(itemstack6);
                }
            }
        } else {
            if (p_184098_1_ != null && !p_184098_1_.func_82869_a(this.field_230706_i_.field_71439_g)) {
                return;
            }
            if (p_184098_1_ == this.field_147064_C && flag) {
                for (int j = 0; j < this.field_230706_i_.field_71439_g.field_71069_bz.func_75138_a().size(); ++j) {
                    this.field_230706_i_.field_71442_b.func_78761_a(ItemStack.field_190927_a, j);
                }
            } else if (field_147058_w == ItemGroup.field_78036_m.func_78021_a()) {
                if (p_184098_1_ == this.field_147064_C) {
                    this.field_230706_i_.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                } else if (p_184098_4_ == ClickType.THROW && p_184098_1_ != null && p_184098_1_.func_75216_d()) {
                    ItemStack itemstack = p_184098_1_.func_75209_a(p_184098_3_ == 0 ? 1 : p_184098_1_.func_75211_c().func_77976_d());
                    ItemStack itemstack1 = p_184098_1_.func_75211_c();
                    this.field_230706_i_.field_71439_g.func_71019_a(itemstack, true);
                    this.field_230706_i_.field_71442_b.func_78752_a(itemstack);
                    this.field_230706_i_.field_71442_b.func_78761_a(itemstack1, ((CreativeSlot)p_184098_1_).field_148332_b.field_75222_d);
                } else if (p_184098_4_ == ClickType.THROW && !this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    this.field_230706_i_.field_71439_g.func_71019_a(this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o(), true);
                    this.field_230706_i_.field_71442_b.func_78752_a(this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o());
                    this.field_230706_i_.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                } else {
                    this.field_230706_i_.field_71439_g.field_71069_bz.func_184996_a(p_184098_1_ == null ? p_184098_2_ : ((CreativeSlot)p_184098_1_).field_148332_b.field_75222_d, p_184098_3_, p_184098_4_, this.field_230706_i_.field_71439_g);
                    this.field_230706_i_.field_71439_g.field_71069_bz.func_75142_b();
                }
            } else if (p_184098_4_ != ClickType.QUICK_CRAFT && p_184098_1_.field_75224_c == field_195378_x) {
                PlayerInventory playerinventory = this.field_230706_i_.field_71439_g.field_71071_by;
                ItemStack itemstack5 = playerinventory.func_70445_o();
                ItemStack itemstack7 = p_184098_1_.func_75211_c();
                if (p_184098_4_ == ClickType.SWAP) {
                    if (!itemstack7.func_190926_b()) {
                        ItemStack itemstack10 = itemstack7.func_77946_l();
                        itemstack10.func_190920_e(itemstack10.func_77976_d());
                        this.field_230706_i_.field_71439_g.field_71071_by.func_70299_a(p_184098_3_, itemstack10);
                        this.field_230706_i_.field_71439_g.field_71069_bz.func_75142_b();
                    }
                    return;
                }
                if (p_184098_4_ == ClickType.CLONE) {
                    if (playerinventory.func_70445_o().func_190926_b() && p_184098_1_.func_75216_d()) {
                        ItemStack itemstack9 = p_184098_1_.func_75211_c().func_77946_l();
                        itemstack9.func_190920_e(itemstack9.func_77976_d());
                        playerinventory.func_70437_b(itemstack9);
                    }
                    return;
                }
                if (p_184098_4_ == ClickType.THROW) {
                    if (!itemstack7.func_190926_b()) {
                        ItemStack itemstack8 = itemstack7.func_77946_l();
                        itemstack8.func_190920_e(p_184098_3_ == 0 ? 1 : itemstack8.func_77976_d());
                        this.field_230706_i_.field_71439_g.func_71019_a(itemstack8, true);
                        this.field_230706_i_.field_71442_b.func_78752_a(itemstack8);
                    }
                    return;
                }
                if (!itemstack5.func_190926_b() && !itemstack7.func_190926_b() && itemstack5.func_77969_a(itemstack7) && ItemStack.func_77970_a(itemstack5, itemstack7)) {
                    if (p_184098_3_ == 0) {
                        if (flag) {
                            itemstack5.func_190920_e(itemstack5.func_77976_d());
                        } else if (itemstack5.func_190916_E() < itemstack5.func_77976_d()) {
                            itemstack5.func_190917_f(1);
                        }
                    } else {
                        itemstack5.func_190918_g(1);
                    }
                } else if (!itemstack7.func_190926_b() && itemstack5.func_190926_b()) {
                    playerinventory.func_70437_b(itemstack7.func_77946_l());
                    itemstack5 = playerinventory.func_70445_o();
                    if (flag) {
                        itemstack5.func_190920_e(itemstack5.func_77976_d());
                    }
                } else if (p_184098_3_ == 0) {
                    playerinventory.func_70437_b(ItemStack.field_190927_a);
                } else {
                    playerinventory.func_70445_o().func_190918_g(1);
                }
            } else if (this.field_147002_h != null) {
                ItemStack itemstack3 = p_184098_1_ == null ? ItemStack.field_190927_a : ((CreativeContainer)this.field_147002_h).func_75139_a(p_184098_1_.field_75222_d).func_75211_c();
                ((CreativeContainer)this.field_147002_h).func_184996_a(p_184098_1_ == null ? p_184098_2_ : p_184098_1_.field_75222_d, p_184098_3_, p_184098_4_, this.field_230706_i_.field_71439_g);
                if (Container.func_94532_c(p_184098_3_) == 2) {
                    for (int k = 0; k < 9; ++k) {
                        this.field_230706_i_.field_71442_b.func_78761_a(((CreativeContainer)this.field_147002_h).func_75139_a(45 + k).func_75211_c(), 36 + k);
                    }
                } else if (p_184098_1_ != null) {
                    ItemStack itemstack4 = ((CreativeContainer)this.field_147002_h).func_75139_a(p_184098_1_.field_75222_d).func_75211_c();
                    this.field_230706_i_.field_71442_b.func_78761_a(itemstack4, p_184098_1_.field_75222_d - ((CreativeContainer)this.field_147002_h).field_75151_b.size() + 9 + 36);
                    int i = 45 + p_184098_3_;
                    if (p_184098_4_ == ClickType.SWAP) {
                        this.field_230706_i_.field_71442_b.func_78761_a(itemstack3, i - ((CreativeContainer)this.field_147002_h).field_75151_b.size() + 9 + 36);
                    } else if (p_184098_4_ == ClickType.THROW && !itemstack3.func_190926_b()) {
                        ItemStack itemstack2 = itemstack3.func_77946_l();
                        itemstack2.func_190920_e(p_184098_3_ == 0 ? 1 : itemstack2.func_77976_d());
                        this.field_230706_i_.field_71439_g.func_71019_a(itemstack2, true);
                        this.field_230706_i_.field_71442_b.func_78752_a(itemstack2);
                    }
                    this.field_230706_i_.field_71439_g.field_71069_bz.func_75142_b();
                }
            }
        }
    }

    private boolean func_208018_a(@Nullable Slot p_208018_1_) {
        return p_208018_1_ != null && p_208018_1_.field_75224_c == field_195378_x;
    }

    @Override
    protected void func_175378_g() {
        int i = this.field_147003_i;
        super.func_175378_g();
        if (this.field_147062_A != null && this.field_147003_i != i) {
            this.field_147062_A.func_212952_l(this.field_147003_i + 82);
        }
    }

    @Override
    protected void func_231160_c_() {
        if (this.field_230706_i_.field_71442_b.func_78758_h()) {
            super.func_231160_c_();
            int tabCount = ItemGroup.field_78032_a.length;
            if (tabCount > 12) {
                this.func_230480_a_(new Button(this.field_147003_i, this.field_147009_r - 50, 20, 20, (ITextComponent)new StringTextComponent("<"), b -> {
                    tabPage = Math.max(tabPage - 1, 0);
                }));
                this.func_230480_a_(new Button(this.field_147003_i + this.field_146999_f - 20, this.field_147009_r - 50, 20, 20, (ITextComponent)new StringTextComponent(">"), b -> {
                    tabPage = Math.min(tabPage + 1, this.maxPages);
                }));
                this.maxPages = (int)Math.ceil((double)(tabCount - 12) / 10.0);
            }
            this.field_230706_i_.field_195559_v.func_197967_a(true);
            this.field_147062_A = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 82, this.field_147009_r + 6, 80, 9, (ITextComponent)((Object)new TranslationTextComponent("itemGroup.search")));
            this.field_147062_A.func_146203_f(50);
            this.field_147062_A.func_146185_a(false);
            this.field_147062_A.func_146189_e(false);
            this.field_147062_A.func_146193_g(0xFFFFFF);
            this.field_230705_e_.add(this.field_147062_A);
            int i = field_147058_w;
            field_147058_w = -1;
            this.func_147050_b(ItemGroup.field_78032_a[i]);
            this.field_230706_i_.field_71439_g.field_71069_bz.func_82847_b((IContainerListener)this.field_147059_E);
            this.field_147059_E = new CreativeCraftingListener(this.field_230706_i_);
            this.field_230706_i_.field_71439_g.field_71069_bz.func_75132_a((IContainerListener)this.field_147059_E);
        } else {
            this.field_230706_i_.func_147108_a((Screen)new InventoryScreen((PlayerEntity)this.field_230706_i_.field_71439_g));
        }
    }

    @Override
    public void func_231152_a_(Minecraft p_231152_1_, int p_231152_2_, int p_231152_3_) {
        String s = this.field_147062_A.func_146179_b();
        this.func_231158_b_(p_231152_1_, p_231152_2_, p_231152_3_);
        this.field_147062_A.func_146180_a(s);
        if (!this.field_147062_A.func_146179_b().isEmpty()) {
            this.func_147053_i();
        }
    }

    @Override
    public void func_231164_f_() {
        super.func_231164_f_();
        if (this.field_230706_i_.field_71439_g != null && this.field_230706_i_.field_71439_g.field_71071_by != null) {
            this.field_230706_i_.field_71439_g.field_71069_bz.func_82847_b((IContainerListener)this.field_147059_E);
        }
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public boolean func_231042_a_(char p_231042_1_, int p_231042_2_) {
        if (this.field_195377_F) {
            return false;
        }
        if (!ItemGroup.field_78032_a[field_147058_w].hasSearchBar()) {
            return false;
        }
        String s = this.field_147062_A.func_146179_b();
        if (this.field_147062_A.func_231042_a_(p_231042_1_, p_231042_2_)) {
            if (!Objects.equals(s, this.field_147062_A.func_146179_b())) {
                this.func_147053_i();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        this.field_195377_F = false;
        if (!ItemGroup.field_78032_a[field_147058_w].hasSearchBar()) {
            if (this.field_230706_i_.field_71474_y.field_74310_D.func_197976_a(p_231046_1_, p_231046_2_)) {
                this.field_195377_F = true;
                this.func_147050_b(ItemGroup.field_78027_g);
                return true;
            }
            return super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
        }
        boolean flag = !this.func_208018_a(this.field_147006_u) || this.field_147006_u.func_75216_d();
        boolean flag1 = InputMappings.func_197954_a((int)p_231046_1_, (int)p_231046_2_).func_241552_e_().isPresent();
        if (flag && flag1 && this.func_195363_d(p_231046_1_, p_231046_2_)) {
            this.field_195377_F = true;
            return true;
        }
        String s = this.field_147062_A.func_146179_b();
        if (this.field_147062_A.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_)) {
            if (!Objects.equals(s, this.field_147062_A.func_146179_b())) {
                this.func_147053_i();
            }
            return true;
        }
        return this.field_147062_A.func_230999_j_() && this.field_147062_A.func_146176_q() && p_231046_1_ != 256 ? true : super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public boolean func_223281_a_(int p_223281_1_, int p_223281_2_, int p_223281_3_) {
        this.field_195377_F = false;
        return super.func_223281_a_(p_223281_1_, p_223281_2_, p_223281_3_);
    }

    private void func_147053_i() {
        ((CreativeContainer)this.field_147002_h).field_148330_a.clear();
        this.field_214085_w.clear();
        ItemGroup tab = ItemGroup.field_78032_a[field_147058_w];
        if (tab.hasSearchBar() && tab != ItemGroup.field_78027_g) {
            tab.func_78018_a(((CreativeContainer)this.field_147002_h).field_148330_a);
            if (!this.field_147062_A.func_146179_b().isEmpty()) {
                String search = this.field_147062_A.func_146179_b().toLowerCase(Locale.ROOT);
                Iterator itr = ((CreativeContainer)this.field_147002_h).field_148330_a.iterator();
                while (itr.hasNext()) {
                    ItemStack stack = (ItemStack)((Object)itr.next());
                    boolean matches = false;
                    for (ITextComponent line : stack.func_82840_a(this.field_230706_i_.field_71439_g, (ITooltipFlag)(this.field_230706_i_.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL))) {
                        if (!TextFormatting.func_110646_a(line.getString()).toLowerCase(Locale.ROOT).contains(search)) continue;
                        matches = true;
                        break;
                    }
                    if (matches) continue;
                    itr.remove();
                }
            }
            this.field_147067_x = 0.0f;
            ((CreativeContainer)this.field_147002_h).func_148329_a(0.0f);
            return;
        }
        String s = this.field_147062_A.func_146179_b();
        if (s.isEmpty()) {
            for (Item item : Registry.field_212630_s) {
                item.func_150895_a(ItemGroup.field_78027_g, ((CreativeContainer)this.field_147002_h).field_148330_a);
            }
        } else {
            IMutableSearchTree<ItemStack> isearchtree;
            if (s.startsWith("#")) {
                s = s.substring(1);
                isearchtree = this.field_230706_i_.func_213253_a(SearchTreeManager.field_215360_b);
                this.func_214080_a(s);
            } else {
                isearchtree = this.field_230706_i_.func_213253_a(SearchTreeManager.field_215359_a);
            }
            ((CreativeContainer)this.field_147002_h).field_148330_a.addAll(isearchtree.func_194038_a(s.toLowerCase(Locale.ROOT)));
        }
        this.field_147067_x = 0.0f;
        ((CreativeContainer)this.field_147002_h).func_148329_a(0.0f);
    }

    private void func_214080_a(String p_214080_1_) {
        Predicate<ResourceLocation> predicate;
        int i = p_214080_1_.indexOf(58);
        if (i == -1) {
            predicate = p_214084_1_ -> p_214084_1_.func_110623_a().contains(p_214080_1_);
        } else {
            String s = p_214080_1_.substring(0, i).trim();
            String s1 = p_214080_1_.substring(i + 1).trim();
            predicate = p_214081_2_ -> p_214081_2_.func_110624_b().contains(s) && p_214081_2_.func_110623_a().contains(s1);
        }
        ITagCollection<Item> itagcollection = ItemTags.func_199903_a();
        itagcollection.func_199908_a().stream().filter(predicate).forEach(p_214082_2_ -> {
            ITag itag = this.field_214085_w.put((ResourceLocation)p_214082_2_, itagcollection.func_199910_a((ResourceLocation)p_214082_2_));
        });
    }

    @Override
    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
        ItemGroup itemgroup = ItemGroup.field_78032_a[field_147058_w];
        if (itemgroup != null && itemgroup.func_78019_g()) {
            RenderSystem.disableBlend();
            this.field_230712_o_.func_243248_b(p_230451_1_, itemgroup.func_242392_c(), 8.0f, 6.0f, itemgroup.getLabelColor());
        }
    }

    @Override
    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (p_231044_5_ == 0) {
            double d0 = p_231044_1_ - (double)this.field_147003_i;
            double d1 = p_231044_3_ - (double)this.field_147009_r;
            for (ItemGroup itemgroup : ItemGroup.field_78032_a) {
                if (itemgroup == null || !this.func_195375_a(itemgroup, d0, d1)) continue;
                return true;
            }
            if (field_147058_w != ItemGroup.field_78036_m.func_78021_a() && this.func_195376_a(p_231044_1_, p_231044_3_)) {
                this.field_147066_y = this.func_147055_p();
                return true;
            }
        }
        return super.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_);
    }

    @Override
    public boolean func_231048_c_(double p_231048_1_, double p_231048_3_, int p_231048_5_) {
        if (p_231048_5_ == 0) {
            double d0 = p_231048_1_ - (double)this.field_147003_i;
            double d1 = p_231048_3_ - (double)this.field_147009_r;
            this.field_147066_y = false;
            for (ItemGroup itemgroup : ItemGroup.field_78032_a) {
                if (itemgroup == null || !this.func_195375_a(itemgroup, d0, d1)) continue;
                this.func_147050_b(itemgroup);
                return true;
            }
        }
        return super.func_231048_c_(p_231048_1_, p_231048_3_, p_231048_5_);
    }

    private boolean func_147055_p() {
        if (ItemGroup.field_78032_a[field_147058_w] == null) {
            return false;
        }
        return field_147058_w != ItemGroup.field_78036_m.func_78021_a() && ItemGroup.field_78032_a[field_147058_w].func_78017_i() && ((CreativeContainer)this.field_147002_h).func_148328_e();
    }

    private void func_147050_b(ItemGroup p_147050_1_) {
        if (p_147050_1_ == null) {
            return;
        }
        int i = field_147058_w;
        field_147058_w = p_147050_1_.func_78021_a();
        this.slotColor = p_147050_1_.getSlotColor();
        this.field_147008_s.clear();
        ((CreativeContainer)this.field_147002_h).field_148330_a.clear();
        if (p_147050_1_ == ItemGroup.field_192395_m) {
            CreativeSettings creativesettings = this.field_230706_i_.func_199403_al();
            for (int j = 0; j < 9; ++j) {
                HotbarSnapshot hotbarsnapshot = creativesettings.func_192563_a(j);
                if (hotbarsnapshot.isEmpty()) {
                    for (int k = 0; k < 9; ++k) {
                        if (k == j) {
                            ItemStack itemstack = new ItemStack(Items.field_151121_aF);
                            itemstack.func_190925_c("CustomCreativeLock");
                            ITextComponent itextcomponent = this.field_230706_i_.field_71474_y.field_151456_ac[j].func_238171_j_();
                            ITextComponent itextcomponent1 = this.field_230706_i_.field_71474_y.field_193629_ap.func_238171_j_();
                            itemstack.func_200302_a((ITextComponent)((Object)new TranslationTextComponent("inventory.hotbarInfo", itextcomponent1, itextcomponent)));
                            ((CreativeContainer)this.field_147002_h).field_148330_a.add(itemstack);
                            continue;
                        }
                        ((CreativeContainer)this.field_147002_h).field_148330_a.add(ItemStack.field_190927_a);
                    }
                    continue;
                }
                ((CreativeContainer)this.field_147002_h).field_148330_a.addAll((Collection<ItemStack>)hotbarsnapshot);
            }
        } else if (p_147050_1_ != ItemGroup.field_78027_g) {
            p_147050_1_.func_78018_a(((CreativeContainer)this.field_147002_h).field_148330_a);
        }
        if (p_147050_1_ == ItemGroup.field_78036_m) {
            PlayerContainer container = this.field_230706_i_.field_71439_g.field_71069_bz;
            if (this.field_147063_B == null) {
                this.field_147063_B = ImmutableList.copyOf((Collection)((CreativeContainer)this.field_147002_h).field_75151_b);
            }
            ((CreativeContainer)this.field_147002_h).field_75151_b.clear();
            for (int l = 0; l < container.field_75151_b.size(); ++l) {
                int j1;
                int i1;
                if (l >= 5 && l < 9) {
                    int l1 = l - 5;
                    int j2 = l1 / 2;
                    int l2 = l1 % 2;
                    i1 = 54 + j2 * 54;
                    j1 = 6 + l2 * 27;
                } else if (l >= 0 && l < 5) {
                    i1 = -2000;
                    j1 = -2000;
                } else if (l == 45) {
                    i1 = 35;
                    j1 = 20;
                } else {
                    int k1 = l - 9;
                    int i2 = k1 % 9;
                    int k2 = k1 / 9;
                    i1 = 9 + i2 * 18;
                    j1 = l >= 36 ? 112 : 54 + k2 * 18;
                }
                CreativeSlot slot = new CreativeSlot(container.field_75151_b.get(l), l, i1, j1);
                ((CreativeContainer)this.field_147002_h).field_75151_b.add(slot);
            }
            this.field_147064_C = new Slot(field_195378_x, 0, 173, 112);
            ((CreativeContainer)this.field_147002_h).field_75151_b.add(this.field_147064_C);
        } else if (i == ItemGroup.field_78036_m.func_78021_a()) {
            ((CreativeContainer)this.field_147002_h).field_75151_b.clear();
            ((CreativeContainer)this.field_147002_h).field_75151_b.addAll(this.field_147063_B);
            this.field_147063_B = null;
        }
        if (this.field_147062_A != null) {
            if (p_147050_1_.hasSearchBar()) {
                this.field_147062_A.func_146189_e(true);
                this.field_147062_A.func_146205_d(false);
                this.field_147062_A.func_146195_b(true);
                if (i != p_147050_1_.func_78021_a()) {
                    this.field_147062_A.func_146180_a("");
                }
                this.field_147062_A.func_230991_b_(p_147050_1_.getSearchbarWidth());
                this.field_147062_A.field_230690_l_ = this.field_147003_i + 171 - this.field_147062_A.func_230998_h_();
                this.func_147053_i();
            } else {
                this.field_147062_A.func_146189_e(false);
                this.field_147062_A.func_146205_d(true);
                this.field_147062_A.func_146195_b(false);
                this.field_147062_A.func_146180_a("");
            }
        }
        this.field_147067_x = 0.0f;
        ((CreativeContainer)this.field_147002_h).func_148329_a(0.0f);
    }

    public boolean func_231043_a_(double p_231043_1_, double p_231043_3_, double p_231043_5_) {
        if (!this.func_147055_p()) {
            return false;
        }
        int i = (((CreativeContainer)this.field_147002_h).field_148330_a.size() + 9 - 1) / 9 - 5;
        this.field_147067_x = (float)((double)this.field_147067_x - p_231043_5_ / (double)i);
        this.field_147067_x = MathHelper.func_76131_a((float)this.field_147067_x, (float)0.0f, (float)1.0f);
        ((CreativeContainer)this.field_147002_h).func_148329_a(this.field_147067_x);
        return true;
    }

    @Override
    protected boolean func_195361_a(double p_195361_1_, double p_195361_3_, int p_195361_5_, int p_195361_6_, int p_195361_7_) {
        boolean flag = p_195361_1_ < (double)p_195361_5_ || p_195361_3_ < (double)p_195361_6_ || p_195361_1_ >= (double)(p_195361_5_ + this.field_146999_f) || p_195361_3_ >= (double)(p_195361_6_ + this.field_147000_g);
        this.field_199506_G = flag && !this.func_195375_a(ItemGroup.field_78032_a[field_147058_w], p_195361_1_, p_195361_3_);
        return this.field_199506_G;
    }

    protected boolean func_195376_a(double p_195376_1_, double p_195376_3_) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int k = i + 175;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + 112;
        return p_195376_1_ >= (double)k && p_195376_3_ >= (double)l && p_195376_1_ < (double)i1 && p_195376_3_ < (double)j1;
    }

    @Override
    public boolean func_231045_a_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (this.field_147066_y) {
            int i = this.field_147009_r + 18;
            int j = i + 112;
            this.field_147067_x = ((float)p_231045_3_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.field_147067_x = MathHelper.func_76131_a((float)this.field_147067_x, (float)0.0f, (float)1.0f);
            ((CreativeContainer)this.field_147002_h).func_148329_a(this.field_147067_x);
            return true;
        }
        return super.func_231045_a_(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
    }

    @Override
    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.func_230446_a_(p_230430_1_);
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        int start = tabPage * 10;
        int end = Math.min(ItemGroup.field_78032_a.length, (tabPage + 1) * 10 + 2);
        if (tabPage != 0) {
            start += 2;
        }
        boolean rendered = false;
        for (int x = start; x < end; ++x) {
            ItemGroup itemgroup = ItemGroup.field_78032_a[x];
            if (itemgroup == null || !this.func_238809_a_(p_230430_1_, itemgroup, p_230430_2_, p_230430_3_)) continue;
            rendered = true;
            break;
        }
        if (!rendered && !this.func_238809_a_(p_230430_1_, ItemGroup.field_78027_g, p_230430_2_, p_230430_3_)) {
            this.func_238809_a_(p_230430_1_, ItemGroup.field_78036_m, p_230430_2_, p_230430_3_);
        }
        if (this.field_147064_C != null && field_147058_w == ItemGroup.field_78036_m.func_78021_a() && this.func_195359_a(this.field_147064_C.field_75223_e, this.field_147064_C.field_75221_f, 16, 16, p_230430_2_, p_230430_3_)) {
            this.func_238652_a_(p_230430_1_, field_243345_D, p_230430_2_, p_230430_3_);
        }
        if (this.maxPages != 0) {
            StringTextComponent page = new StringTextComponent(String.format("%d / %d", tabPage + 1, this.maxPages + 1));
            RenderSystem.disableLighting();
            this.func_230926_e_(300);
            this.field_230707_j_.field_77023_b = 300.0f;
            this.field_230712_o_.func_238407_a_(p_230430_1_, page.func_241878_f(), (float)(this.field_147003_i + this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)page) / 2), (float)(this.field_147009_r - 44), -1);
            this.func_230926_e_(0);
            this.field_230707_j_.field_77023_b = 0.0f;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_230459_a_(p_230430_1_, p_230430_2_, p_230430_3_);
    }

    @Override
    protected void func_230457_a_(MatrixStack p_230457_1_, ItemStack p_230457_2_, int p_230457_3_, int p_230457_4_) {
        if (field_147058_w == ItemGroup.field_78027_g.func_78021_a()) {
            Map<Enchantment, Integer> map;
            List<ITextComponent> list = p_230457_2_.func_82840_a(this.field_230706_i_.field_71439_g, (ITooltipFlag)(this.field_230706_i_.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            ArrayList list1 = Lists.newArrayList(list);
            Item item = p_230457_2_.func_77973_b();
            ItemGroup itemgroup = item.func_77640_w();
            if (itemgroup == null && item == Items.field_151134_bR && (map = EnchantmentHelper.func_82781_a(p_230457_2_)).size() == 1) {
                Enchantment enchantment = map.keySet().iterator().next();
                for (ItemGroup itemgroup1 : ItemGroup.field_78032_a) {
                    if (!itemgroup1.func_111226_a(enchantment.field_77351_y)) continue;
                    itemgroup = itemgroup1;
                    break;
                }
            }
            this.field_214085_w.forEach((p_214083_2_, p_214083_3_) -> {
                if (p_214083_3_.func_230235_a_(item)) {
                    list1.add(1, new StringTextComponent("#" + p_214083_2_).func_240699_a_(TextFormatting.DARK_PURPLE));
                }
            });
            if (itemgroup != null) {
                list1.add(1, itemgroup.func_242392_c().func_230532_e_().func_240699_a_(TextFormatting.BLUE));
            }
            FontRenderer font = p_230457_2_.func_77973_b().getFontRenderer(p_230457_2_);
            GuiUtils.preItemToolTip((ItemStack)p_230457_2_);
            this.renderWrappedToolTip(p_230457_1_, list1, p_230457_3_, p_230457_4_, font == null ? this.field_230712_o_ : font);
            GuiUtils.postItemToolTip();
        } else {
            super.func_230457_a_(p_230457_1_, p_230457_2_, p_230457_3_, p_230457_4_);
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack p_230450_1_, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemGroup itemgroup = ItemGroup.field_78032_a[field_147058_w];
        int start = tabPage * 10;
        int end = Math.min(ItemGroup.field_78032_a.length, (tabPage + 1) * 10 + 2);
        if (tabPage != 0) {
            start += 2;
        }
        for (int idx = start; idx < end; ++idx) {
            ItemGroup itemgroup1 = ItemGroup.field_78032_a[idx];
            if (itemgroup1 == null || itemgroup1.func_78021_a() == field_147058_w) continue;
            this.field_230706_i_.func_110434_K().func_110577_a(itemgroup1.getTabsImage());
            this.func_238808_a_(p_230450_1_, itemgroup1);
        }
        if (tabPage != 0) {
            if (itemgroup != ItemGroup.field_78027_g) {
                this.field_230706_i_.func_110434_K().func_110577_a(ItemGroup.field_78027_g.getTabsImage());
                this.func_238808_a_(p_230450_1_, ItemGroup.field_78027_g);
            }
            if (itemgroup != ItemGroup.field_78036_m) {
                this.field_230706_i_.func_110434_K().func_110577_a(ItemGroup.field_78036_m.getTabsImage());
                this.func_238808_a_(p_230450_1_, ItemGroup.field_78036_m);
            }
        }
        this.field_230706_i_.func_110434_K().func_110577_a(itemgroup.getBackgroundImage());
        this.func_238474_b_(p_230450_1_, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_147062_A.func_230430_a_(p_230450_1_, p_230450_3_, p_230450_4_, p_230450_2_);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.field_147003_i + 175;
        int j = this.field_147009_r + 18;
        int k = j + 112;
        this.field_230706_i_.func_110434_K().func_110577_a(itemgroup.getTabsImage());
        if (itemgroup.func_78017_i()) {
            this.func_238474_b_(p_230450_1_, i, j + (int)((float)(k - j - 17) * this.field_147067_x), 232 + (this.func_147055_p() ? 0 : 12), 0, 12, 15);
        }
        if ((itemgroup == null || itemgroup.getTabPage() != tabPage) && itemgroup != ItemGroup.field_78027_g && itemgroup != ItemGroup.field_78036_m) {
            return;
        }
        this.func_238808_a_(p_230450_1_, itemgroup);
        if (itemgroup == ItemGroup.field_78036_m) {
            InventoryScreen.func_228187_a_((int)(this.field_147003_i + 88), (int)(this.field_147009_r + 45), (int)20, (float)(this.field_147003_i + 88 - p_230450_3_), (float)(this.field_147009_r + 45 - 30 - p_230450_4_), (LivingEntity)this.field_230706_i_.field_71439_g);
        }
    }

    protected boolean func_195375_a(ItemGroup p_195375_1_, double p_195375_2_, double p_195375_4_) {
        if (p_195375_1_.getTabPage() != tabPage && p_195375_1_ != ItemGroup.field_78027_g && p_195375_1_ != ItemGroup.field_78036_m) {
            return false;
        }
        int i = p_195375_1_.func_78020_k();
        int j = 28 * i;
        int k = 0;
        if (p_195375_1_.func_192394_m()) {
            j = this.field_146999_f - 28 * (6 - i) + 2;
        } else if (i > 0) {
            j += i;
        }
        k = p_195375_1_.func_78023_l() ? (k -= 32) : (k += this.field_147000_g);
        return p_195375_2_ >= (double)j && p_195375_2_ <= (double)(j + 28) && p_195375_4_ >= (double)k && p_195375_4_ <= (double)(k + 32);
    }

    protected boolean func_238809_a_(MatrixStack p_238809_1_, ItemGroup p_238809_2_, int p_238809_3_, int p_238809_4_) {
        int i = p_238809_2_.func_78020_k();
        int j = 28 * i;
        int k = 0;
        if (p_238809_2_.func_192394_m()) {
            j = this.field_146999_f - 28 * (6 - i) + 2;
        } else if (i > 0) {
            j += i;
        }
        k = p_238809_2_.func_78023_l() ? (k -= 32) : (k += this.field_147000_g);
        if (this.func_195359_a(j + 3, k + 3, 23, 27, p_238809_3_, p_238809_4_)) {
            this.func_238652_a_(p_238809_1_, p_238809_2_.func_242392_c(), p_238809_3_, p_238809_4_);
            return true;
        }
        return false;
    }

    protected void func_238808_a_(MatrixStack p_238808_1_, ItemGroup p_238808_2_) {
        boolean flag = p_238808_2_.func_78021_a() == field_147058_w;
        boolean flag1 = p_238808_2_.func_78023_l();
        int i = p_238808_2_.func_78020_k();
        int j = i * 28;
        int k = 0;
        int l = this.field_147003_i + 28 * i;
        int i1 = this.field_147009_r;
        int j1 = 32;
        if (flag) {
            k += 32;
        }
        if (p_238808_2_.func_192394_m()) {
            l = this.field_147003_i + this.field_146999_f - 28 * (6 - i);
        } else if (i > 0) {
            l += i;
        }
        if (flag1) {
            i1 -= 28;
        } else {
            k += 64;
            i1 += this.field_147000_g - 4;
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        this.func_238474_b_(p_238808_1_, l, i1, j, k, 28, 32);
        this.field_230707_j_.field_77023_b = 100.0f;
        i1 = i1 + 8 + (flag1 ? 1 : -1);
        RenderSystem.enableRescaleNormal();
        ItemStack itemstack = p_238808_2_.func_151244_d();
        this.field_230707_j_.func_180450_b(itemstack, l += 6, i1);
        this.field_230707_j_.func_175030_a(this.field_230712_o_, itemstack, l, i1);
        this.field_230707_j_.field_77023_b = 0.0f;
    }

    public int func_147056_g() {
        return field_147058_w;
    }

    public static void func_192044_a(Minecraft p_192044_0_, int p_192044_1_, boolean p_192044_2_, boolean p_192044_3_) {
        ClientPlayerEntity clientplayerentity = p_192044_0_.field_71439_g;
        CreativeSettings creativesettings = p_192044_0_.func_199403_al();
        HotbarSnapshot hotbarsnapshot = creativesettings.func_192563_a(p_192044_1_);
        if (p_192044_2_) {
            for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
                ItemStack itemstack = ((ItemStack)((Object)hotbarsnapshot.get(i))).func_77946_l();
                clientplayerentity.field_71071_by.func_70299_a(i, itemstack);
                p_192044_0_.field_71442_b.func_78761_a(itemstack, 36 + i);
            }
            clientplayerentity.field_71069_bz.func_75142_b();
        } else if (p_192044_3_) {
            for (int j = 0; j < PlayerInventory.func_70451_h(); ++j) {
                hotbarsnapshot.set(j, (Object)clientplayerentity.field_71071_by.func_70301_a(j).func_77946_l());
            }
            ITextComponent itextcomponent = p_192044_0_.field_71474_y.field_151456_ac[p_192044_1_].func_238171_j_();
            ITextComponent itextcomponent1 = p_192044_0_.field_71474_y.field_193630_aq.func_238171_j_();
            p_192044_0_.field_71456_v.func_175188_a((ITextComponent)((Object)new TranslationTextComponent("inventory.hotbarSaved", itextcomponent1, itextcomponent)), false);
            creativesettings.func_192564_b();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class LockedSlot
    extends Slot {
        public LockedSlot(IInventory p_i47453_1_, int p_i47453_2_, int p_i47453_3_, int p_i47453_4_) {
            super(p_i47453_1_, p_i47453_2_, p_i47453_3_, p_i47453_4_);
        }

        @Override
        public boolean func_82869_a(PlayerEntity p_82869_1_) {
            if (super.func_82869_a(p_82869_1_) && this.func_75216_d()) {
                return this.func_75211_c().func_179543_a("CustomCreativeLock") == null;
            }
            return !this.func_75216_d();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CreativeSlot
    extends Slot {
        private final Slot field_148332_b;

        public CreativeSlot(Slot p_i229959_1_, int p_i229959_2_, int p_i229959_3_, int p_i229959_4_) {
            super(p_i229959_1_.field_75224_c, p_i229959_2_, p_i229959_3_, p_i229959_4_);
            this.field_148332_b = p_i229959_1_;
        }

        @Override
        public ItemStack func_190901_a(PlayerEntity p_190901_1_, ItemStack p_190901_2_) {
            return this.field_148332_b.func_190901_a(p_190901_1_, p_190901_2_);
        }

        @Override
        public boolean func_75214_a(ItemStack p_75214_1_) {
            return this.field_148332_b.func_75214_a(p_75214_1_);
        }

        @Override
        public ItemStack func_75211_c() {
            return this.field_148332_b.func_75211_c();
        }

        @Override
        public boolean func_75216_d() {
            return this.field_148332_b.func_75216_d();
        }

        @Override
        public void func_75215_d(ItemStack p_75215_1_) {
            this.field_148332_b.func_75215_d(p_75215_1_);
        }

        @Override
        public void func_75218_e() {
            this.field_148332_b.func_75218_e();
        }

        @Override
        public int func_75219_a() {
            return this.field_148332_b.func_75219_a();
        }

        @Override
        public int func_178170_b(ItemStack p_178170_1_) {
            return this.field_148332_b.func_178170_b(p_178170_1_);
        }

        @Override
        @Nullable
        public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
            return this.field_148332_b.func_225517_c_();
        }

        @Override
        public ItemStack func_75209_a(int p_75209_1_) {
            return this.field_148332_b.func_75209_a(p_75209_1_);
        }

        @Override
        public boolean func_111238_b() {
            return this.field_148332_b.func_111238_b();
        }

        @Override
        public boolean func_82869_a(PlayerEntity p_82869_1_) {
            return this.field_148332_b.func_82869_a(p_82869_1_);
        }

        @Override
        public int getSlotIndex() {
            return this.field_148332_b.getSlotIndex();
        }

        @Override
        public boolean isSameInventory(Slot other) {
            return this.field_148332_b.isSameInventory(other);
        }

        @Override
        public Slot setBackground(ResourceLocation atlas, ResourceLocation sprite) {
            this.field_148332_b.setBackground(atlas, sprite);
            return this;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CreativeContainer
    extends Container {
        public final NonNullList<ItemStack> field_148330_a = NonNullList.func_191196_a();

        public CreativeContainer(PlayerEntity p_i1086_1_) {
            super(null, 0);
            PlayerInventory playerinventory = p_i1086_1_.field_71071_by;
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.func_75146_a(new LockedSlot(field_195378_x, i * 9 + j, 9 + j * 18, 18 + i * 18));
                }
            }
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot(playerinventory, k, 9 + k * 18, 112));
            }
            this.func_148329_a(0.0f);
        }

        @Override
        public boolean func_75145_c(PlayerEntity p_75145_1_) {
            return true;
        }

        public void func_148329_a(float p_148329_1_) {
            int i = (this.field_148330_a.size() + 9 - 1) / 9 - 5;
            int j = (int)((double)(p_148329_1_ * (float)i) + 0.5);
            if (j < 0) {
                j = 0;
            }
            for (int k = 0; k < 5; ++k) {
                for (int l = 0; l < 9; ++l) {
                    int i1 = l + (k + j) * 9;
                    if (i1 >= 0 && i1 < this.field_148330_a.size()) {
                        field_195378_x.func_70299_a(l + k * 9, this.field_148330_a.get(i1));
                        continue;
                    }
                    field_195378_x.func_70299_a(l + k * 9, ItemStack.field_190927_a);
                }
            }
        }

        public boolean func_148328_e() {
            return this.field_148330_a.size() > 45;
        }

        @Override
        public ItemStack func_82846_b(PlayerEntity p_82846_1_, int p_82846_2_) {
            Slot slot;
            if (p_82846_2_ >= this.field_75151_b.size() - 9 && p_82846_2_ < this.field_75151_b.size() && (slot = (Slot)this.field_75151_b.get(p_82846_2_)) != null && slot.func_75216_d()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public boolean func_94530_a(ItemStack p_94530_1_, Slot p_94530_2_) {
            return p_94530_2_.field_75224_c != field_195378_x;
        }

        @Override
        public boolean func_94531_b(Slot p_94531_1_) {
            return p_94531_1_.field_75224_c != field_195378_x;
        }
    }
}

