/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.Empty3i;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.client.GameConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ScreenSize;
import net.minecraft.client.util.UndeclaredException;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.Session;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Bootstrap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.BackgroundWaiter;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Main {
    private static final Logger field_199741_a = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] p_main_0_) {
        Thread thread1;
        Minecraft minecraft;
        OptionParser optionparser = new OptionParser();
        optionparser.allowsUnrecognizedOptions();
        optionparser.accepts("demo");
        optionparser.accepts("disableMultiplayer");
        optionparser.accepts("disableChat");
        optionparser.accepts("fullscreen");
        optionparser.accepts("checkGlErrors");
        ArgumentAcceptingOptionSpec optionspec = optionparser.accepts("server").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec1 = optionparser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)25565, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec2 = optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec optionspec3 = optionparser.accepts("assetsDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionspec4 = optionparser.accepts("resourcePackDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionspec5 = optionparser.accepts("dataPackDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionspec6 = optionparser.accepts("proxyHost").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec7 = optionparser.accepts("proxyPort").withRequiredArg().defaultsTo((Object)"8080", (Object[])new String[0]).ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec8 = optionparser.accepts("proxyUser").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec9 = optionparser.accepts("proxyPass").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec10 = optionparser.accepts("username").withRequiredArg().defaultsTo((Object)("Player" + Util.func_211177_b() % 1000L), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec11 = optionparser.accepts("uuid").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec12 = optionparser.accepts("accessToken").withRequiredArg().required();
        ArgumentAcceptingOptionSpec optionspec13 = optionparser.accepts("version").withRequiredArg().required();
        ArgumentAcceptingOptionSpec optionspec14 = optionparser.accepts("width").withRequiredArg().ofType(Integer.class).defaultsTo((Object)854, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec15 = optionparser.accepts("height").withRequiredArg().ofType(Integer.class).defaultsTo((Object)480, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec16 = optionparser.accepts("fullscreenWidth").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec17 = optionparser.accepts("fullscreenHeight").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec18 = optionparser.accepts("userProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec19 = optionparser.accepts("profileProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec20 = optionparser.accepts("assetIndex").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec21 = optionparser.accepts("userType").withRequiredArg().defaultsTo((Object)"legacy", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec22 = optionparser.accepts("versionType").withRequiredArg().defaultsTo((Object)"release", (Object[])new String[0]);
        NonOptionArgumentSpec optionspec23 = optionparser.nonOptions();
        OptionSet optionset = optionparser.parse(p_main_0_);
        List list = optionset.valuesOf((OptionSpec)optionspec23);
        if (!list.isEmpty()) {
            System.out.println("Completely ignored arguments: " + list);
        }
        String s = (String)Main.func_206236_a(optionset, optionspec6);
        Proxy proxy = Proxy.NO_PROXY;
        if (s != null) {
            try {
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(s, (int)((Integer)Main.func_206236_a(optionset, optionspec7))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        final String s1 = (String)Main.func_206236_a(optionset, optionspec8);
        final String s2 = (String)Main.func_206236_a(optionset, optionspec9);
        if (!proxy.equals(Proxy.NO_PROXY) && Main.func_110121_a(s1) && Main.func_110121_a(s2)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(s1, s2.toCharArray());
                }
            });
        }
        int i = (Integer)Main.func_206236_a(optionset, optionspec14);
        int j = (Integer)Main.func_206236_a(optionset, optionspec15);
        OptionalInt optionalint = Main.func_224732_a((Integer)Main.func_206236_a(optionset, optionspec16));
        OptionalInt optionalint1 = Main.func_224732_a((Integer)Main.func_206236_a(optionset, optionspec17));
        boolean flag = optionset.has("fullscreen");
        boolean flag1 = optionset.has("demo");
        boolean flag2 = optionset.has("disableMultiplayer");
        boolean flag3 = optionset.has("disableChat");
        String s3 = (String)Main.func_206236_a(optionset, optionspec13);
        Gson gson = new GsonBuilder().registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).create();
        PropertyMap propertymap = (PropertyMap)JSONUtils.func_188178_a((Gson)gson, (String)((String)Main.func_206236_a(optionset, optionspec18)), PropertyMap.class);
        PropertyMap propertymap1 = (PropertyMap)JSONUtils.func_188178_a((Gson)gson, (String)((String)Main.func_206236_a(optionset, optionspec19)), PropertyMap.class);
        String s4 = (String)Main.func_206236_a(optionset, optionspec22);
        File file1 = (File)Main.func_206236_a(optionset, optionspec2);
        File file2 = optionset.has((OptionSpec)optionspec3) ? (File)Main.func_206236_a(optionset, optionspec3) : new File(file1, "assets/");
        File file3 = optionset.has((OptionSpec)optionspec4) ? (File)Main.func_206236_a(optionset, optionspec4) : new File(file1, "resourcepacks/");
        String s5 = optionset.has((OptionSpec)optionspec11) ? (String)optionspec11.value(optionset) : PlayerEntity.func_175147_b((String)optionspec10.value(optionset)).toString();
        String s6 = optionset.has((OptionSpec)optionspec20) ? (String)optionspec20.value(optionset) : null;
        String s7 = (String)Main.func_206236_a(optionset, optionspec);
        Integer integer = (Integer)Main.func_206236_a(optionset, optionspec1);
        CrashReport.func_230188_h_();
        BackgroundWaiter.runAndTick(() -> Bootstrap.func_151354_b(), (Runnable)FMLLoader.progressWindowTick);
        Bootstrap.func_218821_c();
        Util.func_240994_l_();
        Session session = new Session((String)optionspec10.value(optionset), s5, (String)optionspec12.value(optionset), (String)optionspec21.value(optionset));
        GameConfiguration gameconfiguration = new GameConfiguration(new GameConfiguration.UserInformation(session, propertymap, propertymap1, proxy), new ScreenSize(i, j, optionalint, optionalint1, flag), new GameConfiguration.FolderInformation(file1, file3, file2, s6), new GameConfiguration.GameInformation(flag1, s3, s4, flag2, flag3), new GameConfiguration.ServerInformation(s7, integer.intValue()));
        Thread thread = new Thread("Client Shutdown Thread"){

            @Override
            public void run() {
                IntegratedServer integratedserver;
                Minecraft minecraft1 = Minecraft.func_71410_x();
                if (minecraft1 != null && (integratedserver = minecraft1.func_71401_C()) != null) {
                    integratedserver.func_71263_m(true);
                }
            }
        };
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_199741_a));
        Runtime.getRuntime().addShutdownHook(thread);
        new Empty3i();
        try {
            Thread.currentThread().setName("Render thread");
            RenderSystem.initRenderThread();
            RenderSystem.beginInitialization();
            minecraft = new Minecraft(gameconfiguration);
            RenderSystem.finishInitialization();
        }
        catch (UndeclaredException undeclaredexception) {
            field_199741_a.warn("Failed to create window: ", (Throwable)undeclaredexception);
            return;
        }
        catch (Throwable throwable1) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable1, "Initializing game");
            crashreport.func_85058_a("Initialization");
            Minecraft.func_228009_a_(null, gameconfiguration.field_178741_d.field_178755_b, null, crashreport);
            Minecraft.func_71377_b(crashreport);
            return;
        }
        if (minecraft.func_228017_as_()) {
            thread1 = new Thread("Game thread"){

                @Override
                public void run() {
                    try {
                        RenderSystem.initGameThread((boolean)true);
                        minecraft.func_99999_d();
                    }
                    catch (Throwable throwable2) {
                        field_199741_a.error("Exception in client thread", throwable2);
                    }
                }
            };
            thread1.start();
            while (minecraft.func_228025_l_()) {
            }
        } else {
            thread1 = null;
            try {
                RenderSystem.initGameThread((boolean)false);
                minecraft.func_99999_d();
            }
            catch (Throwable throwable) {
                field_199741_a.error("Unhandled game exception", throwable);
            }
        }
        try {
            minecraft.func_71400_g();
            if (thread1 != null) {
                thread1.join();
            }
        }
        catch (InterruptedException interruptedexception) {
            field_199741_a.error("Exception during client thread shutdown", (Throwable)interruptedexception);
        }
        finally {
            minecraft.func_71405_e();
        }
    }

    private static OptionalInt func_224732_a(@Nullable Integer p_224732_0_) {
        return p_224732_0_ != null ? OptionalInt.of(p_224732_0_) : OptionalInt.empty();
    }

    @Nullable
    private static <T> T func_206236_a(OptionSet p_206236_0_, OptionSpec<T> p_206236_1_) {
        try {
            return (T)p_206236_0_.valueOf(p_206236_1_);
        }
        catch (Throwable throwable) {
            ArgumentAcceptingOptionSpec argumentacceptingoptionspec;
            List list;
            if (p_206236_1_ instanceof ArgumentAcceptingOptionSpec && !(list = (argumentacceptingoptionspec = (ArgumentAcceptingOptionSpec)p_206236_1_).defaultValues()).isEmpty()) {
                return (T)list.get(0);
            }
            throw throwable;
        }
    }

    private static boolean func_110121_a(@Nullable String p_110121_0_) {
        return p_110121_0_ != null && !p_110121_0_.isEmpty();
    }

    static {
        System.setProperty("java.awt.headless", "true");
    }
}

