/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientChunkProvider
extends AbstractChunkProvider {
    private static final Logger field_147436_a = LogManager.getLogger();
    private final Chunk field_73238_a;
    private final WorldLightManager field_217255_c;
    private volatile ChunkArray field_217256_d;
    private final ClientWorld field_73235_d;

    public ClientChunkProvider(ClientWorld p_i51057_1_, int p_i51057_2_) {
        this.field_73235_d = p_i51057_1_;
        this.field_73238_a = new EmptyChunk((World)p_i51057_1_, new ChunkPos(0, 0));
        this.field_217255_c = new WorldLightManager((IChunkLightProvider)this, true, p_i51057_1_.func_230315_m_().func_218272_d());
        this.field_217256_d = new ChunkArray(ClientChunkProvider.func_217254_b(p_i51057_2_));
    }

    public WorldLightManager func_212863_j_() {
        return this.field_217255_c;
    }

    private static boolean func_217249_a(@Nullable Chunk p_217249_0_, int p_217249_1_, int p_217249_2_) {
        if (p_217249_0_ == null) {
            return false;
        }
        ChunkPos chunkpos = p_217249_0_.func_76632_l();
        return chunkpos.field_77276_a == p_217249_1_ && chunkpos.field_77275_b == p_217249_2_;
    }

    public void func_73234_b(int p_73234_1_, int p_73234_2_) {
        int i;
        Chunk chunk;
        if (this.field_217256_d.func_217183_b(p_73234_1_, p_73234_2_) && ClientChunkProvider.func_217249_a(chunk = this.field_217256_d.func_217192_a(i = this.field_217256_d.func_217191_a(p_73234_1_, p_73234_2_)), p_73234_1_, p_73234_2_)) {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((IChunk)chunk));
            this.field_217256_d.func_217190_a(i, chunk, null);
        }
    }

    @Nullable
    public Chunk func_212849_a_(int p_212849_1_, int p_212849_2_, ChunkStatus p_212849_3_, boolean p_212849_4_) {
        Chunk chunk;
        if (this.field_217256_d.func_217183_b(p_212849_1_, p_212849_2_) && ClientChunkProvider.func_217249_a(chunk = this.field_217256_d.func_217192_a(this.field_217256_d.func_217191_a(p_212849_1_, p_212849_2_)), p_212849_1_, p_212849_2_)) {
            return chunk;
        }
        return p_212849_4_ ? this.field_73238_a : null;
    }

    public IBlockReader func_212864_k_() {
        return this.field_73235_d;
    }

    @Nullable
    public Chunk func_228313_a_(int p_228313_1_, int p_228313_2_, @Nullable BiomeContainer p_228313_3_, PacketBuffer p_228313_4_, CompoundNBT p_228313_5_, int p_228313_6_, boolean p_228313_7_) {
        if (!this.field_217256_d.func_217183_b(p_228313_1_, p_228313_2_)) {
            field_147436_a.warn("Ignoring chunk since it's not in the view range: {}, {}", (Object)p_228313_1_, (Object)p_228313_2_);
            return null;
        }
        int i = this.field_217256_d.func_217191_a(p_228313_1_, p_228313_2_);
        Chunk chunk = this.field_217256_d.field_217195_b.get(i);
        if (!p_228313_7_ && ClientChunkProvider.func_217249_a(chunk, p_228313_1_, p_228313_2_)) {
            chunk.func_227073_a_(p_228313_3_, p_228313_4_, p_228313_5_, p_228313_6_);
        } else {
            if (p_228313_3_ == null) {
                field_147436_a.warn("Ignoring chunk since we don't have complete data: {}, {}", (Object)p_228313_1_, (Object)p_228313_2_);
                return null;
            }
            chunk = new Chunk(this.field_73235_d, new ChunkPos(p_228313_1_, p_228313_2_), p_228313_3_);
            chunk.func_227073_a_(p_228313_3_, p_228313_4_, p_228313_5_, p_228313_6_);
            this.field_217256_d.func_217181_a(i, chunk);
        }
        ChunkSection[] achunksection = chunk.func_76587_i();
        WorldLightManager worldlightmanager = this.func_212863_j_();
        worldlightmanager.func_215571_a(new ChunkPos(p_228313_1_, p_228313_2_), true);
        for (int j = 0; j < achunksection.length; ++j) {
            ChunkSection chunksection = achunksection[j];
            worldlightmanager.func_215566_a(SectionPos.func_218154_a((int)p_228313_1_, (int)j, (int)p_228313_2_), ChunkSection.func_222628_a(chunksection));
        }
        this.field_73235_d.func_228323_e_(p_228313_1_, p_228313_2_);
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((IChunk)chunk));
        return chunk;
    }

    public void func_217207_a(BooleanSupplier p_217207_1_) {
    }

    public void func_217251_d(int p_217251_1_, int p_217251_2_) {
        this.field_217256_d.field_217198_e = p_217251_1_;
        this.field_217256_d.field_217199_f = p_217251_2_;
    }

    public void func_217248_a(int p_217248_1_) {
        int i = this.field_217256_d.field_217196_c;
        int j = ClientChunkProvider.func_217254_b(p_217248_1_);
        if (i != j) {
            ChunkArray clientchunkprovider$chunkarray = new ChunkArray(j);
            clientchunkprovider$chunkarray.field_217198_e = this.field_217256_d.field_217198_e;
            clientchunkprovider$chunkarray.field_217199_f = this.field_217256_d.field_217199_f;
            for (int k = 0; k < this.field_217256_d.field_217195_b.length(); ++k) {
                Chunk chunk = this.field_217256_d.field_217195_b.get(k);
                if (chunk == null) continue;
                ChunkPos chunkpos = chunk.func_76632_l();
                if (!clientchunkprovider$chunkarray.func_217183_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) continue;
                clientchunkprovider$chunkarray.func_217181_a(clientchunkprovider$chunkarray.func_217191_a(chunkpos.field_77276_a, chunkpos.field_77275_b), chunk);
            }
            this.field_217256_d = clientchunkprovider$chunkarray;
        }
    }

    private static int func_217254_b(int p_217254_0_) {
        return Math.max(2, p_217254_0_) + 3;
    }

    public String func_73148_d() {
        return "Client Chunk Cache: " + this.field_217256_d.field_217195_b.length() + ", " + this.func_217252_g();
    }

    public int func_217252_g() {
        return this.field_217256_d.field_217200_g;
    }

    public void func_217201_a(LightType p_217201_1_, SectionPos p_217201_2_) {
        Minecraft.func_71410_x().field_71438_f.func_215328_b(p_217201_2_.func_218149_a(), p_217201_2_.func_218163_b(), p_217201_2_.func_218148_c());
    }

    public boolean func_222866_a(BlockPos p_222866_1_) {
        return this.func_73149_a(p_222866_1_.func_177958_n() >> 4, p_222866_1_.func_177952_p() >> 4);
    }

    public boolean func_222865_a(ChunkPos p_222865_1_) {
        return this.func_73149_a(p_222865_1_.field_77276_a, p_222865_1_.field_77275_b);
    }

    public boolean func_217204_a(Entity p_217204_1_) {
        return this.func_73149_a(MathHelper.func_76128_c((double)p_217204_1_.func_226277_ct_()) >> 4, MathHelper.func_76128_c((double)p_217204_1_.func_226281_cx_()) >> 4);
    }

    @OnlyIn(value=Dist.CLIENT)
    final class ChunkArray {
        private final AtomicReferenceArray<Chunk> field_217195_b;
        private final int field_217196_c;
        private final int field_217197_d;
        private volatile int field_217198_e;
        private volatile int field_217199_f;
        private int field_217200_g;

        private ChunkArray(int p_i50568_2_) {
            this.field_217196_c = p_i50568_2_;
            this.field_217197_d = p_i50568_2_ * 2 + 1;
            this.field_217195_b = new AtomicReferenceArray(this.field_217197_d * this.field_217197_d);
        }

        private int func_217191_a(int p_217191_1_, int p_217191_2_) {
            return Math.floorMod(p_217191_2_, this.field_217197_d) * this.field_217197_d + Math.floorMod(p_217191_1_, this.field_217197_d);
        }

        protected void func_217181_a(int p_217181_1_, @Nullable Chunk p_217181_2_) {
            Chunk chunk = this.field_217195_b.getAndSet(p_217181_1_, p_217181_2_);
            if (chunk != null) {
                --this.field_217200_g;
                ClientChunkProvider.this.field_73235_d.func_217409_a(chunk);
            }
            if (p_217181_2_ != null) {
                ++this.field_217200_g;
            }
        }

        protected Chunk func_217190_a(int p_217190_1_, Chunk p_217190_2_, @Nullable Chunk p_217190_3_) {
            if (this.field_217195_b.compareAndSet(p_217190_1_, p_217190_2_, p_217190_3_) && p_217190_3_ == null) {
                --this.field_217200_g;
            }
            ClientChunkProvider.this.field_73235_d.func_217409_a(p_217190_2_);
            return p_217190_2_;
        }

        private boolean func_217183_b(int p_217183_1_, int p_217183_2_) {
            return Math.abs(p_217183_1_ - this.field_217198_e) <= this.field_217196_c && Math.abs(p_217183_2_ - this.field_217199_f) <= this.field_217196_c;
        }

        @Nullable
        protected Chunk func_217192_a(int p_217192_1_) {
            return this.field_217195_b.get(p_217192_1_);
        }
    }
}

