/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StructureBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.util.ClientRecipeBook;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.network.play.client.CEnchantItemPacket;
import net.minecraft.network.play.client.CHeldItemChangePacket;
import net.minecraft.network.play.client.CPickItemPacket;
import net.minecraft.network.play.client.CPlaceRecipePacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PlayerController {
    private static final Logger field_225325_a = LogManager.getLogger();
    private final Minecraft field_78776_a;
    private final ClientPlayNetHandler field_78774_b;
    private BlockPos field_178895_c = new BlockPos(-1, -1, -1);
    private ItemStack field_85183_f = ItemStack.field_190927_a;
    private float field_78770_f;
    private float field_78780_h;
    private int field_78781_i;
    private boolean field_78778_j;
    private GameType field_78779_k = GameType.SURVIVAL;
    private GameType field_239166_k_ = GameType.NOT_SET;
    private final Object2ObjectLinkedOpenHashMap<Pair<BlockPos, CPlayerDiggingPacket.Action>, Vector3d> field_225326_k = new Object2ObjectLinkedOpenHashMap();
    private int field_78777_l;

    public PlayerController(Minecraft p_i45062_1_, ClientPlayNetHandler p_i45062_2_) {
        this.field_78776_a = p_i45062_1_;
        this.field_78774_b = p_i45062_2_;
    }

    public void func_78748_a(PlayerEntity p_78748_1_) {
        this.field_78779_k.func_77147_a(p_78748_1_.field_71075_bZ);
    }

    public void func_241675_a_(GameType p_241675_1_) {
        this.field_239166_k_ = p_241675_1_;
    }

    public void func_78746_a(GameType p_78746_1_) {
        if (p_78746_1_ != this.field_78779_k) {
            this.field_239166_k_ = this.field_78779_k;
        }
        this.field_78779_k = p_78746_1_;
        this.field_78779_k.func_77147_a(this.field_78776_a.field_71439_g.field_71075_bZ);
    }

    public boolean func_78755_b() {
        return this.field_78779_k.func_77144_e();
    }

    public boolean func_187103_a(BlockPos p_187103_1_) {
        if (this.field_78776_a.field_71439_g.func_184614_ca().onBlockStartBreak(p_187103_1_, this.field_78776_a.field_71439_g)) {
            return false;
        }
        if (this.field_78776_a.field_71439_g.func_223729_a(this.field_78776_a.field_71441_e, p_187103_1_, this.field_78779_k)) {
            return false;
        }
        ClientWorld world = this.field_78776_a.field_71441_e;
        BlockState blockstate = world.func_180495_p(p_187103_1_);
        if (!this.field_78776_a.field_71439_g.func_184614_ca().func_77973_b().func_195938_a(blockstate, world, p_187103_1_, this.field_78776_a.field_71439_g)) {
            return false;
        }
        Block block = blockstate.func_177230_c();
        if ((block instanceof CommandBlockBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !this.field_78776_a.field_71439_g.func_195070_dx()) {
            return false;
        }
        if (blockstate.isAir((IBlockReader)((Object)world), p_187103_1_)) {
            return false;
        }
        FluidState fluidstate = world.func_204610_c(p_187103_1_);
        boolean flag = blockstate.removedByPlayer(world, p_187103_1_, this.field_78776_a.field_71439_g, false, fluidstate);
        if (flag) {
            block.func_176206_d(world, p_187103_1_, blockstate);
        }
        return flag;
    }

    public boolean func_180511_b(BlockPos p_180511_1_, Direction p_180511_2_) {
        if (this.field_78776_a.field_71439_g.func_223729_a(this.field_78776_a.field_71441_e, p_180511_1_, this.field_78779_k)) {
            return false;
        }
        if (!this.field_78776_a.field_71441_e.func_175723_af().func_177746_a(p_180511_1_)) {
            return false;
        }
        if (this.field_78779_k.func_77145_d()) {
            BlockState blockstate = this.field_78776_a.field_71441_e.func_180495_p(p_180511_1_);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, p_180511_1_, blockstate, 1.0f);
            this.func_225324_a(CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, p_180511_1_, p_180511_2_);
            if (!ForgeHooks.onLeftClickBlock((PlayerEntity)this.field_78776_a.field_71439_g, (BlockPos)p_180511_1_, (Direction)p_180511_2_).isCanceled()) {
                this.func_187103_a(p_180511_1_);
            }
            this.field_78781_i = 5;
        } else if (!this.field_78778_j || !this.func_178893_a(p_180511_1_)) {
            boolean flag;
            if (this.field_78778_j) {
                this.func_225324_a(CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK, this.field_178895_c, p_180511_2_);
            }
            PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((PlayerEntity)this.field_78776_a.field_71439_g, (BlockPos)p_180511_1_, (Direction)p_180511_2_);
            BlockState blockstate1 = this.field_78776_a.field_71441_e.func_180495_p(p_180511_1_);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, p_180511_1_, blockstate1, 0.0f);
            this.func_225324_a(CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, p_180511_1_, p_180511_2_);
            boolean bl = flag = !blockstate1.isAir((IBlockReader)((Object)this.field_78776_a.field_71441_e), p_180511_1_);
            if (flag && this.field_78770_f == 0.0f && event.getUseBlock() != Event.Result.DENY) {
                blockstate1.func_196942_a(this.field_78776_a.field_71441_e, p_180511_1_, this.field_78776_a.field_71439_g);
            }
            if (event.getUseItem() == Event.Result.DENY) {
                return true;
            }
            if (flag && blockstate1.func_185903_a(this.field_78776_a.field_71439_g, (IBlockReader)((Object)this.field_78776_a.field_71439_g.field_70170_p), p_180511_1_) >= 1.0f) {
                this.func_187103_a(p_180511_1_);
            } else {
                this.field_78778_j = true;
                this.field_178895_c = p_180511_1_;
                this.field_85183_f = this.field_78776_a.field_71439_g.func_184614_ca();
                this.field_78770_f = 0.0f;
                this.field_78780_h = 0.0f;
                this.field_78776_a.field_71441_e.func_175715_c(this.field_78776_a.field_71439_g.func_145782_y(), this.field_178895_c, (int)(this.field_78770_f * 10.0f) - 1);
            }
        }
        return true;
    }

    public void func_78767_c() {
        if (this.field_78778_j) {
            BlockState blockstate = this.field_78776_a.field_71441_e.func_180495_p(this.field_178895_c);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, this.field_178895_c, blockstate, -1.0f);
            this.func_225324_a(CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK, this.field_178895_c, Direction.DOWN);
            this.field_78778_j = false;
            this.field_78770_f = 0.0f;
            this.field_78776_a.field_71441_e.func_175715_c(this.field_78776_a.field_71439_g.func_145782_y(), this.field_178895_c, -1);
            this.field_78776_a.field_71439_g.func_184821_cY();
        }
    }

    public boolean func_180512_c(BlockPos p_180512_1_, Direction p_180512_2_) {
        this.func_78750_j();
        if (this.field_78781_i > 0) {
            --this.field_78781_i;
            return true;
        }
        if (this.field_78779_k.func_77145_d() && this.field_78776_a.field_71441_e.func_175723_af().func_177746_a(p_180512_1_)) {
            this.field_78781_i = 5;
            BlockState blockstate1 = this.field_78776_a.field_71441_e.func_180495_p(p_180512_1_);
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, p_180512_1_, blockstate1, 1.0f);
            this.func_225324_a(CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, p_180512_1_, p_180512_2_);
            if (!ForgeHooks.onLeftClickBlock((PlayerEntity)this.field_78776_a.field_71439_g, (BlockPos)p_180512_1_, (Direction)p_180512_2_).isCanceled()) {
                this.func_187103_a(p_180512_1_);
            }
            return true;
        }
        if (this.func_178893_a(p_180512_1_)) {
            BlockState blockstate = this.field_78776_a.field_71441_e.func_180495_p(p_180512_1_);
            if (blockstate.isAir((IBlockReader)((Object)this.field_78776_a.field_71441_e), p_180512_1_)) {
                this.field_78778_j = false;
                return false;
            }
            this.field_78770_f += blockstate.func_185903_a(this.field_78776_a.field_71439_g, (IBlockReader)((Object)this.field_78776_a.field_71439_g.field_70170_p), p_180512_1_);
            if (this.field_78780_h % 4.0f == 0.0f) {
                SoundType soundtype = blockstate.getSoundType((IWorldReader)((Object)this.field_78776_a.field_71441_e), p_180512_1_, this.field_78776_a.field_71439_g);
                this.field_78776_a.func_147118_V().func_147682_a((ISound)new SimpleSound(soundtype.func_185846_f(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 8.0f, soundtype.func_185847_b() * 0.5f, p_180512_1_));
            }
            this.field_78780_h += 1.0f;
            this.field_78776_a.func_193032_ao().func_193294_a(this.field_78776_a.field_71441_e, p_180512_1_, blockstate, MathHelper.func_76131_a((float)this.field_78770_f, (float)0.0f, (float)1.0f));
            if (ForgeHooks.onLeftClickBlock((PlayerEntity)this.field_78776_a.field_71439_g, (BlockPos)p_180512_1_, (Direction)p_180512_2_).getUseItem() == Event.Result.DENY) {
                return true;
            }
            if (this.field_78770_f >= 1.0f) {
                this.field_78778_j = false;
                this.func_225324_a(CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK, p_180512_1_, p_180512_2_);
                this.func_187103_a(p_180512_1_);
                this.field_78770_f = 0.0f;
                this.field_78780_h = 0.0f;
                this.field_78781_i = 5;
            }
            this.field_78776_a.field_71441_e.func_175715_c(this.field_78776_a.field_71439_g.func_145782_y(), this.field_178895_c, (int)(this.field_78770_f * 10.0f) - 1);
            return true;
        }
        return this.func_180511_b(p_180512_1_, p_180512_2_);
    }

    public float func_78757_d() {
        float attrib = (float)this.field_78776_a.field_71439_g.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        return this.field_78779_k.func_77145_d() ? attrib : attrib - 0.5f;
    }

    public void func_78765_e() {
        this.func_78750_j();
        if (this.field_78774_b.func_147298_b().func_150724_d()) {
            this.field_78774_b.func_147298_b().func_74428_b();
        } else {
            this.field_78774_b.func_147298_b().func_179293_l();
        }
    }

    private boolean func_178893_a(BlockPos p_178893_1_) {
        boolean flag;
        ItemStack itemstack = this.field_78776_a.field_71439_g.func_184614_ca();
        boolean bl = flag = this.field_85183_f.func_190926_b() && itemstack.func_190926_b();
        if (!this.field_85183_f.func_190926_b() && !itemstack.func_190926_b()) {
            flag = !this.field_85183_f.shouldCauseBlockBreakReset(itemstack);
        }
        return p_178893_1_.equals((Object)this.field_178895_c) && flag;
    }

    private void func_78750_j() {
        int i = this.field_78776_a.field_71439_g.field_71071_by.field_70461_c;
        if (i != this.field_78777_l) {
            this.field_78777_l = i;
            this.field_78774_b.func_147297_a((IPacket<?>)new CHeldItemChangePacket(this.field_78777_l));
        }
    }

    public ActionResultType func_217292_a(ClientPlayerEntity p_217292_1_, ClientWorld p_217292_2_, Hand p_217292_3_, BlockRayTraceResult p_217292_4_) {
        ActionResultType actionresulttype;
        boolean flag1;
        ActionResultType result;
        this.func_78750_j();
        BlockPos blockpos = p_217292_4_.func_216350_a();
        if (!this.field_78776_a.field_71441_e.func_175723_af().func_177746_a(blockpos)) {
            return ActionResultType.FAIL;
        }
        ItemStack itemstack = p_217292_1_.func_184586_b(p_217292_3_);
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)p_217292_1_, (Hand)p_217292_3_, (BlockPos)blockpos, (BlockRayTraceResult)p_217292_4_);
        if (event.isCanceled()) {
            this.field_78774_b.func_147297_a(new CPlayerTryUseItemOnBlockPacket(p_217292_3_, p_217292_4_));
            return event.getCancellationResult();
        }
        if (this.field_78779_k == GameType.SPECTATOR) {
            this.field_78774_b.func_147297_a(new CPlayerTryUseItemOnBlockPacket(p_217292_3_, p_217292_4_));
            return ActionResultType.SUCCESS;
        }
        ItemUseContext itemusecontext = new ItemUseContext((PlayerEntity)p_217292_1_, p_217292_3_, p_217292_4_);
        if (event.getUseItem() != Event.Result.DENY && (result = itemstack.onItemUseFirst(itemusecontext)) != ActionResultType.PASS) {
            this.field_78774_b.func_147297_a(new CPlayerTryUseItemOnBlockPacket(p_217292_3_, p_217292_4_));
            return result;
        }
        boolean flag = !p_217292_1_.func_184614_ca().doesSneakBypassUse((IWorldReader)((Object)p_217292_2_), blockpos, p_217292_1_) || !p_217292_1_.func_184592_cb().doesSneakBypassUse((IWorldReader)((Object)p_217292_2_), blockpos, p_217292_1_);
        boolean bl = flag1 = p_217292_1_.func_226563_dT_() && flag;
        if ((event.getUseBlock() == Event.Result.ALLOW || event.getUseBlock() != Event.Result.DENY && !flag1) && (actionresulttype = p_217292_2_.func_180495_p(blockpos).func_227031_a_(p_217292_2_, p_217292_1_, p_217292_3_, p_217292_4_)).func_226246_a_()) {
            this.field_78774_b.func_147297_a(new CPlayerTryUseItemOnBlockPacket(p_217292_3_, p_217292_4_));
            return actionresulttype;
        }
        this.field_78774_b.func_147297_a(new CPlayerTryUseItemOnBlockPacket(p_217292_3_, p_217292_4_));
        if (event.getUseItem() == Event.Result.DENY) {
            return ActionResultType.PASS;
        }
        if (event.getUseItem() == Event.Result.ALLOW || !itemstack.func_190926_b() && !p_217292_1_.func_184811_cZ().func_185141_a(itemstack.func_77973_b())) {
            ActionResultType actionresulttype1;
            if (this.field_78779_k.func_77145_d()) {
                int i = itemstack.func_190916_E();
                actionresulttype1 = itemstack.func_196084_a(itemusecontext);
                itemstack.func_190920_e(i);
            } else {
                actionresulttype1 = itemstack.func_196084_a(itemusecontext);
            }
            return actionresulttype1;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_187101_a(PlayerEntity p_187101_1_, World p_187101_2_, Hand p_187101_3_) {
        if (this.field_78779_k == GameType.SPECTATOR) {
            return ActionResultType.PASS;
        }
        this.func_78750_j();
        this.field_78774_b.func_147297_a(new CPlayerTryUseItemPacket(p_187101_3_));
        ItemStack itemstack = p_187101_1_.func_184586_b(p_187101_3_);
        if (p_187101_1_.func_184811_cZ().func_185141_a(itemstack.func_77973_b())) {
            return ActionResultType.PASS;
        }
        ActionResultType cancelResult = ForgeHooks.onItemRightClick((PlayerEntity)p_187101_1_, (Hand)p_187101_3_);
        if (cancelResult != null) {
            return cancelResult;
        }
        int i = itemstack.func_190916_E();
        ActionResult<ItemStack> actionresult = itemstack.func_77957_a(p_187101_2_, p_187101_1_, p_187101_3_);
        ItemStack itemstack1 = (ItemStack)((Object)actionresult.func_188398_b());
        if (itemstack1 != itemstack) {
            p_187101_1_.func_184611_a(p_187101_3_, itemstack1);
            if (itemstack1.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)p_187101_1_, (ItemStack)itemstack, (Hand)p_187101_3_);
            }
        }
        return actionresult.func_188397_a();
    }

    public ClientPlayerEntity func_199681_a(ClientWorld p_199681_1_, StatisticsManager p_199681_2_, ClientRecipeBook p_199681_3_) {
        return this.func_239167_a_(p_199681_1_, p_199681_2_, p_199681_3_, false, false);
    }

    public ClientPlayerEntity func_239167_a_(ClientWorld p_239167_1_, StatisticsManager p_239167_2_, ClientRecipeBook p_239167_3_, boolean p_239167_4_, boolean p_239167_5_) {
        return new ClientPlayerEntity(this.field_78776_a, p_239167_1_, this.field_78774_b, p_239167_2_, p_239167_3_, p_239167_4_, p_239167_5_);
    }

    public void func_78764_a(PlayerEntity p_78764_1_, Entity p_78764_2_) {
        this.func_78750_j();
        this.field_78774_b.func_147297_a((IPacket<?>)new CUseEntityPacket(p_78764_2_, p_78764_1_.func_225608_bj_()));
        if (this.field_78779_k != GameType.SPECTATOR) {
            p_78764_1_.func_71059_n(p_78764_2_);
            p_78764_1_.func_184821_cY();
        }
    }

    public ActionResultType func_187097_a(PlayerEntity p_187097_1_, Entity p_187097_2_, Hand p_187097_3_) {
        this.func_78750_j();
        this.field_78774_b.func_147297_a((IPacket<?>)new CUseEntityPacket(p_187097_2_, p_187097_3_, p_187097_1_.func_225608_bj_()));
        if (this.field_78779_k == GameType.SPECTATOR) {
            return ActionResultType.PASS;
        }
        ActionResultType cancelResult = ForgeHooks.onInteractEntity((PlayerEntity)p_187097_1_, (Entity)p_187097_2_, (Hand)p_187097_3_);
        if (cancelResult != null) {
            return cancelResult;
        }
        return this.field_78779_k == GameType.SPECTATOR ? ActionResultType.PASS : p_187097_1_.func_190775_a(p_187097_2_, p_187097_3_);
    }

    public ActionResultType func_187102_a(PlayerEntity p_187102_1_, Entity p_187102_2_, EntityRayTraceResult p_187102_3_, Hand p_187102_4_) {
        this.func_78750_j();
        Vector3d vector3d = p_187102_3_.func_216347_e().func_178786_a(p_187102_2_.func_226277_ct_(), p_187102_2_.func_226278_cu_(), p_187102_2_.func_226281_cx_());
        this.field_78774_b.func_147297_a((IPacket<?>)new CUseEntityPacket(p_187102_2_, p_187102_4_, vector3d, p_187102_1_.func_225608_bj_()));
        if (this.field_78779_k == GameType.SPECTATOR) {
            return ActionResultType.PASS;
        }
        ActionResultType cancelResult = ForgeHooks.onInteractEntityAt((PlayerEntity)p_187102_1_, (Entity)p_187102_2_, (RayTraceResult)p_187102_3_, (Hand)p_187102_4_);
        if (cancelResult != null) {
            return cancelResult;
        }
        return this.field_78779_k == GameType.SPECTATOR ? ActionResultType.PASS : p_187102_2_.func_184199_a(p_187102_1_, vector3d, p_187102_4_);
    }

    public ItemStack func_187098_a(int p_187098_1_, int p_187098_2_, int p_187098_3_, ClickType p_187098_4_, PlayerEntity p_187098_5_) {
        short short1 = p_187098_5_.field_71070_bA.func_75136_a(p_187098_5_.field_71071_by);
        ItemStack itemstack = p_187098_5_.field_71070_bA.func_184996_a(p_187098_2_, p_187098_3_, p_187098_4_, p_187098_5_);
        this.field_78774_b.func_147297_a(new CClickWindowPacket(p_187098_1_, p_187098_2_, p_187098_3_, p_187098_4_, itemstack, short1));
        return itemstack;
    }

    public void func_203413_a(int p_203413_1_, IRecipe<?> p_203413_2_, boolean p_203413_3_) {
        this.field_78774_b.func_147297_a((IPacket<?>)new CPlaceRecipePacket(p_203413_1_, p_203413_2_, p_203413_3_));
    }

    public void func_78756_a(int p_78756_1_, int p_78756_2_) {
        this.field_78774_b.func_147297_a((IPacket<?>)new CEnchantItemPacket(p_78756_1_, p_78756_2_));
    }

    public void func_78761_a(ItemStack p_78761_1_, int p_78761_2_) {
        if (this.field_78779_k.func_77145_d()) {
            this.field_78774_b.func_147297_a(new CCreativeInventoryActionPacket(p_78761_2_, p_78761_1_));
        }
    }

    public void func_78752_a(ItemStack p_78752_1_) {
        if (this.field_78779_k.func_77145_d() && !p_78752_1_.func_190926_b()) {
            this.field_78774_b.func_147297_a(new CCreativeInventoryActionPacket(-1, p_78752_1_));
        }
    }

    public void func_78766_c(PlayerEntity p_78766_1_) {
        this.func_78750_j();
        this.field_78774_b.func_147297_a((IPacket<?>)new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.RELEASE_USE_ITEM, BlockPos.field_177992_a, Direction.DOWN));
        p_78766_1_.func_184597_cx();
    }

    public boolean func_78763_f() {
        return this.field_78779_k.func_77144_e();
    }

    public boolean func_78762_g() {
        return !this.field_78779_k.func_77145_d();
    }

    public boolean func_78758_h() {
        return this.field_78779_k.func_77145_d();
    }

    public boolean func_78749_i() {
        return this.field_78779_k.func_77145_d();
    }

    public boolean func_110738_j() {
        return this.field_78776_a.field_71439_g.func_184218_aH() && this.field_78776_a.field_71439_g.func_184187_bx() instanceof AbstractHorseEntity;
    }

    public boolean func_178887_k() {
        return this.field_78779_k == GameType.SPECTATOR;
    }

    public GameType func_241822_k() {
        return this.field_239166_k_;
    }

    public GameType func_178889_l() {
        return this.field_78779_k;
    }

    public boolean func_181040_m() {
        return this.field_78778_j;
    }

    public void func_187100_a(int p_187100_1_) {
        this.field_78774_b.func_147297_a((IPacket<?>)new CPickItemPacket(p_187100_1_));
    }

    private void func_225324_a(CPlayerDiggingPacket.Action p_225324_1_, BlockPos p_225324_2_, Direction p_225324_3_) {
        ClientPlayerEntity clientplayerentity = this.field_78776_a.field_71439_g;
        this.field_225326_k.put((Object)Pair.of((Object)((Object)p_225324_2_), (Object)p_225324_1_), (Object)clientplayerentity.func_213303_ch());
        this.field_78774_b.func_147297_a((IPacket<?>)new CPlayerDiggingPacket(p_225324_1_, p_225324_2_, p_225324_3_));
    }

    public void func_225323_a(ClientWorld p_225323_1_, BlockPos p_225323_2_, BlockState p_225323_3_, CPlayerDiggingPacket.Action p_225323_4_, boolean p_225323_5_) {
        Vector3d vector3d = (Vector3d)this.field_225326_k.remove((Object)Pair.of((Object)((Object)p_225323_2_), (Object)p_225323_4_));
        BlockState blockstate = p_225323_1_.func_180495_p(p_225323_2_);
        if ((vector3d == null || !p_225323_5_ || p_225323_4_ != CPlayerDiggingPacket.Action.START_DESTROY_BLOCK && blockstate != p_225323_3_) && blockstate != p_225323_3_) {
            p_225323_1_.func_195597_b(p_225323_2_, p_225323_3_);
            ClientPlayerEntity playerentity = this.field_78776_a.field_71439_g;
            if (vector3d != null && p_225323_1_ == playerentity.field_70170_p && playerentity.func_242278_a(p_225323_2_, p_225323_3_)) {
                playerentity.func_242281_f(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
            }
        }
        while (this.field_225326_k.size() >= 50) {
            Pair pair = (Pair)this.field_225326_k.firstKey();
            this.field_225326_k.removeFirst();
            field_225325_a.error("Too many unacked block actions, dropping " + pair);
        }
    }
}

