/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class BlockModelRenderer {
    private final BlockColors field_187499_a;
    private static final ThreadLocal<Cache> field_210267_b = ThreadLocal.withInitial(() -> new Cache());

    public BlockModelRenderer(BlockColors p_i46575_1_) {
        this.field_187499_a = p_i46575_1_;
    }

    @Deprecated
    public boolean func_228802_a_(IBlockDisplayReader p_228802_1_, IBakedModel p_228802_2_, BlockState p_228802_3_, BlockPos p_228802_4_, MatrixStack p_228802_5_, IVertexBuilder p_228802_6_, boolean p_228802_7_, Random p_228802_8_, long p_228802_9_, int p_228802_11_) {
        return this.renderModel(p_228802_1_, p_228802_2_, p_228802_3_, p_228802_4_, p_228802_5_, p_228802_6_, p_228802_7_, p_228802_8_, p_228802_9_, p_228802_11_, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModel(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        boolean flag = Minecraft.func_71379_u() && stateIn.getLightValue((IBlockReader)worldIn, posIn) == 0 && modelIn.func_177555_b();
        Vector3d vector3d = stateIn.func_191059_e((IBlockReader)worldIn, posIn);
        matrixIn.func_227861_a_(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
        modelData = modelIn.getModelData(worldIn, posIn, stateIn, modelData);
        try {
            return flag ? this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData) : this.renderModelFlat(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block model being tesselated");
            CrashReportCategory.func_175750_a(crashreportcategory, posIn, stateIn);
            crashreportcategory.func_71507_a("Using AO", flag);
            throw new ReportedException(crashreport);
        }
    }

    @Deprecated
    public boolean func_228805_b_(IBlockDisplayReader p_228805_1_, IBakedModel p_228805_2_, BlockState p_228805_3_, BlockPos p_228805_4_, MatrixStack p_228805_5_, IVertexBuilder p_228805_6_, boolean p_228805_7_, Random p_228805_8_, long p_228805_9_, int p_228805_11_) {
        return this.renderModelSmooth(p_228805_1_, p_228805_2_, p_228805_3_, p_228805_4_, p_228805_5_, p_228805_6_, p_228805_7_, p_228805_8_, p_228805_9_, p_228805_11_, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModelSmooth(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        boolean flag = false;
        float[] afloat = new float[Direction.values().length * 2];
        BitSet bitset = new BitSet(3);
        AmbientOcclusionFace blockmodelrenderer$ambientocclusionface = new AmbientOcclusionFace();
        for (Direction direction : Direction.values()) {
            randomIn.setSeed(rand);
            List list = modelIn.getQuads(stateIn, direction, randomIn, modelData);
            if (list.isEmpty() || checkSides && !Block.func_176225_a(stateIn, (IBlockReader)worldIn, posIn, direction)) continue;
            this.func_228799_a_(worldIn, stateIn, posIn, matrixStackIn, buffer, list, afloat, bitset, blockmodelrenderer$ambientocclusionface, combinedOverlayIn);
            flag = true;
        }
        randomIn.setSeed(rand);
        List list1 = modelIn.getQuads(stateIn, null, randomIn, modelData);
        if (!list1.isEmpty()) {
            this.func_228799_a_(worldIn, stateIn, posIn, matrixStackIn, buffer, list1, afloat, bitset, blockmodelrenderer$ambientocclusionface, combinedOverlayIn);
            flag = true;
        }
        return flag;
    }

    @Deprecated
    public boolean func_228806_c_(IBlockDisplayReader p_228806_1_, IBakedModel p_228806_2_, BlockState p_228806_3_, BlockPos p_228806_4_, MatrixStack p_228806_5_, IVertexBuilder p_228806_6_, boolean p_228806_7_, Random p_228806_8_, long p_228806_9_, int p_228806_11_) {
        return this.renderModelFlat(p_228806_1_, p_228806_2_, p_228806_3_, p_228806_4_, p_228806_5_, p_228806_6_, p_228806_7_, p_228806_8_, p_228806_9_, p_228806_11_, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModelFlat(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        boolean flag = false;
        BitSet bitset = new BitSet(3);
        for (Direction direction : Direction.values()) {
            randomIn.setSeed(rand);
            List list = modelIn.getQuads(stateIn, direction, randomIn, modelData);
            if (list.isEmpty() || checkSides && !Block.func_176225_a(stateIn, (IBlockReader)worldIn, posIn, direction)) continue;
            int i = WorldRenderer.func_228420_a_(worldIn, stateIn, posIn.func_177972_a(direction));
            this.func_228798_a_(worldIn, stateIn, posIn, i, combinedOverlayIn, false, matrixStackIn, buffer, list, bitset);
            flag = true;
        }
        randomIn.setSeed(rand);
        List list1 = modelIn.getQuads(stateIn, null, randomIn, modelData);
        if (!list1.isEmpty()) {
            this.func_228798_a_(worldIn, stateIn, posIn, -1, combinedOverlayIn, true, matrixStackIn, buffer, list1, bitset);
            flag = true;
        }
        return flag;
    }

    private void func_228799_a_(IBlockDisplayReader p_228799_1_, BlockState p_228799_2_, BlockPos p_228799_3_, MatrixStack p_228799_4_, IVertexBuilder p_228799_5_, List<BakedQuad> p_228799_6_, float[] p_228799_7_, BitSet p_228799_8_, AmbientOcclusionFace p_228799_9_, int p_228799_10_) {
        for (BakedQuad bakedquad : p_228799_6_) {
            this.func_228801_a_(p_228799_1_, p_228799_2_, p_228799_3_, bakedquad.func_178209_a(), bakedquad.func_178210_d(), p_228799_7_, p_228799_8_);
            p_228799_9_.func_239285_a_(p_228799_1_, p_228799_2_, p_228799_3_, bakedquad.func_178210_d(), p_228799_7_, p_228799_8_, bakedquad.func_239287_f_());
            this.func_228800_a_(p_228799_1_, p_228799_2_, p_228799_3_, p_228799_5_, p_228799_4_.func_227866_c_(), bakedquad, p_228799_9_.field_178206_b[0], p_228799_9_.field_178206_b[1], p_228799_9_.field_178206_b[2], p_228799_9_.field_178206_b[3], p_228799_9_.field_178207_c[0], p_228799_9_.field_178207_c[1], p_228799_9_.field_178207_c[2], p_228799_9_.field_178207_c[3], p_228799_10_);
        }
    }

    private void func_228800_a_(IBlockDisplayReader p_228800_1_, BlockState p_228800_2_, BlockPos p_228800_3_, IVertexBuilder p_228800_4_, MatrixStack.Entry p_228800_5_, BakedQuad p_228800_6_, float p_228800_7_, float p_228800_8_, float p_228800_9_, float p_228800_10_, int p_228800_11_, int p_228800_12_, int p_228800_13_, int p_228800_14_, int p_228800_15_) {
        float f2;
        float f1;
        float f;
        if (p_228800_6_.func_178212_b()) {
            int i = this.field_187499_a.func_228054_a_(p_228800_2_, p_228800_1_, p_228800_3_, p_228800_6_.func_178211_c());
            f = (float)(i >> 16 & 0xFF) / 255.0f;
            f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            f2 = (float)(i & 0xFF) / 255.0f;
        } else {
            f = 1.0f;
            f1 = 1.0f;
            f2 = 1.0f;
        }
        p_228800_4_.func_227890_a_(p_228800_5_, p_228800_6_, new float[]{p_228800_7_, p_228800_8_, p_228800_9_, p_228800_10_}, f, f1, f2, new int[]{p_228800_11_, p_228800_12_, p_228800_13_, p_228800_14_}, p_228800_15_, true);
    }

    private void func_228801_a_(IBlockDisplayReader p_228801_1_, BlockState p_228801_2_, BlockPos p_228801_3_, int[] p_228801_4_, Direction p_228801_5_, @Nullable float[] p_228801_6_, BitSet p_228801_7_) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(p_228801_4_[i * 8]);
            float f7 = Float.intBitsToFloat(p_228801_4_[i * 8 + 1]);
            float f8 = Float.intBitsToFloat(p_228801_4_[i * 8 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (p_228801_6_ != null) {
            p_228801_6_[Direction.WEST.func_176745_a()] = f;
            p_228801_6_[Direction.EAST.func_176745_a()] = f3;
            p_228801_6_[Direction.DOWN.func_176745_a()] = f1;
            p_228801_6_[Direction.UP.func_176745_a()] = f4;
            p_228801_6_[Direction.NORTH.func_176745_a()] = f2;
            p_228801_6_[Direction.SOUTH.func_176745_a()] = f5;
            int j = Direction.values().length;
            p_228801_6_[Direction.WEST.func_176745_a() + j] = 1.0f - f;
            p_228801_6_[Direction.EAST.func_176745_a() + j] = 1.0f - f3;
            p_228801_6_[Direction.DOWN.func_176745_a() + j] = 1.0f - f1;
            p_228801_6_[Direction.UP.func_176745_a() + j] = 1.0f - f4;
            p_228801_6_[Direction.NORTH.func_176745_a() + j] = 1.0f - f2;
            p_228801_6_[Direction.SOUTH.func_176745_a() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (p_228801_5_) {
            case DOWN: {
                p_228801_7_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_228801_7_.set(0, f1 == f4 && (f1 < 1.0E-4f || p_228801_2_.func_235785_r_((IBlockReader)p_228801_1_, p_228801_3_)));
                break;
            }
            case UP: {
                p_228801_7_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_228801_7_.set(0, f1 == f4 && (f4 > 0.9999f || p_228801_2_.func_235785_r_((IBlockReader)p_228801_1_, p_228801_3_)));
                break;
            }
            case NORTH: {
                p_228801_7_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_228801_7_.set(0, f2 == f5 && (f2 < 1.0E-4f || p_228801_2_.func_235785_r_((IBlockReader)p_228801_1_, p_228801_3_)));
                break;
            }
            case SOUTH: {
                p_228801_7_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_228801_7_.set(0, f2 == f5 && (f5 > 0.9999f || p_228801_2_.func_235785_r_((IBlockReader)p_228801_1_, p_228801_3_)));
                break;
            }
            case WEST: {
                p_228801_7_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_228801_7_.set(0, f == f3 && (f < 1.0E-4f || p_228801_2_.func_235785_r_((IBlockReader)p_228801_1_, p_228801_3_)));
                break;
            }
            case EAST: {
                p_228801_7_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_228801_7_.set(0, f == f3 && (f3 > 0.9999f || p_228801_2_.func_235785_r_((IBlockReader)p_228801_1_, p_228801_3_)));
            }
        }
    }

    private void func_228798_a_(IBlockDisplayReader p_228798_1_, BlockState p_228798_2_, BlockPos p_228798_3_, int p_228798_4_, int p_228798_5_, boolean p_228798_6_, MatrixStack p_228798_7_, IVertexBuilder p_228798_8_, List<BakedQuad> p_228798_9_, BitSet p_228798_10_) {
        for (BakedQuad bakedquad : p_228798_9_) {
            if (p_228798_6_) {
                this.func_228801_a_(p_228798_1_, p_228798_2_, p_228798_3_, bakedquad.func_178209_a(), bakedquad.func_178210_d(), null, p_228798_10_);
                BlockPos blockpos = p_228798_10_.get(0) ? p_228798_3_.func_177972_a(bakedquad.func_178210_d()) : p_228798_3_;
                p_228798_4_ = WorldRenderer.func_228420_a_(p_228798_1_, p_228798_2_, blockpos);
            }
            float f = p_228798_1_.func_230487_a_(bakedquad.func_178210_d(), bakedquad.func_239287_f_());
            this.func_228800_a_(p_228798_1_, p_228798_2_, p_228798_3_, p_228798_8_, p_228798_7_.func_227866_c_(), bakedquad, f, f, f, f, p_228798_4_, p_228798_4_, p_228798_4_, p_228798_4_, p_228798_5_);
        }
    }

    @Deprecated
    public void func_228804_a_(MatrixStack.Entry p_228804_1_, IVertexBuilder p_228804_2_, @Nullable BlockState p_228804_3_, IBakedModel p_228804_4_, float p_228804_5_, float p_228804_6_, float p_228804_7_, int p_228804_8_, int p_228804_9_) {
        this.renderModel(p_228804_1_, p_228804_2_, p_228804_3_, p_228804_4_, p_228804_5_, p_228804_6_, p_228804_7_, p_228804_8_, p_228804_9_, (IModelData)EmptyModelData.INSTANCE);
    }

    public void renderModel(MatrixStack.Entry p_228804_1_, IVertexBuilder p_228804_2_, @Nullable BlockState p_228804_3_, IBakedModel p_228804_4_, float p_228804_5_, float p_228804_6_, float p_228804_7_, int p_228804_8_, int p_228804_9_, IModelData modelData) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            BlockModelRenderer.func_228803_a_(p_228804_1_, p_228804_2_, p_228804_5_, p_228804_6_, p_228804_7_, p_228804_4_.getQuads(p_228804_3_, direction, random, modelData), p_228804_8_, p_228804_9_);
        }
        random.setSeed(42L);
        BlockModelRenderer.func_228803_a_(p_228804_1_, p_228804_2_, p_228804_5_, p_228804_6_, p_228804_7_, p_228804_4_.getQuads(p_228804_3_, null, random, modelData), p_228804_8_, p_228804_9_);
    }

    private static void func_228803_a_(MatrixStack.Entry p_228803_0_, IVertexBuilder p_228803_1_, float p_228803_2_, float p_228803_3_, float p_228803_4_, List<BakedQuad> p_228803_5_, int p_228803_6_, int p_228803_7_) {
        for (BakedQuad bakedquad : p_228803_5_) {
            float f2;
            float f1;
            float f;
            if (bakedquad.func_178212_b()) {
                f = MathHelper.func_76131_a((float)p_228803_2_, (float)0.0f, (float)1.0f);
                f1 = MathHelper.func_76131_a((float)p_228803_3_, (float)0.0f, (float)1.0f);
                f2 = MathHelper.func_76131_a((float)p_228803_4_, (float)0.0f, (float)1.0f);
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            p_228803_1_.func_227889_a_(p_228803_0_, bakedquad, f, f1, f2, p_228803_6_, p_228803_7_);
        }
    }

    public static void func_211847_a() {
        field_210267_b.get().func_222895_a();
    }

    public static void func_210266_a() {
        field_210267_b.get().func_222897_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int field_178191_g;
        private final int field_178200_h;
        private final int field_178201_i;
        private final int field_178198_j;
        private static final VertexTranslations[] field_178199_k;

        private VertexTranslations(int p_i46234_3_, int p_i46234_4_, int p_i46234_5_, int p_i46234_6_) {
            this.field_178191_g = p_i46234_3_;
            this.field_178200_h = p_i46234_4_;
            this.field_178201_i = p_i46234_5_;
            this.field_178198_j = p_i46234_6_;
        }

        public static VertexTranslations func_178184_a(Direction p_178184_0_) {
            return field_178199_k[p_178184_0_.func_176745_a()];
        }

        static {
            field_178199_k = Util.func_200696_a(new VertexTranslations[6], p_209261_0_ -> {
                p_209261_0_[Direction.DOWN.func_176745_a()] = DOWN;
                p_209261_0_[Direction.UP.func_176745_a()] = UP;
                p_209261_0_[Direction.NORTH.func_176745_a()] = NORTH;
                p_209261_0_[Direction.SOUTH.func_176745_a()] = SOUTH;
                p_209261_0_[Direction.WEST.func_176745_a()] = WEST;
                p_209261_0_[Direction.EAST.func_176745_a()] = EAST;
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Orientation {
        DOWN(Direction.DOWN, false),
        UP(Direction.UP, false),
        NORTH(Direction.NORTH, false),
        SOUTH(Direction.SOUTH, false),
        WEST(Direction.WEST, false),
        EAST(Direction.EAST, false),
        FLIP_DOWN(Direction.DOWN, true),
        FLIP_UP(Direction.UP, true),
        FLIP_NORTH(Direction.NORTH, true),
        FLIP_SOUTH(Direction.SOUTH, true),
        FLIP_WEST(Direction.WEST, true),
        FLIP_EAST(Direction.EAST, true);

        private final int field_178229_m;

        private Orientation(Direction p_i46233_3_, boolean p_i46233_4_) {
            this.field_178229_m = p_i46233_3_.func_176745_a() + (p_i46233_4_ ? Direction.values().length : 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum NeighborInfo {
        DOWN(new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        private final Direction[] field_178276_g;
        private final boolean field_178289_i;
        private final Orientation[] field_178286_j;
        private final Orientation[] field_178287_k;
        private final Orientation[] field_178284_l;
        private final Orientation[] field_178285_m;
        private static final NeighborInfo[] field_178282_n;

        private NeighborInfo(Direction[] p_i46236_3_, float p_i46236_4_, boolean p_i46236_5_, Orientation[] p_i46236_6_, Orientation[] p_i46236_7_, Orientation[] p_i46236_8_, Orientation[] p_i46236_9_) {
            this.field_178276_g = p_i46236_3_;
            this.field_178289_i = p_i46236_5_;
            this.field_178286_j = p_i46236_6_;
            this.field_178287_k = p_i46236_7_;
            this.field_178284_l = p_i46236_8_;
            this.field_178285_m = p_i46236_9_;
        }

        public static NeighborInfo func_178273_a(Direction p_178273_0_) {
            return field_178282_n[p_178273_0_.func_176745_a()];
        }

        static {
            field_178282_n = Util.func_200696_a(new NeighborInfo[6], p_209260_0_ -> {
                p_209260_0_[Direction.DOWN.func_176745_a()] = DOWN;
                p_209260_0_[Direction.UP.func_176745_a()] = UP;
                p_209260_0_[Direction.NORTH.func_176745_a()] = NORTH;
                p_209260_0_[Direction.SOUTH.func_176745_a()] = SOUTH;
                p_209260_0_[Direction.WEST.func_176745_a()] = WEST;
                p_209260_0_[Direction.EAST.func_176745_a()] = EAST;
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Cache {
        private boolean field_222898_a;
        private final Long2IntLinkedOpenHashMap field_222899_b = Util.func_199748_a(() -> {
            Long2IntLinkedOpenHashMap long2intlinkedopenhashmap = new Long2IntLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_rehash_1_) {
                }
            };
            long2intlinkedopenhashmap.defaultReturnValue(Integer.MAX_VALUE);
            return long2intlinkedopenhashmap;
        });
        private final Long2FloatLinkedOpenHashMap field_222900_c = Util.func_199748_a(() -> {
            Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_rehash_1_) {
                }
            };
            long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
            return long2floatlinkedopenhashmap;
        });

        private Cache() {
        }

        public void func_222895_a() {
            this.field_222898_a = true;
        }

        public void func_222897_b() {
            this.field_222898_a = false;
            this.field_222899_b.clear();
            this.field_222900_c.clear();
        }

        public int func_228810_a_(BlockState p_228810_1_, IBlockDisplayReader p_228810_2_, BlockPos p_228810_3_) {
            int j;
            long i = p_228810_3_.func_218275_a();
            if (this.field_222898_a && (j = this.field_222899_b.get(i)) != Integer.MAX_VALUE) {
                return j;
            }
            int k = WorldRenderer.func_228420_a_(p_228810_2_, p_228810_1_, p_228810_3_);
            if (this.field_222898_a) {
                if (this.field_222899_b.size() == 100) {
                    this.field_222899_b.removeFirstInt();
                }
                this.field_222899_b.put(i, k);
            }
            return k;
        }

        public float func_228811_b_(BlockState p_228811_1_, IBlockDisplayReader p_228811_2_, BlockPos p_228811_3_) {
            float f;
            long i = p_228811_3_.func_218275_a();
            if (this.field_222898_a && !Float.isNaN(f = this.field_222900_c.get(i))) {
                return f;
            }
            float f1 = p_228811_1_.func_215703_d((IBlockReader)p_228811_2_, p_228811_3_);
            if (this.field_222898_a) {
                if (this.field_222900_c.size() == 100) {
                    this.field_222900_c.removeFirstFloat();
                }
                this.field_222900_c.put(i, f1);
            }
            return f1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class AmbientOcclusionFace {
        private final float[] field_178206_b = new float[4];
        private final int[] field_178207_c = new int[4];

        public void func_239285_a_(IBlockDisplayReader p_239285_1_, BlockState p_239285_2_, BlockPos p_239285_3_, Direction p_239285_4_, float[] p_239285_5_, BitSet p_239285_6_, boolean p_239285_7_) {
            int l1;
            float f7;
            int k1;
            float f6;
            int j1;
            float f5;
            int i1;
            float f4;
            boolean flag3;
            BlockPos blockpos = p_239285_6_.get(0) ? p_239285_3_.func_177972_a(p_239285_4_) : p_239285_3_;
            NeighborInfo blockmodelrenderer$neighborinfo = NeighborInfo.func_178273_a(p_239285_4_);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            Cache blockmodelrenderer$cache = field_210267_b.get();
            blockpos$mutable.func_239622_a_(blockpos, blockmodelrenderer$neighborinfo.field_178276_g[0]);
            BlockState blockstate = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable);
            int i = blockmodelrenderer$cache.func_228810_a_(blockstate, p_239285_1_, blockpos$mutable);
            float f = blockmodelrenderer$cache.func_228811_b_(blockstate, p_239285_1_, blockpos$mutable);
            blockpos$mutable.func_239622_a_(blockpos, blockmodelrenderer$neighborinfo.field_178276_g[1]);
            BlockState blockstate1 = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable);
            int j = blockmodelrenderer$cache.func_228810_a_(blockstate1, p_239285_1_, blockpos$mutable);
            float f1 = blockmodelrenderer$cache.func_228811_b_(blockstate1, p_239285_1_, blockpos$mutable);
            blockpos$mutable.func_239622_a_(blockpos, blockmodelrenderer$neighborinfo.field_178276_g[2]);
            BlockState blockstate2 = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable);
            int k = blockmodelrenderer$cache.func_228810_a_(blockstate2, p_239285_1_, blockpos$mutable);
            float f2 = blockmodelrenderer$cache.func_228811_b_(blockstate2, p_239285_1_, blockpos$mutable);
            blockpos$mutable.func_239622_a_(blockpos, blockmodelrenderer$neighborinfo.field_178276_g[3]);
            BlockState blockstate3 = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable);
            int l = blockmodelrenderer$cache.func_228810_a_(blockstate3, p_239285_1_, blockpos$mutable);
            float f3 = blockmodelrenderer$cache.func_228811_b_(blockstate3, p_239285_1_, blockpos$mutable);
            blockpos$mutable.func_239622_a_(blockpos, blockmodelrenderer$neighborinfo.field_178276_g[0]).func_189536_c(p_239285_4_);
            boolean flag = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable).func_200016_a((IBlockReader)p_239285_1_, blockpos$mutable) == 0;
            blockpos$mutable.func_239622_a_(blockpos, blockmodelrenderer$neighborinfo.field_178276_g[1]).func_189536_c(p_239285_4_);
            boolean flag1 = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable).func_200016_a((IBlockReader)p_239285_1_, blockpos$mutable) == 0;
            blockpos$mutable.func_239622_a_(blockpos, blockmodelrenderer$neighborinfo.field_178276_g[2]).func_189536_c(p_239285_4_);
            boolean flag2 = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable).func_200016_a((IBlockReader)p_239285_1_, blockpos$mutable) == 0;
            blockpos$mutable.func_239622_a_(blockpos, blockmodelrenderer$neighborinfo.field_178276_g[3]).func_189536_c(p_239285_4_);
            boolean bl = flag3 = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable).func_200016_a((IBlockReader)p_239285_1_, blockpos$mutable) == 0;
            if (!flag2 && !flag) {
                f4 = f;
                i1 = i;
            } else {
                blockpos$mutable.func_239622_a_(blockpos, blockmodelrenderer$neighborinfo.field_178276_g[0]).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[2]);
                BlockState blockstate4 = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable);
                f4 = blockmodelrenderer$cache.func_228811_b_(blockstate4, p_239285_1_, blockpos$mutable);
                i1 = blockmodelrenderer$cache.func_228810_a_(blockstate4, p_239285_1_, blockpos$mutable);
            }
            if (!flag3 && !flag) {
                f5 = f;
                j1 = i;
            } else {
                blockpos$mutable.func_239622_a_(blockpos, blockmodelrenderer$neighborinfo.field_178276_g[0]).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[3]);
                BlockState blockstate6 = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable);
                f5 = blockmodelrenderer$cache.func_228811_b_(blockstate6, p_239285_1_, blockpos$mutable);
                j1 = blockmodelrenderer$cache.func_228810_a_(blockstate6, p_239285_1_, blockpos$mutable);
            }
            if (!flag2 && !flag1) {
                f6 = f;
                k1 = i;
            } else {
                blockpos$mutable.func_239622_a_(blockpos, blockmodelrenderer$neighborinfo.field_178276_g[1]).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[2]);
                BlockState blockstate7 = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable);
                f6 = blockmodelrenderer$cache.func_228811_b_(blockstate7, p_239285_1_, blockpos$mutable);
                k1 = blockmodelrenderer$cache.func_228810_a_(blockstate7, p_239285_1_, blockpos$mutable);
            }
            if (!flag3 && !flag1) {
                f7 = f;
                l1 = i;
            } else {
                blockpos$mutable.func_239622_a_(blockpos, blockmodelrenderer$neighborinfo.field_178276_g[1]).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[3]);
                BlockState blockstate8 = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable);
                f7 = blockmodelrenderer$cache.func_228811_b_(blockstate8, p_239285_1_, blockpos$mutable);
                l1 = blockmodelrenderer$cache.func_228810_a_(blockstate8, p_239285_1_, blockpos$mutable);
            }
            int i3 = blockmodelrenderer$cache.func_228810_a_(p_239285_2_, p_239285_1_, p_239285_3_);
            blockpos$mutable.func_239622_a_(p_239285_3_, p_239285_4_);
            BlockState blockstate5 = p_239285_1_.func_180495_p((BlockPos)blockpos$mutable);
            if (p_239285_6_.get(0) || !blockstate5.func_200015_d((IBlockReader)p_239285_1_, blockpos$mutable)) {
                i3 = blockmodelrenderer$cache.func_228810_a_(blockstate5, p_239285_1_, blockpos$mutable);
            }
            float f8 = p_239285_6_.get(0) ? blockmodelrenderer$cache.func_228811_b_(p_239285_1_.func_180495_p(blockpos), p_239285_1_, blockpos) : blockmodelrenderer$cache.func_228811_b_(p_239285_1_.func_180495_p(p_239285_3_), p_239285_1_, p_239285_3_);
            VertexTranslations blockmodelrenderer$vertextranslations = VertexTranslations.func_178184_a(p_239285_4_);
            if (p_239285_6_.get(1) && blockmodelrenderer$neighborinfo.field_178289_i) {
                float f29 = (f3 + f + f5 + f8) * 0.25f;
                float f31 = (f2 + f + f4 + f8) * 0.25f;
                float f32 = (f2 + f1 + f6 + f8) * 0.25f;
                float f33 = (f3 + f1 + f7 + f8) * 0.25f;
                float f13 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178286_j[0].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178286_j[1].field_178229_m];
                float f14 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178286_j[2].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178286_j[3].field_178229_m];
                float f15 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178286_j[4].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178286_j[5].field_178229_m];
                float f16 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178286_j[6].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178286_j[7].field_178229_m];
                float f17 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178287_k[0].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178287_k[1].field_178229_m];
                float f18 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178287_k[2].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178287_k[3].field_178229_m];
                float f19 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178287_k[4].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178287_k[5].field_178229_m];
                float f20 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178287_k[6].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178287_k[7].field_178229_m];
                float f21 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178284_l[0].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178284_l[1].field_178229_m];
                float f22 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178284_l[2].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178284_l[3].field_178229_m];
                float f23 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178284_l[4].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178284_l[5].field_178229_m];
                float f24 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178284_l[6].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178284_l[7].field_178229_m];
                float f25 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178285_m[0].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178285_m[1].field_178229_m];
                float f26 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178285_m[2].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178285_m[3].field_178229_m];
                float f27 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178285_m[4].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178285_m[5].field_178229_m];
                float f28 = p_239285_5_[blockmodelrenderer$neighborinfo.field_178285_m[6].field_178229_m] * p_239285_5_[blockmodelrenderer$neighborinfo.field_178285_m[7].field_178229_m];
                this.field_178206_b[blockmodelrenderer$vertextranslations.field_178191_g] = f29 * f13 + f31 * f14 + f32 * f15 + f33 * f16;
                this.field_178206_b[blockmodelrenderer$vertextranslations.field_178200_h] = f29 * f17 + f31 * f18 + f32 * f19 + f33 * f20;
                this.field_178206_b[blockmodelrenderer$vertextranslations.field_178201_i] = f29 * f21 + f31 * f22 + f32 * f23 + f33 * f24;
                this.field_178206_b[blockmodelrenderer$vertextranslations.field_178198_j] = f29 * f25 + f31 * f26 + f32 * f27 + f33 * f28;
                int i2 = this.func_147778_a(l, i, j1, i3);
                int j2 = this.func_147778_a(k, i, i1, i3);
                int k2 = this.func_147778_a(k, j, k1, i3);
                int l2 = this.func_147778_a(l, j, l1, i3);
                this.field_178207_c[blockmodelrenderer$vertextranslations.field_178191_g] = this.func_178203_a(i2, j2, k2, l2, f13, f14, f15, f16);
                this.field_178207_c[blockmodelrenderer$vertextranslations.field_178200_h] = this.func_178203_a(i2, j2, k2, l2, f17, f18, f19, f20);
                this.field_178207_c[blockmodelrenderer$vertextranslations.field_178201_i] = this.func_178203_a(i2, j2, k2, l2, f21, f22, f23, f24);
                this.field_178207_c[blockmodelrenderer$vertextranslations.field_178198_j] = this.func_178203_a(i2, j2, k2, l2, f25, f26, f27, f28);
            } else {
                float f9 = (f3 + f + f5 + f8) * 0.25f;
                float f10 = (f2 + f + f4 + f8) * 0.25f;
                float f11 = (f2 + f1 + f6 + f8) * 0.25f;
                float f12 = (f3 + f1 + f7 + f8) * 0.25f;
                this.field_178207_c[blockmodelrenderer$vertextranslations.field_178191_g] = this.func_147778_a(l, i, j1, i3);
                this.field_178207_c[blockmodelrenderer$vertextranslations.field_178200_h] = this.func_147778_a(k, i, i1, i3);
                this.field_178207_c[blockmodelrenderer$vertextranslations.field_178201_i] = this.func_147778_a(k, j, k1, i3);
                this.field_178207_c[blockmodelrenderer$vertextranslations.field_178198_j] = this.func_147778_a(l, j, l1, i3);
                this.field_178206_b[blockmodelrenderer$vertextranslations.field_178191_g] = f9;
                this.field_178206_b[blockmodelrenderer$vertextranslations.field_178200_h] = f10;
                this.field_178206_b[blockmodelrenderer$vertextranslations.field_178201_i] = f11;
                this.field_178206_b[blockmodelrenderer$vertextranslations.field_178198_j] = f12;
            }
            float f30 = p_239285_1_.func_230487_a_(p_239285_4_, p_239285_7_);
            int j3 = 0;
            while (j3 < this.field_178206_b.length) {
                int n = j3++;
                this.field_178206_b[n] = this.field_178206_b[n] * f30;
            }
        }

        private int func_147778_a(int p_147778_1_, int p_147778_2_, int p_147778_3_, int p_147778_4_) {
            if (p_147778_1_ == 0) {
                p_147778_1_ = p_147778_4_;
            }
            if (p_147778_2_ == 0) {
                p_147778_2_ = p_147778_4_;
            }
            if (p_147778_3_ == 0) {
                p_147778_3_ = p_147778_4_;
            }
            return p_147778_1_ + p_147778_2_ + p_147778_3_ + p_147778_4_ >> 2 & 0xFF00FF;
        }

        private int func_178203_a(int p_178203_1_, int p_178203_2_, int p_178203_3_, int p_178203_4_, float p_178203_5_, float p_178203_6_, float p_178203_7_, float p_178203_8_) {
            int i = (int)((float)(p_178203_1_ >> 16 & 0xFF) * p_178203_5_ + (float)(p_178203_2_ >> 16 & 0xFF) * p_178203_6_ + (float)(p_178203_3_ >> 16 & 0xFF) * p_178203_7_ + (float)(p_178203_4_ >> 16 & 0xFF) * p_178203_8_) & 0xFF;
            int j = (int)((float)(p_178203_1_ & 0xFF) * p_178203_5_ + (float)(p_178203_2_ & 0xFF) * p_178203_6_ + (float)(p_178203_3_ & 0xFF) * p_178203_7_ + (float)(p_178203_4_ & 0xFF) * p_178203_8_) & 0xFF;
            return i << 16 | j;
        }
    }
}

