/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.ForgeBlockModelRenderer;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

@OnlyIn(value=Dist.CLIENT)
public class BlockRendererDispatcher
implements IResourceManagerReloadListener {
    private final BlockModelShapes field_175028_a;
    private final BlockModelRenderer field_175027_c;
    private final FluidBlockRenderer field_175025_e;
    private final Random field_195476_e = new Random();
    private final BlockColors field_228790_e_;

    public BlockRendererDispatcher(BlockModelShapes p_i46577_1_, BlockColors p_i46577_2_) {
        this.field_175028_a = p_i46577_1_;
        this.field_228790_e_ = p_i46577_2_;
        this.field_175027_c = new ForgeBlockModelRenderer(this.field_228790_e_);
        this.field_175025_e = new FluidBlockRenderer();
    }

    public BlockModelShapes func_175023_a() {
        return this.field_175028_a;
    }

    @Deprecated
    public void func_228792_a_(BlockState p_228792_1_, BlockPos p_228792_2_, IBlockDisplayReader p_228792_3_, MatrixStack p_228792_4_, IVertexBuilder p_228792_5_) {
        this.renderBlockDamage(p_228792_1_, p_228792_2_, p_228792_3_, p_228792_4_, p_228792_5_, (IModelData)EmptyModelData.INSTANCE);
    }

    public void renderBlockDamage(BlockState blockStateIn, BlockPos posIn, IBlockDisplayReader lightReaderIn, MatrixStack matrixStackIn, IVertexBuilder vertexBuilderIn, IModelData modelData) {
        if (blockStateIn.func_185901_i() == BlockRenderType.MODEL) {
            IBakedModel ibakedmodel = this.field_175028_a.func_178125_b(blockStateIn);
            long i = blockStateIn.func_209533_a(posIn);
            this.field_175027_c.renderModel(lightReaderIn, ibakedmodel, blockStateIn, posIn, matrixStackIn, vertexBuilderIn, true, this.field_195476_e, i, OverlayTexture.field_229196_a_, modelData);
        }
    }

    @Deprecated
    public boolean func_228793_a_(BlockState p_228793_1_, BlockPos p_228793_2_, IBlockDisplayReader p_228793_3_, MatrixStack p_228793_4_, IVertexBuilder p_228793_5_, boolean p_228793_6_, Random p_228793_7_) {
        return this.renderModel(p_228793_1_, p_228793_2_, p_228793_3_, p_228793_4_, p_228793_5_, p_228793_6_, p_228793_7_, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModel(BlockState blockStateIn, BlockPos posIn, IBlockDisplayReader lightReaderIn, MatrixStack matrixStackIn, IVertexBuilder vertexBuilderIn, boolean checkSides, Random rand, IModelData modelData) {
        try {
            BlockRenderType blockrendertype = blockStateIn.func_185901_i();
            return blockrendertype != BlockRenderType.MODEL ? false : this.field_175027_c.renderModel(lightReaderIn, this.func_184389_a(blockStateIn), blockStateIn, posIn, matrixStackIn, vertexBuilderIn, checkSides, rand, blockStateIn.func_209533_a(posIn), OverlayTexture.field_229196_a_, modelData);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a(crashreportcategory, posIn, blockStateIn);
            throw new ReportedException(crashreport);
        }
    }

    public boolean func_228794_a_(BlockPos p_228794_1_, IBlockDisplayReader p_228794_2_, IVertexBuilder p_228794_3_, FluidState p_228794_4_) {
        try {
            return this.field_175025_e.func_228796_a_(p_228794_2_, p_228794_1_, p_228794_3_, p_228794_4_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Tesselating liquid in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a(crashreportcategory, p_228794_1_, null);
            throw new ReportedException(crashreport);
        }
    }

    public BlockModelRenderer func_175019_b() {
        return this.field_175027_c;
    }

    public IBakedModel func_184389_a(BlockState p_184389_1_) {
        return this.field_175028_a.func_178125_b(p_184389_1_);
    }

    @Deprecated
    public void func_228791_a_(BlockState p_228791_1_, MatrixStack p_228791_2_, IRenderTypeBuffer p_228791_3_, int p_228791_4_, int p_228791_5_) {
        this.renderBlock(p_228791_1_, p_228791_2_, p_228791_3_, p_228791_4_, p_228791_5_, (IModelData)EmptyModelData.INSTANCE);
    }

    public void renderBlock(BlockState p_228791_1_, MatrixStack p_228791_2_, IRenderTypeBuffer p_228791_3_, int p_228791_4_, int p_228791_5_, IModelData modelData) {
        BlockRenderType blockrendertype = p_228791_1_.func_185901_i();
        if (blockrendertype != BlockRenderType.INVISIBLE) {
            switch (blockrendertype) {
                case MODEL: {
                    IBakedModel ibakedmodel = this.func_184389_a(p_228791_1_);
                    int i = this.field_228790_e_.func_228054_a_(p_228791_1_, null, null, 0);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.field_175027_c.renderModel(p_228791_2_.func_227866_c_(), p_228791_3_.getBuffer(RenderTypeLookup.func_239220_a_(p_228791_1_, false)), p_228791_1_, ibakedmodel, f, f1, f2, p_228791_4_, p_228791_5_, modelData);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack(p_228791_1_.func_177230_c());
                    stack.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(stack, ItemCameraTransforms.TransformType.NONE, p_228791_2_, p_228791_3_, p_228791_4_, p_228791_5_);
                }
            }
        }
    }

    @Override
    public void func_195410_a(IResourceManager p_195410_1_) {
        this.field_175025_e.func_178268_a();
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }
}

