/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.chunk.SetVisibility;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.crash.CrashReport;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.IForgeRenderChunk;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ChunkRenderDispatcher {
    private static final Logger field_178523_a = LogManager.getLogger();
    private final PriorityQueue<ChunkRender.ChunkRenderTask> field_228885_b_ = Queues.newPriorityQueue();
    private final Queue<RegionRenderCacheBuilder> field_228886_c_;
    private final Queue<Runnable> field_228887_d_ = Queues.newConcurrentLinkedQueue();
    private volatile int field_228888_e_;
    private volatile int field_228889_f_;
    private final RegionRenderCacheBuilder field_228890_g_;
    private final DelegatedTaskExecutor<Runnable> field_228891_h_;
    private final Executor field_228892_i_;
    private World field_228893_j_;
    private final WorldRenderer field_228894_k_;
    private Vector3d field_217672_l = Vector3d.field_186680_a;

    public ChunkRenderDispatcher(World p_i226020_1_, WorldRenderer p_i226020_2_, Executor p_i226020_3_, boolean p_i226020_4_, RegionRenderCacheBuilder p_i226020_5_) {
        this(p_i226020_1_, p_i226020_2_, p_i226020_3_, p_i226020_4_, p_i226020_5_, -1);
    }

    public ChunkRenderDispatcher(World p_i226020_1_, WorldRenderer p_i226020_2_, Executor p_i226020_3_, boolean p_i226020_4_, RegionRenderCacheBuilder p_i226020_5_, int countRenderBuilders) {
        this.field_228893_j_ = p_i226020_1_;
        this.field_228894_k_ = p_i226020_2_;
        int i = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / (RenderType.func_228661_n_().stream().mapToInt(RenderType::func_228662_o_).sum() * 4) - 1);
        int j = Runtime.getRuntime().availableProcessors();
        int k = p_i226020_4_ ? j : Math.min(j, 4);
        int l = countRenderBuilders < 0 ? Math.max(1, Math.min(k, i)) : countRenderBuilders;
        this.field_228890_g_ = p_i226020_5_;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)l);
        try {
            for (int i1 = 0; i1 < l; ++i1) {
                list.add(new RegionRenderCacheBuilder());
            }
        }
        catch (OutOfMemoryError outofmemoryerror) {
            field_178523_a.warn("Allocated only {}/{} buffers", (Object)list.size(), (Object)l);
            int j1 = Math.min(list.size() * 2 / 3, list.size() - 1);
            for (int k1 = 0; k1 < j1; ++k1) {
                list.remove(list.size() - 1);
            }
            System.gc();
        }
        this.field_228886_c_ = Queues.newArrayDeque((Iterable)list);
        this.field_228889_f_ = this.field_228886_c_.size();
        this.field_228892_i_ = p_i226020_3_;
        this.field_228891_h_ = DelegatedTaskExecutor.func_213144_a(p_i226020_3_, "Chunk Renderer");
        this.field_228891_h_.func_212871_a_(this::func_228909_h_);
    }

    public void func_228895_a_(World p_228895_1_) {
        this.field_228893_j_ = p_228895_1_;
    }

    private void func_228909_h_() {
        ChunkRender.ChunkRenderTask chunkrenderdispatcher$chunkrender$chunkrendertask;
        if (!this.field_228886_c_.isEmpty() && (chunkrenderdispatcher$chunkrender$chunkrendertask = this.field_228885_b_.poll()) != null) {
            RegionRenderCacheBuilder regionrendercachebuilder = this.field_228886_c_.poll();
            this.field_228888_e_ = this.field_228885_b_.size();
            this.field_228889_f_ = this.field_228886_c_.size();
            ((CompletableFuture)CompletableFuture.runAsync(() -> {}, this.field_228892_i_).thenCompose(p_228901_2_ -> chunkrenderdispatcher$chunkrender$chunkrendertask.func_225618_a_(regionrendercachebuilder))).whenComplete((p_228898_2_, p_228898_3_) -> {
                if (p_228898_3_ != null) {
                    CrashReport crashreport = CrashReport.func_85055_a(p_228898_3_, "Batching chunks");
                    Minecraft.func_71410_x().func_71404_a(Minecraft.func_71410_x().func_71396_d(crashreport));
                } else {
                    this.field_228891_h_.func_212871_a_(() -> {
                        if (p_228898_2_ == ChunkTaskResult.SUCCESSFUL) {
                            regionrendercachebuilder.func_228365_a_();
                        } else {
                            regionrendercachebuilder.func_228367_b_();
                        }
                        this.field_228886_c_.add(regionrendercachebuilder);
                        this.field_228889_f_ = this.field_228886_c_.size();
                        this.func_228909_h_();
                    });
                }
            });
        }
    }

    public String func_178504_a() {
        return String.format("pC: %03d, pU: %02d, aB: %02d", this.field_228888_e_, this.field_228887_d_.size(), this.field_228889_f_);
    }

    public void func_217669_a(Vector3d p_217669_1_) {
        this.field_217672_l = p_217669_1_;
    }

    public Vector3d func_217671_b() {
        return this.field_217672_l;
    }

    public boolean func_228908_d_() {
        Runnable runnable;
        boolean flag = false;
        while ((runnable = this.field_228887_d_.poll()) != null) {
            runnable.run();
            flag = true;
        }
        return flag;
    }

    public void func_228902_a_(ChunkRender p_228902_1_) {
        p_228902_1_.func_228936_k_();
    }

    public void func_178514_b() {
        this.func_178513_e();
    }

    public void func_228900_a_(ChunkRender.ChunkRenderTask p_228900_1_) {
        this.field_228891_h_.func_212871_a_(() -> {
            this.field_228885_b_.offer(p_228900_1_);
            this.field_228888_e_ = this.field_228885_b_.size();
            this.func_228909_h_();
        });
    }

    public CompletableFuture<Void> func_228896_a_(BufferBuilder p_228896_1_, VertexBuffer p_228896_2_) {
        return CompletableFuture.runAsync(() -> {}, this.field_228887_d_::add).thenCompose(p_228897_3_ -> this.func_228904_b_(p_228896_1_, p_228896_2_));
    }

    private CompletableFuture<Void> func_228904_b_(BufferBuilder p_228904_1_, VertexBuffer p_228904_2_) {
        return p_228904_2_.func_227878_b_(p_228904_1_);
    }

    private void func_178513_e() {
        while (!this.field_228885_b_.isEmpty()) {
            ChunkRender.ChunkRenderTask chunkrenderdispatcher$chunkrender$chunkrendertask = this.field_228885_b_.poll();
            if (chunkrenderdispatcher$chunkrender$chunkrendertask == null) continue;
            chunkrenderdispatcher$chunkrender$chunkrendertask.func_225617_a_();
        }
        this.field_228888_e_ = 0;
    }

    public boolean func_188247_f() {
        return this.field_228888_e_ == 0 && this.field_228887_d_.isEmpty();
    }

    public void func_188244_g() {
        this.func_178513_e();
        this.field_228891_h_.close();
        this.field_228886_c_.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CompiledChunk {
        public static final CompiledChunk field_178502_a = new CompiledChunk(){

            @Override
            public boolean func_178495_a(Direction p_178495_1_, Direction p_178495_2_) {
                return false;
            }
        };
        private final Set<RenderType> field_178500_b = new ObjectArraySet();
        private final Set<RenderType> field_178501_c = new ObjectArraySet();
        private boolean field_178498_d = true;
        private final List<TileEntity> field_178499_e = Lists.newArrayList();
        private SetVisibility field_178496_f = new SetVisibility();
        @Nullable
        private BufferBuilder.State field_178497_g;

        public boolean func_178489_a() {
            return this.field_178498_d;
        }

        public boolean func_228912_a_(RenderType p_228912_1_) {
            return !this.field_178500_b.contains(p_228912_1_);
        }

        public List<TileEntity> func_178485_b() {
            return this.field_178499_e;
        }

        public boolean func_178495_a(Direction p_178495_1_, Direction p_178495_2_) {
            return this.field_178496_f.func_178621_a(p_178495_1_, p_178495_2_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum ChunkTaskResult {
        SUCCESSFUL,
        CANCELLED;

    }

    @OnlyIn(value=Dist.CLIENT)
    public class ChunkRender
    implements IForgeRenderChunk {
        public final AtomicReference<CompiledChunk> field_178590_b = new AtomicReference<CompiledChunk>(CompiledChunk.field_178502_a);
        @Nullable
        private RebuildTask field_228921_d_;
        @Nullable
        private SortTransparencyTask field_228922_e_;
        private final Set<TileEntity> field_181056_j = Sets.newHashSet();
        private final Map<RenderType, VertexBuffer> field_178594_l = RenderType.func_228661_n_().stream().collect(Collectors.toMap(p_228934_0_ -> p_228934_0_, p_228933_0_ -> new VertexBuffer(DefaultVertexFormats.field_176600_a)));
        public AxisAlignedBB field_178591_c;
        private int field_178595_m = -1;
        private boolean field_178593_n = true;
        private final BlockPos.Mutable field_178586_f = new BlockPos.Mutable(-1, -1, -1);
        private final BlockPos.Mutable[] field_181702_p = Util.func_200696_a(new BlockPos.Mutable[6], p_228932_0_ -> {
            for (int i = 0; i < ((BlockPos.Mutable[])p_228932_0_).length; ++i) {
                p_228932_0_[i] = new BlockPos.Mutable();
            }
        });
        private boolean field_188284_q;

        private boolean func_228930_a_(BlockPos p_228930_1_) {
            return ChunkRenderDispatcher.this.field_228893_j_.func_217353_a(p_228930_1_.func_177958_n() >> 4, p_228930_1_.func_177952_p() >> 4, ChunkStatus.field_222617_m, false) != null;
        }

        public boolean func_217674_b() {
            int i = 24;
            if (!(this.func_188280_f() > 576.0)) {
                return true;
            }
            return this.func_228930_a_(this.field_181702_p[Direction.WEST.ordinal()]) && this.func_228930_a_(this.field_181702_p[Direction.NORTH.ordinal()]) && this.func_228930_a_(this.field_181702_p[Direction.EAST.ordinal()]) && this.func_228930_a_(this.field_181702_p[Direction.SOUTH.ordinal()]);
        }

        public boolean func_178577_a(int p_178577_1_) {
            if (this.field_178595_m == p_178577_1_) {
                return false;
            }
            this.field_178595_m = p_178577_1_;
            return true;
        }

        public VertexBuffer func_228924_a_(RenderType p_228924_1_) {
            return this.field_178594_l.get(p_228924_1_);
        }

        public void func_189562_a(int p_189562_1_, int p_189562_2_, int p_189562_3_) {
            if (p_189562_1_ != this.field_178586_f.func_177958_n() || p_189562_2_ != this.field_178586_f.func_177956_o() || p_189562_3_ != this.field_178586_f.func_177952_p()) {
                this.func_178585_h();
                this.field_178586_f.func_181079_c(p_189562_1_, p_189562_2_, p_189562_3_);
                this.field_178591_c = new AxisAlignedBB((double)p_189562_1_, (double)p_189562_2_, (double)p_189562_3_, (double)(p_189562_1_ + 16), (double)(p_189562_2_ + 16), (double)(p_189562_3_ + 16));
                for (Direction direction : Direction.values()) {
                    this.field_181702_p[direction.ordinal()].func_189533_g(this.field_178586_f).func_189534_c(direction, 16);
                }
            }
        }

        protected double func_188280_f() {
            ActiveRenderInfo activerenderinfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
            double d0 = this.field_178591_c.field_72340_a + 8.0 - activerenderinfo.func_216785_c().field_72450_a;
            double d1 = this.field_178591_c.field_72338_b + 8.0 - activerenderinfo.func_216785_c().field_72448_b;
            double d2 = this.field_178591_c.field_72339_c + 8.0 - activerenderinfo.func_216785_c().field_72449_c;
            return d0 * d0 + d1 * d1 + d2 * d2;
        }

        private void func_228923_a_(BufferBuilder p_228923_1_) {
            p_228923_1_.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        }

        public CompiledChunk func_178571_g() {
            return this.field_178590_b.get();
        }

        private void func_178585_h() {
            this.func_228935_i_();
            this.field_178590_b.set(CompiledChunk.field_178502_a);
            this.field_178593_n = true;
        }

        public void func_178566_a() {
            this.func_178585_h();
            this.field_178594_l.values().forEach(VertexBuffer::close);
        }

        public BlockPos func_178568_j() {
            return this.field_178586_f;
        }

        public void func_178575_a(boolean p_178575_1_) {
            boolean flag = this.field_178593_n;
            this.field_178593_n = true;
            this.field_188284_q = p_178575_1_ | (flag && this.field_188284_q);
        }

        public void func_188282_m() {
            this.field_178593_n = false;
            this.field_188284_q = false;
        }

        public boolean func_178569_m() {
            return this.field_178593_n;
        }

        public boolean func_188281_o() {
            return this.field_178593_n && this.field_188284_q;
        }

        public BlockPos func_181701_a(Direction p_181701_1_) {
            return this.field_181702_p[p_181701_1_.ordinal()];
        }

        public boolean func_228925_a_(RenderType p_228925_1_, ChunkRenderDispatcher p_228925_2_) {
            CompiledChunk chunkrenderdispatcher$compiledchunk = this.func_178571_g();
            if (this.field_228922_e_ != null) {
                this.field_228922_e_.func_225617_a_();
            }
            if (!chunkrenderdispatcher$compiledchunk.field_178501_c.contains(p_228925_1_)) {
                return false;
            }
            this.field_228922_e_ = new SortTransparencyTask(new ChunkPos(this.func_178568_j()), this.func_188280_f(), chunkrenderdispatcher$compiledchunk);
            p_228925_2_.func_228900_a_(this.field_228922_e_);
            return true;
        }

        protected void func_228935_i_() {
            if (this.field_228921_d_ != null) {
                this.field_228921_d_.func_225617_a_();
                this.field_228921_d_ = null;
            }
            if (this.field_228922_e_ != null) {
                this.field_228922_e_.func_225617_a_();
                this.field_228922_e_ = null;
            }
        }

        public ChunkRenderTask func_178574_d() {
            this.func_228935_i_();
            BlockPos blockpos = this.field_178586_f.func_185334_h();
            boolean i = true;
            ChunkRenderCache chunkrendercache = this.createRegionRenderCache(ChunkRenderDispatcher.this.field_228893_j_, blockpos.func_177982_a(-1, -1, -1), blockpos.func_177982_a(16, 16, 16), 1);
            this.field_228921_d_ = new RebuildTask(new ChunkPos(this.func_178568_j()), this.func_188280_f(), chunkrendercache);
            return this.field_228921_d_;
        }

        public void func_228929_a_(ChunkRenderDispatcher p_228929_1_) {
            ChunkRenderTask chunkrenderdispatcher$chunkrender$chunkrendertask = this.func_178574_d();
            p_228929_1_.func_228900_a_(chunkrenderdispatcher$chunkrender$chunkrendertask);
        }

        private void func_228931_a_(Set<TileEntity> p_228931_1_) {
            HashSet set = Sets.newHashSet(p_228931_1_);
            HashSet set1 = Sets.newHashSet(this.field_181056_j);
            set.removeAll(this.field_181056_j);
            set1.removeAll(p_228931_1_);
            this.field_181056_j.clear();
            this.field_181056_j.addAll(p_228931_1_);
            ChunkRenderDispatcher.this.field_228894_k_.func_181023_a(set1, set);
        }

        public void func_228936_k_() {
            ChunkRenderTask chunkrenderdispatcher$chunkrender$chunkrendertask = this.func_178574_d();
            chunkrenderdispatcher$chunkrender$chunkrendertask.func_225618_a_(ChunkRenderDispatcher.this.field_228890_g_);
        }

        @OnlyIn(value=Dist.CLIENT)
        class SortTransparencyTask
        extends ChunkRenderTask {
            private final CompiledChunk field_228945_e_;

            @Deprecated
            public SortTransparencyTask(double p_i226025_2_, CompiledChunk p_i226025_4_) {
                this(null, p_i226025_2_, p_i226025_4_);
            }

            public SortTransparencyTask(ChunkPos pos, double p_i226025_2_, CompiledChunk p_i226025_4_) {
                super(pos, p_i226025_2_);
                this.field_228945_e_ = p_i226025_4_;
            }

            @Override
            public CompletableFuture<ChunkTaskResult> func_225618_a_(RegionRenderCacheBuilder p_225618_1_) {
                if (this.field_178554_h.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (!ChunkRender.this.func_217674_b()) {
                    this.field_178554_h.set(true);
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (this.field_178554_h.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                Vector3d vector3d = ChunkRenderDispatcher.this.func_217671_b();
                float f = (float)vector3d.field_72450_a;
                float f1 = (float)vector3d.field_72448_b;
                float f2 = (float)vector3d.field_72449_c;
                BufferBuilder.State bufferbuilder$state = this.field_228945_e_.field_178497_g;
                if (bufferbuilder$state != null && this.field_228945_e_.field_178500_b.contains(RenderType.func_228645_f_())) {
                    BufferBuilder bufferbuilder = p_225618_1_.func_228366_a_(RenderType.func_228645_f_());
                    ChunkRender.this.func_228923_a_(bufferbuilder);
                    bufferbuilder.func_178993_a(bufferbuilder$state);
                    bufferbuilder.func_181674_a(f - (float)ChunkRender.this.field_178586_f.func_177958_n(), f1 - (float)ChunkRender.this.field_178586_f.func_177956_o(), f2 - (float)ChunkRender.this.field_178586_f.func_177952_p());
                    this.field_228945_e_.field_178497_g = bufferbuilder.func_181672_a();
                    bufferbuilder.func_178977_d();
                    if (this.field_178554_h.get()) {
                        return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                    }
                    CompletionStage completablefuture = ChunkRenderDispatcher.this.func_228896_a_(p_225618_1_.func_228366_a_(RenderType.func_228645_f_()), ChunkRender.this.func_228924_a_(RenderType.func_228645_f_())).thenApply(p_228947_0_ -> ChunkTaskResult.CANCELLED);
                    return ((CompletableFuture)completablefuture).handle((p_228946_1_, p_228946_2_) -> {
                        if (p_228946_2_ != null && !(p_228946_2_ instanceof CancellationException) && !(p_228946_2_ instanceof InterruptedException)) {
                            Minecraft.func_71410_x().func_71404_a(CrashReport.func_85055_a(p_228946_2_, "Rendering chunk"));
                        }
                        return this.field_178554_h.get() ? ChunkTaskResult.CANCELLED : ChunkTaskResult.SUCCESSFUL;
                    });
                }
                return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
            }

            @Override
            public void func_225617_a_() {
                this.field_178554_h.set(true);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        class RebuildTask
        extends ChunkRenderTask {
            @Nullable
            protected ChunkRenderCache field_228938_d_;

            @Deprecated
            public RebuildTask(@Nullable double p_i226024_2_, ChunkRenderCache p_i226024_4_) {
                this(null, p_i226024_2_, p_i226024_4_);
            }

            public RebuildTask(ChunkPos pos, @Nullable double p_i226024_2_, ChunkRenderCache p_i226024_4_) {
                super(pos, p_i226024_2_);
                this.field_228938_d_ = p_i226024_4_;
            }

            @Override
            public CompletableFuture<ChunkTaskResult> func_225618_a_(RegionRenderCacheBuilder p_225618_1_) {
                if (this.field_178554_h.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (!ChunkRender.this.func_217674_b()) {
                    this.field_228938_d_ = null;
                    ChunkRender.this.func_178575_a(false);
                    this.field_178554_h.set(true);
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (this.field_178554_h.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                Vector3d vector3d = ChunkRenderDispatcher.this.func_217671_b();
                float f = (float)vector3d.field_72450_a;
                float f1 = (float)vector3d.field_72448_b;
                float f2 = (float)vector3d.field_72449_c;
                CompiledChunk chunkrenderdispatcher$compiledchunk = new CompiledChunk();
                Set<TileEntity> set = this.func_228940_a_(f, f1, f2, chunkrenderdispatcher$compiledchunk, p_225618_1_);
                ChunkRender.this.func_228931_a_(set);
                if (this.field_178554_h.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                ArrayList list = Lists.newArrayList();
                chunkrenderdispatcher$compiledchunk.field_178501_c.forEach(p_228943_3_ -> list.add(ChunkRenderDispatcher.this.func_228896_a_(p_225618_1_.func_228366_a_(p_228943_3_), ChunkRender.this.func_228924_a_((RenderType)p_228943_3_))));
                return Util.func_215079_b(list).handle((p_228941_2_, p_228941_3_) -> {
                    if (p_228941_3_ != null && !(p_228941_3_ instanceof CancellationException) && !(p_228941_3_ instanceof InterruptedException)) {
                        Minecraft.func_71410_x().func_71404_a(CrashReport.func_85055_a(p_228941_3_, "Rendering chunk"));
                    }
                    if (this.field_178554_h.get()) {
                        return ChunkTaskResult.CANCELLED;
                    }
                    ChunkRender.this.field_178590_b.set(chunkrenderdispatcher$compiledchunk);
                    return ChunkTaskResult.SUCCESSFUL;
                });
            }

            private Set<TileEntity> func_228940_a_(float p_228940_1_, float p_228940_2_, float p_228940_3_, CompiledChunk p_228940_4_, RegionRenderCacheBuilder p_228940_5_) {
                boolean i = true;
                BlockPos blockpos = ChunkRender.this.field_178586_f.func_185334_h();
                BlockPos blockpos1 = blockpos.func_177982_a(15, 15, 15);
                VisGraph visgraph = new VisGraph();
                HashSet set = Sets.newHashSet();
                ChunkRenderCache chunkrendercache = this.field_228938_d_;
                this.field_228938_d_ = null;
                MatrixStack matrixstack = new MatrixStack();
                if (chunkrendercache != null) {
                    BlockModelRenderer.func_211847_a();
                    Random random = new Random();
                    BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                    for (BlockPos blockpos2 : BlockPos.func_218278_a(blockpos, blockpos1)) {
                        TileEntity tileentity;
                        BlockState blockstate = chunkrendercache.func_180495_p(blockpos2);
                        Block block = blockstate.func_177230_c();
                        if (blockstate.func_200015_d((IBlockReader)chunkrendercache, blockpos2)) {
                            visgraph.func_178606_a(blockpos2);
                        }
                        if (blockstate.hasTileEntity() && (tileentity = chunkrendercache.func_212399_a(blockpos2, Chunk.CreateEntityType.CHECK)) != null) {
                            this.func_228942_a_(p_228940_4_, set, tileentity);
                        }
                        FluidState fluidstate = chunkrendercache.func_204610_c(blockpos2);
                        IModelData modelData = this.getModelData(blockpos2);
                        for (RenderType rendertype : RenderType.func_228661_n_()) {
                            ForgeHooksClient.setRenderLayer((RenderType)rendertype);
                            if (!fluidstate.func_206888_e() && RenderTypeLookup.canRenderInLayer(fluidstate, rendertype)) {
                                BufferBuilder bufferbuilder = p_228940_5_.func_228366_a_(rendertype);
                                if (p_228940_4_.field_178501_c.add(rendertype)) {
                                    ChunkRender.this.func_228923_a_(bufferbuilder);
                                }
                                if (blockrendererdispatcher.func_228794_a_(blockpos2, (IBlockDisplayReader)chunkrendercache, (IVertexBuilder)((Object)bufferbuilder), fluidstate)) {
                                    p_228940_4_.field_178498_d = false;
                                    p_228940_4_.field_178500_b.add(rendertype);
                                }
                            }
                            if (blockstate.func_185901_i() == BlockRenderType.INVISIBLE || !RenderTypeLookup.canRenderInLayer(blockstate, rendertype)) continue;
                            RenderType rendertype1 = rendertype;
                            BufferBuilder bufferbuilder2 = p_228940_5_.func_228366_a_(rendertype1);
                            if (p_228940_4_.field_178501_c.add(rendertype1)) {
                                ChunkRender.this.func_228923_a_(bufferbuilder2);
                            }
                            matrixstack.func_227860_a_();
                            matrixstack.func_227861_a_((double)(blockpos2.func_177958_n() & 0xF), (double)(blockpos2.func_177956_o() & 0xF), (double)(blockpos2.func_177952_p() & 0xF));
                            if (blockrendererdispatcher.renderModel(blockstate, blockpos2, (IBlockDisplayReader)chunkrendercache, matrixstack, (IVertexBuilder)((Object)bufferbuilder2), true, random, modelData)) {
                                p_228940_4_.field_178498_d = false;
                                p_228940_4_.field_178500_b.add(rendertype1);
                            }
                            matrixstack.func_227865_b_();
                        }
                    }
                    ForgeHooksClient.setRenderLayer(null);
                    if (p_228940_4_.field_178500_b.contains(RenderType.func_228645_f_())) {
                        BufferBuilder bufferbuilder1 = p_228940_5_.func_228366_a_(RenderType.func_228645_f_());
                        bufferbuilder1.func_181674_a(p_228940_1_ - (float)blockpos.func_177958_n(), p_228940_2_ - (float)blockpos.func_177956_o(), p_228940_3_ - (float)blockpos.func_177952_p());
                        p_228940_4_.field_178497_g = bufferbuilder1.func_181672_a();
                    }
                    p_228940_4_.field_178501_c.stream().map(arg_0 -> ((RegionRenderCacheBuilder)p_228940_5_).func_228366_a_(arg_0)).forEach(BufferBuilder::func_178977_d);
                    BlockModelRenderer.func_210266_a();
                }
                p_228940_4_.field_178496_f = visgraph.func_178607_a();
                return set;
            }

            private <E extends TileEntity> void func_228942_a_(CompiledChunk p_228942_1_, Set<TileEntity> p_228942_2_, E p_228942_3_) {
                TileEntityRenderer<E> tileentityrenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(p_228942_3_);
                if (tileentityrenderer != null) {
                    if (tileentityrenderer.func_188185_a(p_228942_3_)) {
                        p_228942_2_.add(p_228942_3_);
                    } else {
                        p_228942_1_.field_178499_e.add(p_228942_3_);
                    }
                }
            }

            @Override
            public void func_225617_a_() {
                this.field_228938_d_ = null;
                if (this.field_178554_h.compareAndSet(false, true)) {
                    ChunkRender.this.func_178575_a(false);
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        abstract class ChunkRenderTask
        implements Comparable<ChunkRenderTask> {
            protected final double field_188229_e;
            protected final AtomicBoolean field_178554_h = new AtomicBoolean(false);
            protected Map<BlockPos, IModelData> modelData;

            public ChunkRenderTask(double p_i226023_2_) {
                this(null, p_i226023_2_);
            }

            public ChunkRenderTask(ChunkPos pos, double p_i226023_2_) {
                this.field_188229_e = p_i226023_2_;
                this.modelData = pos == null ? Collections.emptyMap() : ModelDataManager.getModelData((World)Minecraft.func_71410_x().field_71441_e, (ChunkPos)pos);
            }

            public abstract CompletableFuture<ChunkTaskResult> func_225618_a_(RegionRenderCacheBuilder var1);

            public abstract void func_225617_a_();

            @Override
            public int compareTo(ChunkRenderTask p_compareTo_1_) {
                return Doubles.compare((double)this.field_188229_e, (double)p_compareTo_1_.field_188229_e);
            }

            public IModelData getModelData(BlockPos pos) {
                return this.modelData.getOrDefault((Object)pos, (IModelData)EmptyModelData.INSTANCE);
            }
        }
    }
}

