/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.SpriteMap;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.fluid.FluidState;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

@OnlyIn(value=Dist.CLIENT)
public class ModelManager
extends ReloadListener<ModelBakery>
implements AutoCloseable {
    private Map<ResourceLocation, IBakedModel> field_174958_a = new HashMap<ResourceLocation, IBakedModel>();
    @Nullable
    private SpriteMap field_229352_b_;
    private final BlockModelShapes field_174957_c;
    private final TextureManager field_229353_d_;
    private final BlockColors field_224743_d;
    private int field_229354_f_;
    private IBakedModel field_174955_d;
    private Object2IntMap<BlockState> field_224744_f;

    public ModelManager(TextureManager p_i226057_1_, BlockColors p_i226057_2_, int p_i226057_3_) {
        this.field_229353_d_ = p_i226057_1_;
        this.field_224743_d = p_i226057_2_;
        this.field_229354_f_ = p_i226057_3_;
        this.field_174957_c = new BlockModelShapes(this);
    }

    public IBakedModel getModel(ResourceLocation modelLocation) {
        return this.field_174958_a.getOrDefault(modelLocation, this.field_174955_d);
    }

    public IBakedModel func_174953_a(ModelResourceLocation p_174953_1_) {
        return this.field_174958_a.getOrDefault(p_174953_1_, this.field_174955_d);
    }

    public IBakedModel func_174951_a() {
        return this.field_174955_d;
    }

    public BlockModelShapes func_174954_c() {
        return this.field_174957_c;
    }

    protected ModelBakery func_212854_a_(IResourceManager p_212854_1_, IProfiler p_212854_2_) {
        p_212854_2_.func_219894_a();
        ModelLoader modelbakery = new ModelLoader(p_212854_1_, this.field_224743_d, p_212854_2_, this.field_229354_f_);
        p_212854_2_.func_219897_b();
        return modelbakery;
    }

    protected void func_212853_a_(ModelBakery p_212853_1_, IResourceManager p_212853_2_, IProfiler p_212853_3_) {
        p_212853_3_.func_219894_a();
        p_212853_3_.func_76320_a("upload");
        if (this.field_229352_b_ != null) {
            this.field_229352_b_.close();
        }
        this.field_229352_b_ = p_212853_1_.func_229333_a_(this.field_229353_d_, p_212853_3_);
        this.field_174958_a = p_212853_1_.func_217846_a();
        this.field_224744_f = p_212853_1_.func_225354_b();
        this.field_174955_d = this.field_174958_a.get(ModelBakery.field_177604_a);
        ForgeHooksClient.onModelBake((ModelManager)this, this.field_174958_a, (ModelLoader)((ModelLoader)p_212853_1_));
        p_212853_3_.func_219895_b("cache");
        this.field_174957_c.func_178124_c();
        p_212853_3_.func_76319_b();
        p_212853_3_.func_219897_b();
    }

    public boolean func_224742_a(BlockState p_224742_1_, BlockState p_224742_2_) {
        int j;
        if (p_224742_1_ == p_224742_2_) {
            return false;
        }
        int i = this.field_224744_f.getInt((Object)p_224742_1_);
        if (i != -1 && i == (j = this.field_224744_f.getInt((Object)p_224742_2_))) {
            FluidState fluidstate1;
            FluidState fluidstate = p_224742_1_.func_204520_s();
            return fluidstate != (fluidstate1 = p_224742_2_.func_204520_s());
        }
        return true;
    }

    public AtlasTexture func_229356_a_(ResourceLocation p_229356_1_) {
        if (this.field_229352_b_ == null) {
            throw new RuntimeException("getAtlasTexture called too early!");
        }
        return this.field_229352_b_.func_229152_a_(p_229356_1_);
    }

    @Override
    public void close() {
        if (this.field_229352_b_ != null) {
            this.field_229352_b_.close();
        }
    }

    public void func_229355_a_(int p_229355_1_) {
        this.field_229354_f_ = p_229355_1_;
    }

    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }
}

