/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.ResourceLocation;

public class FunctionObject {
    private final IEntry[] field_193530_b;
    private final ResourceLocation field_197002_b;
    public Timing timing;

    public Timing getTiming() {
        if (this.timing == null) {
            this.timing = MinecraftTimings.getCommandFunctionTiming((FunctionObject)this);
        }
        return this.timing;
    }

    public FunctionObject(ResourceLocation p_i47973_1_, IEntry[] p_i47973_2_) {
        this.field_197002_b = p_i47973_1_;
        this.field_193530_b = p_i47973_2_;
    }

    public final ResourceLocation getMinecraftKey() {
        return this.func_197001_a();
    }

    public ResourceLocation func_197001_a() {
        return this.field_197002_b;
    }

    public IEntry[] func_193528_a() {
        return this.field_193530_b;
    }

    public static FunctionObject func_237140_a_(ResourceLocation p_237140_0_, CommandDispatcher<CommandSource> p_237140_1_, CommandSource p_237140_2_, List<String> p_237140_3_) {
        ArrayList list = Lists.newArrayListWithCapacity((int)p_237140_3_.size());
        for (int i = 0; i < p_237140_3_.size(); ++i) {
            int j = i + 1;
            String s = p_237140_3_.get(i).trim();
            StringReader stringreader = new StringReader(s);
            if (!stringreader.canRead() || stringreader.peek() == '#') continue;
            if (stringreader.peek() == '/') {
                stringreader.skip();
                if (stringreader.peek() == '/') {
                    throw new IllegalArgumentException("Unknown or invalid command '" + s + "' on line " + j + " (if you intended to make a comment, use '#' not '//')");
                }
                String s1 = stringreader.readUnquotedString();
                throw new IllegalArgumentException("Unknown or invalid command '" + s + "' on line " + j + " (did you mean '" + s1 + "'? Do not use a preceding forwards slash.)");
            }
            try {
                ParseResults parseresults = p_237140_1_.parse(stringreader, (Object)p_237140_2_);
                if (parseresults.getReader().canRead()) {
                    throw Commands.func_227481_a_(parseresults);
                }
                list.add(new CommandEntry((ParseResults<CommandSource>)parseresults));
                continue;
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                throw new IllegalArgumentException("Whilst parsing command on line " + j + ": " + commandsyntaxexception.getMessage());
            }
        }
        return new FunctionObject(p_237140_0_, list.toArray(new IEntry[0]));
    }

    public static interface IEntry {
        public void func_196998_a(FunctionManager var1, CommandSource var2, ArrayDeque<FunctionManager.QueuedCommand> var3, int var4) throws CommandSyntaxException;
    }

    public static class FunctionEntry
    implements IEntry {
        private final CacheableFunction field_193524_a;

        public FunctionEntry(FunctionObject p_i47601_1_) {
            this.field_193524_a = new CacheableFunction(p_i47601_1_);
        }

        @Override
        public void func_196998_a(FunctionManager p_196998_1_, CommandSource p_196998_2_, ArrayDeque<FunctionManager.QueuedCommand> p_196998_3_, int p_196998_4_) {
            this.field_193524_a.func_218039_a(p_196998_1_).ifPresent(p_218041_4_ -> {
                IEntry[] afunctionobject$ientry = p_218041_4_.func_193528_a();
                int i = p_196998_4_ - p_196998_3_.size();
                int j = Math.min(afunctionobject$ientry.length, i);
                for (int k = j - 1; k >= 0; --k) {
                    p_196998_3_.addFirst(new FunctionManager.QueuedCommand(p_196998_1_, p_196998_2_, afunctionobject$ientry[k]));
                }
            });
        }

        public String toString() {
            return "function " + this.field_193524_a.func_200376_a();
        }
    }

    public static class CommandEntry
    implements IEntry {
        private final ParseResults<CommandSource> field_196999_a;

        public CommandEntry(ParseResults<CommandSource> p_i47816_1_) {
            this.field_196999_a = p_i47816_1_;
        }

        @Override
        public void func_196998_a(FunctionManager p_196998_1_, CommandSource p_196998_2_, ArrayDeque<FunctionManager.QueuedCommand> p_196998_3_, int p_196998_4_) throws CommandSyntaxException {
            p_196998_1_.func_195446_d().execute(new ParseResults(this.field_196999_a.getContext().withSource((Object)p_196998_2_), this.field_196999_a.getReader(), this.field_196999_a.getExceptions()));
        }

        public String toString() {
            return this.field_196999_a.getReader().getString();
        }
    }

    public static class CacheableFunction {
        public static final CacheableFunction field_193519_a = new CacheableFunction((ResourceLocation)null);
        @Nullable
        private final ResourceLocation field_193520_b;
        private boolean field_193521_c;
        private Optional<FunctionObject> field_193522_d = Optional.empty();

        public CacheableFunction(@Nullable ResourceLocation p_i47537_1_) {
            this.field_193520_b = p_i47537_1_;
        }

        public CacheableFunction(FunctionObject p_i47602_1_) {
            this.field_193521_c = true;
            this.field_193520_b = null;
            this.field_193522_d = Optional.of(p_i47602_1_);
        }

        public Optional<FunctionObject> func_218039_a(FunctionManager p_218039_1_) {
            if (!this.field_193521_c) {
                if (this.field_193520_b != null) {
                    this.field_193522_d = p_218039_1_.func_215361_a(this.field_193520_b);
                }
                this.field_193521_c = true;
            }
            return this.field_193522_d;
        }

        @Nullable
        public ResourceLocation func_200376_a() {
            return this.field_193522_d.map(p_218040_0_ -> p_218040_0_.field_197002_b).orElse(this.field_193520_b);
        }
    }
}

