/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.world.server.ServerWorld;

public class EntitySelector {
    private final int field_197354_a;
    private final boolean field_197355_b;
    private final boolean field_197356_c;
    private final Predicate<Entity> field_197357_d;
    private final MinMaxBounds.FloatBound field_197358_e;
    private final Function<Vector3d, Vector3d> field_197359_f;
    @Nullable
    private final AxisAlignedBB field_197360_g;
    private final BiConsumer<Vector3d, List<? extends Entity>> field_197361_h;
    private final boolean field_197362_i;
    @Nullable
    private final String field_197363_j;
    @Nullable
    private final UUID field_197364_k;
    @Nullable
    private final EntityType<?> field_201957_l;
    private final boolean field_210325_m;

    public EntitySelector(int p_i50800_1_, boolean p_i50800_2_, boolean p_i50800_3_, Predicate<Entity> p_i50800_4_, MinMaxBounds.FloatBound p_i50800_5_, Function<Vector3d, Vector3d> p_i50800_6_, @Nullable AxisAlignedBB p_i50800_7_, BiConsumer<Vector3d, List<? extends Entity>> p_i50800_8_, boolean p_i50800_9_, @Nullable String p_i50800_10_, @Nullable UUID p_i50800_11_, @Nullable EntityType<?> p_i50800_12_, boolean p_i50800_13_) {
        this.field_197354_a = p_i50800_1_;
        this.field_197355_b = p_i50800_2_;
        this.field_197356_c = p_i50800_3_;
        this.field_197357_d = p_i50800_4_;
        this.field_197358_e = p_i50800_5_;
        this.field_197359_f = p_i50800_6_;
        this.field_197360_g = p_i50800_7_;
        this.field_197361_h = p_i50800_8_;
        this.field_197362_i = p_i50800_9_;
        this.field_197363_j = p_i50800_10_;
        this.field_197364_k = p_i50800_11_;
        this.field_201957_l = p_i50800_12_;
        this.field_210325_m = p_i50800_13_;
    }

    public int func_197346_a() {
        return this.field_197354_a;
    }

    public boolean func_197351_b() {
        return this.field_197355_b;
    }

    public boolean func_197352_c() {
        return this.field_197362_i;
    }

    public boolean func_197353_d() {
        return this.field_197356_c;
    }

    private void func_210324_e(CommandSource p_210324_1_) throws CommandSyntaxException {
        if (this.field_210325_m && !p_210324_1_.hasPermission(2, "minecraft.command.selector")) {
            throw EntityArgument.field_210323_f.create();
        }
    }

    public Entity func_197340_a(CommandSource p_197340_1_) throws CommandSyntaxException {
        this.func_210324_e(p_197340_1_);
        List<? extends Entity> list = this.func_197341_b(p_197340_1_);
        if (list.isEmpty()) {
            throw EntityArgument.field_197101_d.create();
        }
        if (list.size() > 1) {
            throw EntityArgument.field_197098_a.create();
        }
        return list.get(0);
    }

    public List<? extends Entity> func_197341_b(CommandSource p_197341_1_) throws CommandSyntaxException {
        this.func_210324_e(p_197341_1_);
        if (!this.field_197355_b) {
            return this.func_197342_d(p_197341_1_);
        }
        if (this.field_197363_j != null) {
            ServerPlayerEntity serverplayerentity = p_197341_1_.func_197028_i().func_184103_al().func_152612_a(this.field_197363_j);
            return serverplayerentity == null ? Collections.emptyList() : Lists.newArrayList((Object[])new ServerPlayerEntity[]{serverplayerentity});
        }
        if (this.field_197364_k != null) {
            for (ServerWorld serverworld1 : p_197341_1_.func_197028_i().func_212370_w()) {
                Entity entity = serverworld1.func_217461_a(this.field_197364_k);
                if (entity == null) continue;
                return Lists.newArrayList((Object[])new Entity[]{entity});
            }
            return Collections.emptyList();
        }
        Vector3d vector3d = this.field_197359_f.apply(p_197341_1_.func_197036_d());
        Predicate<Entity> predicate = this.func_197349_a(vector3d);
        if (this.field_197362_i) {
            return p_197341_1_.func_197022_f() != null && predicate.test(p_197341_1_.func_197022_f()) ? Lists.newArrayList((Object[])new Entity[]{p_197341_1_.func_197022_f()}) : Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        if (this.func_197353_d()) {
            this.func_197348_a(list, p_197341_1_.func_197023_e(), vector3d, predicate);
        } else {
            for (ServerWorld serverworld : p_197341_1_.func_197028_i().func_212370_w()) {
                this.func_197348_a(list, serverworld, vector3d, predicate);
            }
        }
        return this.func_197345_a(vector3d, list);
    }

    private void func_197348_a(List<Entity> p_197348_1_, ServerWorld p_197348_2_, Vector3d p_197348_3_, Predicate<Entity> p_197348_4_) {
        if (this.field_197360_g != null) {
            p_197348_1_.addAll(p_197348_2_.func_217394_a(this.field_201957_l, this.field_197360_g.func_191194_a(p_197348_3_), p_197348_4_));
        } else {
            p_197348_1_.addAll(p_197348_2_.func_217482_a(this.field_201957_l, p_197348_4_));
        }
    }

    public ServerPlayerEntity func_197347_c(CommandSource p_197347_1_) throws CommandSyntaxException {
        this.func_210324_e(p_197347_1_);
        List<ServerPlayerEntity> list = this.func_197342_d(p_197347_1_);
        if (list.size() != 1) {
            throw EntityArgument.field_197102_e.create();
        }
        return list.get(0);
    }

    public List<ServerPlayerEntity> func_197342_d(CommandSource p_197342_1_) throws CommandSyntaxException {
        List<Object> list;
        this.func_210324_e(p_197342_1_);
        if (this.field_197363_j != null) {
            ServerPlayerEntity serverplayerentity2 = p_197342_1_.func_197028_i().func_184103_al().func_152612_a(this.field_197363_j);
            return serverplayerentity2 == null ? Collections.emptyList() : Lists.newArrayList((Object[])new ServerPlayerEntity[]{serverplayerentity2});
        }
        if (this.field_197364_k != null) {
            ServerPlayerEntity serverplayerentity1 = p_197342_1_.func_197028_i().func_184103_al().func_177451_a(this.field_197364_k);
            return serverplayerentity1 == null ? Collections.emptyList() : Lists.newArrayList((Object[])new ServerPlayerEntity[]{serverplayerentity1});
        }
        Vector3d vector3d = this.field_197359_f.apply(p_197342_1_.func_197036_d());
        Predicate<Entity> predicate = this.func_197349_a(vector3d);
        if (this.field_197362_i) {
            ServerPlayerEntity serverplayerentity3;
            if (p_197342_1_.func_197022_f() instanceof ServerPlayerEntity && predicate.test(serverplayerentity3 = (ServerPlayerEntity)p_197342_1_.func_197022_f())) {
                return Lists.newArrayList((Object[])new ServerPlayerEntity[]{serverplayerentity3});
            }
            return Collections.emptyList();
        }
        if (this.func_197353_d()) {
            list = p_197342_1_.func_197023_e().func_217490_a(predicate::test);
        } else {
            list = Lists.newArrayList();
            for (ServerPlayerEntity serverplayerentity : p_197342_1_.func_197028_i().func_184103_al().func_181057_v()) {
                if (!predicate.test(serverplayerentity)) continue;
                list.add(serverplayerentity);
            }
        }
        return this.func_197345_a(vector3d, list);
    }

    private Predicate<Entity> func_197349_a(Vector3d p_197349_1_) {
        Predicate<Entity> predicate = this.field_197357_d;
        if (this.field_197360_g != null) {
            AxisAlignedBB axisalignedbb = this.field_197360_g.func_191194_a(p_197349_1_);
            predicate = predicate.and(p_197344_1_ -> axisalignedbb.func_72326_a(p_197344_1_.func_174813_aQ()));
        }
        if (!this.field_197358_e.func_211335_c()) {
            predicate = predicate.and(p_211376_2_ -> this.field_197358_e.func_211351_a(p_211376_2_.func_195048_a(p_197349_1_)));
        }
        return predicate;
    }

    private <T extends Entity> List<T> func_197345_a(Vector3d p_197345_1_, List<T> p_197345_2_) {
        if (p_197345_2_.size() > 1) {
            this.field_197361_h.accept(p_197345_1_, p_197345_2_);
        }
        return p_197345_2_.subList(0, Math.min(this.field_197354_a, p_197345_2_.size()));
    }

    public static IFormattableTextComponent func_197350_a(List<? extends Entity> p_197350_0_) {
        return TextComponentUtils.func_240649_b_(p_197350_0_, Entity::func_145748_c_);
    }
}

