/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.ImmutableMap;
import com.mohistmc.util.i18n.i18n;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugCommand {
    private static final Logger field_225390_a = LogManager.getLogger();
    private static final SimpleCommandExceptionType field_198338_b = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.debug.notRunning"));
    private static final SimpleCommandExceptionType field_198339_c = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.debug.alreadyRunning"));
    @Nullable
    private static final FileSystemProvider field_225391_d = FileSystemProvider.installedProviders().stream().filter(p_225386_0_ -> p_225386_0_.getScheme().equalsIgnoreCase("jar")).findFirst().orElse(null);

    public static void func_198330_a(CommandDispatcher<CommandSource> p_198330_0_) {
        p_198330_0_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("debug").requires(p_198332_0_ -> p_198332_0_.func_197034_c(3))).then(Commands.func_197057_a("start").executes(p_198329_0_ -> DebugCommand.func_198335_a((CommandSource)p_198329_0_.getSource())))).then(Commands.func_197057_a("stop").executes(p_198333_0_ -> DebugCommand.func_198336_b((CommandSource)p_198333_0_.getSource())))).then(Commands.func_197057_a("report").executes(p_225388_0_ -> DebugCommand.func_225389_c((CommandSource)p_225388_0_.getSource()))));
    }

    private static int func_198335_a(CommandSource p_198335_0_) throws CommandSyntaxException {
        MinecraftServer minecraftserver = p_198335_0_.func_197028_i();
        if (minecraftserver.func_240789_aP_()) {
            throw field_198339_c.create();
        }
        minecraftserver.func_240790_aQ_();
        p_198335_0_.func_197030_a((ITextComponent)((Object)new TranslationTextComponent("commands.debug.started", "Started the debug profiler. Type '/debug stop' to stop it.")), true);
        return 0;
    }

    private static int func_198336_b(CommandSource p_198336_0_) throws CommandSyntaxException {
        MinecraftServer minecraftserver = p_198336_0_.func_197028_i();
        if (!minecraftserver.func_240789_aP_()) {
            throw field_198338_b.create();
        }
        IProfileResult iprofileresult = minecraftserver.func_240791_aR_();
        File file1 = new File(minecraftserver.func_71209_f("debug"), "profile-results-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".txt");
        iprofileresult.func_219919_a(file1);
        float f = (float)iprofileresult.func_219924_f() / 1.0E9f;
        float f1 = (float)iprofileresult.func_219925_g() / f;
        p_198336_0_.func_197030_a((ITextComponent)((Object)new TranslationTextComponent("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", Float.valueOf(f)), iprofileresult.func_219925_g(), String.format("%.2f", Float.valueOf(f1)))), true);
        return MathHelper.func_76141_d((float)f1);
    }

    private static int func_225389_c(CommandSource p_225389_0_) {
        MinecraftServer minecraftserver = p_225389_0_.func_197028_i();
        String s = "debug-report-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        try {
            Path path1 = minecraftserver.func_71209_f("debug").toPath();
            Files.createDirectories(path1, new FileAttribute[0]);
            if (!SharedConstants.field_206244_b && field_225391_d != null) {
                Path path2 = path1.resolve(s + ".zip");
                try (FileSystem filesystem = field_225391_d.newFileSystem(path2, (Map<String, ?>)ImmutableMap.of((Object)"create", (Object)"true"));){
                    minecraftserver.func_223711_a(filesystem.getPath("/", new String[0]));
                }
            } else {
                Path path = path1.resolve(s);
                minecraftserver.func_223711_a(path);
            }
            p_225389_0_.func_197030_a((ITextComponent)((Object)new TranslationTextComponent("commands.debug.reportSaved", s)), false);
            return 1;
        }
        catch (IOException ioexception) {
            field_225390_a.error(i18n.get((String)"debugcommand.1", (Object[])new Object[]{ioexception}));
            p_225389_0_.func_197021_a((ITextComponent)((Object)new TranslationTextComponent("commands.debug.reportFailed")));
            return 0;
        }
    }
}

