/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic4CommandExceptionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.Vec2Argument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;

public class SpreadPlayersCommand {
    private static final Dynamic4CommandExceptionType field_198723_a = new Dynamic4CommandExceptionType((p_208910_0_, p_208910_1_, p_208910_2_, p_208910_3_) -> new TranslationTextComponent("commands.spreadplayers.failed.teams", p_208910_0_, p_208910_1_, p_208910_2_, p_208910_3_));
    private static final Dynamic4CommandExceptionType field_198724_b = new Dynamic4CommandExceptionType((p_208912_0_, p_208912_1_, p_208912_2_, p_208912_3_) -> new TranslationTextComponent("commands.spreadplayers.failed.entities", p_208912_0_, p_208912_1_, p_208912_2_, p_208912_3_));

    public static void func_198716_a(CommandDispatcher<CommandSource> p_198716_0_) {
        p_198716_0_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("spreadplayers").requires(p_198721_0_ -> p_198721_0_.func_197034_c(2))).then(Commands.func_197056_a("center", Vec2Argument.func_197296_a()).then(Commands.func_197056_a("spreadDistance", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)Commands.func_197056_a("maxRange", FloatArgumentType.floatArg((float)1.0f)).then(Commands.func_197056_a("respectTeams", BoolArgumentType.bool()).then(Commands.func_197056_a("targets", EntityArgument.func_197093_b()).executes(p_198718_0_ -> SpreadPlayersCommand.func_241070_a_((CommandSource)p_198718_0_.getSource(), Vec2Argument.func_197295_a((CommandContext)p_198718_0_, (String)"center"), FloatArgumentType.getFloat((CommandContext)p_198718_0_, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)p_198718_0_, (String)"maxRange"), 256, BoolArgumentType.getBool((CommandContext)p_198718_0_, (String)"respectTeams"), EntityArgument.func_197097_b((CommandContext<CommandSource>)p_198718_0_, "targets")))))).then(Commands.func_197057_a("under").then(Commands.func_197056_a("maxHeight", IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a("respectTeams", BoolArgumentType.bool()).then(Commands.func_197056_a("targets", EntityArgument.func_197093_b()).executes(p_241069_0_ -> SpreadPlayersCommand.func_241070_a_((CommandSource)p_241069_0_.getSource(), Vec2Argument.func_197295_a((CommandContext)p_241069_0_, (String)"center"), FloatArgumentType.getFloat((CommandContext)p_241069_0_, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)p_241069_0_, (String)"maxRange"), IntegerArgumentType.getInteger((CommandContext)p_241069_0_, (String)"maxHeight"), BoolArgumentType.getBool((CommandContext)p_241069_0_, (String)"respectTeams"), EntityArgument.func_197097_b((CommandContext<CommandSource>)p_241069_0_, "targets")))))))))));
    }

    private static int func_241070_a_(CommandSource p_241070_0_, Vector2f p_241070_1_, float p_241070_2_, float p_241070_3_, int p_241070_4_, boolean p_241070_5_, Collection<? extends Entity> p_241070_6_) throws CommandSyntaxException {
        Random random = new Random();
        double d0 = p_241070_1_.field_189982_i - p_241070_3_;
        double d1 = p_241070_1_.field_189983_j - p_241070_3_;
        double d2 = p_241070_1_.field_189982_i + p_241070_3_;
        double d3 = p_241070_1_.field_189983_j + p_241070_3_;
        Position[] aspreadplayerscommand$position = SpreadPlayersCommand.func_198720_a(random, p_241070_5_ ? SpreadPlayersCommand.func_198715_a(p_241070_6_) : p_241070_6_.size(), d0, d1, d2, d3);
        SpreadPlayersCommand.func_241071_a_(p_241070_1_, p_241070_2_, p_241070_0_.func_197023_e(), random, d0, d1, d2, d3, p_241070_4_, aspreadplayerscommand$position, p_241070_5_);
        double d4 = SpreadPlayersCommand.func_241072_a_(p_241070_6_, p_241070_0_.func_197023_e(), aspreadplayerscommand$position, p_241070_4_, p_241070_5_);
        p_241070_0_.func_197030_a((ITextComponent)((Object)new TranslationTextComponent("commands.spreadplayers.success." + (p_241070_5_ ? "teams" : "entities"), aspreadplayerscommand$position.length, Float.valueOf(p_241070_1_.field_189982_i), Float.valueOf(p_241070_1_.field_189983_j), String.format(Locale.ROOT, "%.2f", d4))), true);
        return aspreadplayerscommand$position.length;
    }

    private static int func_198715_a(Collection<? extends Entity> p_198715_0_) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : p_198715_0_) {
            if (entity instanceof PlayerEntity) {
                set.add(entity.func_96124_cp());
                continue;
            }
            set.add(null);
        }
        return set.size();
    }

    private static void func_241071_a_(Vector2f p_241071_0_, double p_241071_1_, ServerWorld p_241071_3_, Random p_241071_4_, double p_241071_5_, double p_241071_7_, double p_241071_9_, double p_241071_11_, int p_241071_13_, Position[] p_241071_14_, boolean p_241071_15_) throws CommandSyntaxException {
        int i;
        boolean flag = true;
        double d0 = 3.4028234663852886E38;
        for (i = 0; i < 10000 && flag; ++i) {
            flag = false;
            d0 = 3.4028234663852886E38;
            for (int j = 0; j < p_241071_14_.length; ++j) {
                Position spreadplayerscommand$position = p_241071_14_[j];
                int k = 0;
                Position spreadplayerscommand$position1 = new Position();
                for (int l = 0; l < p_241071_14_.length; ++l) {
                    if (j == l) continue;
                    Position spreadplayerscommand$position2 = p_241071_14_[l];
                    double d1 = spreadplayerscommand$position.func_198708_a(spreadplayerscommand$position2);
                    d0 = Math.min(d1, d0);
                    if (!(d1 < p_241071_1_)) continue;
                    ++k;
                    spreadplayerscommand$position1.field_198713_a += spreadplayerscommand$position2.field_198713_a - spreadplayerscommand$position.field_198713_a;
                    spreadplayerscommand$position1.field_198714_b += spreadplayerscommand$position2.field_198714_b - spreadplayerscommand$position.field_198714_b;
                }
                if (k > 0) {
                    spreadplayerscommand$position1.field_198713_a /= (double)k;
                    spreadplayerscommand$position1.field_198714_b /= (double)k;
                    double d2 = spreadplayerscommand$position1.func_198712_b();
                    if (d2 > 0.0) {
                        spreadplayerscommand$position1.func_198707_a();
                        spreadplayerscommand$position.func_198705_b(spreadplayerscommand$position1);
                    } else {
                        spreadplayerscommand$position.func_198711_a(p_241071_4_, p_241071_5_, p_241071_7_, p_241071_9_, p_241071_11_);
                    }
                    flag = true;
                }
                if (!spreadplayerscommand$position.func_198709_a(p_241071_5_, p_241071_7_, p_241071_9_, p_241071_11_)) continue;
                flag = true;
            }
            if (flag) continue;
            for (Position spreadplayerscommand$position3 : p_241071_14_) {
                if (spreadplayerscommand$position3.func_241074_b_((IBlockReader)((Object)p_241071_3_), p_241071_13_)) continue;
                spreadplayerscommand$position3.func_198711_a(p_241071_4_, p_241071_5_, p_241071_7_, p_241071_9_, p_241071_11_);
                flag = true;
            }
        }
        if (d0 == 3.4028234663852886E38) {
            d0 = 0.0;
        }
        if (i >= 10000) {
            if (p_241071_15_) {
                throw field_198723_a.create((Object)p_241071_14_.length, (Object)Float.valueOf(p_241071_0_.field_189982_i), (Object)Float.valueOf(p_241071_0_.field_189983_j), (Object)String.format(Locale.ROOT, "%.2f", d0));
            }
            throw field_198724_b.create((Object)p_241071_14_.length, (Object)Float.valueOf(p_241071_0_.field_189982_i), (Object)Float.valueOf(p_241071_0_.field_189983_j), (Object)String.format(Locale.ROOT, "%.2f", d0));
        }
    }

    private static double func_241072_a_(Collection<? extends Entity> p_241072_0_, ServerWorld p_241072_1_, Position[] p_241072_2_, int p_241072_3_, boolean p_241072_4_) {
        double d0 = 0.0;
        int i = 0;
        HashMap map = Maps.newHashMap();
        for (Entity entity : p_241072_0_) {
            Position spreadplayerscommand$position;
            if (p_241072_4_) {
                Team team;
                Team team2 = team = entity instanceof PlayerEntity ? entity.func_96124_cp() : null;
                if (!map.containsKey(team)) {
                    map.put(team, p_241072_2_[i++]);
                }
                spreadplayerscommand$position = (Position)map.get(team);
            } else {
                spreadplayerscommand$position = p_241072_2_[i++];
            }
            EntityTeleportEvent.SpreadPlayersCommand event = ForgeEventFactory.onEntityTeleportSpreadPlayersCommand((Entity)entity, (double)((double)MathHelper.func_76128_c((double)spreadplayerscommand$position.field_198713_a) + 0.5), (double)spreadplayerscommand$position.func_198710_a((IBlockReader)((Object)p_241072_1_), p_241072_3_), (double)((double)MathHelper.func_76128_c((double)spreadplayerscommand$position.field_198714_b) + 0.5));
            if (!event.isCanceled()) {
                entity.func_223102_j(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            }
            double d2 = Double.MAX_VALUE;
            for (Position spreadplayerscommand$position1 : p_241072_2_) {
                if (spreadplayerscommand$position == spreadplayerscommand$position1) continue;
                double d1 = spreadplayerscommand$position.func_198708_a(spreadplayerscommand$position1);
                d2 = Math.min(d1, d2);
            }
            d0 += d2;
        }
        return p_241072_0_.size() < 2 ? 0.0 : d0 / (double)p_241072_0_.size();
    }

    private static Position[] func_198720_a(Random p_198720_0_, int p_198720_1_, double p_198720_2_, double p_198720_4_, double p_198720_6_, double p_198720_8_) {
        Position[] aspreadplayerscommand$position = new Position[p_198720_1_];
        for (int i = 0; i < aspreadplayerscommand$position.length; ++i) {
            Position spreadplayerscommand$position = new Position();
            spreadplayerscommand$position.func_198711_a(p_198720_0_, p_198720_2_, p_198720_4_, p_198720_6_, p_198720_8_);
            aspreadplayerscommand$position[i] = spreadplayerscommand$position;
        }
        return aspreadplayerscommand$position;
    }

    static class Position {
        private double field_198713_a;
        private double field_198714_b;

        Position() {
        }

        double func_198708_a(Position p_198708_1_) {
            double d0 = this.field_198713_a - p_198708_1_.field_198713_a;
            double d1 = this.field_198714_b - p_198708_1_.field_198714_b;
            return Math.sqrt(d0 * d0 + d1 * d1);
        }

        void func_198707_a() {
            double d0 = this.func_198712_b();
            this.field_198713_a /= d0;
            this.field_198714_b /= d0;
        }

        float func_198712_b() {
            return MathHelper.func_76133_a((double)(this.field_198713_a * this.field_198713_a + this.field_198714_b * this.field_198714_b));
        }

        public void func_198705_b(Position p_198705_1_) {
            this.field_198713_a -= p_198705_1_.field_198713_a;
            this.field_198714_b -= p_198705_1_.field_198714_b;
        }

        public boolean func_198709_a(double p_198709_1_, double p_198709_3_, double p_198709_5_, double p_198709_7_) {
            boolean flag = false;
            if (this.field_198713_a < p_198709_1_) {
                this.field_198713_a = p_198709_1_;
                flag = true;
            } else if (this.field_198713_a > p_198709_5_) {
                this.field_198713_a = p_198709_5_;
                flag = true;
            }
            if (this.field_198714_b < p_198709_3_) {
                this.field_198714_b = p_198709_3_;
                flag = true;
            } else if (this.field_198714_b > p_198709_7_) {
                this.field_198714_b = p_198709_7_;
                flag = true;
            }
            return flag;
        }

        public int func_198710_a(IBlockReader p_198710_1_, int p_198710_2_) {
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(this.field_198713_a, (double)(p_198710_2_ + 1), this.field_198714_b);
            boolean flag = Position.getType(p_198710_1_, blockpos$mutable).func_196958_f();
            blockpos$mutable.func_189536_c(Direction.DOWN);
            boolean flag1 = p_198710_1_.func_180495_p(blockpos$mutable).func_196958_f();
            while (blockpos$mutable.func_177956_o() > 0) {
                blockpos$mutable.func_189536_c(Direction.DOWN);
                boolean flag2 = p_198710_1_.func_180495_p(blockpos$mutable).func_196958_f();
                if (!flag2 && flag1 && flag) {
                    return blockpos$mutable.func_177956_o() + 1;
                }
                flag = flag1;
                flag1 = flag2;
            }
            return p_198710_2_ + 1;
        }

        public boolean func_241074_b_(IBlockReader p_241074_1_, int p_241074_2_) {
            BlockPos blockpos = new BlockPos(this.field_198713_a, (double)(this.func_198710_a(p_241074_1_, p_241074_2_) - 1), this.field_198714_b);
            BlockState blockstate = Position.getType(p_241074_1_, blockpos);
            Material material = blockstate.func_185904_a();
            return blockpos.func_177956_o() < p_241074_2_ && !material.func_76224_d() && material != Material.field_151581_o;
        }

        public void func_198711_a(Random p_198711_1_, double p_198711_2_, double p_198711_4_, double p_198711_6_, double p_198711_8_) {
            this.field_198713_a = MathHelper.func_82716_a((Random)p_198711_1_, (double)p_198711_2_, (double)p_198711_6_);
            this.field_198714_b = MathHelper.func_82716_a((Random)p_198711_1_, (double)p_198711_4_, (double)p_198711_8_);
        }

        private static BlockState getType(IBlockReader iblockaccess, BlockPos position) {
            ((ServerChunkProvider)((World)((Object)iblockaccess)).func_72863_F()).func_217205_a(position.func_177958_n() >> 4, position.func_177952_p() >> 4, true);
            return iblockaccess.func_180495_p(position);
        }
    }
}

