/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.google.common.collect.ImmutableSet;
import com.mohistmc.util.i18n.i18n;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.CommandBlockMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.item.minecart.HopperMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.item.minecart.SpawnerMinecartEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GiantEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.CodEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.passive.fish.SalmonEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.DragonFireballEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.entity.projectile.EyeOfEnderEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ReverseTagWrapper;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntityType<T extends Entity>
extends ForgeRegistryEntry<EntityType<?>> {
    private static final Logger field_200731_aJ = LogManager.getLogger();
    public static final EntityType<AreaEffectCloudEntity> field_200788_b = EntityType.func_200712_a("area_effect_cloud", Builder.func_220322_a(AreaEffectCloudEntity::new, EntityClassification.MISC).func_220320_c().func_220321_a(6.0f, 0.5f).func_233606_a_(10).func_233608_b_(10));
    public static final EntityType<ArmorStandEntity> field_200789_c = EntityType.func_200712_a("armor_stand", Builder.func_220322_a(ArmorStandEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 1.975f).func_233606_a_(10));
    public static final EntityType<ArrowEntity> field_200790_d = EntityType.func_200712_a("arrow", Builder.func_220322_a(ArrowEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_233606_a_(4).func_233608_b_(20));
    public static final EntityType<BatEntity> field_200791_e = EntityType.func_200712_a("bat", Builder.func_220322_a(BatEntity::new, EntityClassification.AMBIENT).func_220321_a(0.5f, 0.9f).func_233606_a_(5));
    public static final EntityType<BeeEntity> field_226289_e_ = EntityType.func_200712_a("bee", Builder.func_220322_a(BeeEntity::new, EntityClassification.CREATURE).func_220321_a(0.7f, 0.6f).func_233606_a_(8));
    public static final EntityType<BlazeEntity> field_200792_f = EntityType.func_200712_a("blaze", Builder.func_220322_a(BlazeEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(0.6f, 1.8f).func_233606_a_(8));
    public static final EntityType<BoatEntity> field_200793_g = EntityType.func_200712_a("boat", Builder.func_220322_a(BoatEntity::new, EntityClassification.MISC).func_220321_a(1.375f, 0.5625f).func_233606_a_(10));
    public static final EntityType<CatEntity> field_220360_g = EntityType.func_200712_a("cat", Builder.func_220322_a(CatEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 0.7f).func_233606_a_(8));
    public static final EntityType<CaveSpiderEntity> field_200794_h = EntityType.func_200712_a("cave_spider", Builder.func_220322_a(CaveSpiderEntity::new, EntityClassification.MONSTER).func_220321_a(0.7f, 0.5f).func_233606_a_(8));
    public static final EntityType<ChickenEntity> field_200795_i = EntityType.func_200712_a("chicken", Builder.func_220322_a(ChickenEntity::new, EntityClassification.CREATURE).func_220321_a(0.4f, 0.7f).func_233606_a_(10));
    public static final EntityType<CodEntity> field_203780_j = EntityType.func_200712_a("cod", Builder.func_220322_a(CodEntity::new, EntityClassification.WATER_AMBIENT).func_220321_a(0.5f, 0.3f).func_233606_a_(4));
    public static final EntityType<CowEntity> field_200796_j = EntityType.func_200712_a("cow", Builder.func_220322_a(CowEntity::new, EntityClassification.CREATURE).func_220321_a(0.9f, 1.4f).func_233606_a_(10));
    public static final EntityType<CreeperEntity> field_200797_k = EntityType.func_200712_a("creeper", Builder.func_220322_a(CreeperEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.7f).func_233606_a_(8));
    public static final EntityType<DolphinEntity> field_205137_n = EntityType.func_200712_a("dolphin", Builder.func_220322_a(DolphinEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(0.9f, 0.6f));
    public static final EntityType<DonkeyEntity> field_200798_l = EntityType.func_200712_a("donkey", Builder.func_220322_a(DonkeyEntity::new, EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.5f).func_233606_a_(10));
    public static final EntityType<DragonFireballEntity> field_200799_m = EntityType.func_200712_a("dragon_fireball", Builder.func_220322_a(DragonFireballEntity::new, EntityClassification.MISC).func_220321_a(1.0f, 1.0f).func_233606_a_(4).func_233608_b_(10));
    public static final EntityType<DrownedEntity> field_204724_o = EntityType.func_200712_a("drowned", Builder.func_220322_a(DrownedEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8));
    public static final EntityType<ElderGuardianEntity> field_200800_n = EntityType.func_200712_a("elder_guardian", Builder.func_220322_a(ElderGuardianEntity::new, EntityClassification.MONSTER).func_220321_a(1.9975f, 1.9975f).func_233606_a_(10));
    public static final EntityType<EnderCrystalEntity> field_200801_o = EntityType.func_200712_a("end_crystal", Builder.func_220322_a(EnderCrystalEntity::new, EntityClassification.MISC).func_220321_a(2.0f, 2.0f).func_233606_a_(16).func_233608_b_(Integer.MAX_VALUE));
    public static final EntityType<EnderDragonEntity> field_200802_p = EntityType.func_200712_a("ender_dragon", Builder.func_220322_a(EnderDragonEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(16.0f, 8.0f).func_233606_a_(10));
    public static final EntityType<EndermanEntity> field_200803_q = EntityType.func_200712_a("enderman", Builder.func_220322_a(EndermanEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 2.9f).func_233606_a_(8));
    public static final EntityType<EndermiteEntity> field_200804_r = EntityType.func_200712_a("endermite", Builder.func_220322_a(EndermiteEntity::new, EntityClassification.MONSTER).func_220321_a(0.4f, 0.3f).func_233606_a_(8));
    public static final EntityType<EvokerEntity> field_200806_t = EntityType.func_200712_a("evoker", Builder.func_220322_a(EvokerEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8));
    public static final EntityType<EvokerFangsEntity> field_200805_s = EntityType.func_200712_a("evoker_fangs", Builder.func_220322_a(EvokerFangsEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.8f).func_233606_a_(6).func_233608_b_(2));
    public static final EntityType<ExperienceOrbEntity> field_200807_u = EntityType.func_200712_a("experience_orb", Builder.func_220322_a(ExperienceOrbEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_233606_a_(6).func_233608_b_(20));
    public static final EntityType<EyeOfEnderEntity> field_200808_v = EntityType.func_200712_a("eye_of_ender", Builder.func_220322_a(EyeOfEnderEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(4).func_233608_b_(4));
    public static final EntityType<FallingBlockEntity> field_200809_w = EntityType.func_200712_a("falling_block", Builder.func_220322_a(FallingBlockEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.98f).func_233606_a_(10).func_233608_b_(20));
    public static final EntityType<FireworkRocketEntity> field_200810_x = EntityType.func_200712_a("firework_rocket", Builder.func_220322_a(FireworkRocketEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(4).func_233608_b_(10));
    public static final EntityType<FoxEntity> field_220356_B = EntityType.func_200712_a("fox", Builder.func_220322_a(FoxEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 0.7f).func_233606_a_(8).func_233607_a_(Blocks.field_222434_lW));
    public static final EntityType<GhastEntity> field_200811_y = EntityType.func_200712_a("ghast", Builder.func_220322_a(GhastEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(4.0f, 4.0f).func_233606_a_(10));
    public static final EntityType<GiantEntity> field_200812_z = EntityType.func_200712_a("giant", Builder.func_220322_a(GiantEntity::new, EntityClassification.MONSTER).func_220321_a(3.6f, 12.0f).func_233606_a_(10));
    public static final EntityType<GuardianEntity> field_200761_A = EntityType.func_200712_a("guardian", Builder.func_220322_a(GuardianEntity::new, EntityClassification.MONSTER).func_220321_a(0.85f, 0.85f).func_233606_a_(8));
    public static final EntityType<HoglinEntity> field_233588_G_ = EntityType.func_200712_a("hoglin", Builder.func_220322_a(HoglinEntity::new, EntityClassification.MONSTER).func_220321_a(1.3964844f, 1.4f).func_233606_a_(8));
    public static final EntityType<HorseEntity> field_200762_B = EntityType.func_200712_a("horse", Builder.func_220322_a(HorseEntity::new, EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f).func_233606_a_(10));
    public static final EntityType<HuskEntity> field_200763_C = EntityType.func_200712_a("husk", Builder.func_220322_a(HuskEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8));
    public static final EntityType<IllusionerEntity> field_200764_D = EntityType.func_200712_a("illusioner", Builder.func_220322_a(IllusionerEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8));
    public static final EntityType<IronGolemEntity> field_200757_aw = EntityType.func_200712_a("iron_golem", Builder.func_220322_a(IronGolemEntity::new, EntityClassification.MISC).func_220321_a(1.4f, 2.7f).func_233606_a_(10));
    public static final EntityType<ItemEntity> field_200765_E = EntityType.func_200712_a("item", Builder.func_220322_a(ItemEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(6).func_233608_b_(20));
    public static final EntityType<ItemFrameEntity> field_200766_F = EntityType.func_200712_a("item_frame", Builder.func_220322_a(ItemFrameEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_233606_a_(10).func_233608_b_(Integer.MAX_VALUE));
    public static final EntityType<FireballEntity> field_200767_G = EntityType.func_200712_a("fireball", Builder.func_220322_a(FireballEntity::new, EntityClassification.MISC).func_220321_a(1.0f, 1.0f).func_233606_a_(4).func_233608_b_(10));
    public static final EntityType<LeashKnotEntity> field_200768_H = EntityType.func_200712_a("leash_knot", Builder.func_220322_a(LeashKnotEntity::new, EntityClassification.MISC).func_200706_c().func_220321_a(0.5f, 0.5f).func_233606_a_(10).func_233608_b_(Integer.MAX_VALUE));
    public static final EntityType<LightningBoltEntity> field_200728_aG = EntityType.func_200712_a("lightning_bolt", Builder.func_220322_a(LightningBoltEntity::new, EntityClassification.MISC).func_200706_c().func_220321_a(0.0f, 0.0f).func_233606_a_(16).func_233608_b_(Integer.MAX_VALUE));
    public static final EntityType<LlamaEntity> field_200769_I = EntityType.func_200712_a("llama", Builder.func_220322_a(LlamaEntity::new, EntityClassification.CREATURE).func_220321_a(0.9f, 1.87f).func_233606_a_(10));
    public static final EntityType<LlamaSpitEntity> field_200770_J = EntityType.func_200712_a("llama_spit", Builder.func_220322_a(LlamaSpitEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(4).func_233608_b_(10));
    public static final EntityType<MagmaCubeEntity> field_200771_K = EntityType.func_200712_a("magma_cube", Builder.func_220322_a(MagmaCubeEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(2.04f, 2.04f).func_233606_a_(8));
    public static final EntityType<MinecartEntity> field_200772_L = EntityType.func_200712_a("minecart", Builder.func_220322_a(MinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f).func_233606_a_(8));
    public static final EntityType<ChestMinecartEntity> field_200773_M = EntityType.func_200712_a("chest_minecart", Builder.func_220322_a(ChestMinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f).func_233606_a_(8));
    public static final EntityType<CommandBlockMinecartEntity> field_200774_N = EntityType.func_200712_a("command_block_minecart", Builder.func_220322_a(CommandBlockMinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f).func_233606_a_(8));
    public static final EntityType<FurnaceMinecartEntity> field_200775_O = EntityType.func_200712_a("furnace_minecart", Builder.func_220322_a(FurnaceMinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f).func_233606_a_(8));
    public static final EntityType<HopperMinecartEntity> field_200776_P = EntityType.func_200712_a("hopper_minecart", Builder.func_220322_a(HopperMinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f).func_233606_a_(8));
    public static final EntityType<SpawnerMinecartEntity> field_200777_Q = EntityType.func_200712_a("spawner_minecart", Builder.func_220322_a(SpawnerMinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f).func_233606_a_(8));
    public static final EntityType<TNTMinecartEntity> field_200778_R = EntityType.func_200712_a("tnt_minecart", Builder.func_220322_a(TNTMinecartEntity::new, EntityClassification.MISC).func_220321_a(0.98f, 0.7f).func_233606_a_(8));
    public static final EntityType<MuleEntity> field_200779_S = EntityType.func_200712_a("mule", Builder.func_220322_a(MuleEntity::new, EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f).func_233606_a_(8));
    public static final EntityType<MooshroomEntity> field_200780_T = EntityType.func_200712_a("mooshroom", Builder.func_220322_a(MooshroomEntity::new, EntityClassification.CREATURE).func_220321_a(0.9f, 1.4f).func_233606_a_(10));
    public static final EntityType<OcelotEntity> field_200781_U = EntityType.func_200712_a("ocelot", Builder.func_220322_a(OcelotEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 0.7f).func_233606_a_(10));
    public static final EntityType<PaintingEntity> field_200782_V = EntityType.func_200712_a("painting", Builder.func_220322_a(PaintingEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_233606_a_(10).func_233608_b_(Integer.MAX_VALUE));
    public static final EntityType<PandaEntity> field_220353_aa = EntityType.func_200712_a("panda", Builder.func_220322_a(PandaEntity::new, EntityClassification.CREATURE).func_220321_a(1.3f, 1.25f).func_233606_a_(10));
    public static final EntityType<ParrotEntity> field_200783_W = EntityType.func_200712_a("parrot", Builder.func_220322_a(ParrotEntity::new, EntityClassification.CREATURE).func_220321_a(0.5f, 0.9f).func_233606_a_(8));
    public static final EntityType<PhantomEntity> field_203097_aH = EntityType.func_200712_a("phantom", Builder.func_220322_a(PhantomEntity::new, EntityClassification.MONSTER).func_220321_a(0.9f, 0.5f).func_233606_a_(8));
    public static final EntityType<PigEntity> field_200784_X = EntityType.func_200712_a("pig", Builder.func_220322_a(PigEntity::new, EntityClassification.CREATURE).func_220321_a(0.9f, 0.9f).func_233606_a_(10));
    public static final EntityType<PiglinEntity> field_233591_ai_ = EntityType.func_200712_a("piglin", Builder.func_220322_a(PiglinEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8));
    public static final EntityType<PiglinBruteEntity> field_242287_aj = EntityType.func_200712_a("piglin_brute", Builder.func_220322_a(PiglinBruteEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8));
    public static final EntityType<PillagerEntity> field_220350_aJ = EntityType.func_200712_a("pillager", Builder.func_220322_a(PillagerEntity::new, EntityClassification.MONSTER).func_225435_d().func_220321_a(0.6f, 1.95f).func_233606_a_(8));
    public static final EntityType<PolarBearEntity> field_200786_Z = EntityType.func_200712_a("polar_bear", Builder.func_220322_a(PolarBearEntity::new, EntityClassification.CREATURE).func_220321_a(1.4f, 1.4f).func_233606_a_(10));
    public static final EntityType<TNTEntity> field_200735_aa = EntityType.func_200712_a("tnt", Builder.func_220322_a(TNTEntity::new, EntityClassification.MISC).func_220320_c().func_220321_a(0.98f, 0.98f).func_233606_a_(10).func_233608_b_(10));
    public static final EntityType<PufferfishEntity> field_203779_Z = EntityType.func_200712_a("pufferfish", Builder.func_220322_a(PufferfishEntity::new, EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.7f).func_233606_a_(4));
    public static final EntityType<RabbitEntity> field_200736_ab = EntityType.func_200712_a("rabbit", Builder.func_220322_a(RabbitEntity::new, EntityClassification.CREATURE).func_220321_a(0.4f, 0.5f).func_233606_a_(8));
    public static final EntityType<RavagerEntity> field_220352_aU = EntityType.func_200712_a("ravager", Builder.func_220322_a(RavagerEntity::new, EntityClassification.MONSTER).func_220321_a(1.95f, 2.2f).func_233606_a_(10));
    public static final EntityType<SalmonEntity> field_203778_ae = EntityType.func_200712_a("salmon", Builder.func_220322_a(SalmonEntity::new, EntityClassification.WATER_AMBIENT).func_220321_a(0.7f, 0.4f).func_233606_a_(4));
    public static final EntityType<SheepEntity> field_200737_ac = EntityType.func_200712_a("sheep", Builder.func_220322_a(SheepEntity::new, EntityClassification.CREATURE).func_220321_a(0.9f, 1.3f).func_233606_a_(10));
    public static final EntityType<ShulkerEntity> field_200738_ad = EntityType.func_200712_a("shulker", Builder.func_220322_a(ShulkerEntity::new, EntityClassification.MONSTER).func_220320_c().func_225435_d().func_220321_a(1.0f, 1.0f).func_233606_a_(10));
    public static final EntityType<ShulkerBulletEntity> field_200739_ae = EntityType.func_200712_a("shulker_bullet", Builder.func_220322_a(ShulkerBulletEntity::new, EntityClassification.MISC).func_220321_a(0.3125f, 0.3125f).func_233606_a_(8));
    public static final EntityType<SilverfishEntity> field_200740_af = EntityType.func_200712_a("silverfish", Builder.func_220322_a(SilverfishEntity::new, EntityClassification.MONSTER).func_220321_a(0.4f, 0.3f).func_233606_a_(8));
    public static final EntityType<SkeletonEntity> field_200741_ag = EntityType.func_200712_a("skeleton", Builder.func_220322_a(SkeletonEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.99f).func_233606_a_(8));
    public static final EntityType<SkeletonHorseEntity> field_200742_ah = EntityType.func_200712_a("skeleton_horse", Builder.func_220322_a(SkeletonHorseEntity::new, EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f).func_233606_a_(10));
    public static final EntityType<SlimeEntity> field_200743_ai = EntityType.func_200712_a("slime", Builder.func_220322_a(SlimeEntity::new, EntityClassification.MONSTER).func_220321_a(2.04f, 2.04f).func_233606_a_(10));
    public static final EntityType<SmallFireballEntity> field_200744_aj = EntityType.func_200712_a("small_fireball", Builder.func_220322_a(SmallFireballEntity::new, EntityClassification.MISC).func_220321_a(0.3125f, 0.3125f).func_233606_a_(4).func_233608_b_(10));
    public static final EntityType<SnowGolemEntity> field_200745_ak = EntityType.func_200712_a("snow_golem", Builder.func_220322_a(SnowGolemEntity::new, EntityClassification.MISC).func_220321_a(0.7f, 1.9f).func_233606_a_(8));
    public static final EntityType<SnowballEntity> field_200746_al = EntityType.func_200712_a("snowball", Builder.func_220322_a(SnowballEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(4).func_233608_b_(10));
    public static final EntityType<SpectralArrowEntity> field_200747_am = EntityType.func_200712_a("spectral_arrow", Builder.func_220322_a(SpectralArrowEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_233606_a_(4).func_233608_b_(20));
    public static final EntityType<SpiderEntity> field_200748_an = EntityType.func_200712_a("spider", Builder.func_220322_a(SpiderEntity::new, EntityClassification.MONSTER).func_220321_a(1.4f, 0.9f).func_233606_a_(8));
    public static final EntityType<SquidEntity> field_200749_ao = EntityType.func_200712_a("squid", Builder.func_220322_a(SquidEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(0.8f, 0.8f).func_233606_a_(8));
    public static final EntityType<StrayEntity> field_200750_ap = EntityType.func_200712_a("stray", Builder.func_220322_a(StrayEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.99f).func_233606_a_(8));
    public static final EntityType<StriderEntity> field_233589_aE_ = EntityType.func_200712_a("strider", Builder.func_220322_a(StriderEntity::new, EntityClassification.CREATURE).func_220320_c().func_220321_a(0.9f, 1.7f).func_233606_a_(10));
    public static final EntityType<EggEntity> field_200751_aq = EntityType.func_200712_a("egg", Builder.func_220322_a(EggEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(4).func_233608_b_(10));
    public static final EntityType<EnderPearlEntity> field_200752_ar = EntityType.func_200712_a("ender_pearl", Builder.func_220322_a(EnderPearlEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(4).func_233608_b_(10));
    public static final EntityType<ExperienceBottleEntity> field_200753_as = EntityType.func_200712_a("experience_bottle", Builder.func_220322_a(ExperienceBottleEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(4).func_233608_b_(10));
    public static final EntityType<PotionEntity> field_200754_at = EntityType.func_200712_a("potion", Builder.func_220322_a(PotionEntity::new, EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(4).func_233608_b_(10));
    public static final EntityType<TridentEntity> field_203098_aL = EntityType.func_200712_a("trident", Builder.func_220322_a(TridentEntity::new, EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_233606_a_(4).func_233608_b_(20));
    public static final EntityType<TraderLlamaEntity> field_220354_ax = EntityType.func_200712_a("trader_llama", Builder.func_220322_a(TraderLlamaEntity::new, EntityClassification.CREATURE).func_220321_a(0.9f, 1.87f).func_233606_a_(10));
    public static final EntityType<TropicalFishEntity> field_204262_at = EntityType.func_200712_a("tropical_fish", Builder.func_220322_a(TropicalFishEntity::new, EntityClassification.WATER_AMBIENT).func_220321_a(0.5f, 0.4f).func_233606_a_(4));
    public static final EntityType<TurtleEntity> field_203099_aq = EntityType.func_200712_a("turtle", Builder.func_220322_a(TurtleEntity::new, EntityClassification.CREATURE).func_220321_a(1.2f, 0.4f).func_233606_a_(10));
    public static final EntityType<VexEntity> field_200755_au = EntityType.func_200712_a("vex", Builder.func_220322_a(VexEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(0.4f, 0.8f).func_233606_a_(8));
    public static final EntityType<VillagerEntity> field_200756_av = EntityType.func_200712_a("villager", Builder.func_220322_a(VillagerEntity::new, EntityClassification.MISC).func_220321_a(0.6f, 1.95f).func_233606_a_(10));
    public static final EntityType<VindicatorEntity> field_200758_ax = EntityType.func_200712_a("vindicator", Builder.func_220322_a(VindicatorEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8));
    public static final EntityType<WanderingTraderEntity> field_220351_aK = EntityType.func_200712_a("wandering_trader", Builder.func_220322_a(WanderingTraderEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 1.95f).func_233606_a_(10));
    public static final EntityType<WitchEntity> field_200759_ay = EntityType.func_200712_a("witch", Builder.func_220322_a(WitchEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8));
    public static final EntityType<WitherEntity> field_200760_az = EntityType.func_200712_a("wither", Builder.func_220322_a(WitherEntity::new, EntityClassification.MONSTER).func_220320_c().func_233607_a_(Blocks.field_222388_bz).func_220321_a(0.9f, 3.5f).func_233606_a_(10));
    public static final EntityType<WitherSkeletonEntity> field_200722_aA = EntityType.func_200712_a("wither_skeleton", Builder.func_220322_a(WitherSkeletonEntity::new, EntityClassification.MONSTER).func_220320_c().func_233607_a_(Blocks.field_222388_bz).func_220321_a(0.7f, 2.4f).func_233606_a_(8));
    public static final EntityType<WitherSkullEntity> field_200723_aB = EntityType.func_200712_a("wither_skull", Builder.func_220322_a(WitherSkullEntity::new, EntityClassification.MISC).func_220321_a(0.3125f, 0.3125f).func_233606_a_(4).func_233608_b_(10));
    public static final EntityType<WolfEntity> field_200724_aC = EntityType.func_200712_a("wolf", Builder.func_220322_a(WolfEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 0.85f).func_233606_a_(10));
    public static final EntityType<ZoglinEntity> field_233590_aW_ = EntityType.func_200712_a("zoglin", Builder.func_220322_a(ZoglinEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(1.3964844f, 1.4f).func_233606_a_(8));
    public static final EntityType<ZombieEntity> field_200725_aD = EntityType.func_200712_a("zombie", Builder.func_220322_a(ZombieEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8));
    public static final EntityType<ZombieHorseEntity> field_200726_aE = EntityType.func_200712_a("zombie_horse", Builder.func_220322_a(ZombieHorseEntity::new, EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f).func_233606_a_(10));
    public static final EntityType<ZombieVillagerEntity> field_200727_aF = EntityType.func_200712_a("zombie_villager", Builder.func_220322_a(ZombieVillagerEntity::new, EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f).func_233606_a_(8));
    public static final EntityType<ZombifiedPiglinEntity> field_233592_ba_ = EntityType.func_200712_a("zombified_piglin", Builder.func_220322_a(ZombifiedPiglinEntity::new, EntityClassification.MONSTER).func_220320_c().func_220321_a(0.6f, 1.95f).func_233606_a_(8));
    public static final EntityType<PlayerEntity> field_200729_aH = EntityType.func_200712_a("player", Builder.func_220319_a(EntityClassification.MISC).func_200706_c().func_200705_b().func_220321_a(0.6f, 1.8f).func_233606_a_(32).func_233608_b_(2));
    public static final EntityType<FishingBobberEntity> field_200730_aI = EntityType.func_200712_a("fishing_bobber", Builder.func_220319_a(EntityClassification.MISC).func_200706_c().func_200705_b().func_220321_a(0.25f, 0.25f).func_233606_a_(4).func_233608_b_(5));
    private final IFactory<T> field_200732_aK;
    private final EntityClassification field_220355_ba;
    private final ImmutableSet<Block> field_233593_bg_;
    private final boolean field_200733_aL;
    private final boolean field_200734_aM;
    private final boolean field_220357_bd;
    private final boolean field_225438_be;
    private final int field_233594_bl_;
    private final int field_233595_bm_;
    @Nullable
    private String field_210762_aX;
    @Nullable
    private ITextComponent field_212547_aX;
    @Nullable
    private ResourceLocation field_220358_bg;
    private final EntitySize field_220359_bi;
    private final Predicate<EntityType<?>> velocityUpdateSupplier;
    private final ToIntFunction<EntityType<?>> trackingRangeSupplier;
    private final ToIntFunction<EntityType<?>> updateIntervalSupplier;
    private final BiFunction<FMLPlayMessages.SpawnEntity, World, T> customClientFactory;
    private final ReverseTagWrapper<EntityType<?>> reverseTags = new ReverseTagWrapper((Object)this, EntityTypeTags::func_219762_a);
    public final String id;
    public final Timing tickTimer;
    public final Timing inactiveTickTimer;
    public final Timing passengerTickTimer;
    public final Timing passengerInactiveTickTimer;

    private static <T extends Entity> EntityType<T> func_200712_a(String p_200712_0_, Builder<T> p_200712_1_) {
        return Registry.func_218325_a(Registry.field_212629_r, p_200712_0_, p_200712_1_.func_206830_a(p_200712_0_));
    }

    public static ResourceLocation func_200718_a(EntityType<?> p_200718_0_) {
        return Registry.field_212629_r.func_177774_c(p_200718_0_);
    }

    public static Optional<EntityType<?>> func_220327_a(String p_220327_0_) {
        return Registry.field_212629_r.func_241873_b(ResourceLocation.func_208304_a(p_220327_0_));
    }

    public EntityType(IFactory<T> p_i231489_1_, EntityClassification p_i231489_2_, boolean p_i231489_3_, boolean p_i231489_4_, boolean p_i231489_5_, boolean p_i231489_6_, ImmutableSet<Block> p_i231489_7_, EntitySize p_i231489_8_, int p_i231489_9_, int p_i231489_10_) {
        this(p_i231489_1_, p_i231489_2_, p_i231489_3_, p_i231489_4_, p_i231489_5_, p_i231489_6_, p_i231489_7_, p_i231489_8_, p_i231489_9_, p_i231489_10_, EntityType::defaultVelocitySupplier, EntityType::defaultTrackingRangeSupplier, EntityType::defaultUpdateIntervalSupplier, null, "custom");
    }

    public EntityType(IFactory<T> p_i231489_1_, EntityClassification p_i231489_2_, boolean p_i231489_3_, boolean p_i231489_4_, boolean p_i231489_5_, boolean p_i231489_6_, ImmutableSet<Block> p_i231489_7_, EntitySize p_i231489_8_, int p_i231489_9_, int p_i231489_10_, String id) {
        this(p_i231489_1_, p_i231489_2_, p_i231489_3_, p_i231489_4_, p_i231489_5_, p_i231489_6_, p_i231489_7_, p_i231489_8_, p_i231489_9_, p_i231489_10_, EntityType::defaultVelocitySupplier, EntityType::defaultTrackingRangeSupplier, EntityType::defaultUpdateIntervalSupplier, null, id);
    }

    public EntityType(IFactory<T> p_i231489_1_, EntityClassification p_i231489_2_, boolean p_i231489_3_, boolean p_i231489_4_, boolean p_i231489_5_, boolean p_i231489_6_, ImmutableSet<Block> p_i231489_7_, EntitySize p_i231489_8_, int p_i231489_9_, int p_i231489_10_, Predicate<EntityType<?>> velocityUpdateSupplier, ToIntFunction<EntityType<?>> trackingRangeSupplier, ToIntFunction<EntityType<?>> updateIntervalSupplier, BiFunction<FMLPlayMessages.SpawnEntity, World, T> customClientFactory, String id) {
        this.field_200732_aK = p_i231489_1_;
        this.field_220355_ba = p_i231489_2_;
        this.field_225438_be = p_i231489_6_;
        this.field_200733_aL = p_i231489_3_;
        this.field_200734_aM = p_i231489_4_;
        this.field_220357_bd = p_i231489_5_;
        this.field_233593_bg_ = p_i231489_7_;
        this.field_220359_bi = p_i231489_8_;
        this.field_233594_bl_ = p_i231489_9_;
        this.field_233595_bm_ = p_i231489_10_;
        this.velocityUpdateSupplier = velocityUpdateSupplier;
        this.trackingRangeSupplier = trackingRangeSupplier;
        this.updateIntervalSupplier = updateIntervalSupplier;
        this.customClientFactory = customClientFactory;
        this.id = id;
        this.tickTimer = MinecraftTimings.getEntityTimings((String)id, (String)"tick");
        this.inactiveTickTimer = MinecraftTimings.getEntityTimings((String)id, (String)"inactiveTick");
        this.passengerTickTimer = MinecraftTimings.getEntityTimings((String)id, (String)"passengerTick");
        this.passengerInactiveTickTimer = MinecraftTimings.getEntityTimings((String)id, (String)"passengerInactiveTick");
    }

    @Nullable
    public Entity func_220331_a(ServerWorld p_220331_1_, @Nullable ItemStack p_220331_2_, @Nullable PlayerEntity p_220331_3_, BlockPos p_220331_4_, SpawnReason p_220331_5_, boolean p_220331_6_, boolean p_220331_7_) {
        return this.func_220342_a(p_220331_1_, p_220331_2_ == null ? null : p_220331_2_.func_77978_p(), p_220331_2_ != null && p_220331_2_.func_82837_s() ? p_220331_2_.func_200301_q() : null, p_220331_3_, p_220331_4_, p_220331_5_, p_220331_6_, p_220331_7_);
    }

    @Nullable
    public T func_220342_a(ServerWorld p_220342_1_, @Nullable CompoundNBT p_220342_2_, @Nullable ITextComponent p_220342_3_, @Nullable PlayerEntity p_220342_4_, BlockPos p_220342_5_, SpawnReason p_220342_6_, boolean p_220342_7_, boolean p_220342_8_) {
        return this.spawn(p_220342_1_, p_220342_2_, p_220342_3_, p_220342_4_, p_220342_5_, p_220342_6_, p_220342_7_, p_220342_8_, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
    }

    @Nullable
    public T spawn(ServerWorld worldIn, @Nullable CompoundNBT compound, @Nullable ITextComponent customName, @Nullable PlayerEntity playerIn, BlockPos pos, SpawnReason reason, boolean p_220342_7_, boolean p_220342_8_, CreatureSpawnEvent.SpawnReason spawnReason) {
        T t = this.func_220349_b(worldIn, compound, customName, playerIn, pos, reason, p_220342_7_, p_220342_8_);
        if (t != null) {
            if (t instanceof MobEntity && ForgeEventFactory.doSpecialSpawn((MobEntity)((MobEntity)t), (World)worldIn, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p(), null, (SpawnReason)reason)) {
                return null;
            }
            worldIn.addAllEntities((Entity)t, spawnReason);
            return (T)(!((Entity)t).field_70128_L ? t : null);
        }
        return t;
    }

    @Nullable
    public T func_220349_b(ServerWorld p_220349_1_, @Nullable CompoundNBT p_220349_2_, @Nullable ITextComponent p_220349_3_, @Nullable PlayerEntity p_220349_4_, BlockPos p_220349_5_, SpawnReason p_220349_6_, boolean p_220349_7_, boolean p_220349_8_) {
        double d0;
        T t = this.func_200721_a(p_220349_1_);
        if (t == null) {
            return (T)((Entity)null);
        }
        if (p_220349_7_) {
            ((Entity)t).func_70107_b((double)p_220349_5_.func_177958_n() + 0.5, p_220349_5_.func_177956_o() + 1, (double)p_220349_5_.func_177952_p() + 0.5);
            d0 = EntityType.func_208051_a((IWorldReader)((Object)p_220349_1_), p_220349_5_, p_220349_8_, ((Entity)t).func_174813_aQ());
        } else {
            d0 = 0.0;
        }
        ((Entity)t).func_70012_b((double)p_220349_5_.func_177958_n() + 0.5, (double)p_220349_5_.func_177956_o() + d0, (double)p_220349_5_.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(p_220349_1_.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        if (t instanceof MobEntity) {
            MobEntity mobentity = (MobEntity)t;
            mobentity.field_70759_as = mobentity.field_70177_z;
            mobentity.field_70761_aq = mobentity.field_70177_z;
            mobentity.func_213386_a((IServerWorld)((Object)p_220349_1_), p_220349_1_.func_175649_E(mobentity.func_233580_cy_()), p_220349_6_, null, p_220349_2_);
            mobentity.func_70642_aH();
        }
        if (p_220349_3_ != null && t instanceof LivingEntity) {
            ((Entity)t).func_200203_b(p_220349_3_);
        }
        try {
            EntityType.func_208048_a(p_220349_1_, p_220349_4_, t, p_220349_2_);
        }
        catch (Throwable throwable) {
            field_200731_aJ.warn("Error loading spawn egg NBT", throwable);
        }
        return t;
    }

    protected static double func_208051_a(IWorldReader p_208051_0_, BlockPos p_208051_1_, boolean p_208051_2_, AxisAlignedBB p_208051_3_) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(p_208051_1_);
        if (p_208051_2_) {
            axisalignedbb = axisalignedbb.func_72321_a(0.0, -1.0, 0.0);
        }
        Stream stream = p_208051_0_.func_234867_d_(null, axisalignedbb, p_233596_0_ -> true);
        return 1.0 + VoxelShapes.func_212437_a(Direction.Axis.Y, p_208051_3_, stream, p_208051_2_ ? -2.0 : -1.0);
    }

    public static void func_208048_a(World p_208048_0_, @Nullable PlayerEntity p_208048_1_, @Nullable Entity p_208048_2_, @Nullable CompoundNBT p_208048_3_) {
        MinecraftServer minecraftserver;
        if (p_208048_3_ != null && p_208048_3_.func_150297_b("EntityTag", 10) && (minecraftserver = p_208048_0_.func_73046_m()) != null && p_208048_2_ != null && (p_208048_0_.field_72995_K || !p_208048_2_.func_184213_bq() || p_208048_1_ != null && minecraftserver.func_184103_al().func_152596_g(p_208048_1_.func_146103_bH()))) {
            CompoundNBT compoundnbt = p_208048_2_.func_189511_e(new CompoundNBT());
            UUID uuid = p_208048_2_.func_110124_au();
            compoundnbt.func_197643_a(p_208048_3_.func_74775_l("EntityTag"));
            p_208048_2_.func_184221_a(uuid);
            p_208048_2_.func_70020_e(compoundnbt);
        }
    }

    public boolean func_200715_a() {
        return this.field_200733_aL;
    }

    public boolean func_200720_b() {
        return this.field_200734_aM;
    }

    public boolean func_220338_c() {
        return this.field_220357_bd;
    }

    public boolean func_225437_d() {
        return this.field_225438_be;
    }

    public EntityClassification func_220339_d() {
        return this.field_220355_ba;
    }

    public String func_210760_d() {
        if (this.field_210762_aX == null) {
            this.field_210762_aX = Util.func_200697_a("entity", Registry.field_212629_r.func_177774_c((Object)this));
        }
        return this.field_210762_aX;
    }

    public ITextComponent func_212546_e() {
        if (this.field_212547_aX == null) {
            this.field_212547_aX = new TranslationTextComponent(this.func_210760_d());
        }
        return this.field_212547_aX;
    }

    public String toString() {
        return this.func_210760_d();
    }

    public ResourceLocation func_220348_g() {
        if (this.field_220358_bg == null) {
            ResourceLocation resourcelocation = Registry.field_212629_r.func_177774_c((Object)this);
            this.field_220358_bg = new ResourceLocation(resourcelocation.func_110624_b(), "entities/" + resourcelocation.func_110623_a());
        }
        return this.field_220358_bg;
    }

    public float func_220333_h() {
        return this.field_220359_bi.field_220315_a;
    }

    public float func_220344_i() {
        return this.field_220359_bi.field_220316_b;
    }

    @Nullable
    public T func_200721_a(World p_200721_1_) {
        return this.field_200732_aK.create(this, p_200721_1_);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static Entity func_200717_a(int p_200717_0_, World p_200717_1_) {
        return EntityType.func_200719_a(p_200717_1_, (EntityType)((Object)Registry.field_212629_r.func_148745_a(p_200717_0_)));
    }

    public static Optional<Entity> func_220330_a(CompoundNBT p_220330_0_, World p_220330_1_) {
        return Util.func_215077_a(EntityType.func_220347_a(p_220330_0_).map(p_220337_1_ -> p_220337_1_.func_200721_a(p_220330_1_)), p_220329_1_ -> p_220329_1_.func_70020_e(p_220330_0_), () -> field_200731_aJ.warn(i18n.get((String)"entitytype.1", (Object[])new Object[]{p_220330_0_.func_74779_i("id")})));
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    private static Entity func_200719_a(World p_200719_0_, @Nullable EntityType<?> p_200719_1_) {
        return p_200719_1_ == null ? null : (Entity)p_200719_1_.func_200721_a(p_200719_0_);
    }

    public AxisAlignedBB func_220328_a(double p_220328_1_, double p_220328_3_, double p_220328_5_) {
        float f = this.func_220333_h() / 2.0f;
        return new AxisAlignedBB(p_220328_1_ - (double)f, p_220328_3_, p_220328_5_ - (double)f, p_220328_1_ + (double)f, p_220328_3_ + (double)this.func_220344_i(), p_220328_5_ + (double)f);
    }

    public boolean func_233597_a_(BlockState p_233597_1_) {
        if (this.field_233593_bg_.contains((Object)p_233597_1_.func_177230_c())) {
            return false;
        }
        if (this.field_220357_bd || !p_233597_1_.func_235714_a_(BlockTags.field_232872_am_) && !p_233597_1_.func_203425_a(Blocks.field_196814_hQ) && !CampfireBlock.func_226915_i_(p_233597_1_) && !p_233597_1_.func_203425_a(Blocks.field_150353_l)) {
            return p_233597_1_.func_203425_a(Blocks.field_222388_bz) || p_233597_1_.func_203425_a(Blocks.field_222434_lW) || p_233597_1_.func_203425_a(Blocks.field_150434_aF);
        }
        return true;
    }

    public EntitySize func_220334_j() {
        return this.field_220359_bi;
    }

    public static Optional<EntityType<?>> func_220347_a(CompoundNBT p_220347_0_) {
        return Registry.field_212629_r.func_241873_b(new ResourceLocation(p_220347_0_.func_74779_i("id")));
    }

    @Nullable
    public static Entity func_220335_a(CompoundNBT p_220335_0_, World p_220335_1_, Function<Entity, Entity> p_220335_2_) {
        return EntityType.func_220343_b(p_220335_0_, p_220335_1_).map(p_220335_2_).map(p_220346_3_ -> {
            if (p_220335_0_.func_150297_b("Passengers", 9)) {
                ListNBT listnbt = p_220335_0_.func_150295_c("Passengers", 10);
                for (int i = 0; i < listnbt.size(); ++i) {
                    Entity entity = EntityType.func_220335_a(listnbt.func_150305_b(i), p_220335_1_, p_220335_2_);
                    if (entity == null) continue;
                    entity.func_184205_a((Entity)p_220346_3_, true);
                }
            }
            return p_220346_3_;
        }).orElse(null);
    }

    private static Optional<Entity> func_220343_b(CompoundNBT p_220343_0_, World p_220343_1_) {
        try {
            return EntityType.func_220330_a(p_220343_0_, p_220343_1_);
        }
        catch (RuntimeException runtimeexception) {
            field_200731_aJ.warn(i18n.get((String)"entitytype.2", (Object[])new Object[]{runtimeexception}));
            return Optional.empty();
        }
    }

    public int func_233602_m_() {
        return this.trackingRangeSupplier.applyAsInt(this);
    }

    private int defaultTrackingRangeSupplier() {
        return this.field_233594_bl_;
    }

    public int func_220332_l() {
        return this.updateIntervalSupplier.applyAsInt(this);
    }

    private int defaultUpdateIntervalSupplier() {
        return this.field_233595_bm_;
    }

    public boolean func_220340_m() {
        return this.velocityUpdateSupplier.test(this);
    }

    private boolean defaultVelocitySupplier() {
        return this != field_200729_aH && this != field_200770_J && this != field_200760_az && this != field_200791_e && this != field_200766_F && this != field_200768_H && this != field_200782_V && this != field_200801_o && this != field_200805_s;
    }

    public boolean func_220341_a(ITag<EntityType<?>> p_220341_1_) {
        return p_220341_1_.func_230235_a_(this);
    }

    public T customClientSpawn(FMLPlayMessages.SpawnEntity packet, World world) {
        if (this.customClientFactory == null) {
            return this.func_200721_a(world);
        }
        return (T)((Entity)this.customClientFactory.apply(packet, world));
    }

    public Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    public static Set<ResourceLocation> getEntityNameList() {
        return Registry.field_212629_r.func_148742_b();
    }

    public static interface IFactory<T extends Entity> {
        public T create(EntityType<T> var1, World var2);
    }

    public static class Builder<T extends Entity> {
        private final IFactory<T> field_200709_a;
        private final EntityClassification field_220324_b;
        private ImmutableSet<Block> field_233603_c_ = ImmutableSet.of();
        private boolean field_200710_b = true;
        private boolean field_200711_c = true;
        private boolean field_220325_e;
        private boolean field_225436_f;
        private int field_233604_h_ = 5;
        private int field_233605_i_ = 3;
        private EntitySize field_220326_f = EntitySize.func_220314_b((float)0.6f, (float)1.8f);
        private Predicate<EntityType<?>> velocityUpdateSupplier = rec$ -> ((EntityType)((Object)((Object)rec$))).defaultVelocitySupplier();
        private ToIntFunction<EntityType<?>> trackingRangeSupplier = rec$ -> ((EntityType)((Object)((Object)rec$))).defaultTrackingRangeSupplier();
        private ToIntFunction<EntityType<?>> updateIntervalSupplier = rec$ -> ((EntityType)((Object)((Object)rec$))).defaultUpdateIntervalSupplier();
        private BiFunction<FMLPlayMessages.SpawnEntity, World, T> customClientFactory;

        private Builder(IFactory<T> p_i50479_1_, EntityClassification p_i50479_2_) {
            this.field_200709_a = p_i50479_1_;
            this.field_220324_b = p_i50479_2_;
            this.field_225436_f = p_i50479_2_ == EntityClassification.CREATURE || p_i50479_2_ == EntityClassification.MISC;
        }

        public static <T extends Entity> Builder<T> func_220322_a(IFactory<T> p_220322_0_, EntityClassification p_220322_1_) {
            return new Builder<T>(p_220322_0_, p_220322_1_);
        }

        public static <T extends Entity> Builder<T> func_220319_a(EntityClassification p_220319_0_) {
            return new Builder<Entity>((p_220323_0_, p_220323_1_) -> null, p_220319_0_);
        }

        public Builder<T> func_220321_a(float p_220321_1_, float p_220321_2_) {
            this.field_220326_f = EntitySize.func_220314_b((float)p_220321_1_, (float)p_220321_2_);
            return this;
        }

        public Builder<T> func_200705_b() {
            this.field_200711_c = false;
            return this;
        }

        public Builder<T> func_200706_c() {
            this.field_200710_b = false;
            return this;
        }

        public Builder<T> func_220320_c() {
            this.field_220325_e = true;
            return this;
        }

        public Builder<T> func_233607_a_(Block ... p_233607_1_) {
            this.field_233603_c_ = ImmutableSet.copyOf((Object[])p_233607_1_);
            return this;
        }

        public Builder<T> func_225435_d() {
            this.field_225436_f = true;
            return this;
        }

        public Builder<T> func_233606_a_(int p_233606_1_) {
            this.field_233604_h_ = p_233606_1_;
            return this;
        }

        public Builder<T> func_233608_b_(int p_233608_1_) {
            this.field_233605_i_ = p_233608_1_;
            return this;
        }

        public Builder<T> setUpdateInterval(int interval) {
            this.updateIntervalSupplier = t -> interval;
            return this;
        }

        public Builder<T> setTrackingRange(int range) {
            this.trackingRangeSupplier = t -> range;
            return this;
        }

        public Builder<T> setShouldReceiveVelocityUpdates(boolean value) {
            this.velocityUpdateSupplier = t -> value;
            return this;
        }

        public Builder<T> setCustomClientFactory(BiFunction<FMLPlayMessages.SpawnEntity, World, T> customClientFactory) {
            this.customClientFactory = customClientFactory;
            return this;
        }

        public EntityType<T> func_206830_a(String p_206830_1_) {
            if (this.field_200710_b) {
                Util.func_240976_a_(TypeReferences.field_211298_n, p_206830_1_);
            }
            return new EntityType<T>(this.field_200709_a, this.field_220324_b, this.field_200710_b, this.field_200711_c, this.field_220325_e, this.field_225436_f, this.field_233603_c_, this.field_220326_f, this.field_233604_h_, this.field_233605_i_, this.velocityUpdateSupplier, this.trackingRangeSupplier, this.updateIntervalSupplier, this.customClientFactory, p_206830_1_);
        }
    }
}

