/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.EntitySenses;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.controller.JumpController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;

public abstract class MobEntity
extends LivingEntity {
    private static final DataParameter<Byte> field_184654_a = EntityDataManager.func_187226_a(MobEntity.class, DataSerializers.field_187191_a);
    public int field_70757_a;
    protected int field_70728_aV;
    protected LookController field_70749_g;
    protected MovementController field_70765_h;
    protected JumpController field_70767_i;
    private final BodyController field_70762_j;
    protected PathNavigator field_70699_by;
    public GoalSelector field_70714_bg;
    public GoalSelector field_70715_bh;
    private LivingEntity field_70696_bz;
    private final EntitySenses field_70723_bA;
    private final NonNullList<ItemStack> field_184656_bv = NonNullList.func_191197_a(2, ItemStack.field_190927_a);
    public final float[] field_82174_bp = new float[2];
    private final NonNullList<ItemStack> field_184657_bw = NonNullList.func_191197_a(4, ItemStack.field_190927_a);
    public final float[] field_184655_bs = new float[4];
    public boolean field_82179_bU;
    private final Map<PathNodeType, Float> field_184658_bz = Maps.newEnumMap(PathNodeType.class);
    public ResourceLocation field_184659_bA;
    public long field_184653_bB;
    @Nullable
    private Entity field_110168_bw;
    private int field_213400_bI;
    @Nullable
    private CompoundNBT field_110170_bx;
    private BlockPos field_213401_bK = BlockPos.field_177992_a;
    private float field_213402_bL = -1.0f;
    public boolean aware = true;

    protected MobEntity(EntityType<? extends MobEntity> p_i48576_1_, World p_i48576_2_) {
        super((EntityType<? extends LivingEntity>)p_i48576_1_, p_i48576_2_);
        this.field_70714_bg = new GoalSelector(p_i48576_2_.func_234924_Y_());
        this.field_70715_bh = new GoalSelector(p_i48576_2_.func_234924_Y_());
        this.field_70749_g = new LookController(this);
        this.field_70765_h = new MovementController(this);
        this.field_70767_i = new JumpController(this);
        this.field_70762_j = this.func_184650_s();
        this.field_70699_by = this.func_175447_b(p_i48576_2_);
        this.field_70723_bA = new EntitySenses(this);
        Arrays.fill(this.field_184655_bs, 0.085f);
        Arrays.fill(this.field_82174_bp, 0.085f);
        if (p_i48576_2_ != null && !p_i48576_2_.field_72995_K) {
            this.func_184651_r();
        }
    }

    protected void func_184651_r() {
    }

    public static AttributeModifierMap.MutableAttribute func_233666_p_() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233819_b_, 16.0).func_233814_a_(Attributes.field_233824_g_);
    }

    protected PathNavigator func_175447_b(World p_175447_1_) {
        return new GroundPathNavigator(this, p_175447_1_);
    }

    protected boolean func_230286_q_() {
        return false;
    }

    public float func_184643_a(PathNodeType p_184643_1_) {
        MobEntity mobentity = this.func_184187_bx() instanceof MobEntity && ((MobEntity)this.func_184187_bx()).func_230286_q_() ? (MobEntity)this.func_184187_bx() : this;
        Float f = mobentity.field_184658_bz.get((Object)p_184643_1_);
        return f == null ? p_184643_1_.func_186289_a() : f.floatValue();
    }

    public void func_184644_a(PathNodeType p_184644_1_, float p_184644_2_) {
        this.field_184658_bz.put(p_184644_1_, Float.valueOf(p_184644_2_));
    }

    public boolean func_233660_b_(PathNodeType p_233660_1_) {
        return p_233660_1_ != PathNodeType.DANGER_FIRE && p_233660_1_ != PathNodeType.DANGER_CACTUS && p_233660_1_ != PathNodeType.DANGER_OTHER && p_233660_1_ != PathNodeType.WALKABLE_DOOR;
    }

    protected BodyController func_184650_s() {
        return new BodyController(this);
    }

    public LookController func_70671_ap() {
        return this.field_70749_g;
    }

    public MovementController func_70605_aq() {
        if (this.func_184218_aH() && this.func_184187_bx() instanceof MobEntity) {
            MobEntity mobentity = (MobEntity)this.func_184187_bx();
            return mobentity.func_70605_aq();
        }
        return this.field_70765_h;
    }

    public JumpController func_70683_ar() {
        return this.field_70767_i;
    }

    public PathNavigator func_70661_as() {
        if (this.func_184218_aH() && this.func_184187_bx() instanceof MobEntity) {
            MobEntity mobentity = (MobEntity)this.func_184187_bx();
            return mobentity.func_70661_as();
        }
        return this.field_70699_by;
    }

    public EntitySenses func_70635_at() {
        return this.field_70723_bA;
    }

    @Nullable
    public LivingEntity func_70638_az() {
        return this.field_70696_bz;
    }

    public void func_70624_b(@Nullable LivingEntity p_70624_1_) {
        this.setGoalTarget(p_70624_1_, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setGoalTarget(@Nullable LivingEntity entitylivingbaseIn, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.func_70638_az() == entitylivingbaseIn) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.func_70638_az() != null && entitylivingbaseIn == null) {
                reason = this.func_70638_az().func_70089_S() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            CraftLivingEntity ctarget = null;
            if (entitylivingbaseIn != null) {
                ctarget = (CraftLivingEntity)entitylivingbaseIn.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.LivingEntity)ctarget, reason);
            this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entitylivingbaseIn = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.field_70696_bz = entitylivingbaseIn;
        ForgeHooks.onLivingSetAttackTarget((LivingEntity)this, (LivingEntity)entitylivingbaseIn);
        return true;
    }

    @Override
    public boolean func_213358_a(EntityType<?> p_213358_1_) {
        return p_213358_1_ != EntityType.field_200811_y;
    }

    public boolean func_230280_a_(ShootableItem p_230280_1_) {
        return false;
    }

    public void func_70615_aA() {
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184654_a, (byte)0);
    }

    public int func_70627_aG() {
        return 80;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        this.field_70170_p.func_217381_Z().func_76320_a("mobBaseTick");
        if (this.func_70089_S() && this.field_70146_Z.nextInt(1000) < this.field_70757_a++) {
            this.func_241821_eG();
            this.func_70642_aH();
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    @Override
    protected void func_184581_c(DamageSource p_184581_1_) {
        this.func_241821_eG();
        super.func_184581_c(p_184581_1_);
    }

    private void func_241821_eG() {
        this.field_70757_a = -this.func_70627_aG();
    }

    @Override
    protected int func_70693_a(PlayerEntity p_70693_1_) {
        if (this.field_70728_aV > 0) {
            int i = this.field_70728_aV;
            for (int j = 0; j < this.field_184657_bw.size(); ++j) {
                if (this.field_184657_bw.get(j).func_190926_b() || !(this.field_184655_bs[j] <= 1.0f)) continue;
                i += 1 + this.field_70146_Z.nextInt(3);
            }
            for (int k = 0; k < this.field_184656_bv.size(); ++k) {
                if (this.field_184656_bv.get(k).func_190926_b() || !(this.field_82174_bp[k] <= 1.0f)) continue;
                i += 1 + this.field_70146_Z.nextInt(3);
            }
            return i;
        }
        return this.field_70728_aV;
    }

    public void func_70656_aK() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d3 = 10.0;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226275_c_(1.0) - d0 * 10.0, this.func_226279_cv_() - d1 * 10.0, this.func_226287_g_(1.0) - d2 * 10.0, d0, d1, d2);
            }
        } else {
            this.field_70170_p.func_72960_a(this, (byte)20);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 20) {
            this.func_70656_aK();
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.func_110159_bB();
            if (this.field_70173_aa % 5 == 0) {
                this.func_213385_F();
            }
        }
    }

    protected void func_213385_F() {
        boolean flag = !(this.func_184179_bs() instanceof MobEntity);
        boolean flag1 = !(this.func_184187_bx() instanceof BoatEntity);
        this.field_70714_bg.func_220878_a(Goal.Flag.MOVE, flag);
        this.field_70714_bg.func_220878_a(Goal.Flag.JUMP, flag && flag1);
        this.field_70714_bg.func_220878_a(Goal.Flag.LOOK, flag);
    }

    @Override
    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        this.field_70762_j.func_75664_a();
        return p_110146_2_;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74757_a("CanPickUpLoot", this.func_98052_bS());
        p_213281_1_.func_74757_a("PersistenceRequired", this.field_82179_bU);
        ListNBT listnbt = new ListNBT();
        for (ItemStack itemStack : this.field_184657_bw) {
            CompoundNBT compoundNBT = new CompoundNBT();
            if (!itemStack.func_190926_b()) {
                itemStack.func_77955_b(compoundNBT);
            }
            listnbt.add((Object)compoundNBT);
        }
        p_213281_1_.func_218657_a("ArmorItems", (INBT)listnbt);
        ListNBT listnbt1 = new ListNBT();
        for (ItemStack itemStack : this.field_184656_bv) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            if (!itemStack.func_190926_b()) {
                itemStack.func_77955_b(compoundnbt1);
            }
            listnbt1.add((Object)compoundnbt1);
        }
        p_213281_1_.func_218657_a("HandItems", (INBT)listnbt1);
        ListNBT listNBT = new ListNBT();
        for (float f : this.field_184655_bs) {
            listNBT.add((Object)FloatNBT.func_229689_a_((float)f));
        }
        p_213281_1_.func_218657_a("ArmorDropChances", (INBT)listNBT);
        ListNBT listNBT2 = new ListNBT();
        for (float f1 : this.field_82174_bp) {
            listNBT2.add((Object)FloatNBT.func_229689_a_((float)f1));
        }
        p_213281_1_.func_218657_a("HandDropChances", (INBT)listNBT2);
        if (this.field_110168_bw != null) {
            CompoundNBT compoundnbt2 = new CompoundNBT();
            if (this.field_110168_bw instanceof LivingEntity) {
                UUID uuid = this.field_110168_bw.func_110124_au();
                compoundnbt2.func_186854_a("UUID", uuid);
            } else if (this.field_110168_bw instanceof HangingEntity) {
                BlockPos blockpos = ((HangingEntity)this.field_110168_bw).func_174857_n();
                compoundnbt2.func_74768_a("X", blockpos.func_177958_n());
                compoundnbt2.func_74768_a("Y", blockpos.func_177956_o());
                compoundnbt2.func_74768_a("Z", blockpos.func_177952_p());
            }
            p_213281_1_.func_218657_a("Leash", compoundnbt2);
        } else if (this.field_110170_bx != null) {
            p_213281_1_.func_218657_a("Leash", this.field_110170_bx.func_74737_b());
        }
        p_213281_1_.func_74757_a("LeftHanded", this.func_184638_cS());
        if (this.field_184659_bA != null) {
            p_213281_1_.func_74778_a("DeathLootTable", this.field_184659_bA.toString());
            if (this.field_184653_bB != 0L) {
                p_213281_1_.func_74772_a("DeathLootTableSeed", this.field_184653_bB);
            }
        }
        if (this.func_175446_cd()) {
            p_213281_1_.func_74757_a("NoAI", this.func_175446_cd());
        }
        p_213281_1_.func_74757_a("Bukkit.Aware", this.aware);
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        boolean data;
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_150297_b("CanPickUpLoot", 1)) {
            data = p_70037_1_.func_74767_n("CanPickUpLoot");
            if (MobEntity.isLevelAtLeast(p_70037_1_, 1) || data) {
                this.func_98053_h(data);
            }
        }
        data = p_70037_1_.func_74767_n("PersistenceRequired");
        if (MobEntity.isLevelAtLeast(p_70037_1_, 1) || data) {
            this.field_82179_bU = data;
        }
        if (p_70037_1_.func_150297_b("ArmorItems", 9)) {
            ListNBT listnbt = p_70037_1_.func_150295_c("ArmorItems", 10);
            for (int i = 0; i < this.field_184657_bw.size(); ++i) {
                this.field_184657_bw.set(i, ItemStack.func_199557_a(listnbt.func_150305_b(i)));
            }
        }
        if (p_70037_1_.func_150297_b("HandItems", 9)) {
            ListNBT listnbt1 = p_70037_1_.func_150295_c("HandItems", 10);
            for (int j = 0; j < this.field_184656_bv.size(); ++j) {
                this.field_184656_bv.set(j, ItemStack.func_199557_a(listnbt1.func_150305_b(j)));
            }
        }
        if (p_70037_1_.func_150297_b("ArmorDropChances", 9)) {
            ListNBT listnbt2 = p_70037_1_.func_150295_c("ArmorDropChances", 5);
            for (int k = 0; k < listnbt2.size(); ++k) {
                this.field_184655_bs[k] = listnbt2.func_150308_e(k);
            }
        }
        if (p_70037_1_.func_150297_b("HandDropChances", 9)) {
            ListNBT listnbt3 = p_70037_1_.func_150295_c("HandDropChances", 5);
            for (int l = 0; l < listnbt3.size(); ++l) {
                this.field_82174_bp[l] = listnbt3.func_150308_e(l);
            }
        }
        if (p_70037_1_.func_150297_b("Leash", 10)) {
            this.field_110170_bx = p_70037_1_.func_74775_l("Leash");
        }
        this.func_184641_n(p_70037_1_.func_74767_n("LeftHanded"));
        if (p_70037_1_.func_150297_b("DeathLootTable", 8)) {
            this.field_184659_bA = new ResourceLocation(p_70037_1_.func_74779_i("DeathLootTable"));
            this.field_184653_bB = p_70037_1_.func_74763_f("DeathLootTableSeed");
        }
        this.func_94061_f(p_70037_1_.func_74767_n("NoAI"));
        if (p_70037_1_.func_74764_b("Bukkit.Aware")) {
            this.aware = p_70037_1_.func_74767_n("Bukkit.Aware");
        }
    }

    @Override
    protected void func_213354_a(DamageSource p_213354_1_, boolean p_213354_2_) {
        super.func_213354_a(p_213354_1_, p_213354_2_);
        this.field_184659_bA = null;
    }

    @Override
    protected LootContext.Builder func_213363_a(boolean p_213363_1_, DamageSource p_213363_2_) {
        return super.func_213363_a(p_213363_1_, p_213363_2_).func_216020_a(this.field_184653_bB, this.field_70146_Z);
    }

    @Override
    public final ResourceLocation func_213346_cF() {
        return this.field_184659_bA == null ? this.func_184647_J() : this.field_184659_bA;
    }

    public ResourceLocation func_184647_J() {
        return super.func_213346_cF();
    }

    public void func_191989_p(float p_191989_1_) {
        this.field_191988_bg = p_191989_1_;
    }

    public void func_70657_f(float p_70657_1_) {
        this.field_70701_bs = p_70657_1_;
    }

    public void func_184646_p(float p_184646_1_) {
        this.field_70702_br = p_184646_1_;
    }

    @Override
    public void func_70659_e(float p_70659_1_) {
        super.func_70659_e(p_70659_1_);
        this.func_191989_p(p_70659_1_);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.field_70170_p.func_217381_Z().func_76320_a("looting");
        if (!this.field_70170_p.field_72995_K && this.func_98052_bS() && this.func_70089_S() && !this.field_70729_aU && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            for (ItemEntity itementity : this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) {
                if (itementity.field_70128_L || itementity.func_92059_d().func_190926_b() || itementity.func_174874_s() || !this.func_230293_i_(itementity.func_92059_d())) continue;
                this.func_175445_a(itementity);
            }
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    protected void func_175445_a(ItemEntity p_175445_1_) {
        ItemStack itemstack = p_175445_1_.func_92059_d();
        if (this.equipItemIfPossible(itemstack, p_175445_1_)) {
            this.func_233630_a_(p_175445_1_);
            this.func_71001_a(p_175445_1_, itemstack.func_190916_E());
            p_175445_1_.func_70106_y();
        }
    }

    public boolean func_233665_g_(ItemStack p_233665_1_) {
        return this.equipItemIfPossible(p_233665_1_, null);
    }

    public boolean equipItemIfPossible(ItemStack p_233665_1_, ItemEntity entityitem) {
        boolean canPickup;
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(p_233665_1_);
        ItemStack itemstack = this.func_184582_a(equipmentslottype);
        boolean flag = this.func_208003_a(p_233665_1_, itemstack);
        boolean bl = canPickup = flag && this.func_175448_a(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent((Entity)this, (ItemEntity)entityitem, (int)0, (!canPickup ? 1 : 0) != 0).isCancelled();
        }
        if (canPickup) {
            double d0 = this.func_205712_c(equipmentslottype);
            if (!itemstack.func_190926_b() && (double)Math.max(this.field_70146_Z.nextFloat() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.func_199701_a_(itemstack);
                this.forceDrops = false;
            }
            this.func_233657_b_(equipmentslottype, p_233665_1_);
            this.func_184606_a_(p_233665_1_);
            return true;
        }
        return false;
    }

    protected void func_233657_b_(EquipmentSlotType p_233657_1_, ItemStack p_233657_2_) {
        this.func_184201_a(p_233657_1_, p_233657_2_);
        this.func_233663_d_(p_233657_1_);
        this.field_82179_bU = true;
    }

    public void func_233663_d_(EquipmentSlotType p_233663_1_) {
        switch (p_233663_1_.func_188453_a()) {
            case HAND: {
                this.field_82174_bp[p_233663_1_.func_188454_b()] = 2.0f;
                break;
            }
            case ARMOR: {
                this.field_184655_bs[p_233663_1_.func_188454_b()] = 2.0f;
            }
        }
    }

    protected boolean func_208003_a(ItemStack p_208003_1_, ItemStack p_208003_2_) {
        if (p_208003_2_.func_190926_b()) {
            return true;
        }
        if (p_208003_1_.func_77973_b() instanceof SwordItem) {
            if (!(p_208003_2_.func_77973_b() instanceof SwordItem)) {
                return true;
            }
            SwordItem sworditem = (SwordItem)p_208003_1_.func_77973_b();
            SwordItem sworditem1 = (SwordItem)p_208003_2_.func_77973_b();
            if (sworditem.func_200894_d() != sworditem1.func_200894_d()) {
                return sworditem.func_200894_d() > sworditem1.func_200894_d();
            }
            return this.func_233659_b_(p_208003_1_, p_208003_2_);
        }
        if (p_208003_1_.func_77973_b() instanceof BowItem && p_208003_2_.func_77973_b() instanceof BowItem) {
            return this.func_233659_b_(p_208003_1_, p_208003_2_);
        }
        if (p_208003_1_.func_77973_b() instanceof CrossbowItem && p_208003_2_.func_77973_b() instanceof CrossbowItem) {
            return this.func_233659_b_(p_208003_1_, p_208003_2_);
        }
        if (p_208003_1_.func_77973_b() instanceof ArmorItem) {
            if (EnchantmentHelper.func_190938_b(p_208003_2_)) {
                return false;
            }
            if (!(p_208003_2_.func_77973_b() instanceof ArmorItem)) {
                return true;
            }
            ArmorItem armoritem = (ArmorItem)p_208003_1_.func_77973_b();
            ArmorItem armoritem1 = (ArmorItem)p_208003_2_.func_77973_b();
            if (armoritem.func_200881_e() != armoritem1.func_200881_e()) {
                return armoritem.func_200881_e() > armoritem1.func_200881_e();
            }
            if (armoritem.func_234657_f_() != armoritem1.func_234657_f_()) {
                return armoritem.func_234657_f_() > armoritem1.func_234657_f_();
            }
            return this.func_233659_b_(p_208003_1_, p_208003_2_);
        }
        if (p_208003_1_.func_77973_b() instanceof ToolItem) {
            if (p_208003_2_.func_77973_b() instanceof BlockItem) {
                return true;
            }
            if (p_208003_2_.func_77973_b() instanceof ToolItem) {
                ToolItem toolitem = (ToolItem)((Object)p_208003_1_.func_77973_b());
                ToolItem toolitem1 = (ToolItem)((Object)p_208003_2_.func_77973_b());
                if (toolitem.func_234675_d_() != toolitem1.func_234675_d_()) {
                    return toolitem.func_234675_d_() > toolitem1.func_234675_d_();
                }
                return this.func_233659_b_(p_208003_1_, p_208003_2_);
            }
        }
        return false;
    }

    public boolean func_233659_b_(ItemStack p_233659_1_, ItemStack p_233659_2_) {
        if (p_233659_1_.func_77952_i() >= p_233659_2_.func_77952_i() && (!p_233659_1_.func_77942_o() || p_233659_2_.func_77942_o())) {
            if (p_233659_1_.func_77942_o() && p_233659_2_.func_77942_o()) {
                return p_233659_1_.func_77978_p().func_150296_c().stream().anyMatch(p_233664_0_ -> !p_233664_0_.equals("Damage")) && !p_233659_2_.func_77978_p().func_150296_c().stream().anyMatch(p_233662_0_ -> !p_233662_0_.equals("Damage"));
            }
            return false;
        }
        return true;
    }

    public boolean func_175448_a(ItemStack p_175448_1_) {
        return true;
    }

    public boolean func_230293_i_(ItemStack p_230293_1_) {
        return this.func_175448_a(p_230293_1_);
    }

    public boolean func_213397_c(double p_213397_1_) {
        return true;
    }

    public boolean func_213392_I() {
        return this.func_184218_aH();
    }

    protected boolean func_225511_J_() {
        return false;
    }

    @Override
    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_225511_J_()) {
            this.func_70106_y();
        } else if (!this.func_104002_bU() && !this.func_213392_I()) {
            PlayerEntity entity = this.field_70170_p.func_217362_a(this, -1.0);
            Event.Result result = ForgeEventFactory.canEntityDespawn((MobEntity)this);
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
                entity = null;
            } else if (result == Event.Result.ALLOW) {
                this.func_70106_y();
                entity = null;
            }
            if (entity != null) {
                int i;
                int j;
                double d0 = entity.func_70068_e(this);
                if (d0 > (double)(j = (i = this.func_200600_R().func_220339_d().func_233671_f_()) * i) && this.func_213397_c(d0)) {
                    this.func_70106_y();
                }
                int k = this.func_200600_R().func_220339_d().func_233672_g_();
                int l = k * k;
                if (this.field_70708_bq > 600 && this.field_70146_Z.nextInt(800) == 0 && d0 > (double)l && this.func_213397_c(d0)) {
                    this.func_70106_y();
                } else if (d0 < (double)l) {
                    this.field_70708_bq = 0;
                }
            }
        } else {
            this.field_70708_bq = 0;
        }
    }

    @Override
    protected final void func_70626_be() {
        ++this.field_70708_bq;
        if (!this.aware) {
            return;
        }
        this.field_70170_p.func_217381_Z().func_76320_a("sensing");
        this.field_70723_bA.func_75523_a();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("targetSelector");
        this.field_70715_bh.func_75774_a();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("goalSelector");
        this.field_70714_bg.func_75774_a();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("navigation");
        this.field_70699_by.func_75501_e();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("mob tick");
        this.func_70619_bc();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("controls");
        this.field_70170_p.func_217381_Z().func_76320_a("move");
        this.field_70765_h.func_75641_c();
        this.field_70170_p.func_217381_Z().func_219895_b("look");
        this.field_70749_g.func_75649_a();
        this.field_70170_p.func_217381_Z().func_219895_b("jump");
        this.field_70767_i.func_75661_b();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.func_213387_K();
    }

    protected void func_213387_K() {
        DebugPacketSender.func_218800_a((World)this.field_70170_p, (MobEntity)this, (GoalSelector)this.field_70714_bg);
    }

    protected void func_70619_bc() {
    }

    public int func_70646_bf() {
        return 40;
    }

    public int func_184649_cE() {
        return 75;
    }

    public int func_213396_dB() {
        return 10;
    }

    public void func_70625_a(Entity p_70625_1_, float p_70625_2_, float p_70625_3_) {
        double d1;
        double d0 = p_70625_1_.func_226277_ct_() - this.func_226277_ct_();
        double d2 = p_70625_1_.func_226281_cx_() - this.func_226281_cx_();
        if (p_70625_1_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_70625_1_;
            d1 = livingentity.func_226280_cw_() - this.func_226280_cw_();
        } else {
            d1 = (p_70625_1_.func_174813_aQ().field_72338_b + p_70625_1_.func_174813_aQ().field_72337_e) / 2.0 - this.func_226280_cw_();
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
        this.field_70125_A = this.func_70663_b(this.field_70125_A, f1, p_70625_3_);
        this.field_70177_z = this.func_70663_b(this.field_70177_z, f, p_70625_2_);
    }

    private float func_70663_b(float p_70663_1_, float p_70663_2_, float p_70663_3_) {
        float f = MathHelper.func_76142_g((float)(p_70663_2_ - p_70663_1_));
        if (f > p_70663_3_) {
            f = p_70663_3_;
        }
        if (f < -p_70663_3_) {
            f = -p_70663_3_;
        }
        return p_70663_1_ + f;
    }

    public static boolean func_223315_a(EntityType<? extends MobEntity> p_223315_0_, IWorld p_223315_1_, SpawnReason p_223315_2_, BlockPos p_223315_3_, Random p_223315_4_) {
        BlockPos blockpos = p_223315_3_.func_177977_b();
        return p_223315_2_ == SpawnReason.SPAWNER || p_223315_1_.func_180495_p(blockpos).func_215688_a((IBlockReader)((Object)p_223315_1_), blockpos, p_223315_0_);
    }

    public boolean func_213380_a(IWorld p_213380_1_, SpawnReason p_213380_2_) {
        return true;
    }

    public boolean func_205019_a(IWorldReader p_205019_1_) {
        return !p_205019_1_.func_72953_d(this.func_174813_aQ()) && p_205019_1_.func_226668_i_(this);
    }

    public int func_70641_bl() {
        return 4;
    }

    public boolean func_204209_c(int p_204209_1_) {
        return false;
    }

    @Override
    public int func_82143_as() {
        if (this.func_70638_az() == null) {
            return 3;
        }
        int i = (int)(this.func_110143_aJ() - this.func_110138_aP() * 0.33f);
        if ((i -= (3 - this.field_70170_p.func_175659_aa().func_151525_a()) * 4) < 0) {
            i = 0;
        }
        return i + 3;
    }

    @Override
    public Iterable<ItemStack> func_184214_aD() {
        return this.field_184656_bv;
    }

    @Override
    public Iterable<ItemStack> func_184193_aE() {
        return this.field_184657_bw;
    }

    @Override
    public ItemStack func_184582_a(EquipmentSlotType p_184582_1_) {
        switch (p_184582_1_.func_188453_a()) {
            case HAND: {
                return this.field_184656_bv.get(p_184582_1_.func_188454_b());
            }
            case ARMOR: {
                return this.field_184657_bw.get(p_184582_1_.func_188454_b());
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_184201_a(EquipmentSlotType p_184201_1_, ItemStack p_184201_2_) {
        switch (p_184201_1_.func_188453_a()) {
            case HAND: {
                this.field_184656_bv.set(p_184201_1_.func_188454_b(), p_184201_2_);
                break;
            }
            case ARMOR: {
                this.field_184657_bw.set(p_184201_1_.func_188454_b(), p_184201_2_);
            }
        }
    }

    @Override
    protected void func_213333_a(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        super.func_213333_a(p_213333_1_, p_213333_2_, p_213333_3_);
        for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
            boolean flag;
            ItemStack itemstack = this.func_184582_a(equipmentslottype);
            float f = this.func_205712_c(equipmentslottype);
            boolean bl = flag = f > 1.0f;
            if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c(itemstack) || !p_213333_3_ && !flag || !(Math.max(this.field_70146_Z.nextFloat() - (float)p_213333_2_ * 0.01f, 0.0f) < f)) continue;
            if (!flag && itemstack.func_77984_f()) {
                itemstack.func_196085_b(itemstack.func_77958_k() - this.field_70146_Z.nextInt(1 + this.field_70146_Z.nextInt(Math.max(itemstack.func_77958_k() - 3, 1))));
            }
            this.func_199701_a_(itemstack);
            this.func_184201_a(equipmentslottype, ItemStack.field_190927_a);
        }
    }

    protected float func_205712_c(EquipmentSlotType p_205712_1_) {
        float f;
        switch (p_205712_1_.func_188453_a()) {
            case HAND: {
                f = this.field_82174_bp[p_205712_1_.func_188454_b()];
                break;
            }
            case ARMOR: {
                f = this.field_184655_bs[p_205712_1_.func_188454_b()];
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        if (this.field_70146_Z.nextFloat() < 0.15f * p_180481_1_.func_180170_c()) {
            float f;
            int i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 0.1f : 0.25f;
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
                Item item;
                if (equipmentslottype.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(equipmentslottype);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (!itemstack.func_190926_b() || (item = MobEntity.func_184636_a(equipmentslottype, i)) == null) continue;
                this.func_184201_a(equipmentslottype, new ItemStack(item));
            }
        }
    }

    public static EquipmentSlotType func_184640_d(ItemStack p_184640_0_) {
        EquipmentSlotType slot = p_184640_0_.getEquipmentSlot();
        if (slot != null) {
            return slot;
        }
        Item item = p_184640_0_.func_77973_b();
        if (!(item == Blocks.field_196625_cS.func_199767_j() || item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof AbstractSkullBlock)) {
            if (item instanceof ArmorItem) {
                return ((ArmorItem)item).func_185083_B_();
            }
            if (item == Items.field_185160_cR) {
                return EquipmentSlotType.CHEST;
            }
            return p_184640_0_.isShield(null) ? EquipmentSlotType.OFFHAND : EquipmentSlotType.MAINHAND;
        }
        return EquipmentSlotType.HEAD;
    }

    @Nullable
    public static Item func_184636_a(EquipmentSlotType p_184636_0_, int p_184636_1_) {
        switch (p_184636_0_) {
            case HEAD: {
                if (p_184636_1_ == 0) {
                    return Items.field_151024_Q;
                }
                if (p_184636_1_ == 1) {
                    return Items.field_151169_ag;
                }
                if (p_184636_1_ == 2) {
                    return Items.field_151020_U;
                }
                if (p_184636_1_ == 3) {
                    return Items.field_151028_Y;
                }
                if (p_184636_1_ == 4) {
                    return Items.field_151161_ac;
                }
            }
            case CHEST: {
                if (p_184636_1_ == 0) {
                    return Items.field_151027_R;
                }
                if (p_184636_1_ == 1) {
                    return Items.field_151171_ah;
                }
                if (p_184636_1_ == 2) {
                    return Items.field_151023_V;
                }
                if (p_184636_1_ == 3) {
                    return Items.field_151030_Z;
                }
                if (p_184636_1_ == 4) {
                    return Items.field_151163_ad;
                }
            }
            case LEGS: {
                if (p_184636_1_ == 0) {
                    return Items.field_151026_S;
                }
                if (p_184636_1_ == 1) {
                    return Items.field_151149_ai;
                }
                if (p_184636_1_ == 2) {
                    return Items.field_151022_W;
                }
                if (p_184636_1_ == 3) {
                    return Items.field_151165_aa;
                }
                if (p_184636_1_ == 4) {
                    return Items.field_151173_ae;
                }
            }
            case FEET: {
                if (p_184636_1_ == 0) {
                    return Items.field_151021_T;
                }
                if (p_184636_1_ == 1) {
                    return Items.field_151151_aj;
                }
                if (p_184636_1_ == 2) {
                    return Items.field_151029_X;
                }
                if (p_184636_1_ == 3) {
                    return Items.field_151167_ab;
                }
                if (p_184636_1_ != 4) break;
                return Items.field_151175_af;
            }
        }
        return null;
    }

    protected void func_180483_b(DifficultyInstance p_180483_1_) {
        float f = p_180483_1_.func_180170_c();
        this.func_241844_w(f);
        for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
            if (equipmentslottype.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
            this.func_242289_a(f, equipmentslottype);
        }
    }

    protected void func_241844_w(float p_241844_1_) {
        if (!this.func_184614_ca().func_190926_b() && this.field_70146_Z.nextFloat() < 0.25f * p_241844_1_) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, EnchantmentHelper.func_77504_a(this.field_70146_Z, this.func_184614_ca(), (int)(5.0f + p_241844_1_ * (float)this.field_70146_Z.nextInt(18)), false));
        }
    }

    protected void func_242289_a(float p_242289_1_, EquipmentSlotType p_242289_2_) {
        ItemStack itemstack = this.func_184582_a(p_242289_2_);
        if (!itemstack.func_190926_b() && this.field_70146_Z.nextFloat() < 0.5f * p_242289_1_) {
            this.func_184201_a(p_242289_2_, EnchantmentHelper.func_77504_a(this.field_70146_Z, itemstack, (int)(5.0f + p_242289_1_ * (float)this.field_70146_Z.nextInt(18)), false));
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        this.func_110148_a(Attributes.field_233819_b_).func_233769_c_(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        return p_213386_4_;
    }

    public boolean func_82171_bF() {
        return false;
    }

    public void func_110163_bv() {
        this.field_82179_bU = true;
    }

    public void func_184642_a(EquipmentSlotType p_184642_1_, float p_184642_2_) {
        switch (p_184642_1_.func_188453_a()) {
            case HAND: {
                this.field_82174_bp[p_184642_1_.func_188454_b()] = p_184642_2_;
                break;
            }
            case ARMOR: {
                this.field_184655_bs[p_184642_1_.func_188454_b()] = p_184642_2_;
            }
        }
    }

    public boolean func_98052_bS() {
        return this.canPickUpLoot;
    }

    public void func_98053_h(boolean p_98053_1_) {
        this.canPickUpLoot = p_98053_1_;
    }

    @Override
    public boolean func_213365_e(ItemStack p_213365_1_) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(p_213365_1_);
        return this.func_184582_a(equipmentslottype).func_190926_b() && this.func_98052_bS();
    }

    public boolean func_104002_bU() {
        return this.field_82179_bU;
    }

    @Override
    public final ActionResultType func_184230_a(PlayerEntity p_184230_1_, Hand p_184230_2_) {
        if (!this.func_70089_S()) {
            return ActionResultType.PASS;
        }
        if (this.func_110166_bE() == p_184230_1_) {
            if (CraftEventFactory.callPlayerUnleashEntityEvent((MobEntity)this, (PlayerEntity)p_184230_1_).isCancelled()) {
                ((ServerPlayerEntity)p_184230_1_).field_71135_a.func_147359_a((IPacket<?>)new SMountEntityPacket((Entity)this, this.func_110166_bE()));
                return ActionResultType.PASS;
            }
            this.func_110160_i(true, !p_184230_1_.field_71075_bZ.field_75098_d);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        ActionResultType actionresulttype = this.func_233661_c_(p_184230_1_, p_184230_2_);
        if (actionresulttype.func_226246_a_()) {
            return actionresulttype;
        }
        actionresulttype = this.func_230254_b_(p_184230_1_, p_184230_2_);
        return actionresulttype.func_226246_a_() ? actionresulttype : super.func_184230_a(p_184230_1_, p_184230_2_);
    }

    private ActionResultType func_233661_c_(PlayerEntity p_233661_1_, Hand p_233661_2_) {
        ActionResultType actionresulttype;
        ItemStack itemstack = p_233661_1_.func_184586_b(p_233661_2_);
        if (itemstack.func_77973_b() == Items.field_151058_ca && this.func_184652_a(p_233661_1_)) {
            if (CraftEventFactory.callPlayerLeashEntityEvent((MobEntity)this, (Entity)p_233661_1_, (PlayerEntity)p_233661_1_).isCancelled()) {
                ((ServerPlayerEntity)p_233661_1_).field_71135_a.func_147359_a((IPacket<?>)new SMountEntityPacket((Entity)this, this.func_110166_bE()));
                return ActionResultType.PASS;
            }
            this.func_110162_b(p_233661_1_, true);
            itemstack.func_190918_g(1);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (itemstack.func_77973_b() == Items.field_151057_cb && (actionresulttype = itemstack.func_111282_a_(p_233661_1_, this, p_233661_2_)).func_226246_a_()) {
            return actionresulttype;
        }
        if (itemstack.func_77973_b() instanceof SpawnEggItem) {
            if (this.field_70170_p instanceof ServerWorld) {
                SpawnEggItem spawneggitem = (SpawnEggItem)itemstack.func_77973_b();
                Optional<MobEntity> optional = spawneggitem.func_234809_a_(p_233661_1_, this, this.func_200600_R(), (ServerWorld)this.field_70170_p, this.func_213303_ch(), itemstack);
                optional.ifPresent(p_233658_2_ -> this.func_213406_a(p_233661_1_, (MobEntity)p_233658_2_));
                return optional.isPresent() ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    protected void func_213406_a(PlayerEntity p_213406_1_, MobEntity p_213406_2_) {
    }

    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        return ActionResultType.PASS;
    }

    public boolean func_213383_dH() {
        return this.func_213389_a(this.func_233580_cy_());
    }

    public boolean func_213389_a(BlockPos p_213389_1_) {
        if (this.field_213402_bL == -1.0f) {
            return true;
        }
        return this.field_213401_bK.func_177951_i(p_213389_1_) < (double)(this.field_213402_bL * this.field_213402_bL);
    }

    public void func_213390_a(BlockPos p_213390_1_, int p_213390_2_) {
        this.field_213401_bK = p_213390_1_;
        this.field_213402_bL = p_213390_2_;
    }

    public BlockPos func_213384_dI() {
        return this.field_213401_bK;
    }

    public float func_213391_dJ() {
        return this.field_213402_bL;
    }

    public boolean func_213394_dL() {
        return this.field_213402_bL != -1.0f;
    }

    @Nullable
    public <T extends MobEntity> T func_233656_b_(EntityType<T> p_233656_1_, boolean p_233656_2_) {
        return this.convertTo(p_233656_1_, p_233656_2_, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends MobEntity> T convertTo(EntityType<T> p_233656_1_, boolean p_233656_2_, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.field_70128_L) {
            return (T)((MobEntity)null);
        }
        MobEntity t = (MobEntity)p_233656_1_.func_200721_a(this.field_70170_p);
        t.func_82149_j(this);
        t.func_98053_h(this.func_98052_bS());
        t.func_82227_f(this.func_70631_g_());
        t.func_94061_f(this.func_175446_cd());
        if (this.func_145818_k_()) {
            t.func_200203_b(this.func_200201_e());
            t.func_174805_g(this.func_174833_aM());
        }
        if (this.func_104002_bU()) {
            t.func_110163_bv();
        }
        t.func_184224_h(this.func_190530_aW());
        if (p_233656_2_) {
            t.func_98053_h(this.func_98052_bS());
            for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
                ItemStack itemstack = this.func_184582_a(equipmentslottype);
                if (itemstack.func_190926_b()) continue;
                t.func_184201_a(equipmentslottype, itemstack.func_77946_l());
                t.func_184642_a(equipmentslottype, this.func_205712_c(equipmentslottype));
                itemstack.func_190920_e(0);
            }
        }
        if (CraftEventFactory.callEntityTransformEvent((LivingEntity)this, (LivingEntity)t, (EntityTransformEvent.TransformReason)transformReason).isCancelled()) {
            return null;
        }
        this.field_70170_p.addEntity(t, spawnReason);
        if (this.func_184218_aH()) {
            Entity entity = this.func_184187_bx();
            this.func_184210_p();
            t.func_184205_a(entity, true);
        }
        this.func_70106_y();
        return (T)t;
    }

    protected void func_110159_bB() {
        if (this.field_110170_bx != null) {
            this.func_110165_bF();
        }
        if (!(this.field_110168_bw == null || this.func_70089_S() && this.field_110168_bw.func_70089_S())) {
            this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), !this.func_70089_S() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE));
            this.func_110160_i(true, true);
        }
    }

    public void func_110160_i(boolean p_110160_1_, boolean p_110160_2_) {
        if (this.field_110168_bw != null) {
            this.field_98038_p = false;
            if (!(this.field_110168_bw instanceof PlayerEntity)) {
                this.field_110168_bw.field_98038_p = false;
            }
            this.field_110168_bw = null;
            this.field_110170_bx = null;
            if (!this.field_70170_p.field_72995_K && p_110160_2_) {
                this.forceDrops = true;
                this.func_199703_a(Items.field_151058_ca);
                this.forceDrops = false;
            }
            if (!this.field_70170_p.field_72995_K && p_110160_1_ && this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b(this, (IPacket<?>)new SMountEntityPacket((Entity)this, (Entity)null));
            }
        }
    }

    public boolean func_184652_a(PlayerEntity p_184652_1_) {
        return !this.func_110167_bD() && !(this instanceof IMob);
    }

    public boolean func_110167_bD() {
        return this.field_110168_bw != null;
    }

    @Nullable
    public Entity func_110166_bE() {
        if (this.field_110168_bw == null && this.field_213400_bI != 0 && this.field_70170_p.field_72995_K) {
            this.field_110168_bw = this.field_70170_p.func_73045_a(this.field_213400_bI);
        }
        return this.field_110168_bw;
    }

    public void func_110162_b(Entity p_110162_1_, boolean p_110162_2_) {
        this.field_110168_bw = p_110162_1_;
        this.field_110170_bx = null;
        this.field_98038_p = true;
        if (!(this.field_110168_bw instanceof PlayerEntity)) {
            this.field_110168_bw.field_98038_p = true;
        }
        if (!this.field_70170_p.field_72995_K && p_110162_2_ && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b(this, (IPacket<?>)new SMountEntityPacket((Entity)this, this.field_110168_bw));
        }
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_213381_d(int p_213381_1_) {
        this.field_213400_bI = p_213381_1_;
        this.func_110160_i(false, false);
    }

    @Override
    public boolean func_184205_a(Entity p_184205_1_, boolean p_184205_2_) {
        boolean flag = super.func_184205_a(p_184205_1_, p_184205_2_);
        if (flag && this.func_110167_bD()) {
            this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            this.func_110160_i(true, true);
        }
        return flag;
    }

    private void func_110165_bF() {
        if (this.field_110170_bx != null && this.field_70170_p instanceof ServerWorld) {
            if (this.field_110170_bx.func_186855_b("UUID")) {
                UUID uuid = this.field_110170_bx.func_186857_a("UUID");
                Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(uuid);
                if (entity != null) {
                    this.func_110162_b(entity, true);
                    return;
                }
            } else if (this.field_110170_bx.func_150297_b("X", 99) && this.field_110170_bx.func_150297_b("Y", 99) && this.field_110170_bx.func_150297_b("Z", 99)) {
                BlockPos blockpos = new BlockPos(this.field_110170_bx.func_74762_e("X"), this.field_110170_bx.func_74762_e("Y"), this.field_110170_bx.func_74762_e("Z"));
                this.func_110162_b(LeashKnotEntity.func_213855_a(this.field_70170_p, blockpos), true);
                return;
            }
            if (this.field_70173_aa > 100) {
                this.func_199703_a(Items.field_151058_ca);
                this.field_110170_bx = null;
            }
        }
    }

    @Override
    public boolean func_174820_d(int p_174820_1_, ItemStack p_174820_2_) {
        EquipmentSlotType equipmentslottype;
        if (p_174820_1_ == 98) {
            equipmentslottype = EquipmentSlotType.MAINHAND;
        } else if (p_174820_1_ == 99) {
            equipmentslottype = EquipmentSlotType.OFFHAND;
        } else if (p_174820_1_ == 100 + EquipmentSlotType.HEAD.func_188454_b()) {
            equipmentslottype = EquipmentSlotType.HEAD;
        } else if (p_174820_1_ == 100 + EquipmentSlotType.CHEST.func_188454_b()) {
            equipmentslottype = EquipmentSlotType.CHEST;
        } else if (p_174820_1_ == 100 + EquipmentSlotType.LEGS.func_188454_b()) {
            equipmentslottype = EquipmentSlotType.LEGS;
        } else {
            if (p_174820_1_ != 100 + EquipmentSlotType.FEET.func_188454_b()) {
                return false;
            }
            equipmentslottype = EquipmentSlotType.FEET;
        }
        if (!p_174820_2_.func_190926_b() && !MobEntity.func_184648_b(equipmentslottype, p_174820_2_) && equipmentslottype != EquipmentSlotType.HEAD) {
            return false;
        }
        this.func_184201_a(equipmentslottype, p_174820_2_);
        return true;
    }

    @Override
    public boolean func_184186_bw() {
        return this.func_82171_bF() && super.func_184186_bw();
    }

    public static boolean func_184648_b(EquipmentSlotType p_184648_0_, ItemStack p_184648_1_) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(p_184648_1_);
        return equipmentslottype == p_184648_0_ || equipmentslottype == EquipmentSlotType.MAINHAND && p_184648_0_ == EquipmentSlotType.OFFHAND || equipmentslottype == EquipmentSlotType.OFFHAND && p_184648_0_ == EquipmentSlotType.MAINHAND;
    }

    @Override
    public boolean func_70613_aW() {
        return super.func_70613_aW() && !this.func_175446_cd();
    }

    public void func_94061_f(boolean p_94061_1_) {
        byte b0 = this.field_70180_af.func_187225_a(field_184654_a);
        this.field_70180_af.func_187227_b(field_184654_a, p_94061_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void func_184641_n(boolean p_184641_1_) {
        byte b0 = this.field_70180_af.func_187225_a(field_184654_a);
        this.field_70180_af.func_187227_b(field_184654_a, p_184641_1_ ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void func_213395_q(boolean p_213395_1_) {
        byte b0 = this.field_70180_af.func_187225_a(field_184654_a);
        this.field_70180_af.func_187227_b(field_184654_a, p_213395_1_ ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean func_175446_cd() {
        return (this.field_70180_af.func_187225_a(field_184654_a) & 1) != 0;
    }

    public boolean func_184638_cS() {
        return (this.field_70180_af.func_187225_a(field_184654_a) & 2) != 0;
    }

    public boolean func_213398_dR() {
        return (this.field_70180_af.func_187225_a(field_184654_a) & 4) != 0;
    }

    public void func_82227_f(boolean p_82227_1_) {
    }

    @Override
    public HandSide func_184591_cq() {
        return this.func_184638_cS() ? HandSide.LEFT : HandSide.RIGHT;
    }

    @Override
    public boolean func_213336_c(LivingEntity p_213336_1_) {
        return p_213336_1_.func_200600_R() == EntityType.field_200729_aH && ((PlayerEntity)p_213336_1_).field_71075_bZ.field_75102_a ? false : super.func_213336_c(p_213336_1_);
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        boolean flag;
        int i;
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (p_70652_1_ instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a(this.func_184614_ca(), ((LivingEntity)p_70652_1_).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a(this);
        }
        if ((i = EnchantmentHelper.func_90036_a(this)) > 0) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)p_70652_1_.getBukkitEntity(), i * 4);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                p_70652_1_.setFire(combustEvent.getDuration(), false);
            }
        }
        if (flag = p_70652_1_.func_70097_a(DamageSource.func_76358_a(this), f)) {
            if (f1 > 0.0f && p_70652_1_ instanceof LivingEntity) {
                ((LivingEntity)p_70652_1_).func_233627_a_(f1 * 0.5f, MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (p_70652_1_ instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)p_70652_1_;
                this.func_233655_a_(playerentity, this.func_184614_ca(), playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a);
            }
            this.func_174815_a(this, p_70652_1_);
            this.func_130011_c(p_70652_1_);
        }
        return flag;
    }

    private void func_233655_a_(PlayerEntity p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.func_190926_b() && !p_233655_3_.func_190926_b() && p_233655_2_.func_77973_b() instanceof AxeItem && p_233655_3_.func_77973_b() == Items.field_185159_cQ) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e(this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                p_233655_1_.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                this.field_70170_p.func_72960_a(p_233655_1_, (byte)30);
            }
        }
    }

    protected boolean func_204609_dp() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            BlockPos blockpos;
            float f = this.func_70013_c();
            BlockPos blockPos = blockpos = this.func_184187_bx() instanceof BoatEntity ? new BlockPos(this.func_226277_ct_(), Math.round(this.func_226278_cu_()), this.func_226281_cx_()).func_177984_a() : new BlockPos(this.func_226277_ct_(), Math.round(this.func_226278_cu_()), this.func_226281_cx_());
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_226660_f_(blockpos)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void func_180466_bG(ITag<Fluid> p_180466_1_) {
        if (this.func_70661_as().func_212238_t()) {
            super.func_180466_bG(p_180466_1_);
        } else {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.3, 0.0));
        }
    }

    @Override
    protected void func_241204_bJ_() {
        super.func_241204_bJ_();
        this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
        this.func_110160_i(true, false);
    }
}

