/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

public class FallingBlockEntity
extends Entity {
    private BlockState field_175132_d = Blocks.field_150354_m.func_176223_P();
    public int field_145812_b;
    public boolean field_145813_c = true;
    private boolean field_145808_f;
    public boolean field_145809_g;
    private int field_145815_h = 40;
    private float field_145816_i = 2.0f;
    public CompoundNBT field_145810_d;
    protected static final DataParameter<BlockPos> field_184532_d = EntityDataManager.func_187226_a(FallingBlockEntity.class, DataSerializers.field_187200_j);

    public FallingBlockEntity(EntityType<? extends FallingBlockEntity> p_i50218_1_, World p_i50218_2_) {
        super(p_i50218_1_, p_i50218_2_);
    }

    public FallingBlockEntity(World p_i45848_1_, double p_i45848_2_, double p_i45848_4_, double p_i45848_6_, BlockState p_i45848_8_) {
        this((EntityType<? extends FallingBlockEntity>)EntityType.field_200809_w, p_i45848_1_);
        this.field_175132_d = p_i45848_8_;
        this.field_70156_m = true;
        this.func_70107_b(p_i45848_2_, p_i45848_4_ + (double)((1.0f - this.func_213302_cg()) / 2.0f), p_i45848_6_);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = p_i45848_2_;
        this.field_70167_r = p_i45848_4_;
        this.field_70166_s = p_i45848_6_;
        this.func_184530_a(this.func_233580_cy_());
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    public void func_184530_a(BlockPos p_184530_1_) {
        this.field_70180_af.func_187227_b(field_184532_d, p_184530_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos func_184531_j() {
        return this.field_70180_af.func_187225_a(field_184532_d);
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184532_d, BlockPos.field_177992_a);
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70128_L) {
            return;
        }
        if (this.field_175132_d.func_196958_f()) {
            this.func_70106_y();
        } else {
            Block block = this.field_175132_d.func_177230_c();
            if (this.field_145812_b++ == 0) {
                BlockPos blockpos = this.func_233580_cy_();
                if (this.field_70170_p.func_180495_p(blockpos).func_203425_a(block) && !CraftEventFactory.callEntityChangeBlockEvent((Entity)this, (BlockPos)blockpos, (BlockState)Blocks.field_150350_a.func_176223_P()).isCancelled()) {
                    this.field_70170_p.func_217377_a(blockpos, false);
                } else if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                    return;
                }
            }
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (this.field_70128_L) {
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                BlockRayTraceResult blockraytraceresult;
                BlockPos blockpos1 = this.func_233580_cy_();
                boolean flag = this.field_175132_d.func_177230_c() instanceof ConcretePowderBlock;
                boolean flag1 = flag && this.field_70170_p.func_204610_c(blockpos1).func_206884_a(FluidTags.field_206959_a);
                double d0 = this.func_213322_ci().func_189985_c();
                if (flag && d0 > 1.0 && (blockraytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.field_70169_q, this.field_70167_r, this.field_70166_s), this.func_213303_ch(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, this))).func_216346_c() != RayTraceResult.Type.MISS && this.field_70170_p.func_204610_c(blockraytraceresult.func_216350_a()).func_206884_a(FluidTags.field_206959_a)) {
                    blockpos1 = blockraytraceresult.func_216350_a();
                    flag1 = true;
                }
                if (!this.field_70122_E && !flag1) {
                    if (!(this.field_70170_p.field_72995_K || (this.field_145812_b <= 100 || blockpos1.func_177956_o() >= 1 && blockpos1.func_177956_o() <= 256) && this.field_145812_b <= 600)) {
                        if (this.field_145813_c && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.func_199703_a(block);
                        }
                        this.func_70106_y();
                    }
                } else {
                    BlockState blockstate = this.field_70170_p.func_180495_p(blockpos1);
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
                    if (!blockstate.func_203425_a(Blocks.field_196603_bb)) {
                        this.func_70106_y();
                        if (!this.field_145808_f) {
                            boolean flag4;
                            boolean flag2 = blockstate.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(this.field_70170_p, blockpos1, Direction.DOWN, ItemStack.field_190927_a, Direction.UP));
                            boolean flag3 = FallingBlock.func_185759_i(this.field_70170_p.func_180495_p(blockpos1.func_177977_b())) && (!flag || !flag1);
                            boolean bl = flag4 = this.field_175132_d.func_196955_c((IWorldReader)((Object)this.field_70170_p), blockpos1) && !flag3;
                            if (flag2 && flag4) {
                                if (this.field_175132_d.func_235901_b_(BlockStateProperties.field_208198_y) && this.field_70170_p.func_204610_c(blockpos1).func_206886_c() == Fluids.field_204546_a) {
                                    this.field_175132_d = (BlockState)this.field_175132_d.func_206870_a(BlockStateProperties.field_208198_y, true);
                                }
                                if (CraftEventFactory.callEntityChangeBlockEvent((Entity)this, (BlockPos)blockpos1, (BlockState)this.field_175132_d).isCancelled()) {
                                    return;
                                }
                                if (this.field_70170_p.func_180501_a(blockpos1, this.field_175132_d, 3)) {
                                    TileEntity tileentity;
                                    if (block instanceof FallingBlock) {
                                        ((FallingBlock)block).func_176502_a_(this.field_70170_p, blockpos1, this.field_175132_d, blockstate, this);
                                    }
                                    if (this.field_145810_d != null && this.field_175132_d.hasTileEntity() && (tileentity = this.field_70170_p.func_175625_s(blockpos1)) != null) {
                                        CompoundNBT compoundnbt = tileentity.func_189515_b(new CompoundNBT());
                                        for (String s : this.field_145810_d.func_150296_c()) {
                                            INBT inbt = this.field_145810_d.func_74781_a(s);
                                            if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                                            compoundnbt.func_218657_a(s, inbt.func_74737_b());
                                        }
                                        tileentity.func_230337_a_(this.field_175132_d, compoundnbt);
                                        tileentity.func_70296_d();
                                    }
                                } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                                    this.func_199703_a(block);
                                }
                            } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                                this.func_199703_a(block);
                            }
                        } else if (block instanceof FallingBlock) {
                            ((FallingBlock)block).func_190974_b(this.field_70170_p, blockpos1, this);
                        }
                    }
                }
            }
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        }
    }

    @Override
    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        int i;
        if (this.field_145809_g && (i = MathHelper.func_76123_f((float)(p_225503_1_ - 1.0f))) > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b(this, this.func_174813_aQ()));
            boolean flag = this.field_175132_d.func_235714_a_(BlockTags.field_200572_k);
            DamageSource damagesource = flag ? DamageSource.field_82728_o : DamageSource.field_82729_p;
            for (Entity entity : list) {
                CraftEventFactory.entityDamage = this;
                entity.func_70097_a(damagesource, Math.min(MathHelper.func_76141_d((float)((float)i * this.field_145816_i)), this.field_145815_h));
                CraftEventFactory.entityDamage = null;
            }
            if (flag && (double)this.field_70146_Z.nextFloat() < (double)0.05f + (double)i * 0.05) {
                BlockState blockstate = AnvilBlock.func_196433_f((BlockState)this.field_175132_d);
                if (blockstate == null) {
                    this.field_145808_f = true;
                } else {
                    this.field_175132_d = blockstate;
                }
            }
        }
        return false;
    }

    @Override
    protected void func_213281_b(CompoundNBT p_213281_1_) {
        p_213281_1_.func_218657_a("BlockState", NBTUtil.func_190009_a(this.field_175132_d));
        p_213281_1_.func_74768_a("Time", this.field_145812_b);
        p_213281_1_.func_74757_a("DropItem", this.field_145813_c);
        p_213281_1_.func_74757_a("HurtEntities", this.field_145809_g);
        p_213281_1_.func_74776_a("FallHurtAmount", this.field_145816_i);
        p_213281_1_.func_74768_a("FallHurtMax", this.field_145815_h);
        if (this.field_145810_d != null) {
            p_213281_1_.func_218657_a("TileEntityData", this.field_145810_d);
        }
    }

    @Override
    protected void func_70037_a(CompoundNBT p_70037_1_) {
        this.field_175132_d = NBTUtil.func_190008_d(p_70037_1_.func_74775_l("BlockState"));
        this.field_145812_b = p_70037_1_.func_74762_e("Time");
        if (p_70037_1_.func_150297_b("HurtEntities", 99)) {
            this.field_145809_g = p_70037_1_.func_74767_n("HurtEntities");
            this.field_145816_i = p_70037_1_.func_74760_g("FallHurtAmount");
            this.field_145815_h = p_70037_1_.func_74762_e("FallHurtMax");
        } else if (this.field_175132_d.func_235714_a_(BlockTags.field_200572_k)) {
            this.field_145809_g = true;
        }
        if (p_70037_1_.func_150297_b("DropItem", 99)) {
            this.field_145813_c = p_70037_1_.func_74767_n("DropItem");
        }
        if (p_70037_1_.func_150297_b("TileEntityData", 10)) {
            this.field_145810_d = p_70037_1_.func_74775_l("TileEntityData");
        }
        if (this.field_175132_d.func_196958_f()) {
            this.field_175132_d = Blocks.field_150354_m.func_176223_P();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public World func_145807_e() {
        return this.field_70170_p;
    }

    public void func_145806_a(boolean p_145806_1_) {
        this.field_145809_g = p_145806_1_;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    @Override
    public void func_85029_a(CrashReportCategory p_85029_1_) {
        super.func_85029_a(p_85029_1_);
        p_85029_1_.func_71507_a("Immitating BlockState", this.field_175132_d.toString());
    }

    public BlockState func_195054_l() {
        return this.field_175132_d;
    }

    @Override
    public boolean func_184213_bq() {
        return true;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this, Block.func_196246_j(this.func_195054_l()));
    }
}

