/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class ItemEntity
extends Entity {
    private static final DataParameter<ItemStack> field_184533_c = EntityDataManager.func_187226_a(ItemEntity.class, DataSerializers.field_187196_f);
    public int field_70292_b;
    public int field_145804_b;
    private int field_70291_e = 5;
    private UUID field_145801_f;
    private UUID field_145802_g;
    public final float field_70290_d;
    public int lifespan = 6000;
    private int lastTick = MinecraftServer.currentTick - 1;
    private static final double[] vanillaMergeRadius = new double[]{0.5};

    public ItemEntity(EntityType<? extends ItemEntity> p_i50217_1_, World p_i50217_2_) {
        super(p_i50217_1_, p_i50217_2_);
        this.field_70290_d = (float)(Math.random() * Math.PI * 2.0);
    }

    public ItemEntity(World p_i1709_1_, double p_i1709_2_, double p_i1709_4_, double p_i1709_6_) {
        this((EntityType<? extends ItemEntity>)EntityType.field_200765_E, p_i1709_1_);
        this.func_70107_b(p_i1709_2_, p_i1709_4_, p_i1709_6_);
        this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
        this.func_213293_j(this.field_70146_Z.nextDouble() * 0.2 - 0.1, 0.2, this.field_70146_Z.nextDouble() * 0.2 - 0.1);
    }

    public ItemEntity(World p_i1710_1_, double p_i1710_2_, double p_i1710_4_, double p_i1710_6_, ItemStack p_i1710_8_) {
        this(p_i1710_1_, p_i1710_2_, p_i1710_4_, p_i1710_6_);
        this.func_92058_a(p_i1710_8_);
        this.lifespan = p_i1710_8_.func_77973_b() == null ? 6000 : p_i1710_8_.getEntityLifespan(p_i1710_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private ItemEntity(ItemEntity p_i231561_1_) {
        super(p_i231561_1_.func_200600_R(), p_i231561_1_.field_70170_p);
        this.func_92058_a(p_i231561_1_.func_92059_d().func_77946_l());
        this.func_82149_j(p_i231561_1_);
        this.field_70292_b = p_i231561_1_.field_70292_b;
        this.field_70290_d = p_i231561_1_.field_70290_d;
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184533_c, ItemStack.field_190927_a);
    }

    @Override
    public void func_70071_h_() {
        if (this.func_92059_d().onEntityItemUpdate(this)) {
            return;
        }
        if (this.func_92059_d().func_190926_b()) {
            this.func_70106_y();
        } else {
            double d0;
            int i;
            super.func_70071_h_();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.field_145804_b != Short.MAX_VALUE) {
                this.field_145804_b -= elapsedTicks;
            }
            if (this.field_70292_b != Short.MIN_VALUE) {
                this.field_70292_b += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.field_70169_q = this.func_226277_ct_();
            this.field_70167_r = this.func_226278_cu_();
            this.field_70166_s = this.func_226281_cx_();
            Vector3d vector3d = this.func_213322_ci();
            float f = this.func_70047_e() - 0.11111111f;
            if (this.func_70090_H() && this.func_233571_b_(FluidTags.field_206959_a) > (double)f) {
                this.func_203043_v();
            } else if (this.func_180799_ab() && this.func_233571_b_(FluidTags.field_206960_b) > (double)f) {
                this.func_234274_v_();
            } else if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            if (this.field_70170_p.field_72995_K) {
                this.field_70145_X = false;
            } else {
                boolean bl = this.field_70145_X = !this.field_70170_p.func_226669_j_(this);
                if (this.field_70145_X) {
                    this.func_213282_i(this.func_226277_ct_(), (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.func_226281_cx_());
                }
            }
            if (!this.field_70122_E || ItemEntity.func_213296_b(this.func_213322_ci()) > (double)1.0E-5f || this.field_70173_aa % 4 == 0) {
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                float f1 = 0.98f;
                if (this.field_70122_E) {
                    f1 = this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_())).getSlipperiness((IWorldReader)((Object)this.field_70170_p), new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_()), this) * 0.98f;
                }
                this.func_213317_d(this.func_213322_ci().func_216372_d(f1, 0.98, f1));
                if (this.field_70122_E) {
                    Vector3d vector3d1 = this.func_213322_ci();
                    if (vector3d1.field_72448_b < 0.0) {
                        this.func_213317_d(vector3d1.func_216372_d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.func_76128_c((double)this.field_70169_q) != MathHelper.func_76128_c((double)this.func_226277_ct_()) || MathHelper.func_76128_c((double)this.field_70167_r) != MathHelper.func_76128_c((double)this.func_226278_cu_()) || MathHelper.func_76128_c((double)this.field_70166_s) != MathHelper.func_76128_c((double)this.func_226281_cx_());
            int n = i = flag ? 2 : 40;
            if (this.field_70173_aa % i == 0) {
                if (this.field_70170_p.func_204610_c(this.func_233580_cy_()).func_206884_a(FluidTags.field_206960_b) && !this.func_230279_az_()) {
                    this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
                }
                if (!this.field_70170_p.field_72995_K && this.func_213857_z()) {
                    this.func_85054_d();
                }
            }
            this.field_70160_al |= this.func_233566_aG_();
            if (!this.field_70170_p.field_72995_K && (d0 = this.func_213322_ci().func_178788_d(vector3d).func_189985_c()) > 0.01) {
                this.field_70160_al = true;
            }
            ItemStack item = this.func_92059_d();
            if (!this.field_70170_p.field_72995_K && this.field_70292_b >= this.field_70170_p.spigotConfig.itemDespawnRate) {
                if (CraftEventFactory.callItemDespawnEvent((ItemEntity)this).isCancelled()) {
                    this.field_70292_b = 0;
                    return;
                }
                int hook = ForgeEventFactory.onItemExpire((ItemEntity)this, (ItemStack)item);
                if (hook < 0) {
                    this.func_70106_y();
                } else {
                    this.lifespan += hook;
                }
            }
            if (item.func_190926_b()) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public void inactiveTick() {
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        if (this.field_145804_b != Short.MAX_VALUE) {
            this.field_145804_b -= elapsedTicks;
        }
        if (this.field_70292_b != Short.MIN_VALUE) {
            this.field_70292_b += elapsedTicks;
        }
        this.lastTick = MinecraftServer.currentTick;
        if (!this.field_70170_p.field_72995_K && this.field_70292_b >= this.field_70170_p.spigotConfig.itemDespawnRate) {
            if (CraftEventFactory.callItemDespawnEvent((ItemEntity)this).isCancelled()) {
                this.field_70292_b = 0;
                return;
            }
            this.func_70106_y();
        }
    }

    private void func_203043_v() {
        Vector3d vector3d = this.func_213322_ci();
        this.func_213293_j(vector3d.field_72450_a * (double)0.99f, vector3d.field_72448_b + (double)(vector3d.field_72448_b < (double)0.06f ? 5.0E-4f : 0.0f), vector3d.field_72449_c * (double)0.99f);
    }

    private void func_234274_v_() {
        Vector3d vector3d = this.func_213322_ci();
        this.func_213293_j(vector3d.field_72450_a * (double)0.95f, vector3d.field_72448_b + (double)(vector3d.field_72448_b < (double)0.06f ? 5.0E-4f : 0.0f), vector3d.field_72449_c * (double)0.95f);
    }

    private void func_85054_d() {
        if (this.func_213857_z()) {
            double pehkuiRadius = 0.5;
            double radius = pehkuiRadius == vanillaMergeRadius[0] ? this.field_70170_p.spigotConfig.itemMerge : pehkuiRadius;
            for (ItemEntity itementity : this.field_70170_p.func_175647_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(radius, radius, radius), p_213859_1_ -> p_213859_1_ != this && p_213859_1_.func_213857_z())) {
                if (!itementity.func_213857_z()) continue;
                this.func_226530_a_(itementity);
                if (!this.field_70128_L) continue;
                break;
            }
        }
    }

    private boolean func_213857_z() {
        ItemStack itemstack = this.func_92059_d();
        return this.func_70089_S() && this.field_145804_b != Short.MAX_VALUE && this.field_70292_b != Short.MIN_VALUE && this.field_70292_b < 6000 && itemstack.func_190916_E() < itemstack.func_77976_d();
    }

    private void func_226530_a_(ItemEntity p_226530_1_) {
        ItemStack itemstack = this.func_92059_d();
        ItemStack itemstack1 = p_226530_1_.func_92059_d();
        if (Objects.equals(this.func_200215_l(), p_226530_1_.func_200215_l()) && ItemEntity.func_226532_a_(itemstack, itemstack1)) {
            if (itemstack1.func_190916_E() < itemstack.func_190916_E()) {
                ItemEntity.func_213858_a(this, itemstack, p_226530_1_, itemstack1);
            } else {
                ItemEntity.func_213858_a(p_226530_1_, itemstack1, this, itemstack);
            }
        }
    }

    public static boolean func_226532_a_(ItemStack p_226532_0_, ItemStack p_226532_1_) {
        if (p_226532_1_.func_77973_b() != p_226532_0_.func_77973_b()) {
            return false;
        }
        if (p_226532_1_.func_190916_E() + p_226532_0_.func_190916_E() > p_226532_1_.func_77976_d()) {
            return false;
        }
        if (p_226532_1_.func_77942_o() ^ p_226532_0_.func_77942_o()) {
            return false;
        }
        if (!p_226532_0_.areCapsCompatible(p_226532_1_)) {
            return false;
        }
        return !p_226532_1_.func_77942_o() || p_226532_1_.func_77978_p().equals(p_226532_0_.func_77978_p());
    }

    public static ItemStack func_226533_a_(ItemStack p_226533_0_, ItemStack p_226533_1_, int p_226533_2_) {
        int i = Math.min(Math.min(p_226533_0_.func_77976_d(), p_226533_2_) - p_226533_0_.func_190916_E(), p_226533_1_.func_190916_E());
        ItemStack itemstack = p_226533_0_.func_77946_l();
        itemstack.func_190917_f(i);
        p_226533_1_.func_190918_g(i);
        return itemstack;
    }

    private static void func_226531_a_(ItemEntity p_226531_0_, ItemStack p_226531_1_, ItemStack p_226531_2_) {
        ItemStack itemstack = ItemEntity.func_226533_a_(p_226531_1_, p_226531_2_, 64);
        if (!itemstack.func_190926_b()) {
            p_226531_0_.func_92058_a(itemstack);
        }
    }

    private static void func_213858_a(ItemEntity p_213858_0_, ItemStack p_213858_1_, ItemEntity p_213858_2_, ItemStack p_213858_3_) {
        if (CraftEventFactory.callItemMergeEvent((ItemEntity)p_213858_2_, (ItemEntity)p_213858_0_).isCancelled()) {
            return;
        }
        ItemEntity.func_226531_a_(p_213858_0_, p_213858_1_, p_213858_3_);
        p_213858_0_.field_145804_b = Math.max(p_213858_0_.field_145804_b, p_213858_2_.field_145804_b);
        p_213858_0_.field_70292_b = Math.min(p_213858_0_.field_70292_b, p_213858_2_.field_70292_b);
        if (p_213858_3_.func_190926_b()) {
            p_213858_2_.func_70106_y();
        }
    }

    @Override
    public boolean func_230279_az_() {
        return this.func_92059_d().func_77973_b().func_234687_u_() || super.func_230279_az_();
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if (!this.func_92059_d().func_190926_b() && this.func_92059_d().func_77973_b() == Items.field_151156_bN && p_70097_1_.func_94541_c()) {
            return false;
        }
        if (!this.func_92059_d().func_77973_b().func_234685_a_(p_70097_1_)) {
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent((Entity)this, (DamageSource)p_70097_1_, (double)p_70097_2_)) {
            return false;
        }
        this.func_70018_K();
        this.field_70291_e = (int)((float)this.field_70291_e - p_70097_2_);
        if (this.field_70291_e <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        p_213281_1_.func_74777_a("Health", (short)this.field_70291_e);
        p_213281_1_.func_74777_a("Age", (short)this.field_70292_b);
        p_213281_1_.func_74777_a("PickupDelay", (short)this.field_145804_b);
        p_213281_1_.func_74768_a("Lifespan", this.lifespan);
        if (this.func_200214_m() != null) {
            p_213281_1_.func_186854_a("Thrower", this.func_200214_m());
        }
        if (this.func_200215_l() != null) {
            p_213281_1_.func_186854_a("Owner", this.func_200215_l());
        }
        if (!this.func_92059_d().func_190926_b()) {
            p_213281_1_.func_218657_a("Item", this.func_92059_d().func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        this.field_70291_e = p_70037_1_.func_74765_d("Health");
        this.field_70292_b = p_70037_1_.func_74765_d("Age");
        if (p_70037_1_.func_74764_b("PickupDelay")) {
            this.field_145804_b = p_70037_1_.func_74765_d("PickupDelay");
        }
        if (p_70037_1_.func_74764_b("Lifespan")) {
            this.lifespan = p_70037_1_.func_74762_e("Lifespan");
        }
        if (p_70037_1_.func_186855_b("Owner")) {
            this.field_145802_g = p_70037_1_.func_186857_a("Owner");
        }
        if (p_70037_1_.func_186855_b("Thrower")) {
            this.field_145801_f = p_70037_1_.func_186857_a("Thrower");
        }
        CompoundNBT compoundnbt = p_70037_1_.func_74775_l("Item");
        this.func_92058_a(ItemStack.func_199557_a(compoundnbt));
        if (this.func_92059_d().func_190926_b()) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70100_b_(PlayerEntity p_70100_1_) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_145804_b > 0) {
                return;
            }
            ItemStack itemstack = this.func_92059_d();
            Item item = itemstack.func_77973_b();
            int i = itemstack.func_190916_E();
            int canHold = p_70100_1_.field_71071_by.canHold(itemstack);
            int remaining = i - canHold;
            if (this.field_145804_b <= 0 && canHold > 0) {
                itemstack.func_190920_e(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)p_70100_1_.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!p_70100_1_.canPickUpLoot);
                this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)playerEvent);
                if (playerEvent.isCancelled()) {
                    itemstack.func_190920_e(i);
                    return;
                }
                EntityPickupItemEvent entityEvent = new EntityPickupItemEvent((LivingEntity)p_70100_1_.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                entityEvent.setCancelled(!p_70100_1_.canPickUpLoot);
                this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.func_190920_e(i);
                    return;
                }
                ItemStack current = this.func_92059_d();
                if (!((Object)((Object)itemstack)).equals((Object)current)) {
                    itemstack = current;
                } else {
                    itemstack.func_190920_e(canHold + remaining);
                }
                this.field_145804_b = 0;
            } else if (this.field_145804_b == 0) {
                this.field_145804_b = -1;
            }
            int hook = ForgeEventFactory.onItemPickup((ItemEntity)this, (PlayerEntity)p_70100_1_);
            if (hook < 0) {
                return;
            }
            ItemStack copy = itemstack.func_77946_l();
            if (this.field_145804_b == 0 && (this.field_145802_g == null || this.lifespan - this.field_70292_b <= 200 || this.field_145802_g.equals(p_70100_1_.func_110124_au())) && (hook == 1 || i <= 0 || p_70100_1_.field_71071_by.func_70441_a(itemstack))) {
                copy.func_190920_e(copy.func_190916_E() - this.func_92059_d().func_190916_E());
                BasicEventHooks.firePlayerItemPickupEvent((PlayerEntity)p_70100_1_, (ItemEntity)this, (ItemStack)copy);
                p_70100_1_.func_71001_a(this, i);
                if (itemstack.func_190926_b()) {
                    this.func_70106_y();
                    itemstack.func_190920_e(i);
                }
                p_70100_1_.func_71064_a(Stats.field_199089_f.func_199076_b(item), i);
                p_70100_1_.func_233630_a_(this);
            }
        }
    }

    @Override
    public ITextComponent func_200200_C_() {
        ITextComponent itextcomponent = this.func_200201_e();
        return itextcomponent != null ? itextcomponent : new TranslationTextComponent(this.func_92059_d().func_77977_a());
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    @Nullable
    public Entity changeDimension(ServerWorld p_241206_1_, ITeleporter teleporter) {
        Entity entity = super.changeDimension(p_241206_1_, teleporter);
        if (!this.field_70170_p.field_72995_K && entity instanceof ItemEntity) {
            ((ItemEntity)entity).func_85054_d();
        }
        return entity;
    }

    public ItemStack func_92059_d() {
        return this.func_184212_Q().func_187225_a(field_184533_c);
    }

    public void func_92058_a(ItemStack p_92058_1_) {
        this.func_184212_Q().func_187227_b(field_184533_c, p_92058_1_);
    }

    @Override
    public void func_184206_a(DataParameter<?> p_184206_1_) {
        super.func_184206_a(p_184206_1_);
        if (field_184533_c.equals(p_184206_1_)) {
            this.func_92059_d().func_234695_a_(this);
        }
    }

    @Nullable
    public UUID func_200215_l() {
        return this.field_145802_g;
    }

    public void func_200217_b(@Nullable UUID p_200217_1_) {
        this.field_145802_g = p_200217_1_;
    }

    @Nullable
    public UUID func_200214_m() {
        return this.field_145801_f;
    }

    public void func_200216_c(@Nullable UUID p_200216_1_) {
        this.field_145801_f = p_200216_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_174872_o() {
        return this.field_70292_b;
    }

    public void func_174869_p() {
        this.field_145804_b = 10;
    }

    public void func_174868_q() {
        this.field_145804_b = 0;
    }

    public void func_174871_r() {
        this.field_145804_b = Short.MAX_VALUE;
    }

    public void func_174867_a(int p_174867_1_) {
        this.field_145804_b = p_174867_1_;
    }

    public boolean func_174874_s() {
        return this.field_145804_b > 0;
    }

    public void func_174873_u() {
        this.field_70292_b = -6000;
    }

    public void func_174870_v() {
        this.func_174871_r();
        this.field_70292_b = this.func_92059_d().getEntityLifespan(this.field_70170_p) - 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_234272_a_(float p_234272_1_) {
        return ((float)this.func_174872_o() + p_234272_1_) / 20.0f + this.field_70290_d;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemEntity func_234273_t_() {
        return new ItemEntity(this);
    }
}

