/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;

public class DrownedEntity
extends ZombieEntity
implements IRangedAttackMob {
    private boolean field_204718_bx;
    public final SwimmerPathNavigator field_204716_a;
    public final GroundPathNavigator field_204717_b;

    public DrownedEntity(EntityType<? extends DrownedEntity> p_i50212_1_, World p_i50212_2_) {
        super(p_i50212_1_, p_i50212_2_);
        this.field_70138_W = 1.0f;
        this.field_70765_h = new MoveHelperController(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_204716_a = new SwimmerPathNavigator((MobEntity)((Object)this), p_i50212_2_);
        this.field_204717_b = new GroundPathNavigator((MobEntity)((Object)this), p_i50212_2_);
    }

    @Override
    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(1, (Goal)new GoToWaterGoal((CreatureEntity)((Object)this), 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new TridentAttackGoal(this, 1.0, 40, 10.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new GoToBeachGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new SwimUpGoal(this, 1.0, this.field_70170_p.func_181545_F()));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)((Object)this), 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)((Object)this), DrownedEntity.class).func_220794_a(ZombifiedPiglinEntity.class));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)((Object)this), PlayerEntity.class, 10, true, false, this::func_204714_e));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<AbstractVillagerEntity>((MobEntity)((Object)this), AbstractVillagerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<IronGolemEntity>((MobEntity)((Object)this), IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(5, new NearestAttackableTargetGoal<TurtleEntity>((MobEntity)((Object)this), TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        p_213386_4_ = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        if (this.func_184582_a(EquipmentSlotType.OFFHAND).func_190926_b() && this.field_70146_Z.nextFloat() < 0.03f) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack(Items.field_205157_eZ));
            this.field_82174_bp[EquipmentSlotType.OFFHAND.func_188454_b()] = 2.0f;
        }
        return p_213386_4_;
    }

    public static boolean func_223332_b(EntityType<DrownedEntity> p_223332_0_, IServerWorld p_223332_1_, SpawnReason p_223332_2_, BlockPos p_223332_3_, Random p_223332_4_) {
        boolean flag;
        Optional optional = p_223332_1_.func_242406_i(p_223332_3_);
        boolean bl = flag = p_223332_1_.func_175659_aa() != Difficulty.PEACEFUL && DrownedEntity.func_223323_a((IServerWorld)p_223332_1_, (BlockPos)p_223332_3_, (Random)p_223332_4_) && (p_223332_2_ == SpawnReason.SPAWNER || p_223332_1_.func_204610_c(p_223332_3_).func_206884_a(FluidTags.field_206959_a));
        if (!Objects.equals(optional, Optional.of(Biomes.field_76781_i)) && !Objects.equals(optional, Optional.of(Biomes.field_76777_m))) {
            return p_223332_4_.nextInt(40) == 0 && DrownedEntity.func_223333_a(p_223332_1_, p_223332_3_) && flag;
        }
        return p_223332_4_.nextInt(15) == 0 && flag;
    }

    private static boolean func_223333_a(IWorld p_223333_0_, BlockPos p_223333_1_) {
        return p_223333_1_.func_177956_o() < p_223333_0_.func_181545_F() - 5;
    }

    @Override
    protected boolean func_204900_dz() {
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.func_70090_H() ? SoundEvents.field_204775_aZ : SoundEvents.field_204774_aY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.func_70090_H() ? SoundEvents.field_204779_bd : SoundEvents.field_204778_bc;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return this.func_70090_H() ? SoundEvents.field_204777_bb : SoundEvents.field_204776_ba;
    }

    @Override
    protected SoundEvent func_190731_di() {
        return SoundEvents.field_204781_bf;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_204782_bg;
    }

    @Override
    protected ItemStack func_190732_dj() {
        return ItemStack.field_190927_a;
    }

    @Override
    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        if ((double)this.field_70146_Z.nextFloat() > 0.9) {
            int i = this.field_70146_Z.nextInt(16);
            if (i < 10) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_203184_eO));
            } else {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151112_aM));
            }
        }
    }

    protected boolean func_208003_a(ItemStack p_208003_1_, ItemStack p_208003_2_) {
        if (p_208003_2_.func_77973_b() == Items.field_205157_eZ) {
            return false;
        }
        if (p_208003_2_.func_77973_b() == Items.field_203184_eO) {
            if (p_208003_1_.func_77973_b() == Items.field_203184_eO) {
                return p_208003_1_.func_77952_i() < p_208003_2_.func_77952_i();
            }
            return false;
        }
        return p_208003_1_.func_77973_b() == Items.field_203184_eO ? true : super.func_208003_a(p_208003_1_, p_208003_2_);
    }

    @Override
    protected boolean func_204703_dA() {
        return false;
    }

    public boolean func_205019_a(IWorldReader p_205019_1_) {
        return p_205019_1_.func_226668_i_((Entity)((Object)this));
    }

    public boolean func_204714_e(@Nullable LivingEntity p_204714_1_) {
        if (p_204714_1_ != null) {
            return !this.field_70170_p.func_72935_r() || p_204714_1_.func_70090_H();
        }
        return false;
    }

    public boolean func_96092_aw() {
        return !this.func_203007_ba();
    }

    private boolean func_204715_dF() {
        if (this.field_204718_bx) {
            return true;
        }
        LivingEntity livingentity = this.func_70638_az();
        return livingentity != null && livingentity.func_70090_H();
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H() && this.func_204715_dF()) {
            this.func_213309_a(0.01f, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_70090_H() && this.func_204715_dF()) {
                this.field_70699_by = this.field_204716_a;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.field_204717_b;
                this.func_204711_a(false);
            }
        }
    }

    protected boolean func_204710_dB() {
        double d0;
        BlockPos blockpos;
        Path path = this.func_70661_as().func_75505_d();
        return path != null && (blockpos = path.func_224770_k()) != null && (d0 = this.func_70092_e(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p())) < 4.0;
    }

    public void func_82196_d(LivingEntity p_82196_1_, float p_82196_2_) {
        TridentEntity tridententity = new TridentEntity(this.field_70170_p, (LivingEntity)((Object)this), new ItemStack(Items.field_203184_eO));
        double d0 = p_82196_1_.func_226277_ct_() - this.func_226277_ct_();
        double d1 = p_82196_1_.func_226283_e_(0.3333333333333333) - tridententity.func_226278_cu_();
        double d2 = p_82196_1_.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        tridententity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(SoundEvents.field_204780_be, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c(tridententity);
    }

    public void func_204713_s(boolean p_204713_1_) {
        this.field_204718_bx = p_204713_1_;
    }

    static class TridentAttackGoal
    extends RangedAttackGoal {
        private final DrownedEntity field_204728_a;

        public TridentAttackGoal(IRangedAttackMob p_i48907_1_, double p_i48907_2_, int p_i48907_4_, float p_i48907_5_) {
            super(p_i48907_1_, p_i48907_2_, p_i48907_4_, p_i48907_5_);
            this.field_204728_a = (DrownedEntity)p_i48907_1_;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.field_204728_a.func_184614_ca().func_77973_b() == Items.field_203184_eO;
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.field_204728_a.func_213395_q(true);
            this.field_204728_a.func_184598_c(Hand.MAIN_HAND);
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.field_204728_a.func_184602_cy();
            this.field_204728_a.func_213395_q(false);
        }
    }

    static class SwimUpGoal
    extends Goal {
        private final DrownedEntity field_204736_a;
        private final double field_204737_b;
        private final int field_204738_c;
        private boolean field_204739_d;

        public SwimUpGoal(DrownedEntity p_i48908_1_, double p_i48908_2_, int p_i48908_4_) {
            this.field_204736_a = p_i48908_1_;
            this.field_204737_b = p_i48908_2_;
            this.field_204738_c = p_i48908_4_;
        }

        public boolean func_75250_a() {
            return !this.field_204736_a.field_70170_p.func_72935_r() && this.field_204736_a.func_70090_H() && this.field_204736_a.func_226278_cu_() < (double)(this.field_204738_c - 2);
        }

        public boolean func_75253_b() {
            return this.func_75250_a() && !this.field_204739_d;
        }

        public void func_75246_d() {
            if (this.field_204736_a.func_226278_cu_() < (double)(this.field_204738_c - 1) && (this.field_204736_a.func_70661_as().func_75500_f() || this.field_204736_a.func_204710_dB())) {
                Vector3d vector3d = RandomPositionGenerator.func_75464_a((CreatureEntity)((Object)this.field_204736_a), (int)4, (int)8, (Vector3d)new Vector3d(this.field_204736_a.func_226277_ct_(), this.field_204738_c - 1, this.field_204736_a.func_226281_cx_()));
                if (vector3d == null) {
                    this.field_204739_d = true;
                    return;
                }
                this.field_204736_a.func_70661_as().func_75492_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, this.field_204737_b);
            }
        }

        public void func_75249_e() {
            this.field_204736_a.func_204713_s(true);
            this.field_204739_d = false;
        }

        public void func_75251_c() {
            this.field_204736_a.func_204713_s(false);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final DrownedEntity field_204725_i;

        public MoveHelperController(DrownedEntity p_i48909_1_) {
            super((MobEntity)((Object)p_i48909_1_));
            this.field_204725_i = p_i48909_1_;
        }

        public void func_75641_c() {
            LivingEntity livingentity = this.field_204725_i.func_70638_az();
            if (this.field_204725_i.func_204715_dF() && this.field_204725_i.func_70090_H()) {
                if (livingentity != null && livingentity.func_226278_cu_() > this.field_204725_i.func_226278_cu_() || this.field_204725_i.field_204718_bx) {
                    this.field_204725_i.func_213317_d(this.field_204725_i.func_213322_ci().func_72441_c(0.0, 0.002, 0.0));
                }
                if (this.field_188491_h != MovementController.Action.MOVE_TO || this.field_204725_i.func_70661_as().func_75500_f()) {
                    this.field_204725_i.func_70659_e(0.0f);
                    return;
                }
                double d0 = this.field_75646_b - this.field_204725_i.func_226277_ct_();
                double d1 = this.field_75647_c - this.field_204725_i.func_226278_cu_();
                double d2 = this.field_75644_d - this.field_204725_i.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.field_204725_i.field_70761_aq = this.field_204725_i.field_70177_z = this.func_75639_a(this.field_204725_i.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.field_204725_i.func_233637_b_(Attributes.field_233821_d_));
                float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.field_204725_i.func_70689_ay(), (float)f1);
                this.field_204725_i.func_70659_e(f2);
                this.field_204725_i.func_213317_d(this.field_204725_i.func_213322_ci().func_72441_c((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.field_204725_i.field_70122_E) {
                    this.field_204725_i.func_213317_d(this.field_204725_i.func_213322_ci().func_72441_c(0.0, -0.008, 0.0));
                }
                super.func_75641_c();
            }
        }
    }

    static class GoToWaterGoal
    extends Goal {
        private final CreatureEntity field_204730_a;
        private double field_204731_b;
        private double field_204732_c;
        private double field_204733_d;
        private final double field_204734_e;
        private final World field_204735_f;

        public GoToWaterGoal(CreatureEntity p_i48910_1_, double p_i48910_2_) {
            this.field_204730_a = p_i48910_1_;
            this.field_204734_e = p_i48910_2_;
            this.field_204735_f = p_i48910_1_.field_70170_p;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!this.field_204735_f.func_72935_r()) {
                return false;
            }
            if (this.field_204730_a.func_70090_H()) {
                return false;
            }
            Vector3d vector3d = this.func_204729_f();
            if (vector3d == null) {
                return false;
            }
            this.field_204731_b = vector3d.field_72450_a;
            this.field_204732_c = vector3d.field_72448_b;
            this.field_204733_d = vector3d.field_72449_c;
            return true;
        }

        public boolean func_75253_b() {
            return !this.field_204730_a.func_70661_as().func_75500_f();
        }

        public void func_75249_e() {
            this.field_204730_a.func_70661_as().func_75492_a(this.field_204731_b, this.field_204732_c, this.field_204733_d, this.field_204734_e);
        }

        @Nullable
        private Vector3d func_204729_f() {
            Random random = this.field_204730_a.func_70681_au();
            BlockPos blockpos = this.field_204730_a.func_233580_cy_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(20) - 10, 2 - random.nextInt(8), random.nextInt(20) - 10);
                if (!this.field_204735_f.func_180495_p(blockpos1).func_203425_a(Blocks.field_150355_j)) continue;
                return Vector3d.func_237492_c_(blockpos1);
            }
            return null;
        }
    }

    static class GoToBeachGoal
    extends MoveToBlockGoal {
        private final DrownedEntity field_204727_f;

        public GoToBeachGoal(DrownedEntity p_i48911_1_, double p_i48911_2_) {
            super((CreatureEntity)((Object)p_i48911_1_), p_i48911_2_, 8, 2);
            this.field_204727_f = p_i48911_1_;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_204727_f.field_70170_p.func_72935_r() && this.field_204727_f.func_70090_H() && this.field_204727_f.func_226278_cu_() >= (double)(this.field_204727_f.field_70170_p.func_181545_F() - 3);
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        protected boolean func_179488_a(IWorldReader p_179488_1_, BlockPos p_179488_2_) {
            BlockPos blockpos = p_179488_2_.func_177984_a();
            return p_179488_1_.func_175623_d(blockpos) && p_179488_1_.func_175623_d(blockpos.func_177984_a()) ? p_179488_1_.func_180495_p(p_179488_2_).func_235719_a_((IBlockReader)((Object)p_179488_1_), p_179488_2_, (Entity)((Object)this.field_204727_f)) : false;
        }

        public void func_75249_e() {
            this.field_204727_f.func_204713_s(false);
            this.field_204727_f.field_70699_by = (PathNavigator)this.field_204727_f.field_204717_b;
            super.func_75249_e();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    static class AttackGoal
    extends ZombieAttackGoal {
        private final DrownedEntity field_204726_g;

        public AttackGoal(DrownedEntity p_i48913_1_, double p_i48913_2_, boolean p_i48913_4_) {
            super((ZombieEntity)p_i48913_1_, p_i48913_2_, p_i48913_4_);
            this.field_204726_g = p_i48913_1_;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.field_204726_g.func_204714_e(this.field_204726_g.func_70638_az());
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.field_204726_g.func_204714_e(this.field_204726_g.func_70638_az());
        }
    }
}

