/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import org.bukkit.event.entity.EntityTargetEvent;

public class VexEntity
extends MonsterEntity {
    protected static final DataParameter<Byte> field_190664_a = EntityDataManager.func_187226_a(VexEntity.class, DataSerializers.field_187191_a);
    private MobEntity field_190665_b;
    @Nullable
    private BlockPos field_190666_c;
    private boolean field_190667_bw;
    private int field_190668_bx;

    public VexEntity(EntityType<? extends VexEntity> p_i50190_1_, World p_i50190_2_) {
        super(p_i50190_1_, p_i50190_2_);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70728_aV = 3;
    }

    public void func_213315_a(MoverType p_213315_1_, Vector3d p_213315_2_) {
        super.func_213315_a(p_213315_1_, p_213315_2_);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        if (this.field_190667_bw && --this.field_190668_bx <= 0) {
            this.field_190668_bx = 20;
            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(4, (Goal)new ChargeAttackGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new MoveRandomGoal());
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)((Object)this), MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)((Object)this), AbstractRaiderEntity.class).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new CopyOwnerTargetGoal((CreatureEntity)((Object)this)));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)((Object)this), PlayerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute func_234321_m_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 14.0).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_190664_a, (byte)0);
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_74764_b("BoundX")) {
            this.field_190666_c = new BlockPos(p_70037_1_.func_74762_e("BoundX"), p_70037_1_.func_74762_e("BoundY"), p_70037_1_.func_74762_e("BoundZ"));
        }
        if (p_70037_1_.func_74764_b("LifeTicks")) {
            this.func_190653_a(p_70037_1_.func_74762_e("LifeTicks"));
        }
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        if (this.field_190666_c != null) {
            p_213281_1_.func_74768_a("BoundX", this.field_190666_c.func_177958_n());
            p_213281_1_.func_74768_a("BoundY", this.field_190666_c.func_177956_o());
            p_213281_1_.func_74768_a("BoundZ", this.field_190666_c.func_177952_p());
        }
        if (this.field_190667_bw) {
            p_213281_1_.func_74768_a("LifeTicks", this.field_190668_bx);
        }
    }

    public MobEntity func_190645_o() {
        return this.field_190665_b;
    }

    @Nullable
    public BlockPos func_190646_di() {
        return this.field_190666_c;
    }

    public void func_190651_g(@Nullable BlockPos p_190651_1_) {
        this.field_190666_c = p_190651_1_;
    }

    private boolean func_190656_b(int p_190656_1_) {
        byte i = this.field_70180_af.func_187225_a(field_190664_a);
        return (i & p_190656_1_) != 0;
    }

    private void func_190660_a(int p_190660_1_, boolean p_190660_2_) {
        int i = this.field_70180_af.func_187225_a(field_190664_a).byteValue();
        i = p_190660_2_ ? (i |= p_190660_1_) : (i &= ~p_190660_1_);
        this.field_70180_af.func_187227_b(field_190664_a, (byte)(i & 0xFF));
    }

    public boolean func_190647_dj() {
        return this.func_190656_b(1);
    }

    public void func_190648_a(boolean p_190648_1_) {
        this.func_190660_a(1, p_190648_1_);
    }

    public void func_190658_a(MobEntity p_190658_1_) {
        this.field_190665_b = p_190658_1_;
    }

    public void func_190653_a(int p_190653_1_) {
        this.field_190667_bw = true;
        this.field_190668_bx = p_190653_1_;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191264_hc;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191266_he;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_191267_hf;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        this.func_180481_a(p_213386_2_);
        this.func_180483_b(p_213386_2_);
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151040_l));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
    }

    class MoveRandomGoal
    extends Goal {
        public MoveRandomGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !VexEntity.this.func_70605_aq().func_75640_a() && VexEntity.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = VexEntity.this.func_190646_di();
            if (blockpos == null) {
                blockpos = VexEntity.this.func_233580_cy_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(VexEntity.this.field_70146_Z.nextInt(15) - 7, VexEntity.this.field_70146_Z.nextInt(11) - 5, VexEntity.this.field_70146_Z.nextInt(15) - 7);
                if (!VexEntity.this.field_70170_p.func_175623_d(blockpos1)) continue;
                VexEntity.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (VexEntity.this.func_70638_az() != null) break;
                VexEntity.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class MoveHelperController
    extends MovementController {
        public MoveHelperController(VexEntity p_i47230_2_) {
            super((MobEntity)((Object)p_i47230_2_));
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - VexEntity.this.func_226277_ct_(), this.field_75647_c - VexEntity.this.func_226278_cu_(), this.field_75644_d - VexEntity.this.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (d0 < VexEntity.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    VexEntity.this.func_213317_d(VexEntity.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    VexEntity.this.func_213317_d(VexEntity.this.func_213322_ci().func_178787_e(vector3d.func_186678_a(this.field_75645_e * 0.05 / d0)));
                    if (VexEntity.this.func_70638_az() == null) {
                        Vector3d vector3d1 = VexEntity.this.func_213322_ci();
                        VexEntity.this.field_70761_aq = VexEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d2 = VexEntity.this.func_70638_az().func_226277_ct_() - VexEntity.this.func_226277_ct_();
                        double d1 = VexEntity.this.func_70638_az().func_226281_cx_() - VexEntity.this.func_226281_cx_();
                        VexEntity.this.field_70761_aq = VexEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d2, (double)d1)) * 57.295776f;
                    }
                }
            }
        }
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final EntityPredicate field_220803_b;

        public CopyOwnerTargetGoal(CreatureEntity p_i47231_2_) {
            super(p_i47231_2_, false);
            this.field_220803_b = new EntityPredicate().func_221014_c().func_221010_e();
        }

        public boolean func_75250_a() {
            return VexEntity.this.field_190665_b != null && VexEntity.this.field_190665_b.func_70638_az() != null && this.func_220777_a(VexEntity.this.field_190665_b.func_70638_az(), this.field_220803_b);
        }

        @Override
        public void func_75249_e() {
            VexEntity.this.setGoalTarget(VexEntity.this.field_190665_b.func_70638_az(), EntityTargetEvent.TargetReason.OWNER_ATTACKED_TARGET, true);
            super.func_75249_e();
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (VexEntity.this.func_70638_az() != null && !VexEntity.this.func_70605_aq().func_75640_a() && VexEntity.this.field_70146_Z.nextInt(7) == 0) {
                return VexEntity.this.func_70068_e(VexEntity.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return VexEntity.this.func_70605_aq().func_75640_a() && VexEntity.this.func_190647_dj() && VexEntity.this.func_70638_az() != null && VexEntity.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            LivingEntity livingentity = VexEntity.this.func_70638_az();
            Vector3d vector3d = livingentity.func_174824_e(1.0f);
            VexEntity.this.field_70765_h.func_75642_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 1.0);
            VexEntity.this.func_190648_a(true);
            VexEntity.this.func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
        }

        public void func_75251_c() {
            VexEntity.this.func_190648_a(false);
        }

        public void func_75246_d() {
            LivingEntity livingentity = VexEntity.this.func_70638_az();
            if (VexEntity.this.func_174813_aQ().func_72326_a(livingentity.func_174813_aQ())) {
                VexEntity.this.func_70652_k(livingentity);
                VexEntity.this.func_190648_a(false);
            } else {
                double d0 = VexEntity.this.func_70068_e(livingentity);
                if (d0 < 9.0) {
                    Vector3d vector3d = livingentity.func_174824_e(1.0f);
                    VexEntity.this.field_70765_h.func_75642_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 1.0);
                }
            }
        }
    }
}

