/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.event.ForgeEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

public class SnowGolemEntity
extends GolemEntity
implements IShearable,
IRangedAttackMob,
IForgeShearable {
    private static final DataParameter<Byte> field_184749_a = EntityDataManager.func_187226_a(SnowGolemEntity.class, DataSerializers.field_187191_a);

    public SnowGolemEntity(EntityType<? extends SnowGolemEntity> p_i50244_1_, World p_i50244_2_) {
        super(p_i50244_1_, p_i50244_2_);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.25, 20, 10.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)((Object)this), 1.0, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.field_70715_bh.func_75776_a(1, new NearestAttackableTargetGoal<MobEntity>((MobEntity)((Object)this), MobEntity.class, 10, true, false, p_213621_0_ -> p_213621_0_ instanceof IMob));
    }

    public static AttributeModifierMap.MutableAttribute func_234226_m_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233821_d_, 0.2f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184749_a, (byte)16);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74757_a("Pumpkin", this.func_184748_o());
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_74764_b("Pumpkin")) {
            this.func_184747_a(p_70037_1_.func_74767_n("Pumpkin"));
        }
    }

    public boolean func_230270_dK_() {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)this.func_226278_cu_());
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            BlockPos blockPos = new BlockPos(i, 0, k);
            BlockPos blockPos2 = new BlockPos(i, j, k);
            if (this.field_70170_p.func_226691_t_(blockPos).func_225486_c(blockPos2) > 1.0f) {
                this.func_70097_a(CraftEventFactory.MELTING, 1.0f);
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)((Object)this))) {
                return;
            }
            BlockState blockstate = Blocks.field_150433_aE.func_176223_P();
            for (int l = 0; l < 4; ++l) {
                i = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_226278_cu_()), k = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                if (!this.field_70170_p.func_175623_d(blockpos) || !(this.field_70170_p.func_226691_t_(blockpos).func_225486_c(blockpos) < 0.8f) || !blockstate.func_196955_c((IWorldReader)((Object)this.field_70170_p), blockpos)) continue;
                CraftEventFactory.handleBlockFormEvent((World)this.field_70170_p, (BlockPos)blockpos, (BlockState)blockstate, (Entity)((Object)this));
            }
        }
    }

    public void func_82196_d(LivingEntity p_82196_1_, float p_82196_2_) {
        SnowballEntity snowballentity = new SnowballEntity(this.field_70170_p, (LivingEntity)((Object)this));
        double d0 = p_82196_1_.func_226280_cw_() - (double)1.1f;
        double d1 = p_82196_1_.func_226277_ct_() - this.func_226277_ct_();
        double d2 = d0 - snowballentity.func_226278_cu_();
        double d3 = p_82196_1_.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        snowballentity.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 0.4f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)snowballentity);
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 1.7f;
    }

    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        return ActionResultType.PASS;
    }

    @Override
    public void func_230263_a_(SoundCategory p_230263_1_) {
        this.field_70170_p.func_217384_a(null, (Entity)((Object)this), SoundEvents.field_232843_op_, p_230263_1_, 1.0f, 1.0f);
        if (!this.field_70170_p.func_201670_d()) {
            this.func_184747_a(false);
            this.func_70099_a(new ItemStack(Items.field_221689_cG), 1.7f);
        }
    }

    @Override
    public boolean func_230262_K__() {
        return this.func_70089_S() && this.func_184748_o();
    }

    public boolean func_184748_o() {
        return (this.field_70180_af.func_187225_a(field_184749_a) & 0x10) != 0;
    }

    public void func_184747_a(boolean p_184747_1_) {
        byte b0 = this.field_70180_af.func_187225_a(field_184749_a);
        if (p_184747_1_) {
            this.field_70180_af.func_187227_b(field_184749_a, (byte)(b0 | 0x10));
        } else {
            this.field_70180_af.func_187227_b(field_184749_a, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187799_fB;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187803_fD;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187801_fC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.75f * this.func_70047_e(), this.func_213311_cf() * 0.4f);
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return this.func_230262_K__();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)((Object)this), SoundEvents.field_232843_op_, player == null ? SoundCategory.BLOCKS : SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (!world.func_201670_d()) {
            this.func_184747_a(false);
            return Collections.singletonList(new ItemStack(Items.field_221689_cG));
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void func_213622_a(Hand p_230254_2_, PlayerEntity p_213622_1_) {
        p_213622_1_.func_213334_d(p_230254_2_);
    }
}

