/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class FireworkRocketEntity
extends ProjectileEntity
implements IRendersAsItem {
    public static final DataParameter<ItemStack> field_184566_a = EntityDataManager.func_187226_a(FireworkRocketEntity.class, DataSerializers.field_187196_f);
    private static final DataParameter<OptionalInt> field_191512_b = EntityDataManager.func_187226_a(FireworkRocketEntity.class, DataSerializers.field_218814_r);
    public static final DataParameter<Boolean> field_213895_d = EntityDataManager.func_187226_a(FireworkRocketEntity.class, DataSerializers.field_187198_h);
    private int field_92056_a;
    public int field_92055_b;
    private LivingEntity field_191513_e;

    public FireworkRocketEntity(EntityType<? extends FireworkRocketEntity> p_i50164_1_, World p_i50164_2_) {
        super((EntityType<? extends ProjectileEntity>)p_i50164_1_, p_i50164_2_);
    }

    public FireworkRocketEntity(World p_i1763_1_, double p_i1763_2_, double p_i1763_4_, double p_i1763_6_, ItemStack p_i1763_8_) {
        super((EntityType<? extends ProjectileEntity>)EntityType.field_200810_x, p_i1763_1_);
        this.field_92056_a = 0;
        this.func_70107_b(p_i1763_2_, p_i1763_4_, p_i1763_6_);
        int i = 1;
        if (!p_i1763_8_.func_190926_b() && p_i1763_8_.func_77942_o()) {
            this.field_70180_af.func_187227_b(field_184566_a, p_i1763_8_.func_77946_l());
            i += p_i1763_8_.func_190925_c("Fireworks").func_74771_c("Flight");
        }
        this.func_213293_j(this.field_70146_Z.nextGaussian() * 0.001, 0.05, this.field_70146_Z.nextGaussian() * 0.001);
        this.field_92055_b = 10 * i + this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(7);
    }

    public FireworkRocketEntity(World p_i231581_1_, @Nullable Entity p_i231581_2_, double p_i231581_3_, double p_i231581_5_, double p_i231581_7_, ItemStack p_i231581_9_) {
        this(p_i231581_1_, p_i231581_3_, p_i231581_5_, p_i231581_7_, p_i231581_9_);
        this.func_212361_a(p_i231581_2_);
    }

    public FireworkRocketEntity(World p_i47367_1_, ItemStack p_i47367_2_, LivingEntity p_i47367_3_) {
        this(p_i47367_1_, p_i47367_3_, p_i47367_3_.func_226277_ct_(), p_i47367_3_.func_226278_cu_(), p_i47367_3_.func_226281_cx_(), p_i47367_2_);
        this.field_70180_af.func_187227_b(field_191512_b, OptionalInt.of(p_i47367_3_.func_145782_y()));
        this.field_191513_e = p_i47367_3_;
    }

    public FireworkRocketEntity(World p_i50165_1_, ItemStack p_i50165_2_, double p_i50165_3_, double p_i50165_5_, double p_i50165_7_, boolean p_i50165_9_) {
        this(p_i50165_1_, p_i50165_3_, p_i50165_5_, p_i50165_7_, p_i50165_2_);
        this.field_70180_af.func_187227_b(field_213895_d, p_i50165_9_);
    }

    public FireworkRocketEntity(World p_i231582_1_, ItemStack p_i231582_2_, Entity p_i231582_3_, double p_i231582_4_, double p_i231582_6_, double p_i231582_8_, boolean p_i231582_10_) {
        this(p_i231582_1_, p_i231582_2_, p_i231582_4_, p_i231582_6_, p_i231582_8_, p_i231582_10_);
        this.func_212361_a(p_i231582_3_);
    }

    @Override
    public void inactiveTick() {
        ++this.field_92056_a;
        if (!this.field_70170_p.field_72995_K && this.field_92056_a > this.field_92055_b && !CraftEventFactory.callFireworkExplodeEvent((FireworkRocketEntity)this).isCancelled()) {
            this.func_191510_k();
        }
        super.inactiveTick();
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184566_a, ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(field_191512_b, OptionalInt.empty());
        this.field_70180_af.func_187214_a(field_213895_d, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        return p_70112_1_ < 4096.0 && !this.func_191511_j();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return super.func_145770_h(p_145770_1_, p_145770_3_, p_145770_5_) && !this.func_191511_j();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_191511_j()) {
            if (this.field_191513_e == null) {
                this.field_70180_af.func_187225_a(field_191512_b).ifPresent(p_213891_1_ -> {
                    Entity entity = this.field_70170_p.func_73045_a(p_213891_1_);
                    if (entity instanceof LivingEntity) {
                        this.field_191513_e = (LivingEntity)entity;
                    }
                });
            }
            if (this.field_191513_e != null) {
                if (this.field_191513_e.func_184613_cA()) {
                    Vector3d vector3d = this.field_191513_e.func_70040_Z();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vector3d vector3d1 = this.field_191513_e.func_213322_ci();
                    this.field_191513_e.func_213317_d(vector3d1.func_72441_c(vector3d.field_72450_a * 0.1 + (vector3d.field_72450_a * 1.5 - vector3d1.field_72450_a) * 0.5, vector3d.field_72448_b * 0.1 + (vector3d.field_72448_b * 1.5 - vector3d1.field_72448_b) * 0.5, vector3d.field_72449_c * 0.1 + (vector3d.field_72449_c * 1.5 - vector3d1.field_72449_c) * 0.5));
                }
                this.func_70107_b(this.field_191513_e.func_226277_ct_(), this.field_191513_e.func_226278_cu_(), this.field_191513_e.func_226281_cx_());
                this.func_213317_d(this.field_191513_e.func_213322_ci());
            }
        } else {
            if (!this.func_213889_i()) {
                double d2 = this.field_70123_F ? 1.0 : 1.15;
                this.func_213317_d(this.func_213322_ci().func_216372_d(d2, 1.0, d2).func_72441_c(0.0, 0.04, 0.0));
            }
            Vector3d vector3d2 = this.func_213322_ci();
            this.func_213315_a(MoverType.SELF, vector3d2);
            this.func_213317_d(vector3d2);
        }
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_(this, this::func_230298_a_);
        if (!this.field_70145_X) {
            this.preOnHit(raytraceresult);
            this.field_70160_al = true;
        }
        this.func_234617_x_();
        if (this.field_92056_a == 0 && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187631_bo, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        ++this.field_92056_a;
        if (this.field_70170_p.field_72995_K && this.field_92056_a % 2 < 2) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197629_v, this.func_226277_ct_(), this.func_226278_cu_() - 0.3, this.func_226281_cx_(), this.field_70146_Z.nextGaussian() * 0.05, -this.func_213322_ci().field_72448_b * 0.5, this.field_70146_Z.nextGaussian() * 0.05);
        }
        if (!this.field_70170_p.field_72995_K && this.field_92056_a > this.field_92055_b && !CraftEventFactory.callFireworkExplodeEvent((FireworkRocketEntity)this).isCancelled()) {
            this.func_213893_k();
        }
    }

    @Override
    protected void func_70227_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.MISS || !ForgeEventFactory.onProjectileImpact((FireworkRocketEntity)this, (RayTraceResult)result)) {
            super.func_70227_a(result);
        }
    }

    private void func_213893_k() {
        this.field_70170_p.func_72960_a(this, (byte)17);
        this.func_191510_k();
        this.func_70106_y();
    }

    @Override
    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        super.func_213868_a(p_213868_1_);
        if (!this.field_70170_p.field_72995_K && !CraftEventFactory.callFireworkExplodeEvent((FireworkRocketEntity)this).isCancelled()) {
            this.func_213893_k();
        }
    }

    @Override
    protected void func_230299_a_(BlockRayTraceResult p_230299_1_) {
        BlockPos blockpos = new BlockPos(p_230299_1_.func_216350_a());
        this.field_70170_p.func_180495_p(blockpos).func_196950_a(this.field_70170_p, blockpos, this);
        if (!this.field_70170_p.func_201670_d() && this.func_213894_l() && !CraftEventFactory.callFireworkExplodeEvent((FireworkRocketEntity)this).isCancelled()) {
            this.func_213893_k();
        }
        super.func_230299_a_(p_230299_1_);
    }

    private boolean func_213894_l() {
        ItemStack itemstack = this.field_70180_af.func_187225_a(field_184566_a);
        CompoundNBT compoundnbt = itemstack.func_190926_b() ? null : itemstack.func_179543_a("Fireworks");
        ListNBT listnbt = compoundnbt != null ? compoundnbt.func_150295_c("Explosions", 10) : null;
        return listnbt != null && !listnbt.isEmpty();
    }

    private void func_191510_k() {
        ListNBT listnbt;
        float f = 0.0f;
        ItemStack itemstack = this.field_70180_af.func_187225_a(field_184566_a);
        CompoundNBT compoundnbt = itemstack.func_190926_b() ? null : itemstack.func_179543_a("Fireworks");
        ListNBT listNBT = listnbt = compoundnbt != null ? compoundnbt.func_150295_c("Explosions", 10) : null;
        if (listnbt != null && !listnbt.isEmpty()) {
            f = 5.0f + (float)(listnbt.size() * 2);
        }
        if (f > 0.0f) {
            if (this.field_191513_e != null) {
                CraftEventFactory.entityDamage = this;
                this.field_191513_e.func_70097_a(DamageSource.func_233548_a_(this, this.func_234616_v_()), 5.0f + (float)(listnbt.size() * 2));
                CraftEventFactory.entityDamage = null;
            }
            double d0 = 5.0;
            Vector3d vector3d = this.func_213303_ch();
            for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(5.0))) {
                if (livingentity == this.field_191513_e || this.func_70068_e(livingentity) > 25.0) continue;
                boolean flag = false;
                for (int i = 0; i < 2; ++i) {
                    Vector3d vector3d1 = new Vector3d(livingentity.func_226277_ct_(), livingentity.func_226283_e_(0.5 * (double)i), livingentity.func_226281_cx_());
                    BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, this));
                    if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f * (float)Math.sqrt((5.0 - (double)this.func_70032_d(livingentity)) / 5.0);
                CraftEventFactory.entityDamage = this;
                livingentity.func_70097_a(DamageSource.func_233548_a_(this, this.func_234616_v_()), f1);
                CraftEventFactory.entityDamage = null;
            }
        }
    }

    private boolean func_191511_j() {
        return this.field_70180_af.func_187225_a(field_191512_b).isPresent();
    }

    public boolean func_213889_i() {
        return this.field_70180_af.func_187225_a(field_213895_d);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 17 && this.field_70170_p.field_72995_K) {
            if (!this.func_213894_l()) {
                for (int i = 0; i < this.field_70146_Z.nextInt(3) + 2; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70146_Z.nextGaussian() * 0.05, 0.005, this.field_70146_Z.nextGaussian() * 0.05);
                }
            } else {
                ItemStack itemstack = this.field_70180_af.func_187225_a(field_184566_a);
                CompoundNBT compoundnbt = itemstack.func_190926_b() ? null : itemstack.func_179543_a("Fireworks");
                Vector3d vector3d = this.func_213322_ci();
                this.field_70170_p.func_92088_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, compoundnbt);
            }
        }
        super.func_70103_a(p_70103_1_);
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("Life", this.field_92056_a);
        p_213281_1_.func_74768_a("LifeTime", this.field_92055_b);
        ItemStack itemstack = this.field_70180_af.func_187225_a(field_184566_a);
        if (!itemstack.func_190926_b()) {
            p_213281_1_.func_218657_a("FireworksItem", itemstack.func_77955_b(new CompoundNBT()));
        }
        p_213281_1_.func_74757_a("ShotAtAngle", this.field_70180_af.func_187225_a(field_213895_d));
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.field_92056_a = p_70037_1_.func_74762_e("Life");
        this.field_92055_b = p_70037_1_.func_74762_e("LifeTime");
        ItemStack itemstack = ItemStack.func_199557_a(p_70037_1_.func_74775_l("FireworksItem"));
        if (!itemstack.func_190926_b()) {
            this.field_70180_af.func_187227_b(field_184566_a, itemstack);
        }
        if (p_70037_1_.func_74764_b("ShotAtAngle")) {
            this.field_70180_af.func_187227_b(field_213895_d, p_70037_1_.func_74767_n("ShotAtAngle"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_184543_l() {
        ItemStack itemstack = this.field_70180_af.func_187225_a(field_184566_a);
        return itemstack.func_190926_b() ? new ItemStack(Items.field_196152_dE) : itemstack;
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }
}

