/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class ThrowableEntity
extends ProjectileEntity {
    protected ThrowableEntity(EntityType<? extends ThrowableEntity> p_i48540_1_, World p_i48540_2_) {
        super((EntityType<? extends ProjectileEntity>)p_i48540_1_, p_i48540_2_);
    }

    protected ThrowableEntity(EntityType<? extends ThrowableEntity> p_i48541_1_, double p_i48541_2_, double p_i48541_4_, double p_i48541_6_, World p_i48541_8_) {
        this(p_i48541_1_, p_i48541_8_);
        this.func_70107_b(p_i48541_2_, p_i48541_4_, p_i48541_6_);
    }

    protected ThrowableEntity(EntityType<? extends ThrowableEntity> p_i48542_1_, LivingEntity p_i48542_2_, World p_i48542_3_) {
        this(p_i48542_1_, p_i48542_2_.func_226277_ct_(), p_i48542_2_.func_226280_cw_() - (double)0.1f, p_i48542_2_.func_226281_cx_(), p_i48542_3_);
        this.func_212361_a(p_i48542_2_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return p_70112_1_ < (d0 *= 64.0) * d0;
    }

    @Override
    public void func_70071_h_() {
        float f;
        super.func_70071_h_();
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_(this, this::func_230298_a_);
        boolean flag = false;
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockRayTraceResult)raytraceresult).func_216350_a();
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            if (blockstate.func_203425_a(Blocks.field_150427_aO)) {
                this.func_181015_d(blockpos);
                flag = true;
            } else if (blockstate.func_203425_a(Blocks.field_185775_db)) {
                TileEntity tileentity = this.field_70170_p.func_175625_s(blockpos);
                if (tileentity instanceof EndGatewayTileEntity && EndGatewayTileEntity.func_242690_a(this)) {
                    ((EndGatewayTileEntity)((Object)tileentity)).func_195496_a(this);
                }
                flag = true;
            }
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)raytraceresult)) {
            this.preOnHit(raytraceresult);
        }
        this.func_145775_I();
        Vector3d vector3d = this.func_213322_ci();
        double d2 = this.func_226277_ct_() + vector3d.field_72450_a;
        double d0 = this.func_226278_cu_() + vector3d.field_72448_b;
        double d1 = this.func_226281_cx_() + vector3d.field_72449_c;
        this.func_234617_x_();
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f1 = 0.25f;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d2 - vector3d.field_72450_a * 0.25, d0 - vector3d.field_72448_b * 0.25, d1 - vector3d.field_72449_c * 0.25, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
            }
            f = 0.8f;
        } else {
            f = 0.99f;
        }
        this.func_213317_d(vector3d.func_186678_a(f));
        if (!this.func_189652_ae()) {
            Vector3d vector3d1 = this.func_213322_ci();
            this.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b - (double)this.func_70185_h(), vector3d1.field_72449_c);
        }
        this.func_70107_b(d2, d0, d1);
    }

    protected float func_70185_h() {
        return 0.03f;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }
}

