/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.event.weather.LightningStrikeEvent;

public class TridentEntity
extends AbstractArrowEntity {
    private static final DataParameter<Byte> field_203053_g = EntityDataManager.func_187226_a(TridentEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> field_226571_aq_ = EntityDataManager.func_187226_a(TridentEntity.class, DataSerializers.field_187198_h);
    public ItemStack field_203054_h = new ItemStack(Items.field_203184_eO);
    private boolean field_203051_au;
    public int field_203052_f;

    public TridentEntity(EntityType<? extends TridentEntity> p_i50148_1_, World p_i50148_2_) {
        super((EntityType<? extends AbstractArrowEntity>)p_i50148_1_, p_i50148_2_);
    }

    public TridentEntity(World p_i48790_1_, LivingEntity p_i48790_2_, ItemStack p_i48790_3_) {
        super(EntityType.field_203098_aL, p_i48790_2_, p_i48790_1_);
        this.field_203054_h = p_i48790_3_.func_77946_l();
        this.field_70180_af.func_187227_b(field_203053_g, (byte)EnchantmentHelper.func_203191_f(p_i48790_3_));
        this.field_70180_af.func_187227_b(field_226571_aq_, p_i48790_3_.func_77962_s());
    }

    @OnlyIn(value=Dist.CLIENT)
    public TridentEntity(World p_i48791_1_, double p_i48791_2_, double p_i48791_4_, double p_i48791_6_) {
        super(EntityType.field_203098_aL, p_i48791_2_, p_i48791_4_, p_i48791_6_, p_i48791_1_);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_203053_g, (byte)0);
        this.field_70180_af.func_187214_a(field_226571_aq_, false);
    }

    @Override
    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.field_203051_au = true;
        }
        Entity entity = this.func_234616_v_();
        if ((this.field_203051_au || this.func_203047_q()) && entity != null) {
            byte i = this.field_70180_af.func_187225_a(field_203053_g);
            if (i > 0 && !this.func_207403_q()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (i > 0) {
                this.func_203045_n(true);
                Vector3d vector3d = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226280_cw_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vector3d.field_72448_b * 0.015 * (double)i, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double d0 = 0.05 * (double)i;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vector3d.func_72432_b().func_186678_a(d0)));
                if (this.field_203052_f == 0) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                }
                ++this.field_203052_f;
            }
        }
        super.func_70071_h_();
    }

    private boolean func_207403_q() {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    @Override
    protected ItemStack func_184550_j() {
        return this.field_203054_h.func_77946_l();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_226572_w_() {
        return this.field_70180_af.func_187225_a(field_226571_aq_);
    }

    @Override
    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d p_213866_1_, Vector3d p_213866_2_) {
        return this.field_203051_au ? null : super.func_213866_a(p_213866_1_, p_213866_2_);
    }

    @Override
    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        BlockPos blockpos;
        Entity entity1;
        Entity entity = p_213868_1_.func_216348_a();
        float f = 8.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.func_152377_a(this.field_203054_h, livingentity.func_70668_bt());
        }
        DamageSource damagesource = DamageSource.func_203096_a(this, (entity1 = this.func_234616_v_()) == null ? this : entity1);
        this.field_203051_au = true;
        SoundEvent soundevent = SoundEvents.field_203268_ij;
        if (entity.func_70097_a(damagesource, f)) {
            if (entity.func_200600_R() == EntityType.field_200803_q) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a(livingentity1, entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)entity1, livingentity1);
                }
                this.func_184548_a(livingentity1);
            }
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        if (this.field_70170_p instanceof ServerWorld && this.field_70170_p.func_72911_I() && EnchantmentHelper.func_203192_h(this.field_203054_h) && this.field_70170_p.func_226660_f_(blockpos = entity.func_233580_cy_())) {
            LightningBoltEntity lightningboltentity = EntityType.field_200728_aG.func_200721_a(this.field_70170_p);
            lightningboltentity.func_233576_c_(Vector3d.func_237492_c_(blockpos));
            lightningboltentity.func_204809_d(entity1 instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity1 : null);
            ((ServerWorld)this.field_70170_p).strikeLightning(lightningboltentity, LightningStrikeEvent.Cause.TRIDENT);
            soundevent = SoundEvents.field_203275_iq;
            f1 = 5.0f;
        }
        this.func_184185_a(soundevent, f1, 1.0f);
    }

    @Override
    protected SoundEvent func_213867_k() {
        return SoundEvents.field_203269_ik;
    }

    @Override
    public void func_70100_b_(PlayerEntity p_70100_1_) {
        Entity entity = this.func_234616_v_();
        if (entity == null || entity.func_110124_au() == p_70100_1_.func_110124_au()) {
            super.func_70100_b_(p_70100_1_);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_150297_b("Trident", 10)) {
            this.field_203054_h = ItemStack.func_199557_a(p_70037_1_.func_74775_l("Trident"));
        }
        this.field_203051_au = p_70037_1_.func_74767_n("DealtDamage");
        this.field_70180_af.func_187227_b(field_203053_g, (byte)EnchantmentHelper.func_203191_f(this.field_203054_h));
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_218657_a("Trident", this.field_203054_h.func_77955_b(new CompoundNBT()));
        p_213281_1_.func_74757_a("DealtDamage", this.field_203051_au);
    }

    @Override
    public void func_225516_i_() {
        byte i = this.field_70180_af.func_187225_a(field_203053_g);
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || i <= 0) {
            super.func_225516_i_();
        }
    }

    @Override
    protected float func_203044_p() {
        return 0.99f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }
}

