/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Lists;
import io.papermc.paper.event.entity.EntityLoadCrossbowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.EquipmentSlot;

public class CrossbowItem
extends ShootableItem
implements IVanishable {
    private boolean field_220034_c = false;
    private boolean field_220035_d = false;

    public CrossbowItem(Item.Properties p_i50052_1_) {
        super(p_i50052_1_);
    }

    public Predicate<ItemStack> func_220006_d() {
        return field_220008_b;
    }

    public Predicate<ItemStack> func_220004_b() {
        return field_220007_a;
    }

    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        ItemStack itemstack = p_77659_2_.func_184586_b(p_77659_3_);
        if (CrossbowItem.func_220012_d(itemstack)) {
            CrossbowItem.func_220014_a(p_77659_1_, p_77659_2_, p_77659_3_, itemstack, CrossbowItem.func_220013_l(itemstack), 1.0f);
            CrossbowItem.func_220011_a(itemstack, false);
            return ActionResult.func_226249_b_((Object)((Object)itemstack));
        }
        if (!p_77659_2_.func_213356_f(itemstack).func_190926_b()) {
            if (!CrossbowItem.func_220012_d(itemstack)) {
                this.field_220034_c = false;
                this.field_220035_d = false;
                p_77659_2_.func_184598_c(p_77659_3_);
            }
            return ActionResult.func_226249_b_((Object)((Object)itemstack));
        }
        return ActionResult.func_226251_d_((Object)((Object)itemstack));
    }

    public void func_77615_a(ItemStack p_77615_1_, World p_77615_2_, LivingEntity p_77615_3_, int p_77615_4_) {
        int i = this.func_77626_a(p_77615_1_) - p_77615_4_;
        float f = CrossbowItem.func_220031_a(i, p_77615_1_);
        if (f >= 1.0f && !CrossbowItem.func_220012_d(p_77615_1_)) {
            EntityLoadCrossbowEvent event = new EntityLoadCrossbowEvent((org.bukkit.entity.LivingEntity)p_77615_3_.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror((ItemStack)p_77615_1_), p_77615_3_.func_184600_cs() == Hand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
            if (!event.callEvent() || !CrossbowItem.attemptProjectileLoad(p_77615_3_, p_77615_1_, event.shouldConsumeItem())) {
                return;
            }
            CrossbowItem.func_220011_a(p_77615_1_, true);
            SoundCategory soundcategory = p_77615_3_ instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            p_77615_2_.func_184148_a(null, p_77615_3_.func_226277_ct_(), p_77615_3_.func_226278_cu_(), p_77615_3_.func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean attemptProjectileLoad(LivingEntity ent, ItemStack bow) {
        return CrossbowItem.func_220021_a(ent, bow);
    }

    private static boolean attemptProjectileLoad(LivingEntity ent, ItemStack bow, boolean consume) {
        return CrossbowItem.a(ent, bow, consume);
    }

    private static boolean func_220021_a(LivingEntity p_220021_0_, ItemStack p_220021_1_) {
        int i = EnchantmentHelper.func_77506_a(Enchantments.field_222192_G, p_220021_1_);
        int j = i == 0 ? 1 : 3;
        boolean flag = p_220021_0_ instanceof PlayerEntity && ((PlayerEntity)p_220021_0_).field_71075_bZ.field_75098_d;
        ItemStack itemstack = p_220021_0_.func_213356_f(p_220021_1_);
        ItemStack itemstack1 = itemstack.func_77946_l();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.func_77946_l();
            }
            if (itemstack.func_190926_b() && flag) {
                itemstack = new ItemStack(Items.field_151032_g);
                itemstack1 = itemstack.func_77946_l();
            } else if (itemstack1.func_190926_b()) {
                return false;
            }
            if (CrossbowItem.func_220023_a(p_220021_0_, p_220021_1_, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean a(LivingEntity p_220021_0_, ItemStack p_220021_1_, boolean consume) {
        int i = EnchantmentHelper.func_77506_a(Enchantments.field_222192_G, p_220021_1_);
        int j = i == 0 ? 1 : 3;
        boolean flag = !consume || p_220021_0_ instanceof PlayerEntity && ((PlayerEntity)p_220021_0_).field_71075_bZ.field_75098_d;
        ItemStack itemstack = p_220021_0_.func_213356_f(p_220021_1_);
        ItemStack itemstack1 = itemstack.func_77946_l();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.func_77946_l();
            }
            if (itemstack.func_190926_b() && flag) {
                itemstack = new ItemStack(Items.field_151032_g);
                itemstack1 = itemstack.func_77946_l();
            } else if (itemstack1.func_190926_b()) {
                return false;
            }
            if (CrossbowItem.func_220023_a(p_220021_0_, p_220021_1_, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean func_220023_a(LivingEntity p_220023_0_, ItemStack p_220023_1_, ItemStack p_220023_2_, boolean p_220023_3_, boolean p_220023_4_) {
        ItemStack itemstack;
        boolean flag;
        if (p_220023_2_.func_190926_b()) {
            return false;
        }
        boolean bl = flag = p_220023_4_ && p_220023_2_.func_77973_b() instanceof ArrowItem;
        if (!(flag || p_220023_4_ || p_220023_3_)) {
            itemstack = p_220023_2_.func_77979_a(1);
            if (p_220023_2_.func_190926_b() && p_220023_0_ instanceof PlayerEntity) {
                ((PlayerEntity)p_220023_0_).field_71071_by.func_184437_d(p_220023_2_);
            }
        } else {
            itemstack = p_220023_2_.func_77946_l();
        }
        CrossbowItem.func_220029_b(p_220023_1_, itemstack);
        return true;
    }

    public static boolean func_220012_d(ItemStack p_220012_0_) {
        CompoundNBT compoundnbt = p_220012_0_.func_77978_p();
        return compoundnbt != null && compoundnbt.func_74767_n("Charged");
    }

    public static void func_220011_a(ItemStack p_220011_0_, boolean p_220011_1_) {
        CompoundNBT compoundnbt = p_220011_0_.func_196082_o();
        compoundnbt.func_74757_a("Charged", p_220011_1_);
    }

    private static void func_220029_b(ItemStack p_220029_0_, ItemStack p_220029_1_) {
        CompoundNBT compoundnbt = p_220029_0_.func_196082_o();
        ListNBT listnbt = compoundnbt.func_150297_b("ChargedProjectiles", 9) ? compoundnbt.func_150295_c("ChargedProjectiles", 10) : new ListNBT();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        p_220029_1_.func_77955_b(compoundnbt1);
        listnbt.add((Object)compoundnbt1);
        compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
    }

    private static List<ItemStack> func_220018_j(ItemStack p_220018_0_) {
        ListNBT listnbt;
        ArrayList list = Lists.newArrayList();
        CompoundNBT compoundnbt = p_220018_0_.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("ChargedProjectiles", 9) && (listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                list.add(ItemStack.func_199557_a(compoundnbt1));
            }
        }
        return list;
    }

    private static void func_220027_k(ItemStack p_220027_0_) {
        CompoundNBT compoundnbt = p_220027_0_.func_77978_p();
        if (compoundnbt != null) {
            ListNBT listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 9);
            listnbt.clear();
            compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
        }
    }

    public static boolean func_220019_a(ItemStack p_220019_0_, Item p_220019_1_) {
        return CrossbowItem.func_220018_j(p_220019_0_).stream().anyMatch(p_220010_1_ -> p_220010_1_.func_77973_b() == p_220019_1_);
    }

    private static void func_220016_a(World p_220016_0_, LivingEntity p_220016_1_, Hand p_220016_2_, ItemStack p_220016_3_, ItemStack p_220016_4_, float p_220016_5_, boolean p_220016_6_, float p_220016_7_, float p_220016_8_, float p_220016_9_) {
        if (!p_220016_0_.field_72995_K) {
            ProjectileEntity projectileentity;
            boolean flag;
            boolean bl = flag = p_220016_4_.func_77973_b() == Items.field_196152_dE;
            if (flag) {
                projectileentity = new FireworkRocketEntity(p_220016_0_, p_220016_4_, p_220016_1_, p_220016_1_.func_226277_ct_(), p_220016_1_.func_226280_cw_() - (double)0.15f, p_220016_1_.func_226281_cx_(), true);
            } else {
                projectileentity = CrossbowItem.func_220024_a(p_220016_0_, p_220016_1_, p_220016_3_, p_220016_4_);
                if (p_220016_6_ || p_220016_9_ != 0.0f) {
                    ((AbstractArrowEntity)projectileentity).field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
            }
            if (p_220016_1_ instanceof ICrossbowUser) {
                ICrossbowUser icrossbowuser = (ICrossbowUser)p_220016_1_;
                icrossbowuser.func_230284_a_(icrossbowuser.func_70638_az(), p_220016_3_, projectileentity, p_220016_9_);
            } else {
                Vector3d vector3d1 = p_220016_1_.func_213286_i(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), p_220016_9_, true);
                Vector3d vector3d = p_220016_1_.func_70676_i(1.0f);
                Vector3f vector3f = new Vector3f(vector3d);
                vector3f.func_214905_a(quaternion);
                projectileentity.func_70186_c(vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c(), p_220016_7_, p_220016_8_);
            }
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent((LivingEntity)p_220016_1_, (ItemStack)p_220016_3_, (ItemStack)p_220016_4_, (Entity)projectileentity, (Hand)p_220016_1_.func_184600_cs(), (float)p_220016_5_, (boolean)true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            p_220016_3_.func_222118_a(flag ? 3 : 1, p_220016_1_, p_220017_1_ -> p_220017_1_.func_213334_d(p_220016_2_));
            if (event.getProjectile() == projectileentity.getBukkitEntity() && !p_220016_0_.func_217376_c(projectileentity)) {
                if (p_220016_1_ instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)p_220016_1_).getBukkitEntity().updateInventory();
                }
                return;
            }
            p_220016_0_.func_184148_a(null, p_220016_1_.func_226277_ct_(), p_220016_1_.func_226278_cu_(), p_220016_1_.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, p_220016_5_);
        }
    }

    private static AbstractArrowEntity func_220024_a(World p_220024_0_, LivingEntity p_220024_1_, ItemStack p_220024_2_, ItemStack p_220024_3_) {
        ArrowItem arrowitem = (ArrowItem)(p_220024_3_.func_77973_b() instanceof ArrowItem ? p_220024_3_.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(p_220024_0_, p_220024_3_, p_220024_1_);
        if (p_220024_1_ instanceof PlayerEntity) {
            abstractarrowentity.func_70243_d(true);
        }
        abstractarrowentity.func_213869_a(SoundEvents.field_219609_bA);
        abstractarrowentity.func_213865_o(true);
        int i = EnchantmentHelper.func_77506_a(Enchantments.field_222194_I, p_220024_2_);
        if (i > 0) {
            abstractarrowentity.func_213872_b((byte)i);
        }
        return abstractarrowentity;
    }

    public static void func_220014_a(World p_220014_0_, LivingEntity p_220014_1_, Hand p_220014_2_, ItemStack p_220014_3_, float p_220014_4_, float p_220014_5_) {
        List<ItemStack> list = CrossbowItem.func_220018_j(p_220014_3_);
        float[] afloat = CrossbowItem.func_220028_a(p_220014_1_.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = list.get(i);
            boolean bl = flag = p_220014_1_ instanceof PlayerEntity && ((PlayerEntity)p_220014_1_).field_71075_bZ.field_75098_d;
            if (itemstack.func_190926_b()) continue;
            if (i == 0) {
                CrossbowItem.func_220016_a(p_220014_0_, p_220014_1_, p_220014_2_, p_220014_3_, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, 0.0f);
                continue;
            }
            if (i == 1) {
                CrossbowItem.func_220016_a(p_220014_0_, p_220014_1_, p_220014_2_, p_220014_3_, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, -10.0f);
                continue;
            }
            if (i != 2) continue;
            CrossbowItem.func_220016_a(p_220014_0_, p_220014_1_, p_220014_2_, p_220014_3_, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, 10.0f);
        }
        CrossbowItem.func_220015_a(p_220014_0_, p_220014_1_, p_220014_3_);
    }

    private static float[] func_220028_a(Random p_220028_0_) {
        boolean flag = p_220028_0_.nextBoolean();
        return new float[]{1.0f, CrossbowItem.func_220032_a(flag), CrossbowItem.func_220032_a(!flag)};
    }

    private static float func_220032_a(boolean p_220032_0_) {
        float f = p_220032_0_ ? 0.63f : 0.43f;
        return 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static void func_220015_a(World p_220015_0_, LivingEntity p_220015_1_, ItemStack p_220015_2_) {
        if (p_220015_1_ instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)p_220015_1_;
            if (!p_220015_0_.field_72995_K) {
                CriteriaTriggers.field_215099_F.func_215111_a(serverplayerentity, p_220015_2_);
            }
            serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b(p_220015_2_.func_77973_b()));
        }
        CrossbowItem.func_220027_k(p_220015_2_);
    }

    public void func_219972_a(World p_219972_1_, LivingEntity p_219972_2_, ItemStack p_219972_3_, int p_219972_4_) {
        if (!p_219972_1_.field_72995_K) {
            int i = EnchantmentHelper.func_77506_a(Enchantments.field_222193_H, p_219972_3_);
            SoundEvent soundevent = this.func_220025_a(i);
            SoundEvent soundevent1 = i == 0 ? SoundEvents.field_219611_bC : null;
            float f = (float)(p_219972_3_.func_77988_m() - p_219972_4_) / (float)CrossbowItem.func_220026_e(p_219972_3_);
            if (f < 0.2f) {
                this.field_220034_c = false;
                this.field_220035_d = false;
            }
            if (f >= 0.2f && !this.field_220034_c) {
                this.field_220034_c = true;
                p_219972_1_.func_184148_a(null, p_219972_2_.func_226277_ct_(), p_219972_2_.func_226278_cu_(), p_219972_2_.func_226281_cx_(), soundevent, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundevent1 != null && !this.field_220035_d) {
                this.field_220035_d = true;
                p_219972_1_.func_184148_a(null, p_219972_2_.func_226277_ct_(), p_219972_2_.func_226278_cu_(), p_219972_2_.func_226281_cx_(), soundevent1, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return CrossbowItem.func_220026_e(p_77626_1_) + 3;
    }

    public static int func_220026_e(ItemStack p_220026_0_) {
        int i = EnchantmentHelper.func_77506_a(Enchantments.field_222193_H, p_220026_0_);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.CROSSBOW;
    }

    private SoundEvent func_220025_a(int p_220025_1_) {
        switch (p_220025_1_) {
            case 1: {
                return SoundEvents.field_219613_bE;
            }
            case 2: {
                return SoundEvents.field_219614_bF;
            }
            case 3: {
                return SoundEvents.field_219615_bG;
            }
        }
        return SoundEvents.field_219612_bD;
    }

    private static float func_220031_a(int p_220031_0_, ItemStack p_220031_1_) {
        float f = (float)p_220031_0_ / (float)CrossbowItem.func_220026_e(p_220031_1_);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, @Nullable World p_77624_2_, List<ITextComponent> p_77624_3_, ITooltipFlag p_77624_4_) {
        List<ItemStack> list = CrossbowItem.func_220018_j(p_77624_1_);
        if (CrossbowItem.func_220012_d(p_77624_1_) && !list.isEmpty()) {
            ItemStack itemstack = list.get(0);
            p_77624_3_.add((ITextComponent)new TranslationTextComponent("item.minecraft.crossbow.projectile").func_240702_b_(" ").func_230529_a_(itemstack.func_151000_E()));
            if (p_77624_4_.func_194127_a() && itemstack.func_77973_b() == Items.field_196152_dE) {
                ArrayList list1 = Lists.newArrayList();
                Items.field_196152_dE.func_77624_a(itemstack, p_77624_2_, list1, p_77624_4_);
                if (!list1.isEmpty()) {
                    for (int i = 0; i < list1.size(); ++i) {
                        list1.set(i, new StringTextComponent("  ").func_230529_a_((ITextComponent)list1.get(i)).func_240699_a_(TextFormatting.GRAY));
                    }
                    p_77624_3_.addAll(list1);
                }
            }
        }
    }

    private static float func_220013_l(ItemStack p_220013_0_) {
        return p_220013_0_.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220019_a(p_220013_0_, Items.field_196152_dE) ? 1.6f : 3.15f;
    }

    public int func_230305_d_() {
        return 8;
    }
}

