/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.AbstractMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.map.MapView;

public class FilledMapItem
extends AbstractMapItem {
    public FilledMapItem(Item.Properties p_i48482_1_) {
        super(p_i48482_1_);
    }

    public static ItemStack func_195952_a(World p_195952_0_, int p_195952_1_, int p_195952_2_, byte p_195952_3_, boolean p_195952_4_, boolean p_195952_5_) {
        ItemStack itemstack = new ItemStack(Items.field_151098_aY);
        FilledMapItem.func_195951_a(itemstack, p_195952_0_, p_195952_1_, p_195952_2_, p_195952_3_, p_195952_4_, p_195952_5_, p_195952_0_.func_234923_W_());
        return itemstack;
    }

    @Nullable
    public static MapData func_219994_a(ItemStack p_219994_0_, World p_219994_1_) {
        return p_219994_1_.func_217406_a(FilledMapItem.func_219993_a(FilledMapItem.func_195949_f(p_219994_0_)));
    }

    @Nullable
    public static MapData func_195950_a(ItemStack p_195950_0_, World p_195950_1_) {
        Item map = p_195950_0_.func_77973_b();
        if (map instanceof FilledMapItem) {
            return ((FilledMapItem)((Object)map)).getCustomMapData(p_195950_0_, p_195950_1_);
        }
        return null;
    }

    @Nullable
    protected MapData getCustomMapData(ItemStack p_195950_0_, World p_195950_1_) {
        MapData mapdata = FilledMapItem.func_219994_a(p_195950_0_, p_195950_1_);
        if (mapdata == null && p_195950_1_ instanceof ServerWorld) {
            mapdata = FilledMapItem.func_195951_a(p_195950_0_, p_195950_1_, p_195950_1_.func_72912_H().func_76079_c(), p_195950_1_.func_72912_H().func_76074_e(), 3, false, false, p_195950_1_.func_234923_W_());
        }
        return mapdata;
    }

    public static int func_195949_f(ItemStack p_195949_0_) {
        CompoundNBT compoundnbt = p_195949_0_.func_77978_p();
        return compoundnbt != null && compoundnbt.func_150297_b("map", 99) ? compoundnbt.func_74762_e("map") : -1;
    }

    private static MapData func_195951_a(ItemStack p_195951_0_, World p_195951_1_, int p_195951_2_, int p_195951_3_, int p_195951_4_, boolean p_195951_5_, boolean p_195951_6_, RegistryKey<World> p_195951_7_) {
        int i = p_195951_1_.func_217395_y();
        MapData mapdata = new MapData(FilledMapItem.func_219993_a(i));
        mapdata.func_237241_a_(p_195951_2_, p_195951_3_, p_195951_4_, p_195951_5_, p_195951_6_, p_195951_7_);
        p_195951_1_.func_217399_a(mapdata);
        p_195951_0_.func_196082_o().func_74768_a("map", i);
        MapInitializeEvent event = new MapInitializeEvent((MapView)mapdata.mapView);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return mapdata;
    }

    public static String func_219993_a(int p_219993_0_) {
        return "map_" + p_219993_0_;
    }

    public void func_77872_a(World p_77872_1_, Entity p_77872_2_, MapData p_77872_3_) {
        if (p_77872_1_.func_234923_W_() == p_77872_3_.field_76200_c && p_77872_2_ instanceof PlayerEntity) {
            int i = 1 << p_77872_3_.field_76197_d;
            int j = p_77872_3_.field_76201_a;
            int k = p_77872_3_.field_76199_b;
            int l = MathHelper.func_76128_c((double)(p_77872_2_.func_226277_ct_() - (double)j)) / i + 64;
            int i1 = MathHelper.func_76128_c((double)(p_77872_2_.func_226281_cx_() - (double)k)) / i + 64;
            int j1 = 128 / i;
            if (p_77872_1_.func_230315_m_().func_236037_d_()) {
                j1 /= 2;
            }
            MapData.MapInfo mapdata$mapinfo = p_77872_3_.func_82568_a((PlayerEntity)p_77872_2_);
            ++mapdata$mapinfo.field_82569_d;
            boolean flag = false;
            for (int k1 = l - j1 + 1; k1 < l + j1; ++k1) {
                if ((k1 & 0xF) != (mapdata$mapinfo.field_82569_d & 0xF) && !flag) continue;
                flag = false;
                double d0 = 0.0;
                for (int l1 = i1 - j1 - 1; l1 < i1 + j1; ++l1) {
                    byte b1;
                    byte b0;
                    MaterialColor materialcolor;
                    if (k1 < 0 || l1 < -1 || k1 >= 128 || l1 >= 128) continue;
                    int i2 = k1 - l;
                    int j2 = l1 - i1;
                    boolean flag1 = i2 * i2 + j2 * j2 > (j1 - 2) * (j1 - 2);
                    int k2 = (j / i + k1 - 64) * i;
                    int l2 = (k / i + l1 - 64) * i;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    Chunk chunk = p_77872_1_.func_175726_f(new BlockPos(k2, 0, l2));
                    if (chunk.func_76621_g()) continue;
                    ChunkPos chunkpos = chunk.func_76632_l();
                    int i3 = k2 & 0xF;
                    int j3 = l2 & 0xF;
                    int k3 = 0;
                    double d1 = 0.0;
                    if (p_77872_1_.func_230315_m_().func_236037_d_()) {
                        int l3 = k2 + l2 * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.field_150346_d.func_176223_P().func_185909_g((IBlockReader)((Object)p_77872_1_), BlockPos.field_177992_a), 10);
                        } else {
                            multiset.add((Object)Blocks.field_150348_b.func_176223_P().func_185909_g((IBlockReader)((Object)p_77872_1_), BlockPos.field_177992_a), 100);
                        }
                        d1 = 100.0;
                    } else {
                        BlockPos.Mutable blockpos$mutable1 = new BlockPos.Mutable();
                        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
                        for (int i4 = 0; i4 < i; ++i4) {
                            for (int j4 = 0; j4 < i; ++j4) {
                                BlockState blockstate;
                                int k4 = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, i4 + i3, j4 + j3) + 1;
                                if (k4 <= 1) {
                                    blockstate = Blocks.field_150357_h.func_176223_P();
                                } else {
                                    do {
                                        blockpos$mutable1.func_181079_c(chunkpos.func_180334_c() + i4 + i3, --k4, chunkpos.func_180333_d() + j4 + j3);
                                    } while ((blockstate = chunk.func_180495_p(blockpos$mutable1)).func_185909_g((IBlockReader)((Object)p_77872_1_), blockpos$mutable1) == MaterialColor.field_151660_b && k4 > 0);
                                    if (k4 > 0 && !blockstate.func_204520_s().func_206888_e()) {
                                        BlockState blockstate1;
                                        int l4 = k4 - 1;
                                        blockpos$mutable.func_189533_g(blockpos$mutable1);
                                        do {
                                            blockpos$mutable.func_185336_p(l4--);
                                            blockstate1 = chunk.func_180495_p(blockpos$mutable);
                                            ++k3;
                                        } while (l4 > 0 && !blockstate1.func_204520_s().func_206888_e());
                                        blockstate = this.func_211698_a(p_77872_1_, blockstate, blockpos$mutable1);
                                    }
                                }
                                p_77872_3_.func_204268_a((IBlockReader)((Object)p_77872_1_), chunkpos.func_180334_c() + i4 + i3, chunkpos.func_180333_d() + j4 + j3);
                                d1 += (double)k4 / (double)(i * i);
                                multiset.add((Object)blockstate.func_185909_g((IBlockReader)((Object)p_77872_1_), blockpos$mutable1));
                            }
                        }
                    }
                    k3 /= i * i;
                    double d2 = (d1 - d0) * 4.0 / (double)(i + 4) + ((double)(k1 + l1 & 1) - 0.5) * 0.4;
                    int i5 = 1;
                    if (d2 > 0.6) {
                        i5 = 2;
                    }
                    if (d2 < -0.6) {
                        i5 = 0;
                    }
                    if ((materialcolor = (MaterialColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialColor.field_151660_b)) == MaterialColor.field_151662_n) {
                        d2 = (double)k3 * 0.1 + (double)(k1 + l1 & 1) * 0.2;
                        i5 = 1;
                        if (d2 < 0.5) {
                            i5 = 2;
                        }
                        if (d2 > 0.9) {
                            i5 = 0;
                        }
                    }
                    d0 = d1;
                    if (l1 < 0 || i2 * i2 + j2 * j2 >= j1 * j1 || flag1 && (k1 + l1 & 1) == 0 || (b0 = p_77872_3_.field_76198_e[k1 + l1 * 128]) == (b1 = (byte)(materialcolor.field_76290_q * 4 + i5))) continue;
                    p_77872_3_.field_76198_e[k1 + l1 * 128] = b1;
                    p_77872_3_.func_176053_a(k1, l1);
                    flag = true;
                }
            }
        }
    }

    private BlockState func_211698_a(World p_211698_1_, BlockState p_211698_2_, BlockPos p_211698_3_) {
        FluidState fluidstate = p_211698_2_.func_204520_s();
        return !fluidstate.func_206888_e() && !p_211698_2_.func_224755_d((IBlockReader)((Object)p_211698_1_), p_211698_3_, Direction.UP) ? fluidstate.func_206883_i() : p_211698_2_;
    }

    private static boolean func_195954_a(Biome[] p_195954_0_, int p_195954_1_, int p_195954_2_, int p_195954_3_) {
        return p_195954_0_[p_195954_2_ * p_195954_1_ + p_195954_3_ * p_195954_1_ * 128 * p_195954_1_].func_185355_j() >= 0.0f;
    }

    public static void func_226642_a_(ServerWorld p_226642_0_, ItemStack p_226642_1_) {
        MapData mapdata = FilledMapItem.func_195950_a(p_226642_1_, p_226642_0_);
        if (mapdata != null && p_226642_0_.func_234923_W_() == mapdata.field_76200_c) {
            int i = 1 << mapdata.field_76197_d;
            int j = mapdata.field_76201_a;
            int k = mapdata.field_76199_b;
            Biome[] abiome = new Biome[128 * i * 128 * i];
            for (int l = 0; l < 128 * i; ++l) {
                for (int i1 = 0; i1 < 128 * i; ++i1) {
                    abiome[l * 128 * i + i1] = p_226642_0_.getBiomeBySeed((j / i - 64) * i + i1, 0, (k / i - 64) * i + l);
                }
            }
            for (int l1 = 0; l1 < 128; ++l1) {
                for (int i2 = 0; i2 < 128; ++i2) {
                    if (l1 <= 0 || i2 <= 0 || l1 >= 127 || i2 >= 127) continue;
                    Biome biome = abiome[l1 * i + i2 * i * 128 * i];
                    int j1 = 8;
                    if (FilledMapItem.func_195954_a(abiome, i, l1 - 1, i2 - 1)) {
                        --j1;
                    }
                    if (FilledMapItem.func_195954_a(abiome, i, l1 - 1, i2 + 1)) {
                        --j1;
                    }
                    if (FilledMapItem.func_195954_a(abiome, i, l1 - 1, i2)) {
                        --j1;
                    }
                    if (FilledMapItem.func_195954_a(abiome, i, l1 + 1, i2 - 1)) {
                        --j1;
                    }
                    if (FilledMapItem.func_195954_a(abiome, i, l1 + 1, i2 + 1)) {
                        --j1;
                    }
                    if (FilledMapItem.func_195954_a(abiome, i, l1 + 1, i2)) {
                        --j1;
                    }
                    if (FilledMapItem.func_195954_a(abiome, i, l1, i2 - 1)) {
                        --j1;
                    }
                    if (FilledMapItem.func_195954_a(abiome, i, l1, i2 + 1)) {
                        --j1;
                    }
                    int k1 = 3;
                    MaterialColor materialcolor = MaterialColor.field_151660_b;
                    if (biome.func_185355_j() < 0.0f) {
                        materialcolor = MaterialColor.field_151676_q;
                        if (j1 > 7 && i2 % 2 == 0) {
                            k1 = (l1 + (int)(MathHelper.func_76126_a((float)((float)i2 + 0.0f)) * 7.0f)) / 8 % 5;
                            if (k1 == 3) {
                                k1 = 1;
                            } else if (k1 == 4) {
                                k1 = 0;
                            }
                        } else if (j1 > 7) {
                            materialcolor = MaterialColor.field_151660_b;
                        } else if (j1 > 5) {
                            k1 = 1;
                        } else if (j1 > 3) {
                            k1 = 0;
                        } else if (j1 > 1) {
                            k1 = 0;
                        }
                    } else if (j1 > 0) {
                        materialcolor = MaterialColor.field_151650_B;
                        k1 = j1 > 3 ? 1 : 3;
                    }
                    if (materialcolor == MaterialColor.field_151660_b) continue;
                    mapdata.field_76198_e[l1 + i2 * 128] = (byte)(materialcolor.field_76290_q * 4 + k1);
                    mapdata.func_176053_a(l1, i2);
                }
            }
        }
    }

    public void func_77663_a(ItemStack p_77663_1_, World p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        MapData mapdata;
        if (!p_77663_2_.field_72995_K && (mapdata = FilledMapItem.func_195950_a(p_77663_1_, p_77663_2_)) != null) {
            if (p_77663_3_ instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)p_77663_3_;
                mapdata.func_76191_a(playerentity, p_77663_1_);
            }
            if (!mapdata.field_215161_h && (p_77663_5_ || p_77663_3_ instanceof PlayerEntity && ((PlayerEntity)p_77663_3_).func_184592_cb() == p_77663_1_)) {
                this.func_77872_a(p_77663_2_, p_77663_3_, mapdata);
            }
        }
    }

    @Nullable
    public IPacket<?> func_150911_c(ItemStack p_150911_1_, World p_150911_2_, PlayerEntity p_150911_3_) {
        return FilledMapItem.func_195950_a(p_150911_1_, p_150911_2_).func_176052_a(p_150911_1_, (IBlockReader)((Object)p_150911_2_), p_150911_3_);
    }

    public void func_77622_d(ItemStack p_77622_1_, World p_77622_2_, PlayerEntity p_77622_3_) {
        CompoundNBT compoundnbt = p_77622_1_.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("map_scale_direction", 99)) {
            FilledMapItem.func_185063_a(p_77622_1_, p_77622_2_, compoundnbt.func_74762_e("map_scale_direction"));
            compoundnbt.func_82580_o("map_scale_direction");
        } else if (compoundnbt != null && compoundnbt.func_150297_b("map_to_lock", 1) && compoundnbt.func_74767_n("map_to_lock")) {
            FilledMapItem.func_219992_b(p_77622_2_, p_77622_1_);
            compoundnbt.func_82580_o("map_to_lock");
        }
    }

    protected static void func_185063_a(ItemStack p_185063_0_, World p_185063_1_, int p_185063_2_) {
        MapData mapdata = FilledMapItem.func_195950_a(p_185063_0_, p_185063_1_);
        if (mapdata != null) {
            FilledMapItem.func_195951_a(p_185063_0_, p_185063_1_, mapdata.field_76201_a, mapdata.field_76199_b, MathHelper.func_76125_a((int)(mapdata.field_76197_d + p_185063_2_), (int)0, (int)4), mapdata.field_186210_e, mapdata.field_191096_f, mapdata.field_76200_c);
        }
    }

    public static void func_219992_b(World p_219992_0_, ItemStack p_219992_1_) {
        MapData mapdata = FilledMapItem.func_195950_a(p_219992_1_, p_219992_0_);
        if (mapdata != null) {
            MapData mapdata1 = FilledMapItem.func_195951_a(p_219992_1_, p_219992_0_, 0, 0, mapdata.field_76197_d, mapdata.field_186210_e, mapdata.field_191096_f, mapdata.field_76200_c);
            mapdata1.func_215160_a(mapdata);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, @Nullable World p_77624_2_, List<ITextComponent> p_77624_3_, ITooltipFlag p_77624_4_) {
        MapData mapdata;
        MapData mapData = mapdata = p_77624_2_ == null ? null : FilledMapItem.func_195950_a(p_77624_1_, p_77624_2_);
        if (mapdata != null && mapdata.field_215161_h) {
            p_77624_3_.add((ITextComponent)new TranslationTextComponent("filled_map.locked", FilledMapItem.func_195949_f(p_77624_1_)).func_240699_a_(TextFormatting.GRAY));
        }
        if (p_77624_4_.func_194127_a()) {
            if (mapdata != null) {
                p_77624_3_.add((ITextComponent)new TranslationTextComponent("filled_map.id", FilledMapItem.func_195949_f(p_77624_1_)).func_240699_a_(TextFormatting.GRAY));
                p_77624_3_.add((ITextComponent)new TranslationTextComponent("filled_map.scale", 1 << mapdata.field_76197_d).func_240699_a_(TextFormatting.GRAY));
                p_77624_3_.add((ITextComponent)new TranslationTextComponent("filled_map.level", mapdata.field_76197_d, 4).func_240699_a_(TextFormatting.GRAY));
            } else {
                p_77624_3_.add((ITextComponent)new TranslationTextComponent("filled_map.unknown").func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int func_190907_h(ItemStack p_190907_0_) {
        CompoundNBT compoundnbt = p_190907_0_.func_179543_a("display");
        if (compoundnbt != null && compoundnbt.func_150297_b("MapColor", 99)) {
            int i = compoundnbt.func_74762_e("MapColor");
            return 0xFF000000 | i & 0xFFFFFF;
        }
        return -12173266;
    }

    public ActionResultType func_195939_a(ItemUseContext p_195939_1_) {
        BlockState blockstate = p_195939_1_.func_195991_k().func_180495_p(p_195939_1_.func_195995_a());
        if (blockstate.func_235714_a_(BlockTags.field_202897_p)) {
            if (!p_195939_1_.func_195991_k().field_72995_K) {
                MapData mapdata = FilledMapItem.func_195950_a(p_195939_1_.func_195996_i(), p_195939_1_.func_195991_k());
                mapdata.func_204269_a(p_195939_1_.func_195991_k(), p_195939_1_.func_195995_a());
            }
            return ActionResultType.func_233537_a_((boolean)p_195939_1_.func_195991_k().field_72995_K);
        }
        return super.func_195939_a(p_195939_1_);
    }
}

