/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.loot.LootTableIdCondition;

public class LootContext {
    private final Random field_216035_a;
    private final float field_186498_a;
    private final ServerWorld field_186499_b;
    private final Function<ResourceLocation, LootTable> field_186500_c;
    private final Set<LootTable> field_186504_g = Sets.newLinkedHashSet();
    private final Function<ResourceLocation, ILootCondition> field_227499_f_;
    private final Set<ILootCondition> field_227500_g_ = Sets.newLinkedHashSet();
    private final Map<LootParameter<?>, Object> field_216036_f;
    private final Map<ResourceLocation, IDynamicDropProvider> field_216037_g;
    private ResourceLocation queriedLootTableId;

    private LootContext(Random p_i225885_1_, float p_i225885_2_, ServerWorld p_i225885_3_, Function<ResourceLocation, LootTable> p_i225885_4_, Function<ResourceLocation, ILootCondition> p_i225885_5_, Map<LootParameter<?>, Object> p_i225885_6_, Map<ResourceLocation, IDynamicDropProvider> p_i225885_7_) {
        this.field_216035_a = p_i225885_1_;
        this.field_186498_a = p_i225885_2_;
        this.field_186499_b = p_i225885_3_;
        this.field_186500_c = p_i225885_4_;
        this.field_227499_f_ = p_i225885_5_;
        this.field_216036_f = ImmutableMap.copyOf(p_i225885_6_);
        this.field_216037_g = ImmutableMap.copyOf(p_i225885_7_);
    }

    public boolean func_216033_a(LootParameter<?> p_216033_1_) {
        return this.field_216036_f.containsKey(p_216033_1_);
    }

    public void func_216034_a(ResourceLocation p_216034_1_, Consumer<ItemStack> p_216034_2_) {
        IDynamicDropProvider lootcontext$idynamicdropprovider = this.field_216037_g.get(p_216034_1_);
        if (lootcontext$idynamicdropprovider != null) {
            lootcontext$idynamicdropprovider.add(this, p_216034_2_);
        }
    }

    @Nullable
    public <T> T func_216031_c(LootParameter<T> p_216031_1_) {
        return (T)this.field_216036_f.get(p_216031_1_);
    }

    public boolean func_186496_a(LootTable p_186496_1_) {
        return this.field_186504_g.add(p_186496_1_);
    }

    public void func_186490_b(LootTable p_186490_1_) {
        this.field_186504_g.remove(p_186490_1_);
    }

    public boolean func_227501_a_(ILootCondition p_227501_1_) {
        return this.field_227500_g_.add(p_227501_1_);
    }

    public void func_227503_b_(ILootCondition p_227503_1_) {
        this.field_227500_g_.remove(p_227503_1_);
    }

    public LootTable func_227502_a_(ResourceLocation p_227502_1_) {
        return this.field_186500_c.apply(p_227502_1_);
    }

    public ILootCondition func_227504_b_(ResourceLocation p_227504_1_) {
        return this.field_227499_f_.apply(p_227504_1_);
    }

    public Random func_216032_b() {
        return this.field_216035_a;
    }

    public float func_186491_f() {
        return this.field_186498_a;
    }

    public ServerWorld func_202879_g() {
        return this.field_186499_b;
    }

    public int getLootingModifier() {
        return ForgeHooks.getLootingLevel((Entity)this.func_216031_c(LootParameters.field_216281_a), (Entity)this.func_216031_c(LootParameters.field_216284_d), (DamageSource)this.func_216031_c(LootParameters.field_216283_c));
    }

    private LootContext(Random rand, float luckIn, ServerWorld worldIn, Function<ResourceLocation, LootTable> lootTableManagerIn, Function<ResourceLocation, ILootCondition> p_i225885_5_, Map<LootParameter<?>, Object> parametersIn, Map<ResourceLocation, IDynamicDropProvider> conditionsIn, ResourceLocation queriedLootTableId) {
        this(rand, luckIn, worldIn, lootTableManagerIn, p_i225885_5_, parametersIn, conditionsIn);
        if (queriedLootTableId != null) {
            this.queriedLootTableId = queriedLootTableId;
        }
    }

    public void setQueriedLootTableId(ResourceLocation queriedLootTableId) {
        if (this.queriedLootTableId == null && queriedLootTableId != null) {
            this.queriedLootTableId = queriedLootTableId;
        }
    }

    public ResourceLocation getQueriedLootTableId() {
        return this.queriedLootTableId == null ? LootTableIdCondition.UNKNOWN_LOOT_TABLE : this.queriedLootTableId;
    }

    @FunctionalInterface
    public static interface IDynamicDropProvider {
        public void add(LootContext var1, Consumer<ItemStack> var2);
    }

    public static enum EntityTarget {
        THIS("this", LootParameters.field_216281_a),
        KILLER("killer", LootParameters.field_216284_d),
        DIRECT_KILLER("direct_killer", LootParameters.field_216285_e),
        KILLER_PLAYER("killer_player", LootParameters.field_216282_b);

        private final String field_186488_d;
        private final LootParameter<? extends Entity> field_216030_f;

        private EntityTarget(String p_i50476_3_, LootParameter<? extends Entity> p_i50476_4_) {
            this.field_186488_d = p_i50476_3_;
            this.field_216030_f = p_i50476_4_;
        }

        public LootParameter<? extends Entity> func_216029_a() {
            return this.field_216030_f;
        }

        public static EntityTarget func_186482_a(String p_186482_0_) {
            for (EntityTarget lootcontext$entitytarget : EntityTarget.values()) {
                if (!lootcontext$entitytarget.field_186488_d.equals(p_186482_0_)) continue;
                return lootcontext$entitytarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + p_186482_0_);
        }

        public static class Serializer
        extends TypeAdapter<EntityTarget> {
            public void write(JsonWriter p_write_1_, EntityTarget p_write_2_) throws IOException {
                p_write_1_.value(p_write_2_.field_186488_d);
            }

            public EntityTarget read(JsonReader p_read_1_) throws IOException {
                return EntityTarget.func_186482_a(p_read_1_.nextString());
            }
        }
    }

    public static class Builder {
        private final ServerWorld field_186474_a;
        private final Map<LootParameter<?>, Object> field_216025_b = Maps.newIdentityHashMap();
        private final Map<ResourceLocation, IDynamicDropProvider> field_216026_c = Maps.newHashMap();
        private Random field_216027_d;
        private float field_186475_b;
        private ResourceLocation queriedLootTableId;

        public Builder(ServerWorld p_i46993_1_) {
            this.field_186474_a = p_i46993_1_;
        }

        public Builder(LootContext context) {
            this.field_186474_a = context.field_186499_b;
            this.field_216025_b.putAll(context.field_216036_f);
            this.field_216026_c.putAll(context.field_216037_g);
            this.field_216027_d = context.field_216035_a;
            this.field_186475_b = context.field_186498_a;
            this.queriedLootTableId = context.queriedLootTableId;
        }

        public Builder func_216023_a(Random p_216023_1_) {
            this.field_216027_d = p_216023_1_;
            return this;
        }

        public Builder func_216016_a(long p_216016_1_) {
            if (p_216016_1_ != 0L) {
                this.field_216027_d = new Random(p_216016_1_);
            }
            return this;
        }

        public Builder func_216020_a(long p_216020_1_, Random p_216020_3_) {
            this.field_216027_d = p_216020_1_ == 0L ? p_216020_3_ : new Random(p_216020_1_);
            return this;
        }

        public Builder func_186469_a(float p_186469_1_) {
            this.field_186475_b = p_186469_1_;
            return this;
        }

        public <T> Builder func_216015_a(LootParameter<T> p_216015_1_, T p_216015_2_) {
            this.field_216025_b.put(p_216015_1_, p_216015_2_);
            return this;
        }

        public <T> Builder func_216021_b(LootParameter<T> p_216021_1_, @Nullable T p_216021_2_) {
            if (p_216021_2_ == null) {
                this.field_216025_b.remove(p_216021_1_);
            } else {
                this.field_216025_b.put(p_216021_1_, p_216021_2_);
            }
            return this;
        }

        public Builder func_216017_a(ResourceLocation p_216017_1_, IDynamicDropProvider p_216017_2_) {
            IDynamicDropProvider lootcontext$idynamicdropprovider = this.field_216026_c.put(p_216017_1_, p_216017_2_);
            if (lootcontext$idynamicdropprovider != null) {
                throw new IllegalStateException("Duplicated dynamic drop '" + this.field_216026_c + "'");
            }
            return this;
        }

        public ServerWorld func_216018_a() {
            return this.field_186474_a;
        }

        public <T> T func_216024_a(LootParameter<T> p_216024_1_) {
            Object t = this.field_216025_b.get(p_216024_1_);
            if (t == null) {
                throw new IllegalArgumentException("No parameter " + p_216024_1_);
            }
            return (T)t;
        }

        @Nullable
        public <T> T func_216019_b(LootParameter<T> p_216019_1_) {
            return (T)this.field_216025_b.get(p_216019_1_);
        }

        public LootContext func_216022_a(LootParameterSet p_216022_1_) {
            Sets.SetView set = Sets.difference(this.field_216025_b.keySet(), (Set)p_216022_1_.func_216276_b());
            Sets.SetView set1 = Sets.difference((Set)p_216022_1_.func_216277_a(), this.field_216025_b.keySet());
            if (!set1.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + (Set)set1);
            }
            Random random = this.field_216027_d;
            if (random == null) {
                random = new Random();
            }
            MinecraftServer minecraftserver = this.field_186474_a.func_73046_m();
            return new LootContext(random, this.field_186475_b, this.field_186474_a, minecraftserver.func_200249_aQ()::func_186521_a, arg_0 -> ((LootPredicateManager)minecraftserver.func_229736_aP_()).func_227517_a_(arg_0), this.field_216025_b, this.field_216026_c, this.queriedLootTableId);
        }
    }
}

