/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mohistmc.util.i18n.i18n;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableManager
extends JsonReloadListener {
    private static final Logger field_186525_a = LogManager.getLogger();
    private static final Gson field_186526_b = LootSerializers.func_237388_c_().create();
    private Map<ResourceLocation, LootTable> field_186527_c = ImmutableMap.of();
    public Map<LootTable, ResourceLocation> lootTableToKey = ImmutableMap.of();
    private final LootPredicateManager field_227507_d_;

    public LootTableManager(LootPredicateManager p_i225887_1_) {
        super(field_186526_b, "loot_tables");
        this.field_227507_d_ = p_i225887_1_;
    }

    public LootTable func_186521_a(ResourceLocation p_186521_1_) {
        return this.field_186527_c.getOrDefault(p_186521_1_, LootTable.field_186464_a);
    }

    protected void func_212853_a_(Map<ResourceLocation, JsonElement> p_212853_1_, IResourceManager p_212853_2_, IProfiler p_212853_3_) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        JsonElement jsonelement = p_212853_1_.remove(LootTables.field_186419_a);
        if (jsonelement != null) {
            field_186525_a.warn(i18n.get((String)"loottablemanager.1", (Object[])new Object[]{LootTables.field_186419_a}));
        }
        p_212853_1_.forEach((p_237403_1_, p_237403_2_) -> {
            try (IResource res = p_212853_2_.func_199002_a(this.getPreparedPath((ResourceLocation)p_237403_1_));){
                LootTable loottable = ForgeHooks.loadLootTable((Gson)field_186526_b, (ResourceLocation)p_237403_1_, (JsonElement)p_237403_2_, (res == null || !res.func_199026_d().equals("Default") ? 1 : 0) != 0, (LootTableManager)this);
                builder.put(p_237403_1_, (Object)loottable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        builder.put((Object)LootTables.field_186419_a, (Object)LootTable.field_186464_a);
        ImmutableMap immutablemap = builder.build();
        ValidationTracker validationtracker = new ValidationTracker(LootParameterSets.field_216266_g, arg_0 -> ((LootPredicateManager)this.field_227507_d_).func_227517_a_(arg_0), arg_0 -> ((ImmutableMap)immutablemap).get(arg_0));
        immutablemap.forEach((p_227509_1_, p_227509_2_) -> LootTableManager.func_227508_a_(validationtracker, p_227509_1_, p_227509_2_));
        validationtracker.func_227527_a_().forEach((p_215303_0_, p_215303_1_) -> field_186525_a.warn("Found validation problem in " + p_215303_0_ + ": " + p_215303_1_));
        this.field_186527_c = immutablemap;
        ImmutableMap.Builder lootTableToKeyBuilder = ImmutableMap.builder();
        this.field_186527_c.forEach((lootTable, key) -> lootTableToKeyBuilder.put(key, lootTable));
        this.lootTableToKey = lootTableToKeyBuilder.build();
    }

    public static void func_227508_a_(ValidationTracker p_227508_0_, ResourceLocation p_227508_1_, LootTable p_227508_2_) {
        p_227508_2_.func_227506_a_(p_227508_0_.func_227529_a_(p_227508_2_.func_216122_a()).func_227531_a_("{" + p_227508_1_ + "}", p_227508_1_));
    }

    public static JsonElement func_215301_a(LootTable p_215301_0_) {
        return field_186526_b.toJsonTree((Object)p_215301_0_);
    }

    public Set<ResourceLocation> func_215304_a() {
        return this.field_186527_c.keySet();
    }
}

