/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mohistmc.util.i18n.i18n;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnchantRandomly
extends LootFunction {
    private static final Logger field_186557_a = LogManager.getLogger();
    private final List<Enchantment> field_186558_b;

    private EnchantRandomly(ILootCondition[] p_i51238_1_, Collection<Enchantment> p_i51238_2_) {
        super(p_i51238_1_);
        this.field_186558_b = ImmutableList.copyOf(p_i51238_2_);
    }

    public LootFunctionType func_230425_b_() {
        return LootFunctionManager.field_237431_d_;
    }

    public ItemStack func_215859_a(ItemStack p_215859_1_, LootContext p_215859_2_) {
        Enchantment enchantment;
        Random random = p_215859_2_.func_216032_b();
        if (this.field_186558_b.isEmpty()) {
            boolean flag = p_215859_1_.func_77973_b() == Items.field_151122_aG;
            List list = Registry.field_212628_q.func_201756_e().filter(Enchantment::func_230310_i_).filter(p_237421_2_ -> flag || p_237421_2_.func_92089_a(p_215859_1_)).collect(Collectors.toList());
            if (list.isEmpty()) {
                field_186557_a.warn(i18n.get((String)"enchantrandomly.1", (Object[])new Object[]{p_215859_1_}));
                return p_215859_1_;
            }
            enchantment = (Enchantment)((Object)list.get(random.nextInt(list.size())));
        } else {
            enchantment = this.field_186558_b.get(random.nextInt(this.field_186558_b.size()));
        }
        return EnchantRandomly.func_237420_a_(p_215859_1_, enchantment, random);
    }

    private static ItemStack func_237420_a_(ItemStack p_237420_0_, Enchantment p_237420_1_, Random p_237420_2_) {
        int i = MathHelper.func_76136_a((Random)p_237420_2_, (int)p_237420_1_.func_77319_d(), (int)p_237420_1_.func_77325_b());
        if (p_237420_0_.func_77973_b() == Items.field_151122_aG) {
            p_237420_0_ = new ItemStack(Items.field_151134_bR);
            EnchantedBookItem.func_92115_a((ItemStack)p_237420_0_, (EnchantmentData)new EnchantmentData(p_237420_1_, i));
        } else {
            p_237420_0_.func_77966_a(p_237420_1_, i);
        }
        return p_237420_0_;
    }

    public static LootFunction.Builder<?> func_215900_c() {
        return EnchantRandomly.func_215860_a(p_237422_0_ -> new EnchantRandomly((ILootCondition[])p_237422_0_, (Collection<Enchantment>)ImmutableList.of()));
    }

    public static class Serializer
    extends LootFunction.Serializer<EnchantRandomly> {
        public void func_230424_a_(JsonObject p_230424_1_, EnchantRandomly p_230424_2_, JsonSerializationContext p_230424_3_) {
            super.func_230424_a_(p_230424_1_, (LootFunction)p_230424_2_, p_230424_3_);
            if (!p_230424_2_.field_186558_b.isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (Enchantment enchantment : p_230424_2_.field_186558_b) {
                    ResourceLocation resourcelocation = Registry.field_212628_q.func_177774_c(enchantment);
                    if (resourcelocation == null) {
                        throw new IllegalArgumentException("Don't know how to serialize enchantment " + enchantment);
                    }
                    jsonarray.add((JsonElement)new JsonPrimitive(resourcelocation.toString()));
                }
                p_230424_1_.add("enchantments", (JsonElement)jsonarray);
            }
        }

        public EnchantRandomly func_186530_b(JsonObject p_186530_1_, JsonDeserializationContext p_186530_2_, ILootCondition[] p_186530_3_) {
            ArrayList list = Lists.newArrayList();
            if (p_186530_1_.has("enchantments")) {
                for (JsonElement jsonelement : JSONUtils.func_151214_t((JsonObject)p_186530_1_, (String)"enchantments")) {
                    String s = JSONUtils.func_151206_a((JsonElement)jsonelement, (String)"enchantment");
                    Enchantment enchantment = Registry.field_212628_q.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown enchantment '" + s + "'"));
                    list.add(enchantment);
                }
            }
            return new EnchantRandomly(p_186530_3_, list);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final Set<Enchantment> field_237423_a_ = Sets.newHashSet();

        protected Builder func_212826_d_() {
            return this;
        }

        public Builder func_237424_a_(Enchantment p_237424_1_) {
            this.field_237423_a_.add(p_237424_1_);
            return this;
        }

        public ILootFunction func_216052_b() {
            return new EnchantRandomly(this.func_216053_g(), this.field_237423_a_);
        }
    }
}

