/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTypes;

public class CompressedStreamTools {
    public static CompoundNBT func_244263_a(File p_244263_0_) throws IOException {
        CompoundNBT compoundnbt;
        try (FileInputStream inputstream = new FileInputStream(p_244263_0_);){
            compoundnbt = CompressedStreamTools.func_74796_a(inputstream);
        }
        return compoundnbt;
    }

    public static CompoundNBT func_74796_a(InputStream p_74796_0_) throws IOException {
        CompoundNBT compoundnbt;
        try (DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(p_74796_0_)));){
            compoundnbt = CompressedStreamTools.func_152456_a(datainputstream, NBTSizeTracker.field_152451_a);
        }
        return compoundnbt;
    }

    public static void func_244264_a(CompoundNBT p_244264_0_, File p_244264_1_) throws IOException {
        try (FileOutputStream outputstream = new FileOutputStream(p_244264_1_);){
            CompressedStreamTools.func_74799_a(p_244264_0_, outputstream);
        }
    }

    public static void func_74799_a(CompoundNBT p_74799_0_, OutputStream p_74799_1_) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(p_74799_1_)));){
            CompressedStreamTools.func_74800_a(p_74799_0_, dataoutputstream);
        }
    }

    public static void func_74795_b(CompoundNBT p_74795_0_, File p_74795_1_) throws IOException {
        try (FileOutputStream fileoutputstream = new FileOutputStream(p_74795_1_);
             DataOutputStream dataoutputstream = new DataOutputStream(fileoutputstream);){
            CompressedStreamTools.func_74800_a(p_74795_0_, dataoutputstream);
        }
    }

    @Nullable
    public static CompoundNBT func_74797_a(File p_74797_0_) throws IOException {
        CompoundNBT compoundnbt;
        if (!p_74797_0_.exists()) {
            return null;
        }
        try (FileInputStream fileinputstream = new FileInputStream(p_74797_0_);
             DataInputStream datainputstream = new DataInputStream(fileinputstream);){
            compoundnbt = CompressedStreamTools.func_152456_a(datainputstream, NBTSizeTracker.field_152451_a);
        }
        return compoundnbt;
    }

    public static CompoundNBT func_74794_a(DataInput p_74794_0_) throws IOException {
        return CompressedStreamTools.func_152456_a(p_74794_0_, NBTSizeTracker.field_152451_a);
    }

    public static CompoundNBT func_152456_a(DataInput p_152456_0_, NBTSizeTracker p_152456_1_) throws IOException {
        INBT inbt = CompressedStreamTools.func_152455_a(p_152456_0_, 0, p_152456_1_);
        if (inbt instanceof CompoundNBT) {
            return (CompoundNBT)inbt;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void func_74800_a(CompoundNBT p_74800_0_, DataOutput p_74800_1_) throws IOException {
        CompressedStreamTools.func_150663_a(p_74800_0_, p_74800_1_);
    }

    private static void func_150663_a(INBT p_150663_0_, DataOutput p_150663_1_) throws IOException {
        p_150663_1_.writeByte(p_150663_0_.func_74732_a());
        if (p_150663_0_.func_74732_a() != 0) {
            p_150663_1_.writeUTF("");
            p_150663_0_.func_74734_a(p_150663_1_);
        }
    }

    private static INBT func_152455_a(DataInput p_152455_0_, int p_152455_1_, NBTSizeTracker p_152455_2_) throws IOException {
        byte b0 = p_152455_0_.readByte();
        p_152455_2_.func_152450_a(8L);
        if (b0 == 0) {
            return EndNBT.field_229686_b_;
        }
        p_152455_2_.readUTF(p_152455_0_.readUTF());
        p_152455_2_.func_152450_a(32L);
        try {
            return NBTTypes.func_229710_a_((int)b0).func_225649_b_(p_152455_0_, p_152455_1_, p_152455_2_);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.func_85055_a(ioexception, "Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("NBT Tag");
            crashreportcategory.func_71507_a("Tag type", b0);
            throw new ReportedException(crashreport);
        }
    }
}

