/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.mohistmc.util.i18n.i18n;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.StringUtils;
import net.minecraft.util.UUIDCodec;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NBTUtil {
    private static final Logger field_193591_a = LogManager.getLogger();

    @Nullable
    public static GameProfile func_152459_a(CompoundNBT p_152459_0_) {
        String s = null;
        UUID uuid = null;
        if (p_152459_0_.func_150297_b("Name", 8)) {
            s = p_152459_0_.func_74779_i("Name");
        }
        if (p_152459_0_.func_186855_b("Id")) {
            uuid = p_152459_0_.func_186857_a("Id");
        }
        try {
            GameProfile gameprofile = new GameProfile(uuid, s);
            if (p_152459_0_.func_150297_b("Properties", 10)) {
                CompoundNBT compoundnbt = p_152459_0_.func_74775_l("Properties");
                for (String s1 : compoundnbt.func_150296_c()) {
                    ListNBT listnbt = compoundnbt.func_150295_c(s1, 10);
                    for (int i = 0; i < listnbt.size(); ++i) {
                        CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                        String s2 = compoundnbt1.func_74779_i("Value");
                        if (compoundnbt1.func_150297_b("Signature", 8)) {
                            gameprofile.getProperties().put((Object)s1, (Object)new Property(s1, s2, compoundnbt1.func_74779_i("Signature")));
                            continue;
                        }
                        gameprofile.getProperties().put((Object)s1, (Object)new Property(s1, s2));
                    }
                }
            }
            return gameprofile;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static CompoundNBT func_180708_a(CompoundNBT p_180708_0_, GameProfile p_180708_1_) {
        if (!StringUtils.func_151246_b((String)p_180708_1_.getName())) {
            p_180708_0_.func_74778_a("Name", p_180708_1_.getName());
        }
        if (p_180708_1_.getId() != null) {
            p_180708_0_.func_186854_a("Id", p_180708_1_.getId());
        }
        if (!p_180708_1_.getProperties().isEmpty()) {
            CompoundNBT compoundnbt = new CompoundNBT();
            for (String s : p_180708_1_.getProperties().keySet()) {
                ListNBT listnbt = new ListNBT();
                for (Property property : p_180708_1_.getProperties().get((Object)s)) {
                    CompoundNBT compoundnbt1 = new CompoundNBT();
                    compoundnbt1.func_74778_a("Value", property.getValue());
                    if (property.hasSignature()) {
                        compoundnbt1.func_74778_a("Signature", property.getSignature());
                    }
                    listnbt.add((Object)compoundnbt1);
                }
                compoundnbt.func_218657_a(s, (INBT)listnbt);
            }
            p_180708_0_.func_218657_a("Properties", compoundnbt);
        }
        return p_180708_0_;
    }

    @VisibleForTesting
    public static boolean func_181123_a(@Nullable INBT p_181123_0_, @Nullable INBT p_181123_1_, boolean p_181123_2_) {
        if (p_181123_0_ == p_181123_1_) {
            return true;
        }
        if (p_181123_0_ == null) {
            return true;
        }
        if (p_181123_1_ == null) {
            return false;
        }
        if (!p_181123_0_.getClass().equals(p_181123_1_.getClass())) {
            return false;
        }
        if (p_181123_0_ instanceof CompoundNBT) {
            CompoundNBT compoundnbt = (CompoundNBT)p_181123_0_;
            CompoundNBT compoundnbt1 = (CompoundNBT)p_181123_1_;
            for (String s : compoundnbt.func_150296_c()) {
                INBT inbt1 = compoundnbt.func_74781_a(s);
                if (NBTUtil.func_181123_a(inbt1, compoundnbt1.func_74781_a(s), p_181123_2_)) continue;
                return false;
            }
            return true;
        }
        if (p_181123_0_ instanceof ListNBT && p_181123_2_) {
            ListNBT listnbt = (ListNBT)p_181123_0_;
            ListNBT listnbt1 = (ListNBT)p_181123_1_;
            if (listnbt.isEmpty()) {
                return listnbt1.isEmpty();
            }
            for (int i = 0; i < listnbt.size(); ++i) {
                INBT inbt = listnbt.get(i);
                boolean flag = false;
                for (int j = 0; j < listnbt1.size(); ++j) {
                    if (!NBTUtil.func_181123_a(inbt, listnbt1.get(j), p_181123_2_)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                return false;
            }
            return true;
        }
        return p_181123_0_.equals(p_181123_1_);
    }

    public static IntArrayNBT func_240626_a_(UUID p_240626_0_) {
        return new IntArrayNBT(UUIDCodec.func_239777_a_((UUID)p_240626_0_));
    }

    public static UUID func_186860_b(INBT p_186860_0_) {
        if (p_186860_0_.func_225647_b_() != IntArrayNBT.field_229690_a_) {
            throw new IllegalArgumentException("Expected UUID-Tag to be of type " + IntArrayNBT.field_229690_a_.func_225648_a_() + ", but found " + p_186860_0_.func_225647_b_().func_225648_a_() + ".");
        }
        int[] aint = ((IntArrayNBT)p_186860_0_).func_150302_c();
        if (aint.length != 4) {
            throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + aint.length + ".");
        }
        return UUIDCodec.func_239779_a_((int[])aint);
    }

    public static BlockPos func_186861_c(CompoundNBT p_186861_0_) {
        return new BlockPos(p_186861_0_.func_74762_e("X"), p_186861_0_.func_74762_e("Y"), p_186861_0_.func_74762_e("Z"));
    }

    public static CompoundNBT func_186859_a(BlockPos p_186859_0_) {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74768_a("X", p_186859_0_.func_177958_n());
        compoundnbt.func_74768_a("Y", p_186859_0_.func_177956_o());
        compoundnbt.func_74768_a("Z", p_186859_0_.func_177952_p());
        return compoundnbt;
    }

    public static BlockState func_190008_d(CompoundNBT p_190008_0_) {
        if (!p_190008_0_.func_150297_b("Name", 8)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        Block block = (Block)((Object)Registry.field_212618_g.func_82594_a(new ResourceLocation(p_190008_0_.func_74779_i("Name"))));
        BlockState blockstate = block.func_176223_P();
        if (p_190008_0_.func_150297_b("Properties", 10)) {
            CompoundNBT compoundnbt = p_190008_0_.func_74775_l("Properties");
            StateContainer<Block, BlockState> statecontainer = block.func_176194_O();
            for (String s : compoundnbt.func_150296_c()) {
                net.minecraft.state.Property property = statecontainer.func_185920_a(s);
                if (property == null) continue;
                blockstate = NBTUtil.func_193590_a(blockstate, property, s, compoundnbt, p_190008_0_);
            }
        }
        return blockstate;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S func_193590_a(S p_193590_0_, net.minecraft.state.Property<T> p_193590_1_, String p_193590_2_, CompoundNBT p_193590_3_, CompoundNBT p_193590_4_) {
        Optional optional = p_193590_1_.func_185929_b(p_193590_3_.func_74779_i(p_193590_2_));
        if (optional.isPresent()) {
            return (S)((StateHolder)p_193590_0_.func_206870_a(p_193590_1_, (Comparable)((Comparable)optional.get())));
        }
        field_193591_a.warn(i18n.get((String)"nbtutil.1", (Object[])new Object[]{p_193590_2_, p_193590_3_.func_74779_i(p_193590_2_), p_193590_4_.toString()}));
        return p_193590_0_;
    }

    public static CompoundNBT func_190009_a(BlockState p_190009_0_) {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("Name", Registry.field_212618_g.func_177774_c((Object)p_190009_0_.func_177230_c()).toString());
        ImmutableMap<net.minecraft.state.Property<?>, Comparable<?>> immutablemap = p_190009_0_.func_206871_b();
        if (!immutablemap.isEmpty()) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            for (Map.Entry entry : immutablemap.entrySet()) {
                net.minecraft.state.Property property = (net.minecraft.state.Property)entry.getKey();
                compoundnbt1.func_74778_a(property.func_177701_a(), NBTUtil.func_190010_a(property, (Comparable)entry.getValue()));
            }
            compoundnbt.func_218657_a("Properties", compoundnbt1);
        }
        return compoundnbt;
    }

    private static <T extends Comparable<T>> String func_190010_a(net.minecraft.state.Property<T> p_190010_0_, Comparable<?> p_190010_1_) {
        return p_190010_0_.func_177702_a(p_190010_1_);
    }

    public static CompoundNBT func_210822_a(DataFixer p_210822_0_, DefaultTypeReferences p_210822_1_, CompoundNBT p_210822_2_, int p_210822_3_) {
        return NBTUtil.func_210821_a(p_210822_0_, p_210822_1_, p_210822_2_, p_210822_3_, SharedConstants.func_215069_a().getWorldVersion());
    }

    public static CompoundNBT func_210821_a(DataFixer p_210821_0_, DefaultTypeReferences p_210821_1_, CompoundNBT p_210821_2_, int p_210821_3_, int p_210821_4_) {
        return (CompoundNBT)p_210821_0_.update(p_210821_1_.func_219816_a(), new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)p_210821_2_), p_210821_3_, p_210821_4_).getValue();
    }
}

