/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.handshake;

import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import com.mojang.util.UUIDTypeAdapter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.handshake.IHandshakeNetHandler;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.network.status.ServerStatusNetHandler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.spigotmc.SpigotConfig;

public class ServerHandshakeNetHandler
implements IHandshakeNetHandler {
    private static final Gson gson = new Gson();
    public static final Pattern HOST_PATTERN = Pattern.compile("[0-9a-f\\.:]{0,45}");
    public static final Pattern PROP_PATTERN = Pattern.compile("\\w{0,16}");
    private static final HashMap<InetAddress, Long> throttleTracker = new HashMap();
    private static int throttleCounter = 0;
    private static final ITextComponent field_241169_a_ = new StringTextComponent("Ignoring status request");
    private final MinecraftServer field_147387_a;
    private final NetworkManager field_147386_b;

    public ServerHandshakeNetHandler(MinecraftServer p_i45295_1_, NetworkManager p_i45295_2_) {
        this.field_147387_a = p_i45295_1_;
        this.field_147386_b = p_i45295_2_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_147383_a(CHandshakePacket p_147383_1_) {
        if (!ServerLifecycleHooks.handleServerLogin((CHandshakePacket)p_147383_1_, (NetworkManager)this.field_147386_b)) {
            return;
        }
        switch (p_147383_1_.func_149594_c()) {
            case LOGIN: {
                this.field_147386_b.func_150723_a(ProtocolType.LOGIN);
                try {
                    long currentTime = System.currentTimeMillis();
                    long connectionThrottle = MinecraftServer.getServer().server.getConnectionThrottle();
                    InetAddress address = ((InetSocketAddress)this.field_147386_b.func_74430_c()).getAddress();
                    HashMap<InetAddress, Long> hashMap = throttleTracker;
                    synchronized (hashMap) {
                        if (throttleTracker.containsKey(address) && !"127.0.0.1".equals(address.getHostAddress()) && currentTime - throttleTracker.get(address) < connectionThrottle) {
                            throttleTracker.put(address, currentTime);
                            TranslationTextComponent chatmessage = new TranslationTextComponent("Connection throttled! Please wait before reconnecting.", new Object[0]);
                            this.field_147386_b.func_179290_a((IPacket<?>)new SDisconnectLoginPacket((ITextComponent)((Object)chatmessage)));
                            this.field_147386_b.func_150718_a((ITextComponent)((Object)chatmessage));
                            return;
                        }
                        throttleTracker.put(address, currentTime);
                        if (++throttleCounter > 200) {
                            throttleCounter = 0;
                            Iterator<Map.Entry<InetAddress, Long>> iter = throttleTracker.entrySet().iterator();
                            while (iter.hasNext()) {
                                Map.Entry<InetAddress, Long> entry = iter.next();
                                if (entry.getValue() <= connectionThrottle) continue;
                                iter.remove();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LogManager.getLogger().debug("Failed to check connection throttle", t);
                }
                if (p_147383_1_.func_149595_d() != SharedConstants.func_215069_a().getProtocolVersion()) {
                    TranslationTextComponent itextcomponent = p_147383_1_.func_149595_d() < 754 ? new TranslationTextComponent(MessageFormat.format(SpigotConfig.outdatedClientMessage.replaceAll("'", "''"), SharedConstants.func_215069_a().getName())) : new TranslationTextComponent(MessageFormat.format(SpigotConfig.outdatedServerMessage.replaceAll("'", "''"), SharedConstants.func_215069_a().getName()));
                    this.field_147386_b.func_179290_a((IPacket<?>)new SDisconnectLoginPacket((ITextComponent)((Object)itextcomponent)));
                    this.field_147386_b.func_150718_a((ITextComponent)((Object)itextcomponent));
                    break;
                }
                this.field_147386_b.func_150719_a((INetHandler)new ServerLoginNetHandler(this.field_147387_a, this.field_147386_b));
                if (SpigotConfig.bungee) {
                    String[] split = p_147383_1_.original_ip.split("\u0000");
                    if (split.length != 3 && split.length != 4 || !HOST_PATTERN.matcher(split[1]).matches()) {
                        StringTextComponent chatmessage = new StringTextComponent("If you wish to use IP forwarding, please enable it in your BungeeCord config as well!");
                        this.field_147386_b.func_179290_a((IPacket<?>)new SDisconnectLoginPacket((ITextComponent)chatmessage));
                        this.field_147386_b.func_150718_a((ITextComponent)chatmessage);
                        return;
                    }
                    this.field_147386_b.field_150743_l = new InetSocketAddress(split[1], ((InetSocketAddress)this.field_147386_b.func_74430_c()).getPort());
                    this.field_147386_b.spoofedUUID = UUIDTypeAdapter.fromString((String)split[2]);
                    if (split.length == 4) {
                        this.field_147386_b.spoofedProfile = (Property[])gson.fromJson(split[3], Property[].class);
                    }
                }
                ((ServerLoginNetHandler)this.field_147386_b.func_150729_e()).hostname = p_147383_1_.field_149598_b + ":" + p_147383_1_.field_149599_c;
                break;
            }
            case STATUS: {
                if (this.field_147387_a.func_230541_aj_()) {
                    this.field_147386_b.func_150723_a(ProtocolType.STATUS);
                    this.field_147386_b.func_150719_a((INetHandler)new ServerStatusNetHandler(this.field_147387_a, this.field_147386_b));
                    break;
                }
                this.field_147386_b.func_150718_a(field_241169_a_);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + p_147383_1_.func_149594_c());
            }
        }
    }

    public void func_147231_a(ITextComponent p_147231_1_) {
    }

    public NetworkManager func_147298_b() {
        return this.field_147386_b;
    }
}

