/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.login;

import com.mohistmc.util.i18n.i18n;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.properties.Property;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.handshake.ServerHandshakeNetHandler;
import net.minecraft.network.login.IServerLoginNetHandler;
import net.minecraft.network.login.client.CCustomPayloadLoginPacket;
import net.minecraft.network.login.client.CEncryptionResponsePacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.network.login.server.SEnableCompressionPacket;
import net.minecraft.network.login.server.SEncryptionRequestPacket;
import net.minecraft.network.login.server.SLoginSuccessPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.CryptException;
import net.minecraft.util.CryptManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;

public class ServerLoginNetHandler
implements IServerLoginNetHandler {
    private static final AtomicInteger field_147331_b = new AtomicInteger(0);
    private static final Logger field_147332_c = LogManager.getLogger();
    private static final Random field_147329_d = new Random();
    private final byte[] field_147330_e = new byte[4];
    private final MinecraftServer field_147327_f;
    public final NetworkManager field_147333_a;
    private State field_147328_g = State.HELLO;
    private int field_147336_h;
    private GameProfile field_147337_i;
    private final String field_147334_j = "";
    private SecretKey field_147335_k;
    private ServerPlayerEntity field_181025_l;
    public String hostname = "";

    public ServerLoginNetHandler(MinecraftServer p_i45298_1_, NetworkManager p_i45298_2_) {
        this.field_147327_f = p_i45298_1_;
        this.field_147333_a = p_i45298_2_;
        field_147329_d.nextBytes(this.field_147330_e);
    }

    public void func_73660_a() {
        ServerPlayerEntity serverplayerentity;
        if (this.field_147328_g == State.NEGOTIATING) {
            boolean negotiationComplete = NetworkHooks.tickNegotiation((ServerLoginNetHandler)this, (NetworkManager)this.field_147333_a, (ServerPlayerEntity)this.field_181025_l);
            if (negotiationComplete) {
                this.field_147328_g = State.READY_TO_ACCEPT;
            }
        } else if (this.field_147328_g == State.READY_TO_ACCEPT) {
            this.func_147326_c();
        } else if (this.field_147328_g == State.DELAY_ACCEPT && (serverplayerentity = this.field_147327_f.func_184103_al().func_177451_a(this.field_147337_i.getId())) == null) {
            this.field_147328_g = State.READY_TO_ACCEPT;
            this.field_147327_f.func_184103_al().func_72355_a(this.field_147333_a, this.field_181025_l);
            this.field_181025_l = null;
        }
        if (this.field_147336_h++ == 600) {
            this.func_194026_b((ITextComponent)((Object)new TranslationTextComponent("multiplayer.disconnect.slow_login")));
        }
    }

    public void disconnect(String s) {
        try {
            StringTextComponent ichatbasecomponent = new StringTextComponent(s);
            field_147332_c.info(i18n.get((String)"serverloginnethandler.1", (Object[])new Object[]{this.func_147317_d(), s}));
            this.field_147333_a.func_179290_a((IPacket<?>)new SDisconnectLoginPacket((ITextComponent)ichatbasecomponent));
            this.field_147333_a.func_150718_a((ITextComponent)ichatbasecomponent);
        }
        catch (Exception exception) {
            field_147332_c.error(i18n.get((String)"serverloginnethandler.2", (Object[])new Object[]{exception}));
        }
    }

    public NetworkManager func_147298_b() {
        return this.field_147333_a;
    }

    public void func_194026_b(ITextComponent p_194026_1_) {
        try {
            field_147332_c.info(i18n.get((String)"serverloginnethandler.3", (Object[])new Object[]{this.func_147317_d(), p_194026_1_.getString()}));
            this.field_147333_a.func_179290_a((IPacket<?>)new SDisconnectLoginPacket(p_194026_1_));
            this.field_147333_a.func_150718_a(p_194026_1_);
        }
        catch (Exception exception) {
            field_147332_c.error(i18n.get((String)"serverloginnethandler.4", (Object[])new Object[]{exception}));
        }
    }

    public void initUUID() {
        UUID uuid = this.field_147333_a.spoofedUUID != null ? this.field_147333_a.spoofedUUID : PlayerEntity.func_175147_b(this.field_147337_i.getName());
        this.field_147337_i = new GameProfile(uuid, this.field_147337_i.getName());
        if (this.field_147333_a.spoofedProfile != null) {
            for (Property property : this.field_147333_a.spoofedProfile) {
                if (!ServerHandshakeNetHandler.PROP_PATTERN.matcher(property.getName()).matches()) continue;
                this.field_147337_i.getProperties().put((Object)property.getName(), (Object)property);
            }
        }
    }

    public void func_147326_c() {
        ServerPlayerEntity s = this.field_147327_f.func_184103_al().canPlayerLogin(this, this.field_147337_i, this.field_147333_a.func_74430_c());
        if (s != null) {
            this.field_147328_g = State.ACCEPTED;
            if (this.field_147327_f.func_175577_aI() >= 0 && !this.field_147333_a.func_150731_c()) {
                this.field_147333_a.func_201058_a((IPacket<?>)new SEnableCompressionPacket(this.field_147327_f.func_175577_aI()), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_210149_1_ -> this.field_147333_a.func_179289_a(this.field_147327_f.func_175577_aI())));
            }
            this.field_147333_a.func_179290_a((IPacket<?>)new SLoginSuccessPacket(this.field_147337_i));
            ServerPlayerEntity serverplayerentity = this.field_147327_f.func_184103_al().func_177451_a(this.field_147337_i.getId());
            if (serverplayerentity != null) {
                this.field_147328_g = State.DELAY_ACCEPT;
                this.field_181025_l = s;
            } else {
                this.field_147327_f.func_184103_al().func_72355_a(this.field_147333_a, s);
            }
        }
    }

    public void func_147231_a(ITextComponent p_147231_1_) {
        field_147332_c.info(i18n.get((String)"serverloginnethandler.5", (Object[])new Object[]{this.func_147317_d(), p_147231_1_.getString()}));
    }

    public String func_147317_d() {
        return this.field_147337_i != null ? this.field_147337_i + " (" + this.field_147333_a.func_74430_c() + ")" : String.valueOf(this.field_147333_a.func_74430_c());
    }

    public void func_147316_a(CLoginStartPacket p_147316_1_) {
        Validate.validState((this.field_147328_g == State.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        this.field_147337_i = p_147316_1_.func_149304_c();
        if (this.field_147327_f.func_71266_T() && !this.field_147333_a.func_150731_c()) {
            this.field_147328_g = State.KEY;
            this.field_147333_a.func_179290_a((IPacket<?>)new SEncryptionRequestPacket("", this.field_147327_f.func_71250_E().getPublic().getEncoded(), this.field_147330_e));
        } else {
            new Thread("User Authenticator #" + field_147331_b.incrementAndGet()){

                @Override
                public void run() {
                    try {
                        ServerLoginNetHandler.this.initUUID();
                        new LoginHandler().fireEvents();
                    }
                    catch (Exception ex) {
                        ServerLoginNetHandler.this.disconnect("Failed to verify username!");
                        ServerLoginNetHandler.this.field_147327_f.server.getLogger().log(Level.WARNING, "Exception verifying " + ServerLoginNetHandler.this.field_147337_i.getName(), ex);
                    }
                }
            }.start();
        }
    }

    public void func_147315_a(CEncryptionResponsePacket p_147315_1_) {
        String s;
        Validate.validState((this.field_147328_g == State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        PrivateKey privatekey = this.field_147327_f.func_71250_E().getPrivate();
        try {
            if (!Arrays.equals(this.field_147330_e, p_147315_1_.func_149299_b(privatekey))) {
                throw new IllegalStateException("Protocol error");
            }
            this.field_147335_k = p_147315_1_.func_149300_a(privatekey);
            Cipher cipher = CryptManager.func_151229_a((int)2, (Key)this.field_147335_k);
            Cipher cipher1 = CryptManager.func_151229_a((int)1, (Key)this.field_147335_k);
            s = new BigInteger(CryptManager.func_75895_a((String)"", (PublicKey)this.field_147327_f.func_71250_E().getPublic(), (SecretKey)this.field_147335_k)).toString(16);
            this.field_147328_g = State.AUTHENTICATING;
            this.field_147333_a.func_244777_a(cipher, cipher1);
        }
        catch (CryptException cryptexception) {
            throw new IllegalStateException("Protocol error", cryptexception);
        }
        Thread thread = new Thread((ThreadGroup)SidedThreadGroups.SERVER, "User Authenticator #" + field_147331_b.incrementAndGet()){

            @Override
            public void run() {
                GameProfile gameprofile = ServerLoginNetHandler.this.field_147337_i;
                try {
                    ServerLoginNetHandler.this.field_147337_i = ServerLoginNetHandler.this.field_147327_f.func_147130_as().hasJoinedServer(new GameProfile((UUID)null, gameprofile.getName()), s, this.getAddress());
                    if (ServerLoginNetHandler.this.field_147337_i != null) {
                        if (!ServerLoginNetHandler.this.field_147333_a.func_150724_d()) {
                            return;
                        }
                        new LoginHandler().fireEvents();
                    } else if (ServerLoginNetHandler.this.field_147327_f.func_71264_H()) {
                        field_147332_c.warn(i18n.get((String)"serverloginnethandler.6"));
                        ServerLoginNetHandler.this.field_147337_i = ServerLoginNetHandler.this.func_152506_a(gameprofile);
                        ServerLoginNetHandler.this.field_147328_g = State.NEGOTIATING;
                    } else {
                        ServerLoginNetHandler.this.func_194026_b((ITextComponent)((Object)new TranslationTextComponent("multiplayer.disconnect.unverified_username")));
                        field_147332_c.error(i18n.get((String)"serverloginnethandler.7", (Object[])new Object[]{gameprofile.getName()}));
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (ServerLoginNetHandler.this.field_147327_f.func_71264_H()) {
                        field_147332_c.warn(i18n.get((String)"serverloginnethandler.8"));
                        ServerLoginNetHandler.this.field_147337_i = ServerLoginNetHandler.this.func_152506_a(gameprofile);
                        ServerLoginNetHandler.this.field_147328_g = State.NEGOTIATING;
                    } else {
                        ServerLoginNetHandler.this.func_194026_b((ITextComponent)((Object)new TranslationTextComponent("multiplayer.disconnect.authservers_down")));
                        field_147332_c.error(i18n.get((String)"serverloginnethandler.9"));
                    }
                }
                catch (Exception exception) {
                    ServerLoginNetHandler.this.disconnect("Failed to verify username!");
                    ServerLoginNetHandler.this.field_147327_f.server.getLogger().log(Level.WARNING, "Exception verifying " + gameprofile.getName(), exception);
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress socketaddress = ServerLoginNetHandler.this.field_147333_a.func_74430_c();
                return ServerLoginNetHandler.this.field_147327_f.func_190518_ac() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        };
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_147332_c));
        thread.start();
    }

    public void func_209526_a(CCustomPayloadLoginPacket p_209526_1_) {
        if (!NetworkHooks.onCustomPayload((ICustomPacket)p_209526_1_, (NetworkManager)this.field_147333_a)) {
            this.func_194026_b((ITextComponent)((Object)new TranslationTextComponent("multiplayer.disconnect.unexpected_query_response")));
        }
    }

    protected GameProfile func_152506_a(GameProfile p_152506_1_) {
        UUID uuid = PlayerEntity.func_175147_b(p_152506_1_.getName());
        return new GameProfile(uuid, p_152506_1_.getName());
    }

    static enum State {
        HELLO,
        KEY,
        AUTHENTICATING,
        NEGOTIATING,
        READY_TO_ACCEPT,
        DELAY_ACCEPT,
        ACCEPTED;

    }

    public class LoginHandler {
        public void fireEvents() throws Exception {
            String playerName = ServerLoginNetHandler.this.field_147337_i.getName();
            InetAddress address = ((InetSocketAddress)ServerLoginNetHandler.this.field_147333_a.func_74430_c()).getAddress();
            UUID uniqueId = ServerLoginNetHandler.this.field_147337_i.getId();
            final CraftServer server = ServerLoginNetHandler.this.field_147327_f.server;
            AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId);
            server.getPluginManager().callEvent((Event)asyncEvent);
            if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
                if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                    event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
                }
                Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(){

                    protected PlayerPreLoginEvent.Result evaluate() {
                        server.getPluginManager().callEvent((Event)event);
                        return event.getResult();
                    }
                };
                ServerLoginNetHandler.this.field_147327_f.processQueue.add((Runnable)waitable);
                if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                    ServerLoginNetHandler.this.disconnect(event.getKickMessage());
                    return;
                }
            } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
                ServerLoginNetHandler.this.disconnect(asyncEvent.getKickMessage());
                return;
            }
            field_147332_c.info(i18n.get((String)"serverloginnethandler.10", (Object[])new Object[]{ServerLoginNetHandler.this.field_147337_i.getName(), ServerLoginNetHandler.this.field_147337_i.getId()}));
            ServerLoginNetHandler.this.field_147328_g = State.NEGOTIATING;
        }
    }
}

