/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play;

import co.aikar.timings.MinecraftTimings;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.mohistmc.configuration.MohistConfigUtil;
import com.mohistmc.util.i18n.i18n;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import it.unimi.dsi.fastutil.ints.Int2ShortMap;
import it.unimi.dsi.fastutil.ints.Int2ShortOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.container.BeaconContainer;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.MerchantContainer;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.WritableBookItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.client.CAnimateHandPacket;
import net.minecraft.network.play.client.CChatMessagePacket;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.network.play.client.CCloseWindowPacket;
import net.minecraft.network.play.client.CConfirmTeleportPacket;
import net.minecraft.network.play.client.CConfirmTransactionPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.client.CEditBookPacket;
import net.minecraft.network.play.client.CEnchantItemPacket;
import net.minecraft.network.play.client.CEntityActionPacket;
import net.minecraft.network.play.client.CHeldItemChangePacket;
import net.minecraft.network.play.client.CInputPacket;
import net.minecraft.network.play.client.CJigsawBlockGeneratePacket;
import net.minecraft.network.play.client.CKeepAlivePacket;
import net.minecraft.network.play.client.CLockDifficultyPacket;
import net.minecraft.network.play.client.CMarkRecipeSeenPacket;
import net.minecraft.network.play.client.CMoveVehiclePacket;
import net.minecraft.network.play.client.CPickItemPacket;
import net.minecraft.network.play.client.CPlaceRecipePacket;
import net.minecraft.network.play.client.CPlayerAbilitiesPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemPacket;
import net.minecraft.network.play.client.CQueryEntityNBTPacket;
import net.minecraft.network.play.client.CQueryTileEntityNBTPacket;
import net.minecraft.network.play.client.CRenameItemPacket;
import net.minecraft.network.play.client.CResourcePackStatusPacket;
import net.minecraft.network.play.client.CSeenAdvancementsPacket;
import net.minecraft.network.play.client.CSelectTradePacket;
import net.minecraft.network.play.client.CSetDifficultyPacket;
import net.minecraft.network.play.client.CSpectatePacket;
import net.minecraft.network.play.client.CSteerBoatPacket;
import net.minecraft.network.play.client.CTabCompletePacket;
import net.minecraft.network.play.client.CUpdateBeaconPacket;
import net.minecraft.network.play.client.CUpdateCommandBlockPacket;
import net.minecraft.network.play.client.CUpdateJigsawBlockPacket;
import net.minecraft.network.play.client.CUpdateMinecartCommandBlockPacket;
import net.minecraft.network.play.client.CUpdateRecipeBookStatusPacket;
import net.minecraft.network.play.client.CUpdateSignPacket;
import net.minecraft.network.play.client.CUpdateStructureBlockPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SConfirmTransactionPacket;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.network.play.server.SEntityMetadataPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.network.play.server.SKeepAlivePacket;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.network.play.server.SMoveVehiclePacket;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.network.play.server.SQueryNBTResponsePacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.SSpawnMobPacket;
import net.minecraft.network.play.server.STabCompletePacket;
import net.minecraft.network.play.server.SWorldSpawnChangedPacket;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.JigsawTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.filter.IChatFilter;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftSign;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_16_R3.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_16_R3.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.Vector;
import org.spigotmc.SpigotConfig;

public class ServerPlayNetHandler
implements IServerPlayNetHandler {
    private static final org.apache.logging.log4j.Logger field_147370_c = LogManager.getLogger();
    public final NetworkManager field_147371_a;
    private final MinecraftServer field_147367_d;
    public ServerPlayerEntity field_147369_b;
    private int field_147368_e;
    private long field_194402_f;
    private boolean field_194403_g;
    private long field_194404_h;
    private volatile int chatSpam;
    private static final AtomicIntegerFieldUpdater chatSpamField = AtomicIntegerFieldUpdater.newUpdater(ServerPlayNetHandler.class, "chatSpam");
    private int field_147375_m;
    private final Int2ShortMap field_147372_n = new Int2ShortOpenHashMap();
    private double field_184349_l;
    private double field_184350_m;
    private double field_184351_n;
    private double field_184352_o;
    private double field_184353_p;
    private double field_184354_q;
    private net.minecraft.entity.Entity field_184355_r;
    private double field_184356_s;
    private double field_184357_t;
    private double field_184358_u;
    private double field_184359_v;
    private double field_184360_w;
    private double field_184361_x;
    private Vector3d field_184362_y;
    private int field_184363_z;
    private int field_184343_A;
    private boolean field_184344_B;
    private int field_147365_f;
    private boolean field_184345_D;
    private int field_184346_E;
    private int field_184347_F;
    private int field_184348_G;
    private final CraftServer craftServer;
    public boolean processedDisconnect;
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private static final int SURVIVAL_PLACE_DISTANCE_SQUARED = 36;
    private static final int CREATIVE_PLACE_DISTANCE_SQUARED = 49;
    public int field_147374_l;
    private static final boolean PREVENT_FROM_ENTERING_UNLOADED_CHUNKS = MohistConfigUtil.bMohist((String)"prevent_from_entering_unloaded_chunks", (String)"true");
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private boolean hasMoved;
    private int limitedPackets;
    private long lastLimitedPacket = -1L;
    private static final ResourceLocation CUSTOM_REGISTER = new ResourceLocation("register");
    private static final ResourceLocation CUSTOM_UNREGISTER = new ResourceLocation("unregister");

    public CraftPlayer getPlayer() {
        return this.field_147369_b == null ? null : this.field_147369_b.getBukkitEntity();
    }

    public ServerPlayNetHandler(MinecraftServer p_i1530_1_, NetworkManager p_i1530_2_, ServerPlayerEntity p_i1530_3_) {
        this.field_147367_d = p_i1530_1_;
        this.field_147371_a = p_i1530_2_;
        p_i1530_2_.func_150719_a((INetHandler)this);
        this.field_147369_b = p_i1530_3_;
        p_i1530_3_.field_71135_a = this;
        IChatFilter ichatfilter = p_i1530_3_.func_244529_Q();
        if (ichatfilter != null) {
            ichatfilter.func_244800_a();
        }
        this.craftServer = p_i1530_1_ != null ? p_i1530_1_.server : null;
    }

    public void func_73660_a() {
        int spam;
        this.func_184342_d();
        this.field_147369_b.field_70169_q = this.field_147369_b.func_226277_ct_();
        this.field_147369_b.field_70167_r = this.field_147369_b.func_226278_cu_();
        this.field_147369_b.field_70166_s = this.field_147369_b.func_226281_cx_();
        this.field_147369_b.func_71127_g();
        this.field_147369_b.func_70080_a(this.field_184349_l, this.field_184350_m, this.field_184351_n, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
        ++this.field_147368_e;
        this.field_184348_G = this.field_184347_F;
        if (this.field_184344_B && !this.field_147369_b.func_70608_bn()) {
            if (++this.field_147365_f > 80) {
                field_147370_c.warn(i18n.get((String)"serverplaynethandler.1", (Object[])new Object[]{this.field_147369_b.func_195047_I_()}));
                this.func_194028_b((ITextComponent)((Object)new TranslationTextComponent("multiplayer.disconnect.flying")));
                return;
            }
        } else {
            this.field_184344_B = false;
            this.field_147365_f = 0;
        }
        this.field_184355_r = this.field_147369_b.func_184208_bv();
        if (this.field_184355_r != this.field_147369_b && this.field_184355_r.func_184179_bs() == this.field_147369_b) {
            this.field_184356_s = this.field_184355_r.func_226277_ct_();
            this.field_184357_t = this.field_184355_r.func_226278_cu_();
            this.field_184358_u = this.field_184355_r.func_226281_cx_();
            this.field_184359_v = this.field_184355_r.func_226277_ct_();
            this.field_184360_w = this.field_184355_r.func_226278_cu_();
            this.field_184361_x = this.field_184355_r.func_226281_cx_();
            if (this.field_184345_D && this.field_147369_b.func_184208_bv().func_184179_bs() == this.field_147369_b) {
                if (++this.field_184346_E > 80) {
                    field_147370_c.warn(i18n.get((String)"serverplaynethandler.2", (Object[])new Object[]{this.field_147369_b.func_195047_I_()}));
                    this.func_194028_b((ITextComponent)((Object)new TranslationTextComponent("multiplayer.disconnect.flying")));
                    return;
                }
            } else {
                this.field_184345_D = false;
                this.field_184346_E = 0;
            }
        } else {
            this.field_184355_r = null;
            this.field_184345_D = false;
            this.field_184346_E = 0;
        }
        this.field_147367_d.func_213185_aS().func_76320_a("keepAlive");
        long i = Util.func_211177_b();
        if (i - this.field_194402_f >= 25000L) {
            if (this.field_194403_g) {
                this.func_194028_b((ITextComponent)((Object)new TranslationTextComponent("disconnect.timeout")));
            } else {
                this.field_194403_g = true;
                this.field_194402_f = i;
                this.field_194404_h = i;
                this.func_147359_a((IPacket<?>)new SKeepAlivePacket(this.field_194404_h));
            }
        }
        this.field_147367_d.func_213185_aS().func_76319_b();
        while ((spam = this.chatSpam) > 0 && !chatSpamField.compareAndSet(this, spam, spam - 1)) {
        }
        if (this.field_147375_m > 0) {
            --this.field_147375_m;
        }
        if (this.field_147369_b.func_154331_x() > 0L && this.field_147367_d.func_143007_ar() > 0 && Util.func_211177_b() - this.field_147369_b.func_154331_x() > (long)(this.field_147367_d.func_143007_ar() * 1000 * 60)) {
            this.field_147369_b.func_143004_u();
            this.func_194028_b((ITextComponent)((Object)new TranslationTextComponent("multiplayer.disconnect.idling")));
        }
    }

    public void func_184342_d() {
        this.field_184349_l = this.field_147369_b.func_226277_ct_();
        this.field_184350_m = this.field_147369_b.func_226278_cu_();
        this.field_184351_n = this.field_147369_b.func_226281_cx_();
        this.field_184352_o = this.field_147369_b.func_226277_ct_();
        this.field_184353_p = this.field_147369_b.func_226278_cu_();
        this.field_184354_q = this.field_147369_b.func_226281_cx_();
    }

    public NetworkManager func_147298_b() {
        return this.field_147371_a;
    }

    private boolean func_217264_d() {
        return this.field_147367_d.func_213199_b(this.field_147369_b.func_146103_bH());
    }

    @Deprecated
    public void func_194028_b(ITextComponent p_194028_1_) {
        this.disconnect(CraftChatMessage.fromComponent((ITextComponent)p_194028_1_));
    }

    public void disconnect(String message) {
        if (this.processedDisconnect) {
            return;
        }
        String leaveMessage = TextFormatting.YELLOW + this.field_147369_b.func_195047_I_() + " left the game.";
        PlayerKickEvent event = new PlayerKickEvent(this.craftServer.getPlayer(this.field_147369_b), message, leaveMessage);
        if (this.craftServer.getServer().func_71278_l()) {
            this.craftServer.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return;
        }
        message = event.getReason();
        StringTextComponent textComponent = new StringTextComponent(message);
        this.field_147371_a.func_201058_a((IPacket<?>)new SDisconnectPacket((ITextComponent)textComponent), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)arg_0 -> this.func_210161_a((ITextComponent)textComponent, arg_0)));
        this.func_147231_a((ITextComponent)textComponent);
        this.field_147371_a.func_150721_g();
        MinecraftServer minecraftserver = this.field_147367_d;
        NetworkManager networkmanager = this.field_147371_a;
        ((Object)((Object)this.field_147371_a)).getClass();
        minecraftserver.func_212875_d_(networkmanager::func_179293_l);
    }

    private <T> void func_244533_a(T p_244533_1_, Consumer<T> p_244533_2_, BiFunction<IChatFilter, T, CompletableFuture<Optional<T>>> p_244533_3_) {
        MinecraftServer threadtaskexecutor = this.field_147369_b.func_71121_q().func_73046_m();
        Consumer<Object> consumer = p_244545_2_ -> {
            if (this.func_147298_b().func_150724_d()) {
                p_244533_2_.accept(p_244545_2_);
            } else {
                field_147370_c.debug(i18n.get((String)"serverplaynethandler.3"));
            }
        };
        IChatFilter ichatfilter = this.field_147369_b.func_244529_Q();
        if (ichatfilter != null) {
            p_244533_3_.apply(ichatfilter, (IChatFilter)p_244533_1_).thenAcceptAsync(p_244539_1_ -> p_244539_1_.ifPresent(consumer), (Executor)((Object)threadtaskexecutor));
        } else {
            ((ThreadTaskExecutor)((Object)threadtaskexecutor)).execute(() -> consumer.accept(p_244533_1_));
        }
    }

    private void func_244535_a(String p_244535_1_, Consumer<String> p_244535_2_) {
        this.func_244533_a(p_244535_1_, p_244535_2_, IChatFilter::func_244432_a);
    }

    private void func_244537_a(List<String> p_244537_1_, Consumer<List<String>> p_244537_2_) {
        this.func_244533_a(p_244537_1_, p_244537_2_, IChatFilter::func_244433_a);
    }

    public void func_147358_a(CInputPacket p_147358_1_) {
        PacketThreadUtil.func_218796_a(p_147358_1_, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_110430_a(p_147358_1_.func_149620_c(), p_147358_1_.func_192620_b(), p_147358_1_.func_149618_e(), p_147358_1_.func_229755_e_());
    }

    private static boolean func_183006_b(CPlayerPacket p_183006_0_) {
        if (Doubles.isFinite((double)p_183006_0_.func_186997_a(0.0)) && Doubles.isFinite((double)p_183006_0_.func_186996_b(0.0)) && Doubles.isFinite((double)p_183006_0_.func_187000_c(0.0)) && Floats.isFinite((float)p_183006_0_.func_186998_b(0.0f)) && Floats.isFinite((float)p_183006_0_.func_186999_a(0.0f))) {
            return Math.abs(p_183006_0_.func_186997_a(0.0)) > 3.0E7 || Math.abs(p_183006_0_.func_186996_b(0.0)) > 3.0E7 || Math.abs(p_183006_0_.func_187000_c(0.0)) > 3.0E7;
        }
        return true;
    }

    private static boolean func_184341_b(CMoveVehiclePacket p_184341_0_) {
        return !Doubles.isFinite((double)p_184341_0_.func_187004_a()) || !Doubles.isFinite((double)p_184341_0_.func_187002_b()) || !Doubles.isFinite((double)p_184341_0_.func_187003_c()) || !Floats.isFinite((float)p_184341_0_.func_187005_e()) || !Floats.isFinite((float)p_184341_0_.func_187006_d());
    }

    public void func_184338_a(CMoveVehiclePacket p_184338_1_) {
        PacketThreadUtil.func_218796_a(p_184338_1_, this, this.field_147369_b.func_71121_q());
        if (ServerPlayNetHandler.func_184341_b(p_184338_1_)) {
            this.func_194028_b((ITextComponent)((Object)new TranslationTextComponent("multiplayer.disconnect.invalid_vehicle_movement")));
        } else {
            net.minecraft.entity.Entity entity = this.field_147369_b.func_184208_bv();
            if (entity != this.field_147369_b && entity.func_184179_bs() == this.field_147369_b && entity == this.field_184355_r) {
                double d5;
                double d4;
                double d3;
                double d2;
                double d1;
                double d0;
                ServerWorld serverworld = this.field_147369_b.func_71121_q();
                double fromX = d0 = entity.func_226277_ct_();
                double fromY = d1 = entity.func_226278_cu_();
                double fromZ = d2 = entity.func_226281_cx_();
                double toX = d3 = p_184338_1_.func_187004_a();
                double toY = d4 = p_184338_1_.func_187002_b();
                double toZ = d5 = p_184338_1_.func_187003_c();
                float f = p_184338_1_.func_187006_d();
                float f1 = p_184338_1_.func_187005_e();
                double d6 = d3 - this.field_184356_s;
                double d7 = d4 - this.field_184357_t;
                double d8 = d5 - this.field_184358_u;
                double d9 = entity.func_213322_ci().func_189985_c();
                double currDeltaX = toX - fromX;
                double currDeltaY = toY - fromY;
                double currDeltaZ = toZ - fromZ;
                double d10 = Math.max(d6 * d6 + d7 * d7 + d8 * d8, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.field_184347_F;
                int i = this.field_184347_F - this.field_184348_G;
                if (i > Math.max(this.allowedPlayerTicks, 5)) {
                    field_147370_c.debug(this.field_147369_b.func_195047_I_() + " is sending move packets too frequently (" + i + " packets since last tick)");
                    i = 1;
                }
                this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.field_147369_b.field_71075_bZ.field_75100_b ? (double)(this.field_147369_b.field_71075_bZ.field_75096_f * 20.0f) : (double)(this.field_147369_b.field_71075_bZ.field_75097_g * 10.0f);
                speed *= 2.0;
                if (PREVENT_FROM_ENTERING_UNLOADED_CHUNKS && serverworld.getChunkIfLoaded((int)Math.floor(toX / 16.0), (int)Math.floor(toZ / 16.0)) == null) {
                    this.field_147371_a.func_179290_a((IPacket<?>)new SMoveVehiclePacket(entity));
                    return;
                }
                if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i * speed, 2.0)) && !this.func_217264_d()) {
                    field_147370_c.warn(i18n.get((String)"serverplaynethandler.4", (Object[])new Object[]{entity.func_200200_C_().getString(), this.field_147369_b.func_195047_I_(), d6, d7, d8}));
                    this.field_147371_a.func_179290_a((IPacket<?>)new SMoveVehiclePacket(entity));
                    return;
                }
                boolean flag = serverworld.func_226665_a__(entity, entity.func_174813_aQ().func_186664_h(0.0625));
                d6 = d3 - this.field_184359_v;
                d7 = d4 - this.field_184360_w - 1.0E-6;
                d8 = d5 - this.field_184361_x;
                entity.func_213315_a(MoverType.PLAYER, new Vector3d(d6, d7, d8));
                d6 = d3 - entity.func_226277_ct_();
                d7 = d4 - entity.func_226278_cu_();
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.func_226281_cx_();
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag1 = false;
                if (d10 > SpigotConfig.movedWronglyThreshold) {
                    flag1 = true;
                    field_147370_c.warn(i18n.get((String)"serverplaynethandler.5", (Object[])new Object[]{entity.func_200200_C_().getString(), this.field_147369_b.func_195047_I_(), Math.sqrt(d10)}));
                }
                Location curPos = this.getPlayer().getLocation();
                entity.func_70080_a(d3, d4, d5, f, f1);
                this.field_147369_b.func_70080_a(d3, d4, d5, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                boolean flag2 = serverworld.func_226665_a__(entity, entity.func_174813_aQ().func_186664_h(0.0625));
                if (flag && (flag1 || !flag2)) {
                    entity.func_70080_a(d0, d1, d2, f, f1);
                    this.field_147369_b.func_70080_a(d3, d4, d5, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                    this.field_147371_a.func_179290_a((IPacket<?>)new SMoveVehiclePacket(entity));
                    return;
                }
                CraftPlayer player = this.getPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = curPos.getX();
                    this.lastPosY = curPos.getY();
                    this.lastPosZ = curPos.getZ();
                    this.lastYaw = curPos.getYaw();
                    this.lastPitch = curPos.getPitch();
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = player.getLocation().clone();
                to.setX(p_184338_1_.func_187004_a());
                to.setY(p_184338_1_.func_187002_b());
                to.setZ(p_184338_1_.func_187003_c());
                to.setYaw(p_184338_1_.func_187006_d());
                to.setPitch(p_184338_1_.func_187005_e());
                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.field_147369_b.func_70610_aX()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    Location oldTo = to.clone();
                    PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                    this.craftServer.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.teleport(from);
                        return;
                    }
                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                        this.field_147369_b.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        return;
                    }
                    if (!from.equals((Object)this.getPlayer().getLocation()) && this.justTeleported) {
                        this.justTeleported = false;
                        return;
                    }
                }
                this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
                this.field_147369_b.func_71000_j(this.field_147369_b.func_226277_ct_() - d0, this.field_147369_b.func_226278_cu_() - d1, this.field_147369_b.func_226281_cx_() - d2);
                this.field_184345_D = d7 >= -0.03125 && !this.field_147367_d.func_71231_X() && this.func_241162_a_(entity);
                this.field_184359_v = entity.func_226277_ct_();
                this.field_184360_w = entity.func_226278_cu_();
                this.field_184361_x = entity.func_226281_cx_();
            }
        }
    }

    private boolean func_241162_a_(net.minecraft.entity.Entity p_241162_1_) {
        return BlockPos.func_239581_a_(p_241162_1_.func_174813_aQ().func_186662_g(0.0625).func_72321_a(0.0, -0.55, 0.0)).allMatch(b -> p_241162_1_.field_70170_p.func_180495_p((BlockPos)((Object)b)).isAir((IBlockReader)((Object)p_241162_1_.field_70170_p), (BlockPos)((Object)b)));
    }

    public void func_184339_a(CConfirmTeleportPacket p_184339_1_) {
        PacketThreadUtil.func_218796_a(p_184339_1_, this, this.field_147369_b.func_71121_q());
        if (p_184339_1_.func_186987_a() == this.field_184363_z) {
            this.field_147369_b.func_70080_a(this.field_184362_y.field_72450_a, this.field_184362_y.field_72448_b, this.field_184362_y.field_72449_c, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
            this.field_184352_o = this.field_184362_y.field_72450_a;
            this.field_184353_p = this.field_184362_y.field_72448_b;
            this.field_184354_q = this.field_184362_y.field_72449_c;
            if (this.field_147369_b.func_184850_K()) {
                this.field_147369_b.func_184846_L();
            }
            this.field_184362_y = null;
            this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
        }
    }

    public void func_191984_a(CMarkRecipeSeenPacket p_191984_1_) {
        PacketThreadUtil.func_218796_a(p_191984_1_, this, this.field_147369_b.func_71121_q());
        this.field_147367_d.func_199529_aN().func_215367_a(p_191984_1_.func_244321_b()).ifPresent(this.field_147369_b.func_192037_E()::func_194074_f);
    }

    public void func_241831_a(CUpdateRecipeBookStatusPacket p_241831_1_) {
        PacketThreadUtil.func_218796_a(p_241831_1_, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_192037_E().func_242144_a(p_241831_1_.func_244317_b(), p_241831_1_.func_244318_c(), p_241831_1_.func_244319_d());
    }

    public void func_194027_a(CSeenAdvancementsPacket p_194027_1_) {
        PacketThreadUtil.func_218796_a(p_194027_1_, this, this.field_147369_b.func_71121_q());
        if (p_194027_1_.func_194162_b() == CSeenAdvancementsPacket.Action.OPENED_TAB) {
            ResourceLocation resourcelocation = p_194027_1_.func_194165_c();
            Advancement advancement = this.field_147367_d.func_191949_aK().func_192778_a(resourcelocation);
            if (advancement != null) {
                this.field_147369_b.func_192039_O().func_194220_a(advancement);
            }
        }
    }

    public void func_195518_a(CTabCompletePacket p_195518_1_) {
        PacketThreadUtil.func_218796_a(p_195518_1_, this, this.field_147369_b.func_71121_q());
        if (chatSpamField.addAndGet(this, 1) > 500 && !this.field_147367_d.func_184103_al().func_152596_g(this.field_147369_b.func_146103_bH())) {
            this.func_194028_b((ITextComponent)((Object)new TranslationTextComponent("disconnect.spam", new Object[0])));
            return;
        }
        StringReader stringreader = new StringReader(p_195518_1_.func_197707_b());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        ParseResults parseresults = this.field_147367_d.func_195571_aL().func_197054_a().parse(stringreader, (Object)this.field_147369_b.func_195051_bN());
        this.field_147367_d.func_195571_aL().func_197054_a().getCompletionSuggestions(parseresults).thenAccept(p_195519_2_ -> {
            if (p_195519_2_.isEmpty()) {
                return;
            }
            this.field_147371_a.func_179290_a((IPacket<?>)new STabCompletePacket(p_195518_1_.func_197709_a(), p_195519_2_));
        });
    }

    public void func_210153_a(CUpdateCommandBlockPacket p_210153_1_) {
        PacketThreadUtil.func_218796_a(p_210153_1_, this, this.field_147369_b.func_71121_q());
        if (!this.field_147367_d.func_82356_Z()) {
            this.field_147369_b.func_145747_a((ITextComponent)((Object)new TranslationTextComponent("advMode.notEnabled")), Util.field_240973_b_);
        } else if (!this.field_147369_b.func_195070_dx()) {
            this.field_147369_b.func_145747_a((ITextComponent)((Object)new TranslationTextComponent("advMode.notAllowed")), Util.field_240973_b_);
        } else {
            CommandBlockLogic commandblocklogic = null;
            CommandBlockTileEntity commandblocktileentity = null;
            BlockPos blockpos = p_210153_1_.func_210361_a();
            TileEntity tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos);
            if (tileentity instanceof CommandBlockTileEntity) {
                commandblocktileentity = (CommandBlockTileEntity)tileentity;
                commandblocklogic = commandblocktileentity.func_145993_a();
            }
            String s = p_210153_1_.func_210359_b();
            boolean flag = p_210153_1_.func_210363_c();
            if (commandblocklogic != null) {
                CommandBlockTileEntity.Mode commandblocktileentity$mode = commandblocktileentity.func_184251_i();
                Direction direction = (Direction)((Object)this.field_147369_b.field_70170_p.func_180495_p(blockpos).func_177229_b(CommandBlockBlock.field_185564_a));
                switch (p_210153_1_.func_210360_f()) {
                    case SEQUENCE: {
                        BlockState blockstate1 = Blocks.field_185777_dd.func_176223_P();
                        this.field_147369_b.field_70170_p.func_180501_a(blockpos, (BlockState)((BlockState)blockstate1.func_206870_a(CommandBlockBlock.field_185564_a, direction)).func_206870_a(CommandBlockBlock.field_185565_b, p_210153_1_.func_210364_d()), 2);
                        break;
                    }
                    case AUTO: {
                        BlockState blockstate = Blocks.field_185776_dc.func_176223_P();
                        this.field_147369_b.field_70170_p.func_180501_a(blockpos, (BlockState)((BlockState)blockstate.func_206870_a(CommandBlockBlock.field_185564_a, direction)).func_206870_a(CommandBlockBlock.field_185565_b, p_210153_1_.func_210364_d()), 2);
                        break;
                    }
                    default: {
                        BlockState blockstate2 = Blocks.field_150483_bI.func_176223_P();
                        this.field_147369_b.field_70170_p.func_180501_a(blockpos, (BlockState)((BlockState)blockstate2.func_206870_a(CommandBlockBlock.field_185564_a, direction)).func_206870_a(CommandBlockBlock.field_185565_b, p_210153_1_.func_210364_d()), 2);
                    }
                }
                tileentity.func_145829_t();
                this.field_147369_b.field_70170_p.func_175690_a(blockpos, tileentity);
                commandblocklogic.func_145752_a(s);
                commandblocklogic.func_175573_a(flag);
                if (!flag) {
                    commandblocklogic.func_145750_b(null);
                }
                commandblocktileentity.func_184253_b(p_210153_1_.func_210362_e());
                if (commandblocktileentity$mode != p_210153_1_.func_210360_f()) {
                    commandblocktileentity.func_226987_h_();
                }
                commandblocklogic.func_145756_e();
                if (!net.minecraft.util.StringUtils.func_151246_b((String)s)) {
                    this.field_147369_b.func_145747_a((ITextComponent)((Object)new TranslationTextComponent("advMode.setCommand.success", s)), Util.field_240973_b_);
                }
            }
        }
    }

    public void func_210158_a(CUpdateMinecartCommandBlockPacket p_210158_1_) {
        PacketThreadUtil.func_218796_a(p_210158_1_, this, this.field_147369_b.func_71121_q());
        if (!this.field_147367_d.func_82356_Z()) {
            this.field_147369_b.func_145747_a((ITextComponent)((Object)new TranslationTextComponent("advMode.notEnabled")), Util.field_240973_b_);
        } else if (!this.field_147369_b.func_195070_dx()) {
            this.field_147369_b.func_145747_a((ITextComponent)((Object)new TranslationTextComponent("advMode.notAllowed")), Util.field_240973_b_);
        } else {
            CommandBlockLogic commandblocklogic = p_210158_1_.func_210371_a(this.field_147369_b.field_70170_p);
            if (commandblocklogic != null) {
                commandblocklogic.func_145752_a(p_210158_1_.func_210372_a());
                commandblocklogic.func_175573_a(p_210158_1_.func_210373_b());
                if (!p_210158_1_.func_210373_b()) {
                    commandblocklogic.func_145750_b(null);
                }
                commandblocklogic.func_145756_e();
                this.field_147369_b.func_145747_a((ITextComponent)((Object)new TranslationTextComponent("advMode.setCommand.success", p_210158_1_.func_210372_a())), Util.field_240973_b_);
            }
        }
    }

    public void func_210152_a(CPickItemPacket p_210152_1_) {
        PacketThreadUtil.func_218796_a(p_210152_1_, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.field_71071_by.func_184430_d(p_210152_1_.func_210349_a());
        this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(-2, this.field_147369_b.field_71071_by.field_70461_c, this.field_147369_b.field_71071_by.func_70301_a(this.field_147369_b.field_71071_by.field_70461_c)));
        this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(-2, p_210152_1_.func_210349_a(), this.field_147369_b.field_71071_by.func_70301_a(p_210152_1_.func_210349_a())));
        this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SHeldItemChangePacket(this.field_147369_b.field_71071_by.field_70461_c));
    }

    public void func_210155_a(CRenameItemPacket p_210155_1_) {
        PacketThreadUtil.func_218796_a(p_210155_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71070_bA instanceof RepairContainer) {
            RepairContainer repaircontainer = (RepairContainer)this.field_147369_b.field_71070_bA;
            String s = SharedConstants.func_71565_a(p_210155_1_.func_210351_a());
            if (s.length() <= 35) {
                repaircontainer.func_82850_a(s);
            }
        }
    }

    public void func_210154_a(CUpdateBeaconPacket p_210154_1_) {
        PacketThreadUtil.func_218796_a(p_210154_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71070_bA instanceof BeaconContainer) {
            ((BeaconContainer)this.field_147369_b.field_71070_bA).func_216966_c(p_210154_1_.func_210355_a(), p_210154_1_.func_210356_b());
        }
    }

    public void func_210157_a(CUpdateStructureBlockPacket p_210157_1_) {
        PacketThreadUtil.func_218796_a(p_210157_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_195070_dx()) {
            BlockPos blockpos = p_210157_1_.func_210380_a();
            BlockState blockstate = this.field_147369_b.field_70170_p.func_180495_p(blockpos);
            TileEntity tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos);
            if (tileentity instanceof StructureBlockTileEntity) {
                StructureBlockTileEntity structureblocktileentity = (StructureBlockTileEntity)tileentity;
                structureblocktileentity.func_184405_a(p_210157_1_.func_210378_c());
                structureblocktileentity.func_184404_a(p_210157_1_.func_210377_d());
                structureblocktileentity.func_184414_b(p_210157_1_.func_210383_e());
                structureblocktileentity.func_184409_c(p_210157_1_.func_210385_f());
                structureblocktileentity.func_184411_a(p_210157_1_.func_210386_g());
                structureblocktileentity.func_184408_a(p_210157_1_.func_210379_h());
                structureblocktileentity.func_184410_b(p_210157_1_.func_210388_i());
                structureblocktileentity.func_184406_a(p_210157_1_.func_210389_j());
                structureblocktileentity.func_189703_e(p_210157_1_.func_210390_k());
                structureblocktileentity.func_189710_f(p_210157_1_.func_210387_l());
                structureblocktileentity.func_189718_a(p_210157_1_.func_210382_m());
                structureblocktileentity.func_189725_a(p_210157_1_.func_210381_n());
                if (structureblocktileentity.func_208404_d()) {
                    String s = structureblocktileentity.func_189715_d();
                    if (p_210157_1_.func_210384_b() == StructureBlockTileEntity.UpdateCommand.SAVE_AREA) {
                        if (structureblocktileentity.func_184419_m()) {
                            this.field_147369_b.func_146105_b((ITextComponent)((Object)new TranslationTextComponent("structure_block.save_success", s)), false);
                        } else {
                            this.field_147369_b.func_146105_b((ITextComponent)((Object)new TranslationTextComponent("structure_block.save_failure", s)), false);
                        }
                    } else if (p_210157_1_.func_210384_b() == StructureBlockTileEntity.UpdateCommand.LOAD_AREA) {
                        if (!structureblocktileentity.func_189709_F()) {
                            this.field_147369_b.func_146105_b((ITextComponent)((Object)new TranslationTextComponent("structure_block.load_not_found", s)), false);
                        } else if (structureblocktileentity.func_242687_a(this.field_147369_b.func_71121_q())) {
                            this.field_147369_b.func_146105_b((ITextComponent)((Object)new TranslationTextComponent("structure_block.load_success", s)), false);
                        } else {
                            this.field_147369_b.func_146105_b((ITextComponent)((Object)new TranslationTextComponent("structure_block.load_prepare", s)), false);
                        }
                    } else if (p_210157_1_.func_210384_b() == StructureBlockTileEntity.UpdateCommand.SCAN_AREA) {
                        if (structureblocktileentity.func_184417_l()) {
                            this.field_147369_b.func_146105_b((ITextComponent)((Object)new TranslationTextComponent("structure_block.size_success", s)), false);
                        } else {
                            this.field_147369_b.func_146105_b((ITextComponent)((Object)new TranslationTextComponent("structure_block.size_failure")), false);
                        }
                    }
                } else {
                    this.field_147369_b.func_146105_b((ITextComponent)((Object)new TranslationTextComponent("structure_block.invalid_structure_name", p_210157_1_.func_210377_d())), false);
                }
                structureblocktileentity.func_70296_d();
                this.field_147369_b.field_70170_p.func_184138_a(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public void func_217262_a(CUpdateJigsawBlockPacket p_217262_1_) {
        PacketThreadUtil.func_218796_a(p_217262_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_195070_dx()) {
            BlockPos blockpos = p_217262_1_.func_218789_b();
            BlockState blockstate = this.field_147369_b.field_70170_p.func_180495_p(blockpos);
            TileEntity tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos);
            if (tileentity instanceof JigsawTileEntity) {
                JigsawTileEntity jigsawtileentity = (JigsawTileEntity)tileentity;
                jigsawtileentity.func_235664_a_(p_217262_1_.func_240851_c_());
                jigsawtileentity.func_235666_b_(p_217262_1_.func_240852_d_());
                jigsawtileentity.func_235667_c_(p_217262_1_.func_240853_e_());
                jigsawtileentity.func_214055_a(p_217262_1_.func_218788_e());
                jigsawtileentity.func_235662_a_(p_217262_1_.func_240854_g_());
                jigsawtileentity.func_70296_d();
                this.field_147369_b.field_70170_p.func_184138_a(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public void func_230549_a_(CJigsawBlockGeneratePacket p_230549_1_) {
        BlockPos blockpos;
        TileEntity tileentity;
        PacketThreadUtil.func_218796_a(p_230549_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_195070_dx() && (tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos = p_230549_1_.func_240844_b_())) instanceof JigsawTileEntity) {
            JigsawTileEntity jigsawtileentity = (JigsawTileEntity)tileentity;
            jigsawtileentity.func_235665_a_(this.field_147369_b.func_71121_q(), p_230549_1_.func_240845_c_(), p_230549_1_.func_240846_d_());
        }
    }

    public void func_210159_a(CSelectTradePacket p_210159_1_) {
        PacketThreadUtil.func_218796_a(p_210159_1_, this, this.field_147369_b.func_71121_q());
        int i = p_210159_1_.func_210353_a();
        Container container = this.field_147369_b.field_71070_bA;
        if (container instanceof MerchantContainer) {
            MerchantContainer merchantcontainer = (MerchantContainer)container;
            CraftEventFactory.callTradeSelectEvent((ServerPlayerEntity)this.field_147369_b, (int)i, (MerchantContainer)merchantcontainer);
            merchantcontainer.func_75175_c(i);
            merchantcontainer.func_217046_g(i);
        }
    }

    public void func_210156_a(CEditBookPacket p_210156_1_) {
        CompoundNBT compoundnbt;
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.disconnect("Book edited too quickly!");
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        net.minecraft.item.ItemStack itemstack = p_210156_1_.func_210346_a();
        if (itemstack.func_77973_b() == Items.field_151099_bA && WritableBookItem.func_150930_a((CompoundNBT)(compoundnbt = itemstack.func_77978_p()))) {
            ArrayList list = Lists.newArrayList();
            boolean flag = p_210156_1_.func_210345_b();
            if (flag) {
                list.add(compoundnbt.func_74779_i("title"));
            }
            ListNBT listnbt = compoundnbt.func_150295_c("pages", 8);
            for (int i = 0; i < listnbt.size(); ++i) {
                list.add(listnbt.func_150307_f(i));
            }
            int j = p_210156_1_.func_244708_d();
            if (PlayerInventory.func_184435_e(j) || j == 40) {
                this.func_244537_a(list, flag ? p_244543_2_ -> this.func_244534_a((String)p_244543_2_.get(0), p_244543_2_.subList(1, p_244543_2_.size()), j) : p_244531_2_ -> this.func_244536_a((List<String>)p_244531_2_, j));
            }
        }
    }

    private void func_244536_a(List<String> p_244536_1_, int p_244536_2_) {
        net.minecraft.item.ItemStack itemstack = this.field_147369_b.field_71071_by.func_70301_a(p_244536_2_);
        if (itemstack.func_77973_b() == Items.field_151099_bA) {
            ListNBT listnbt = new ListNBT();
            p_244536_1_.stream().map(StringNBT::func_229705_a_).forEach(arg_0 -> listnbt.add(arg_0));
            net.minecraft.item.ItemStack old = itemstack.func_77946_l();
            itemstack.func_77983_a("pages", (INBT)listnbt);
            CraftEventFactory.handleEditBookEvent((ServerPlayerEntity)this.field_147369_b, (int)p_244536_2_, (net.minecraft.item.ItemStack)old, (net.minecraft.item.ItemStack)itemstack);
        }
    }

    private void func_244534_a(String p_244534_1_, List<String> p_244534_2_, int p_244534_3_) {
        net.minecraft.item.ItemStack itemstack = this.field_147369_b.field_71071_by.func_70301_a(p_244534_3_);
        if (itemstack.func_77973_b() == Items.field_151099_bA) {
            net.minecraft.item.ItemStack itemstack1 = new net.minecraft.item.ItemStack(Items.field_151164_bB);
            CompoundNBT compoundnbt = itemstack.func_77978_p();
            if (compoundnbt != null) {
                itemstack1.func_77982_d(compoundnbt.func_74737_b());
            }
            itemstack1.func_77983_a("author", StringNBT.func_229705_a_(this.field_147369_b.func_200200_C_().getString()));
            itemstack1.func_77983_a("title", StringNBT.func_229705_a_(p_244534_1_));
            ListNBT listnbt = new ListNBT();
            for (String s : p_244534_2_) {
                StringTextComponent itextcomponent = new StringTextComponent(s);
                String s1 = ITextComponent.Serializer.func_150696_a((ITextComponent)itextcomponent);
                listnbt.add((Object)StringNBT.func_229705_a_(s1));
            }
            itemstack1.func_77983_a("pages", (INBT)listnbt);
            this.field_147369_b.field_71071_by.func_70299_a(p_244534_3_, CraftEventFactory.handleEditBookEvent((ServerPlayerEntity)this.field_147369_b, (int)p_244534_3_, (net.minecraft.item.ItemStack)itemstack, (net.minecraft.item.ItemStack)itemstack1));
        }
    }

    public void func_211526_a(CQueryEntityNBTPacket p_211526_1_) {
        net.minecraft.entity.Entity entity;
        PacketThreadUtil.func_218796_a(p_211526_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_211513_k(2) && (entity = this.field_147369_b.func_71121_q().func_73045_a(p_211526_1_.func_211720_c())) != null) {
            CompoundNBT compoundnbt = entity.func_189511_e(new CompoundNBT());
            this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SQueryNBTResponsePacket(p_211526_1_.func_211721_b(), compoundnbt));
        }
    }

    public void func_211525_a(CQueryTileEntityNBTPacket p_211525_1_) {
        PacketThreadUtil.func_218796_a(p_211525_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_211513_k(2)) {
            TileEntity tileentity = this.field_147369_b.func_71121_q().func_175625_s(p_211525_1_.func_211717_c());
            CompoundNBT compoundnbt = tileentity != null ? tileentity.func_189515_b(new CompoundNBT()) : null;
            this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SQueryNBTResponsePacket(p_211525_1_.func_211716_b(), compoundnbt));
        }
    }

    public void func_147347_a(CPlayerPacket p_147347_1_) {
        PacketThreadUtil.func_218796_a(p_147347_1_, this, this.field_147369_b.func_71121_q());
        if (ServerPlayNetHandler.func_183006_b(p_147347_1_)) {
            this.func_194028_b((ITextComponent)((Object)new TranslationTextComponent("multiplayer.disconnect.invalid_player_movement")));
        } else {
            ServerWorld serverworld = this.field_147369_b.func_71121_q();
            if (!this.field_147369_b.field_71136_j && !this.field_147369_b.func_70610_aX()) {
                if (this.field_147368_e == 0) {
                    this.func_184342_d();
                }
                if (this.field_184362_y != null) {
                    if (this.field_147368_e - this.field_184343_A > 20) {
                        this.field_184343_A = this.field_147368_e;
                        this.func_147364_a(this.field_184362_y.field_72450_a, this.field_184362_y.field_72448_b, this.field_184362_y.field_72449_c, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                    }
                    this.allowedPlayerTicks = 20;
                } else {
                    this.field_184343_A = this.field_147368_e;
                    if (this.field_147369_b.func_184218_aH()) {
                        this.field_147369_b.func_70080_a(this.field_147369_b.func_226277_ct_(), this.field_147369_b.func_226278_cu_(), this.field_147369_b.func_226281_cx_(), p_147347_1_.func_186999_a(this.field_147369_b.field_70177_z), p_147347_1_.func_186998_b(this.field_147369_b.field_70125_A));
                        this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double d6;
                        double d5;
                        double d4;
                        double prevX = this.field_147369_b.func_226277_ct_();
                        double prevY = this.field_147369_b.func_226278_cu_();
                        double prevZ = this.field_147369_b.func_226281_cx_();
                        float prevYaw = this.field_147369_b.field_70177_z;
                        float prevPitch = this.field_147369_b.field_70125_A;
                        double d0 = this.field_147369_b.func_226277_ct_();
                        double d1 = this.field_147369_b.func_226278_cu_();
                        double d2 = this.field_147369_b.func_226281_cx_();
                        double d3 = this.field_147369_b.func_226278_cu_();
                        double toX = d4 = p_147347_1_.func_186997_a(this.field_147369_b.func_226277_ct_());
                        double toY = d5 = p_147347_1_.func_186996_b(this.field_147369_b.func_226278_cu_());
                        double toZ = d6 = p_147347_1_.func_187000_c(this.field_147369_b.func_226281_cx_());
                        float f = p_147347_1_.func_186999_a(this.field_147369_b.field_70177_z);
                        float f1 = p_147347_1_.func_186998_b(this.field_147369_b.field_70125_A);
                        double d7 = d4 - this.field_184349_l;
                        double d8 = d5 - this.field_184350_m;
                        double d9 = d6 - this.field_184351_n;
                        double d10 = this.field_147369_b.func_213322_ci().func_189985_c();
                        double currDeltaX = toX - prevX;
                        double currDeltaY = toY - prevY;
                        double currDeltaZ = toZ - prevZ;
                        double d11 = Math.max(d7 * d7 + d8 * d8 + d9 * d9, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                        if (this.field_147369_b.func_70608_bn()) {
                            if (d11 > 1.0) {
                                this.func_147364_a(this.field_147369_b.func_226277_ct_(), this.field_147369_b.func_226278_cu_(), this.field_147369_b.func_226281_cx_(), p_147347_1_.func_186999_a(this.field_147369_b.field_70177_z), p_147347_1_.func_186998_b(this.field_147369_b.field_70125_A));
                            }
                        } else {
                            boolean flag;
                            ++this.field_184347_F;
                            int i = this.field_184347_F - this.field_184348_G;
                            this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                            this.lastTick = (int)(System.currentTimeMillis() / 50L);
                            if (i > Math.max(this.allowedPlayerTicks, 5)) {
                                field_147370_c.debug(i18n.get((String)"serverplaynethandler.6", (Object[])new Object[]{this.field_147369_b.func_195047_I_(), i}));
                                i = 1;
                            }
                            this.allowedPlayerTicks = p_147347_1_.field_149481_i || d11 > 0.0 ? --this.allowedPlayerTicks : 20;
                            double speed = this.field_147369_b.field_71075_bZ.field_75100_b ? (double)(this.field_147369_b.field_71075_bZ.field_75096_f * 20.0f) : (double)(this.field_147369_b.field_71075_bZ.field_75097_g * 10.0f);
                            if (PREVENT_FROM_ENTERING_UNLOADED_CHUNKS && (prevX != toX || prevZ != toZ) && serverworld.getChunkIfLoaded((int)Math.floor(toX / 16.0), (int)Math.floor(toZ / 16.0)) == null) {
                                this.internalTeleport(prevX, prevY, prevZ, prevYaw, prevPitch, Collections.emptySet());
                                return;
                            }
                            if (!(this.field_147369_b.func_184850_K() || this.field_147369_b.func_71121_q().func_82736_K().func_223586_b(GameRules.field_223615_r) && this.field_147369_b.func_184613_cA())) {
                                float f2;
                                float f3 = f2 = this.field_147369_b.func_184613_cA() ? 300.0f : 100.0f;
                                if (d11 - d10 > Math.max((double)f2, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i * speed, 2.0)) && !this.func_217264_d()) {
                                    field_147370_c.warn(i18n.get((String)"serverplaynethandler.7", (Object[])new Object[]{this.field_147369_b.func_195047_I_(), d7, d8, d9}));
                                    this.func_147364_a(this.field_147369_b.func_226277_ct_(), this.field_147369_b.func_226278_cu_(), this.field_147369_b.func_226281_cx_(), this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                                    return;
                                }
                            }
                            AxisAlignedBB axisalignedbb = this.field_147369_b.func_174813_aQ();
                            d7 = d4 - this.field_184352_o;
                            d8 = d5 - this.field_184353_p;
                            d9 = d6 - this.field_184354_q;
                            boolean bl = flag = d8 > 0.0;
                            if (this.field_147369_b.func_233570_aj_() && !p_147347_1_.func_149465_i() && flag) {
                                this.field_147369_b.func_70664_aZ();
                            }
                            this.field_147369_b.func_213315_a(MoverType.PLAYER, new Vector3d(d7, d8, d9));
                            this.field_147369_b.func_230245_c_(p_147347_1_.func_149465_i());
                            d7 = d4 - this.field_147369_b.func_226277_ct_();
                            d8 = d5 - this.field_147369_b.func_226278_cu_();
                            if (d8 > -0.5 || d8 < 0.5) {
                                d8 = 0.0;
                            }
                            d9 = d6 - this.field_147369_b.func_226281_cx_();
                            d11 = d7 * d7 + d8 * d8 + d9 * d9;
                            boolean flag1 = false;
                            if (!this.field_147369_b.func_184850_K() && d11 > SpigotConfig.movedWronglyThreshold && !this.field_147369_b.func_70608_bn() && !this.field_147369_b.field_71134_c.func_73083_d() && this.field_147369_b.field_71134_c.func_73081_b() != GameType.SPECTATOR) {
                                flag1 = true;
                                field_147370_c.warn(i18n.get((String)"serverplaynethandler.8", (Object[])new Object[]{this.field_147369_b.func_195047_I_()}));
                            }
                            this.field_147369_b.func_70080_a(d4, d5, d6, f, f1);
                            if (this.field_147369_b.field_70145_X || this.field_147369_b.func_70608_bn() || (!flag1 || !serverworld.func_226665_a__(this.field_147369_b, axisalignedbb)) && !this.func_241163_a_((IWorldReader)((Object)serverworld), axisalignedbb)) {
                                this.field_147369_b.func_70080_a(prevX, prevY, prevZ, prevYaw, prevPitch);
                                CraftPlayer player = this.getPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (p_147347_1_.field_149480_h) {
                                    to.setX(p_147347_1_.field_149479_a);
                                    to.setY(p_147347_1_.field_149477_b);
                                    to.setZ(p_147347_1_.field_149478_c);
                                }
                                if (p_147347_1_.field_149481_i) {
                                    to.setYaw(p_147347_1_.field_149476_e);
                                    to.setPitch(p_147347_1_.field_149473_f);
                                }
                                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.field_147369_b.func_70610_aX()) {
                                    this.lastPosX = to.getX();
                                    this.lastPosY = to.getY();
                                    this.lastPosZ = to.getZ();
                                    this.lastYaw = to.getYaw();
                                    this.lastPitch = to.getPitch();
                                    if (from.getX() != Double.MAX_VALUE) {
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                                        this.craftServer.getPluginManager().callEvent((Event)event);
                                        if (event.isCancelled()) {
                                            this.teleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                                            this.field_147369_b.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                }
                                this.field_147369_b.func_70080_a(d4, d5, d6, f, f1);
                                this.field_184344_B = d8 >= -0.03125 && this.field_147369_b.field_71134_c.func_73081_b() != GameType.SPECTATOR && !this.field_147367_d.func_71231_X() && !this.field_147369_b.field_71075_bZ.field_75101_c && !this.field_147369_b.func_70644_a(Effects.field_188424_y) && !this.field_147369_b.func_184613_cA() && this.func_241162_a_(this.field_147369_b) && !this.field_147369_b.func_204805_cN();
                                this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
                                this.field_147369_b.func_71122_b(this.field_147369_b.func_226278_cu_() - d3, p_147347_1_.func_149465_i());
                                if (flag) {
                                    this.field_147369_b.field_70143_R = 0.0f;
                                }
                                this.field_147369_b.func_71000_j(this.field_147369_b.func_226277_ct_() - d0, this.field_147369_b.func_226278_cu_() - d1, this.field_147369_b.func_226281_cx_() - d2);
                                this.field_184352_o = this.field_147369_b.func_226277_ct_();
                                this.field_184353_p = this.field_147369_b.func_226278_cu_();
                                this.field_184354_q = this.field_147369_b.func_226281_cx_();
                            } else {
                                this.func_147364_a(d0, d1, d2, f, f1);
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean func_241163_a_(IWorldReader p_241163_1_, AxisAlignedBB p_241163_2_) {
        Stream stream = p_241163_1_.func_234867_d_(this.field_147369_b, this.field_147369_b.func_174813_aQ().func_186664_h((double)1.0E-5f), p_241167_0_ -> true);
        VoxelShape voxelshape = VoxelShapes.func_197881_a(p_241163_2_.func_186664_h((double)1.0E-5f));
        return stream.anyMatch(p_241164_1_ -> !VoxelShapes.func_197879_c(p_241164_1_, voxelshape, IBooleanFunction.field_223238_i_));
    }

    public void func_147364_a(double p_147364_1_, double p_147364_3_, double p_147364_5_, float p_147364_7_, float p_147364_8_) {
        this.func_175089_a(p_147364_1_, p_147364_3_, p_147364_5_, p_147364_7_, p_147364_8_, Collections.emptySet());
    }

    public void teleport(double x, double y, double z, float yaw, float pitch, PlayerTeleportEvent.TeleportCause cause) {
        this.teleport(x, y, z, yaw, pitch, Collections.emptySet(), cause);
    }

    public void func_175089_a(double p_175089_1_, double p_175089_3_, double p_175089_5_, float p_175089_7_, float p_175089_8_, Set<SPlayerPositionLookPacket.Flags> p_175089_9_) {
        this.teleport(p_175089_1_, p_175089_3_, p_175089_5_, p_175089_7_, p_175089_8_, p_175089_9_, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f, float f1, Set<SPlayerPositionLookPacket.Flags> relativeSet, PlayerTeleportEvent.TeleportCause cause) {
        CraftPlayer player = this.getPlayer();
        Location from = player.getLocation();
        double x = d0;
        double y = d1;
        double z = d2;
        float yaw = f;
        float pitch = f1;
        Location to = new Location(this.getPlayer().getWorld(), x, y, z, yaw, pitch);
        if (from.equals((Object)to)) {
            this.internalTeleport(d0, d1, d2, f, f1, relativeSet);
            return false;
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause);
        this.craftServer.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            relativeSet.clear();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            d0 = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f = to.getYaw();
            f1 = to.getPitch();
        }
        this.internalTeleport(d0, d1, d2, f, f1, relativeSet);
        return event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch(), Collections.emptySet());
    }

    private void internalTeleport(double x, double y, double z, float yaw, float pitch, Set<SPlayerPositionLookPacket.Flags> relativeSet) {
        if (Float.isNaN(yaw)) {
            yaw = 0.0f;
        }
        if (Float.isNaN(pitch)) {
            pitch = 0.0f;
        }
        this.justTeleported = true;
        double d0 = relativeSet.contains(SPlayerPositionLookPacket.Flags.X) ? this.field_147369_b.func_226277_ct_() : 0.0;
        double d1 = relativeSet.contains(SPlayerPositionLookPacket.Flags.Y) ? this.field_147369_b.func_226278_cu_() : 0.0;
        double d2 = relativeSet.contains(SPlayerPositionLookPacket.Flags.Z) ? this.field_147369_b.func_226281_cx_() : 0.0;
        float f = relativeSet.contains(SPlayerPositionLookPacket.Flags.Y_ROT) ? this.field_147369_b.field_70177_z : 0.0f;
        float f1 = relativeSet.contains(SPlayerPositionLookPacket.Flags.X_ROT) ? this.field_147369_b.field_70125_A : 0.0f;
        this.field_184362_y = new Vector3d(x, y, z);
        if (++this.field_184363_z == Integer.MAX_VALUE) {
            this.field_184363_z = 0;
        }
        this.lastPosX = this.field_184362_y.field_72450_a;
        this.lastPosY = this.field_184362_y.field_72448_b;
        this.lastPosZ = this.field_184362_y.field_72449_c;
        this.lastYaw = yaw;
        this.lastPitch = pitch;
        this.field_184343_A = this.field_147368_e;
        this.field_147369_b.func_70012_b(x, y, z, yaw, pitch);
        this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerPositionLookPacket(x - d0, y - d1, z - d2, yaw - f, pitch - f1, relativeSet, this.field_184363_z));
    }

    public void func_147345_a(CPlayerDiggingPacket p_147345_1_) {
        PacketThreadUtil.func_218796_a(p_147345_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_70610_aX()) {
            return;
        }
        BlockPos blockpos = p_147345_1_.func_179715_a();
        this.field_147369_b.func_143004_u();
        CPlayerDiggingPacket.Action cplayerdiggingpacket$action = p_147345_1_.func_180762_c();
        switch (cplayerdiggingpacket$action) {
            case SWAP_ITEM_WITH_OFFHAND: {
                if (!this.field_147369_b.func_175149_v()) {
                    net.minecraft.item.ItemStack itemstack = this.field_147369_b.func_184586_b(Hand.OFF_HAND);
                    CraftItemStack mainHand = CraftItemStack.asCraftMirror((net.minecraft.item.ItemStack)itemstack);
                    CraftItemStack offHand = CraftItemStack.asCraftMirror((net.minecraft.item.ItemStack)this.field_147369_b.func_184586_b(Hand.MAIN_HAND));
                    PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getPlayer(), (ItemStack)mainHand.clone(), (ItemStack)offHand.clone());
                    this.craftServer.getPluginManager().callEvent((Event)swapItemsEvent);
                    if (swapItemsEvent.isCancelled()) {
                        return;
                    }
                    if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                        this.field_147369_b.func_184611_a(Hand.OFF_HAND, this.field_147369_b.func_184586_b(Hand.MAIN_HAND));
                    } else {
                        this.field_147369_b.func_184611_a(Hand.OFF_HAND, CraftItemStack.asNMSCopy((ItemStack)swapItemsEvent.getOffHandItem()));
                    }
                    if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                        this.field_147369_b.func_184611_a(Hand.MAIN_HAND, itemstack);
                    } else {
                        this.field_147369_b.func_184611_a(Hand.MAIN_HAND, CraftItemStack.asNMSCopy((ItemStack)swapItemsEvent.getMainHandItem()));
                    }
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.field_147369_b.func_175149_v()) {
                    if (this.lastDropTick != MinecraftServer.currentTick) {
                        this.dropCount = 0;
                        this.lastDropTick = MinecraftServer.currentTick;
                    } else {
                        ++this.dropCount;
                        if (this.dropCount >= 20) {
                            field_147370_c.warn(this.field_147369_b.func_195047_I_() + " dropped their items too quickly!");
                            this.disconnect("You dropped your items too quickly (Hacking?)");
                            return;
                        }
                    }
                    this.field_147369_b.func_225609_n_(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.field_147369_b.func_175149_v()) {
                    this.field_147369_b.func_225609_n_(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.field_147369_b.func_184597_cx();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.field_147369_b.field_71134_c.func_225416_a(blockpos, cplayerdiggingpacket$action, p_147345_1_.func_179714_b(), this.field_147367_d.func_71207_Z());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < 30L && this.limitedPackets++ >= 4) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= 30L) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    private static boolean func_241166_a_(ServerPlayerEntity p_241166_0_, net.minecraft.item.ItemStack p_241166_1_) {
        if (p_241166_1_.func_190926_b()) {
            return false;
        }
        Item item = p_241166_1_.func_77973_b();
        return (item instanceof BlockItem || item instanceof BucketItem) && !p_241166_0_.func_184811_cZ().func_185141_a(item);
    }

    public void func_184337_a(CPlayerTryUseItemOnBlockPacket p_184337_1_) {
        PacketThreadUtil.func_218796_a(p_184337_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_70610_aX()) {
            return;
        }
        if (!this.checkLimit(p_184337_1_.timestamp)) {
            return;
        }
        ServerWorld serverworld = this.field_147369_b.func_71121_q();
        Hand hand = p_184337_1_.func_187022_c();
        net.minecraft.item.ItemStack itemstack = this.field_147369_b.func_184586_b(hand);
        BlockRayTraceResult blockraytraceresult = p_184337_1_.func_218794_c();
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        Direction direction = blockraytraceresult.func_216354_b();
        this.field_147369_b.func_143004_u();
        if (blockpos.func_177956_o() < this.field_147367_d.func_71207_Z()) {
            double dist = this.field_147369_b.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 3.0;
            dist *= dist;
            if (this.field_184362_y == null && this.field_147369_b.func_70092_e((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5) < dist && serverworld.func_175660_a(this.field_147369_b, blockpos)) {
                this.field_147369_b.func_184597_cx();
                ActionResultType actionresulttype = this.field_147369_b.field_71134_c.func_219441_a(this.field_147369_b, serverworld, itemstack, hand, blockraytraceresult);
                if (direction == Direction.UP && !actionresulttype.func_226246_a_() && blockpos.func_177956_o() >= this.field_147367_d.func_71207_Z() - 1 && ServerPlayNetHandler.func_241166_a_(this.field_147369_b, itemstack)) {
                    IFormattableTextComponent itextcomponent = new TranslationTextComponent("build.tooHigh", this.field_147367_d.func_71207_Z()).func_240699_a_(TextFormatting.RED);
                    this.field_147369_b.field_71135_a.func_147359_a(new SChatPacket((ITextComponent)itextcomponent, ChatType.GAME_INFO, Util.field_240973_b_));
                } else if (actionresulttype.func_226247_b_()) {
                    this.field_147369_b.func_226292_a_(hand, true);
                }
            }
        } else {
            IFormattableTextComponent itextcomponent1 = new TranslationTextComponent("build.tooHigh", this.field_147367_d.func_71207_Z()).func_240699_a_(TextFormatting.RED);
            this.field_147369_b.field_71135_a.func_147359_a(new SChatPacket((ITextComponent)itextcomponent1, ChatType.GAME_INFO, Util.field_240973_b_));
        }
        this.field_147369_b.field_71135_a.func_147359_a(new SChangeBlockPacket((IBlockReader)((Object)serverworld), blockpos));
        this.field_147369_b.field_71135_a.func_147359_a(new SChangeBlockPacket((IBlockReader)((Object)serverworld), blockpos.func_177972_a(direction)));
    }

    public void func_147346_a(CPlayerTryUseItemPacket p_147346_1_) {
        PacketThreadUtil.func_218796_a(p_147346_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_70610_aX()) {
            return;
        }
        if (!this.checkLimit(p_147346_1_.timestamp)) {
            return;
        }
        ServerWorld serverworld = this.field_147369_b.func_71121_q();
        Hand hand = p_147346_1_.func_187028_a();
        net.minecraft.item.ItemStack itemstack = this.field_147369_b.func_184586_b(hand);
        this.field_147369_b.func_143004_u();
        if (!itemstack.func_190926_b()) {
            boolean cancelled;
            float f1 = this.field_147369_b.field_70125_A;
            float f2 = this.field_147369_b.field_70177_z;
            double d0 = this.field_147369_b.func_226277_ct_();
            double d1 = this.field_147369_b.func_226278_cu_() + (double)this.field_147369_b.func_70047_e();
            double d2 = this.field_147369_b.func_226281_cx_();
            Vector3d vec3d = new Vector3d(d0, d1, d2);
            float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
            float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = this.field_147369_b.field_71134_c.func_73081_b() == GameType.CREATIVE ? 5.0 : 4.5;
            Vector3d vec3d1 = vec3d.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            BlockRayTraceResult movingobjectposition = this.field_147369_b.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, this.field_147369_b));
            if (movingobjectposition == null || movingobjectposition.func_216346_c() != RayTraceResult.Type.BLOCK) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((PlayerEntity)this.field_147369_b, (Action)Action.RIGHT_CLICK_AIR, (net.minecraft.item.ItemStack)itemstack, (Hand)hand);
                cancelled = event.useItemInHand() == Event.Result.DENY;
            } else {
                PlayerInteractEvent event2;
                BlockRayTraceResult movingobjectpositionblock = movingobjectposition;
                cancelled = this.field_147369_b.field_71134_c.firedInteract && this.field_147369_b.field_71134_c.interactPosition.equals((Object)movingobjectpositionblock.func_216350_a()) && this.field_147369_b.field_71134_c.interactHand == hand && net.minecraft.item.ItemStack.func_77970_a(this.field_147369_b.field_71134_c.interactItemStack, itemstack) ? this.field_147369_b.field_71134_c.interactResult : (event2 = CraftEventFactory.callPlayerInteractEvent((PlayerEntity)this.field_147369_b, (Action)Action.RIGHT_CLICK_BLOCK, (BlockPos)movingobjectpositionblock.func_216350_a(), (Direction)movingobjectpositionblock.func_216354_b(), (net.minecraft.item.ItemStack)itemstack, (boolean)true, (Hand)hand)).useItemInHand() == Event.Result.DENY;
                this.field_147369_b.field_71134_c.firedInteract = false;
            }
            if (cancelled) {
                this.field_147369_b.getBukkitEntity().updateInventory();
            }
            if ((itemstack = this.field_147369_b.func_184586_b(hand)).func_190926_b()) {
                return;
            }
            ActionResultType actionresulttype = this.field_147369_b.field_71134_c.func_187250_a(this.field_147369_b, serverworld, itemstack, hand);
            if (actionresulttype.func_226247_b_()) {
                this.field_147369_b.func_226292_a_(hand, true);
            }
        }
    }

    public void func_175088_a(CSpectatePacket p_175088_1_) {
        PacketThreadUtil.func_218796_a(p_175088_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_175149_v()) {
            for (ServerWorld serverworld : this.field_147367_d.func_212370_w()) {
                net.minecraft.entity.Entity entity = p_175088_1_.func_179727_a(serverworld);
                if (entity == null) continue;
                this.field_147369_b.func_200619_a(serverworld, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
                return;
            }
        }
    }

    public void func_175086_a(CResourcePackStatusPacket p_175086_1_) {
        PacketThreadUtil.func_218796_a(p_175086_1_, this, this.field_147369_b.func_71121_q());
        this.craftServer.getPluginManager().callEvent((Event)new PlayerResourcePackStatusEvent((Player)this.getPlayer(), PlayerResourcePackStatusEvent.Status.values()[p_175086_1_.field_179719_b.ordinal()]));
    }

    public void func_184340_a(CSteerBoatPacket p_184340_1_) {
        PacketThreadUtil.func_218796_a(p_184340_1_, this, this.field_147369_b.func_71121_q());
        net.minecraft.entity.Entity entity = this.field_147369_b.func_184187_bx();
        if (entity instanceof BoatEntity) {
            ((BoatEntity)entity).func_184445_a(p_184340_1_.func_187012_a(), p_184340_1_.func_187014_b());
        }
    }

    public void func_147231_a(ITextComponent p_147231_1_) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        field_147370_c.info(i18n.get((String)"serverplaynethandler.9", (Object[])new Object[]{this.field_147369_b.func_195047_I_(), p_147231_1_.getString()}));
        String quitMessage = this.field_147367_d.func_184103_al().disconnect(this.field_147369_b);
        IChatFilter ichatfilter = this.field_147369_b.func_244529_Q();
        if (ichatfilter != null) {
            ichatfilter.func_244434_b();
        }
        if (quitMessage != null && quitMessage.length() > 0) {
            this.field_147367_d.func_184103_al().sendMessage(CraftChatMessage.fromString((String)quitMessage));
        }
        if (this.func_217264_d()) {
            field_147370_c.info(i18n.get((String)"serverplaynethandler.10"));
            this.field_147367_d.func_71263_m(false);
        }
    }

    public void func_147359_a(IPacket<?> p_147359_1_) {
        this.func_211148_a(p_147359_1_, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)null));
    }

    public void func_211148_a(IPacket<?> p_211148_1_, @Nullable GenericFutureListener<? extends Future<? super Void>> p_211148_2_) {
        if (p_211148_1_ instanceof SChatPacket) {
            SChatPacket schatpacket = (SChatPacket)p_211148_1_;
            ChatVisibility chatvisibility = this.field_147369_b.func_147096_v();
            if (chatvisibility == ChatVisibility.HIDDEN && schatpacket.func_192590_c() != ChatType.GAME_INFO) {
                return;
            }
            if (chatvisibility == ChatVisibility.SYSTEM && !schatpacket.func_148916_d()) {
                return;
            }
        }
        if (p_211148_1_ == null || this.processedDisconnect) {
            return;
        }
        if (p_211148_1_ instanceof SWorldSpawnChangedPacket) {
            SWorldSpawnChangedPacket packet6 = (SWorldSpawnChangedPacket)p_211148_1_;
            this.field_147369_b.compassTarget = new Location(this.getPlayer().getWorld(), (double)packet6.func_240832_b_().func_177958_n(), (double)packet6.func_240832_b_().func_177956_o(), (double)packet6.func_240832_b_().func_177952_p());
        }
        try {
            this.field_147371_a.func_201058_a(p_211148_1_, p_211148_2_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Sending packet");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Packet being sent");
            crashreportcategory.func_189529_a("Packet class", (ICrashReportDetail<String>)((ICrashReportDetail)() -> p_211148_1_.getClass().getCanonicalName()));
            throw new ReportedException(crashreport);
        }
    }

    public void func_147355_a(CHeldItemChangePacket p_147355_1_) {
        PacketThreadUtil.func_218796_a(p_147355_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_70610_aX()) {
            return;
        }
        if (p_147355_1_.func_149614_c() >= 0 && p_147355_1_.func_149614_c() < PlayerInventory.func_70451_h()) {
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getPlayer(), this.field_147369_b.field_71071_by.field_70461_c, p_147355_1_.func_149614_c());
            this.craftServer.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.func_147359_a((IPacket<?>)new SHeldItemChangePacket(this.field_147369_b.field_71071_by.field_70461_c));
                this.field_147369_b.func_143004_u();
                return;
            }
            if (this.field_147369_b.field_71071_by.field_70461_c != p_147355_1_.func_149614_c() && this.field_147369_b.func_184600_cs() == Hand.MAIN_HAND) {
                this.field_147369_b.func_184602_cy();
            }
            this.field_147369_b.field_71071_by.field_70461_c = p_147355_1_.func_149614_c();
            this.field_147369_b.func_143004_u();
        } else {
            field_147370_c.warn(i18n.get((String)"serverplaynethandler.11", (Object[])new Object[]{this.field_147369_b.func_195047_I_()}));
            this.disconnect("Invalid hotbar selection (Hacking?)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_147354_a(CChatMessagePacket p_147354_1_) {
        if (this.field_147367_d.func_71241_aa()) {
            return;
        }
        boolean isSync = p_147354_1_.func_149439_c().startsWith("/");
        if (p_147354_1_.func_149439_c().startsWith("/")) {
            PacketThreadUtil.func_218796_a(p_147354_1_, this, this.field_147369_b.func_71121_q());
        }
        if (this.field_147369_b.field_70128_L || this.field_147369_b.func_147096_v() == ChatVisibility.HIDDEN) {
            this.func_147359_a(new SChatPacket((ITextComponent)new TranslationTextComponent("chat.cannotSend").func_240699_a_(TextFormatting.RED), ChatType.SYSTEM, Util.field_240973_b_));
        } else {
            this.field_147369_b.func_143004_u();
            String s = StringUtils.normalizeSpace((String)p_147354_1_.func_149439_c());
            for (int i = 0; i < s.length(); ++i) {
                if (SharedConstants.func_71566_a(s.charAt(i))) continue;
                if (!isSync) {
                    Waitable waitable = new Waitable(){

                        protected Object evaluate() {
                            ServerPlayNetHandler.this.func_194028_b((ITextComponent)((Object)new TranslationTextComponent("multiplayer.disconnect.illegal_characters", new Object[0])));
                            return null;
                        }
                    };
                    this.field_147367_d.processQueue.add((Runnable)waitable);
                    try {
                        waitable.get();
                        return;
                    }
                    catch (InterruptedException e3) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                return;
            }
            if (isSync) {
                try {
                    this.field_147367_d.server.playerCommandState = true;
                    this.func_147361_d(s);
                }
                finally {
                    this.field_147367_d.server.playerCommandState = false;
                }
            } else if (s.isEmpty()) {
                field_147370_c.warn(this.field_147369_b.func_195047_I_() + " tried to send an empty message");
            } else if (this.getPlayer().isConversing()) {
                final String conversationInput = s;
                this.field_147367_d.processQueue.add(new Runnable(){

                    @Override
                    public void run() {
                        ServerPlayNetHandler.this.getPlayer().acceptConversationInput(conversationInput);
                    }
                });
            } else if (this.field_147369_b.func_147096_v() == ChatVisibility.SYSTEM) {
                TranslationTextComponent chatmessage = new TranslationTextComponent("chat.cannotSend", new Object[0]);
                chatmessage.func_150256_b().func_240712_a_(TextFormatting.RED);
                this.func_147359_a(new SChatPacket((ITextComponent)new TranslationTextComponent("chat.cannotSend").func_240699_a_(TextFormatting.RED), ChatType.SYSTEM, Util.field_240973_b_));
            } else {
                this.chat(s, true);
            }
            boolean counted = true;
            for (String exclude : SpigotConfig.spamExclusions) {
                if (exclude == null || !s.startsWith(exclude)) continue;
                counted = false;
                break;
            }
            if (counted && chatSpamField.addAndGet(this, 20) > 200 && !this.field_147367_d.func_184103_al().func_152596_g(this.field_147369_b.func_146103_bH())) {
                if (!isSync) {
                    Iterator waitable = new Waitable(){

                        protected Object evaluate() {
                            ServerPlayNetHandler.this.func_194028_b((ITextComponent)((Object)new TranslationTextComponent("disconnect.spam", new Object[0])));
                            return null;
                        }
                    };
                    this.field_147367_d.processQueue.add((Runnable)((Object)waitable));
                    try {
                        waitable.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.func_194028_b((ITextComponent)((Object)new TranslationTextComponent("disconnect.spam", new Object[0])));
                }
            }
        }
    }

    public void chat(String s, boolean async) {
        block14: {
            block13: {
                if (s.isEmpty() || this.field_147369_b.func_147096_v() == ChatVisibility.HIDDEN) {
                    return;
                }
                if (async || !s.startsWith("/")) break block13;
                this.func_147361_d(s);
                break block14;
            }
            if (this.field_147369_b.func_147096_v() == ChatVisibility.SYSTEM) break block14;
            CraftPlayer player = this.getPlayer();
            AsyncPlayerChatEvent event = new AsyncPlayerChatEvent(async, (Player)player, s, (Set)new LazyPlayerSet(this.field_147367_d));
            this.craftServer.getPluginManager().callEvent((Event)event);
            if (PlayerChatEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerChatEvent queueEvent = new PlayerChatEvent((Player)player, event.getMessage(), event.getFormat(), event.getRecipients());
                queueEvent.setCancelled(event.isCancelled());
                Waitable waitable = new Waitable(){

                    protected Object evaluate() {
                        Bukkit.getPluginManager().callEvent((Event)queueEvent);
                        if (queueEvent.isCancelled()) {
                            return null;
                        }
                        String message = String.format(queueEvent.getFormat(), queueEvent.getPlayer().getDisplayName(), queueEvent.getMessage());
                        ServerPlayNetHandler.this.field_147367_d.console.sendMessage(message);
                        if (((LazyPlayerSet)queueEvent.getRecipients()).isLazy()) {
                            for (ServerPlayerEntity recipient : ServerPlayNetHandler.this.field_147367_d.func_184103_al().field_72404_b) {
                                recipient.getBukkitEntity().sendMessage(ServerPlayNetHandler.this.field_147369_b.func_110124_au(), message);
                            }
                        } else {
                            for (Player player : queueEvent.getRecipients()) {
                                player.sendMessage(ServerPlayNetHandler.this.field_147369_b.func_110124_au(), message);
                            }
                        }
                        return null;
                    }
                };
                if (async) {
                    this.field_147367_d.processQueue.add((Runnable)waitable);
                } else {
                    waitable.run();
                }
                try {
                    waitable.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Exception processing chat event", e.getCause());
                }
            } else {
                if (event.isCancelled()) {
                    return;
                }
                s = String.format(event.getFormat(), event.getPlayer().getDisplayName(), event.getMessage());
                this.field_147367_d.console.sendMessage(s);
                if (((LazyPlayerSet)event.getRecipients()).isLazy()) {
                    for (ServerPlayerEntity recipient : this.field_147367_d.func_184103_al().field_72404_b) {
                        recipient.getBukkitEntity().sendMessage(this.field_147369_b.func_110124_au(), s);
                    }
                } else {
                    for (Player recipient : event.getRecipients()) {
                        recipient.sendMessage(this.field_147369_b.func_110124_au(), s);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void func_147361_d(String p_147361_1_) {
        MinecraftTimings.playerCommandTimer.startTiming();
        if (SpigotConfig.logCommands) {
            field_147370_c.info(this.field_147369_b.func_195047_I_() + " issued server command: " + p_147361_1_);
        }
        CraftPlayer player = this.getPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)player, p_147361_1_, (Set)new LazyPlayerSet(this.field_147367_d));
        this.craftServer.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            MinecraftTimings.playerCommandTimer.stopTiming();
            return;
        }
        try {
            if (this.craftServer.dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
                return;
            }
        }
        catch (CommandException ex) {
            player.sendMessage(ChatColor.RED + "An internal error occurred while attempting to perform this command");
            Logger.getLogger(ServerPlayNetHandler.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            MinecraftTimings.playerCommandTimer.stopTiming();
        }
    }

    public void func_175087_a(CAnimateHandPacket p_175087_1_) {
        PacketThreadUtil.func_218796_a(p_175087_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_70610_aX()) {
            return;
        }
        this.field_147369_b.func_143004_u();
        float f1 = this.field_147369_b.field_70125_A;
        float f2 = this.field_147369_b.field_70177_z;
        double d0 = this.field_147369_b.func_226277_ct_();
        double d1 = this.field_147369_b.func_226278_cu_() + (double)this.field_147369_b.func_70047_e();
        double d2 = this.field_147369_b.func_226281_cx_();
        Vector3d vec3d = new Vector3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = this.field_147369_b.field_71134_c.func_73081_b() == GameType.CREATIVE ? 5.0 : 4.5;
        Vector3d vec3d1 = vec3d.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        BlockRayTraceResult movingobjectposition = this.field_147369_b.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, this.field_147369_b));
        if (movingobjectposition == null || movingobjectposition.func_216346_c() != RayTraceResult.Type.BLOCK) {
            CraftEventFactory.callPlayerInteractEvent((PlayerEntity)this.field_147369_b, (Action)Action.LEFT_CLICK_AIR, (net.minecraft.item.ItemStack)this.field_147369_b.field_71071_by.func_70448_g(), (Hand)Hand.MAIN_HAND);
        }
        PlayerAnimationEvent event = new PlayerAnimationEvent((Player)this.getPlayer());
        this.craftServer.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.field_147369_b.func_184609_a(p_175087_1_.func_187018_a());
    }

    public void func_147357_a(CEntityActionPacket p_147357_1_) {
        PacketThreadUtil.func_218796_a(p_147357_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_70128_L) {
            return;
        }
        switch (p_147357_1_.func_180764_b()) {
            case PRESS_SHIFT_KEY: 
            case RELEASE_SHIFT_KEY: {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getPlayer(), p_147357_1_.func_180764_b() == CEntityActionPacket.Action.PRESS_SHIFT_KEY);
                this.craftServer.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) break;
                return;
            }
            case START_SPRINTING: 
            case STOP_SPRINTING: {
                PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((Player)this.getPlayer(), p_147357_1_.func_180764_b() == CEntityActionPacket.Action.START_SPRINTING);
                this.craftServer.getPluginManager().callEvent((Event)e2);
                if (!e2.isCancelled()) break;
                return;
            }
        }
        this.field_147369_b.func_143004_u();
        switch (p_147357_1_.func_180764_b()) {
            case PRESS_SHIFT_KEY: {
                this.field_147369_b.func_226284_e_(true);
                break;
            }
            case RELEASE_SHIFT_KEY: {
                this.field_147369_b.func_226284_e_(false);
                break;
            }
            case START_SPRINTING: {
                this.field_147369_b.func_70031_b(true);
                break;
            }
            case STOP_SPRINTING: {
                this.field_147369_b.func_70031_b(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.field_147369_b.func_70608_bn()) break;
                this.field_147369_b.func_225652_a_(false, true);
                this.field_184362_y = this.field_147369_b.func_213303_ch();
                break;
            }
            case START_RIDING_JUMP: {
                if (!(this.field_147369_b.func_184187_bx() instanceof IJumpingMount)) break;
                IJumpingMount ijumpingmount1 = (IJumpingMount)this.field_147369_b.func_184187_bx();
                int i = p_147357_1_.func_149512_e();
                if (!ijumpingmount1.func_184776_b() || i <= 0) break;
                ijumpingmount1.func_184775_b(i);
                break;
            }
            case STOP_RIDING_JUMP: {
                if (!(this.field_147369_b.func_184187_bx() instanceof IJumpingMount)) break;
                IJumpingMount ijumpingmount = (IJumpingMount)this.field_147369_b.func_184187_bx();
                ijumpingmount.func_184777_r_();
                break;
            }
            case OPEN_INVENTORY: {
                if (!(this.field_147369_b.func_184187_bx() instanceof AbstractHorseEntity)) break;
                ((AbstractHorseEntity)this.field_147369_b.func_184187_bx()).func_110199_f(this.field_147369_b);
                break;
            }
            case START_FALL_FLYING: {
                if (this.field_147369_b.func_226566_ei_()) break;
                this.field_147369_b.func_226568_ek_();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    public void func_147340_a(CUseEntityPacket p_147340_1_) {
        PacketThreadUtil.func_218796_a(p_147340_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_70610_aX()) {
            return;
        }
        ServerWorld serverworld = this.field_147369_b.func_71121_q();
        net.minecraft.entity.Entity entity = p_147340_1_.func_149564_a((World)serverworld);
        if (entity == this.field_147369_b && !this.field_147369_b.func_175149_v()) {
            this.disconnect("Cannot interact with self!");
            return;
        }
        this.field_147369_b.func_143004_u();
        this.field_147369_b.func_226284_e_(p_147340_1_.func_241792_e_());
        if (entity != null) {
            double d0 = 36.0;
            if (this.field_147369_b.func_70068_e(entity) < 36.0) {
                Hand hand = p_147340_1_.func_186994_b();
                net.minecraft.item.ItemStack itemstack = hand != null ? this.field_147369_b.func_184586_b(hand).func_77946_l() : net.minecraft.item.ItemStack.field_190927_a;
                Optional<Object> optional = Optional.empty();
                net.minecraft.item.ItemStack itemInHand = this.field_147369_b.func_184586_b(p_147340_1_.func_186994_b() == null ? Hand.MAIN_HAND : p_147340_1_.func_186994_b());
                if (p_147340_1_.func_149565_c() == CUseEntityPacket.Action.INTERACT || p_147340_1_.func_149565_c() == CUseEntityPacket.Action.INTERACT_AT) {
                    PlayerInteractEntityEvent event;
                    Item origItem;
                    boolean triggerLeashUpdate = itemInHand != null && itemInHand.func_77973_b() == Items.field_151058_ca && entity instanceof MobEntity;
                    Item item = origItem = this.field_147369_b.field_71071_by.func_70448_g() == null ? null : this.field_147369_b.field_71071_by.func_70448_g().func_77973_b();
                    if (p_147340_1_.func_149565_c() == CUseEntityPacket.Action.INTERACT) {
                        event = new PlayerInteractEntityEvent((Player)this.getPlayer(), (Entity)entity.getBukkitEntity(), p_147340_1_.func_186994_b() == Hand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND);
                    } else {
                        Vector3d target = p_147340_1_.func_179712_b();
                        event = new PlayerInteractAtEntityEvent((Player)this.getPlayer(), (Entity)entity.getBukkitEntity(), new Vector(target.field_72450_a, target.field_72448_b, target.field_72449_c), p_147340_1_.func_186994_b() == Hand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND);
                    }
                    this.craftServer.getPluginManager().callEvent((Event)event);
                    if (entity instanceof AbstractFishEntity && origItem != null && origItem.getItem() == Items.field_151131_as && (event.isCancelled() || this.field_147369_b.field_71071_by.func_70448_g() == null || this.field_147369_b.field_71071_by.func_70448_g().func_77973_b() != origItem)) {
                        this.func_147359_a((IPacket<?>)new SSpawnMobPacket((LivingEntity)((Object)((AbstractFishEntity)((Object)entity)))));
                        this.field_147369_b.func_71120_a(this.field_147369_b.field_71070_bA);
                    }
                    if (triggerLeashUpdate && (event.isCancelled() || this.field_147369_b.field_71071_by.func_70448_g() == null || this.field_147369_b.field_71071_by.func_70448_g().func_77973_b() != origItem)) {
                        this.func_147359_a((IPacket<?>)new SMountEntityPacket(entity, ((MobEntity)entity).func_110166_bE()));
                    }
                    if (event.isCancelled() || this.field_147369_b.field_71071_by.func_70448_g() == null || this.field_147369_b.field_71071_by.func_70448_g().func_77973_b() != origItem) {
                        this.func_147359_a((IPacket<?>)new SEntityMetadataPacket(entity.func_145782_y(), entity.func_184212_Q(), true));
                    }
                    if (event.isCancelled()) {
                        return;
                    }
                }
                if (p_147340_1_.func_149565_c() == CUseEntityPacket.Action.INTERACT) {
                    optional = Optional.of(this.field_147369_b.func_190775_a(entity, hand));
                    if (!itemInHand.func_190926_b() && itemInHand.func_190916_E() <= -1) {
                        this.field_147369_b.func_71120_a(this.field_147369_b.field_71070_bA);
                    }
                } else if (p_147340_1_.func_149565_c() == CUseEntityPacket.Action.INTERACT_AT) {
                    if (ForgeHooks.onInteractEntityAt((PlayerEntity)this.field_147369_b, (net.minecraft.entity.Entity)entity, (Vector3d)p_147340_1_.func_179712_b(), (Hand)hand) != null) {
                        return;
                    }
                    optional = Optional.of(entity.func_184199_a(this.field_147369_b, p_147340_1_.func_179712_b(), hand));
                    if (!itemInHand.func_190926_b() && itemInHand.func_190916_E() <= -1) {
                        this.field_147369_b.func_71120_a(this.field_147369_b.field_71070_bA);
                    }
                } else if (p_147340_1_.func_149565_c() == CUseEntityPacket.Action.ATTACK) {
                    if (entity instanceof ItemEntity || entity instanceof ExperienceOrbEntity || entity instanceof AbstractArrowEntity || entity == this.field_147369_b && !this.field_147369_b.func_175149_v()) {
                        this.func_194028_b((ITextComponent)((Object)new TranslationTextComponent("multiplayer.disconnect.invalid_entity_attacked")));
                        field_147370_c.warn(i18n.get((String)"serverplaynethandler.12", (Object[])new Object[]{this.field_147369_b.func_195047_I_()}));
                        return;
                    }
                    this.field_147369_b.func_71059_n(entity);
                    if (!itemInHand.func_190926_b() && itemInHand.func_190916_E() <= -1) {
                        this.field_147369_b.func_71120_a(this.field_147369_b.field_71070_bA);
                    }
                }
                if (optional.isPresent() && ((ActionResultType)optional.get()).func_226246_a_()) {
                    CriteriaTriggers.field_241276_P_.func_241476_a_(this.field_147369_b, itemstack, entity);
                    if (((ActionResultType)optional.get()).func_226247_b_()) {
                        this.field_147369_b.func_226292_a_(hand, true);
                    }
                }
            }
        }
    }

    public void func_147342_a(CClientStatusPacket p_147342_1_) {
        PacketThreadUtil.func_218796_a(p_147342_1_, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        CClientStatusPacket.State cclientstatuspacket$state = p_147342_1_.func_149435_c();
        switch (cclientstatuspacket$state) {
            case PERFORM_RESPAWN: {
                if (this.field_147369_b.field_71136_j) {
                    this.field_147369_b.field_71136_j = false;
                    this.field_147369_b = this.field_147367_d.func_184103_al().func_232644_a_(this.field_147369_b, true);
                    CriteriaTriggers.field_193134_u.func_233551_a_(this.field_147369_b, World.field_234920_i_, World.field_234918_g_);
                    break;
                }
                if (this.field_147369_b.func_110143_aJ() > 0.0f) {
                    return;
                }
                this.field_147369_b = this.field_147367_d.func_184103_al().func_232644_a_(this.field_147369_b, false);
                if (!this.field_147367_d.func_71199_h()) break;
                this.field_147369_b.func_71033_a(GameType.SPECTATOR);
                this.field_147369_b.func_71121_q().func_82736_K().func_223585_a(GameRules.field_223613_p).func_223570_a(false, this.field_147367_d);
                break;
            }
            case REQUEST_STATS: {
                this.field_147369_b.func_147099_x().func_150876_a(this.field_147369_b);
            }
        }
    }

    public void func_147356_a(CCloseWindowPacket p_147356_1_) {
        PacketThreadUtil.func_218796_a(p_147356_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_70610_aX()) {
            return;
        }
        if (this.field_147369_b.field_71070_bA.getBukkitView() != null) {
            CraftEventFactory.handleInventoryCloseEvent((PlayerEntity)this.field_147369_b);
        }
        this.field_147369_b.func_71128_l();
    }

    public void func_147351_a(CClickWindowPacket p_147351_1_) {
        PacketThreadUtil.func_218796_a(p_147351_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_70610_aX()) {
            return;
        }
        this.field_147369_b.func_143004_u();
        if (this.field_147369_b.field_71070_bA.field_75152_c == p_147351_1_.func_149548_c() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && this.field_147369_b.field_71070_bA.func_75145_c(this.field_147369_b)) {
            boolean cancelled = this.field_147369_b.func_175149_v();
            if (p_147351_1_.func_149544_d() < -1 && p_147351_1_.func_149544_d() != -999) {
                return;
            }
            InventoryView inventory = this.field_147369_b.field_71070_bA.getBukkitView();
            if (inventory == null) {
                inventory = new CraftInventoryView((HumanEntity)this.field_147369_b.getBukkitEntity(), MinecraftServer.getServer().server.createInventory((InventoryHolder)this.field_147369_b.getBukkitEntity(), InventoryType.CHEST), this.field_147369_b.field_71070_bA);
                this.field_147369_b.field_71070_bA.setBukkitView(inventory);
            }
            InventoryType.SlotType type = inventory.getSlotType(p_147351_1_.func_149544_d());
            org.bukkit.event.inventory.ClickType click = org.bukkit.event.inventory.ClickType.UNKNOWN;
            InventoryAction action = InventoryAction.UNKNOWN;
            net.minecraft.item.ItemStack itemstack = net.minecraft.item.ItemStack.field_190927_a;
            switch (p_147351_1_.func_186993_f()) {
                case PICKUP: {
                    if (p_147351_1_.func_149543_e() == 0) {
                        click = org.bukkit.event.inventory.ClickType.LEFT;
                    } else if (p_147351_1_.func_149543_e() == 1) {
                        click = org.bukkit.event.inventory.ClickType.RIGHT;
                    }
                    if (p_147351_1_.func_149543_e() != 0 && p_147351_1_.func_149543_e() != 1) break;
                    action = InventoryAction.NOTHING;
                    if (p_147351_1_.func_149544_d() == -999) {
                        if (this.field_147369_b.field_71071_by.func_70445_o().func_190926_b()) break;
                        action = p_147351_1_.func_149543_e() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                        break;
                    }
                    if (p_147351_1_.func_149544_d() < 0) {
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    Slot slot = this.field_147369_b.field_71070_bA.func_75139_a(p_147351_1_.func_149544_d());
                    if (slot == null) break;
                    net.minecraft.item.ItemStack clickedItem = slot.func_75211_c();
                    net.minecraft.item.ItemStack cursor = this.field_147369_b.field_71071_by.func_70445_o();
                    if (clickedItem.func_190926_b()) {
                        if (cursor.func_190926_b()) break;
                        action = p_147351_1_.func_149543_e() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                        break;
                    }
                    if (!slot.func_82869_a(this.field_147369_b)) break;
                    if (cursor.func_190926_b()) {
                        action = p_147351_1_.func_149543_e() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                        break;
                    }
                    if (slot.func_75214_a(cursor)) {
                        if (clickedItem.func_77969_a(cursor) && net.minecraft.item.ItemStack.func_77970_a(clickedItem, cursor)) {
                            int toPlace = p_147351_1_.func_149543_e() == 0 ? cursor.func_190916_E() : 1;
                            toPlace = Math.min(toPlace, clickedItem.func_77976_d() - clickedItem.func_190916_E());
                            if ((toPlace = Math.min(toPlace, slot.field_75224_c.func_70297_j_() - clickedItem.func_190916_E())) == 1) {
                                action = InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (toPlace == cursor.func_190916_E()) {
                                action = InventoryAction.PLACE_ALL;
                                break;
                            }
                            if (toPlace < 0) {
                                action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                break;
                            }
                            if (toPlace == 0) break;
                            action = InventoryAction.PLACE_SOME;
                            break;
                        }
                        if (cursor.func_190916_E() > slot.func_75219_a()) break;
                        action = InventoryAction.SWAP_WITH_CURSOR;
                        break;
                    }
                    if (cursor.func_77973_b() != clickedItem.func_77973_b() || !net.minecraft.item.ItemStack.func_77970_a(cursor, clickedItem) || clickedItem.func_190916_E() < 0 || clickedItem.func_190916_E() + cursor.func_190916_E() > cursor.func_77976_d()) break;
                    action = InventoryAction.PICKUP_ALL;
                    break;
                }
                case QUICK_MOVE: {
                    if (p_147351_1_.func_149543_e() == 0) {
                        click = org.bukkit.event.inventory.ClickType.SHIFT_LEFT;
                    } else if (p_147351_1_.func_149543_e() == 1) {
                        click = org.bukkit.event.inventory.ClickType.SHIFT_RIGHT;
                    }
                    if (p_147351_1_.func_149543_e() != 0 && p_147351_1_.func_149543_e() != 1) break;
                    if (p_147351_1_.func_149544_d() < 0) {
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    Slot slot = this.field_147369_b.field_71070_bA.func_75139_a(p_147351_1_.func_149544_d());
                    if (slot != null && slot.func_82869_a(this.field_147369_b) && slot.func_75216_d()) {
                        action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                        break;
                    }
                    action = InventoryAction.NOTHING;
                    break;
                }
                case SWAP: {
                    if ((p_147351_1_.func_149543_e() < 0 || p_147351_1_.func_149543_e() >= 9) && p_147351_1_.func_149543_e() != 40) break;
                    click = org.bukkit.event.inventory.ClickType.NUMBER_KEY;
                    Slot clickedSlot = this.field_147369_b.field_71070_bA.func_75139_a(p_147351_1_.func_149544_d());
                    if (clickedSlot.func_82869_a(this.field_147369_b)) {
                        boolean canCleanSwap;
                        net.minecraft.item.ItemStack hotbar = this.field_147369_b.field_71071_by.func_70301_a(p_147351_1_.func_149543_e());
                        boolean bl = canCleanSwap = hotbar.func_190926_b() || clickedSlot.field_75224_c == this.field_147369_b.field_71071_by && clickedSlot.func_75214_a(hotbar);
                        if (clickedSlot.func_75216_d()) {
                            if (canCleanSwap) {
                                action = InventoryAction.HOTBAR_SWAP;
                                break;
                            }
                            action = InventoryAction.HOTBAR_MOVE_AND_READD;
                            break;
                        }
                        if (!clickedSlot.func_75216_d() && !hotbar.func_190926_b() && clickedSlot.func_75214_a(hotbar)) {
                            action = InventoryAction.HOTBAR_SWAP;
                            break;
                        }
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    action = InventoryAction.NOTHING;
                    break;
                }
                case CLONE: {
                    Slot slot;
                    if (p_147351_1_.func_149543_e() == 2) {
                        click = org.bukkit.event.inventory.ClickType.MIDDLE;
                        if (p_147351_1_.func_149544_d() < 0) {
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        slot = this.field_147369_b.field_71070_bA.func_75139_a(p_147351_1_.func_149544_d());
                        if (slot != null && slot.func_75216_d() && this.field_147369_b.field_71075_bZ.field_75098_d && this.field_147369_b.field_71071_by.func_70445_o().func_190926_b()) {
                            action = InventoryAction.CLONE_STACK;
                            break;
                        }
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    click = org.bukkit.event.inventory.ClickType.UNKNOWN;
                    action = InventoryAction.UNKNOWN;
                    break;
                }
                case THROW: {
                    Slot slot;
                    if (p_147351_1_.func_149544_d() >= 0) {
                        if (p_147351_1_.func_149543_e() == 0) {
                            click = org.bukkit.event.inventory.ClickType.DROP;
                            slot = this.field_147369_b.field_71070_bA.func_75139_a(p_147351_1_.func_149544_d());
                            if (slot != null && slot.func_75216_d() && slot.func_82869_a(this.field_147369_b) && !slot.func_75211_c().func_190926_b() && slot.func_75211_c().func_77973_b() != Item.func_150898_a(Blocks.field_150350_a)) {
                                action = InventoryAction.DROP_ONE_SLOT;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        if (p_147351_1_.func_149543_e() != 1) break;
                        click = org.bukkit.event.inventory.ClickType.CONTROL_DROP;
                        slot = this.field_147369_b.field_71070_bA.func_75139_a(p_147351_1_.func_149544_d());
                        if (slot != null && slot.func_75216_d() && slot.func_82869_a(this.field_147369_b) && !slot.func_75211_c().func_190926_b() && slot.func_75211_c().func_77973_b() != Item.func_150898_a(Blocks.field_150350_a)) {
                            action = InventoryAction.DROP_ALL_SLOT;
                            break;
                        }
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    click = org.bukkit.event.inventory.ClickType.LEFT;
                    if (p_147351_1_.func_149543_e() == 1) {
                        click = org.bukkit.event.inventory.ClickType.RIGHT;
                    }
                    action = InventoryAction.NOTHING;
                    break;
                }
                case QUICK_CRAFT: {
                    itemstack = this.field_147369_b.field_71070_bA.func_184996_a(p_147351_1_.func_149544_d(), p_147351_1_.func_149543_e(), p_147351_1_.func_186993_f(), this.field_147369_b);
                    break;
                }
                case PICKUP_ALL: {
                    click = org.bukkit.event.inventory.ClickType.DOUBLE_CLICK;
                    action = InventoryAction.NOTHING;
                    if (p_147351_1_.func_149544_d() < 0 || this.field_147369_b.field_71071_by.func_70445_o().func_190926_b()) break;
                    net.minecraft.item.ItemStack cursor = this.field_147369_b.field_71071_by.func_70445_o();
                    action = InventoryAction.NOTHING;
                    if (!inventory.getTopInventory().contains(CraftMagicNumbers.getMaterial((Item)cursor.func_77973_b())) && !inventory.getBottomInventory().contains(CraftMagicNumbers.getMaterial((Item)cursor.func_77973_b()))) break;
                    action = InventoryAction.COLLECT_TO_CURSOR;
                    break;
                }
            }
            if (p_147351_1_.func_186993_f() != ClickType.QUICK_CRAFT) {
                ItemStack result;
                Recipe recipe;
                InventoryClickEvent event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, p_147351_1_.func_149544_d(), click, action, p_147351_1_.func_149543_e()) : new InventoryClickEvent(inventory, type, p_147351_1_.func_149544_d(), click, action);
                Inventory top = inventory.getTopInventory();
                if (p_147351_1_.func_149544_d() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                    event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, p_147351_1_.func_149544_d(), click, action, p_147351_1_.func_149543_e()) : new CraftItemEvent(recipe, inventory, type, p_147351_1_.func_149544_d(), click, action);
                }
                if (p_147351_1_.func_149544_d() == 2 && top instanceof SmithingInventory && (result = ((SmithingInventory)top).getResult()) != null) {
                    event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, p_147351_1_.func_149544_d(), click, action, p_147351_1_.func_149543_e()) : new SmithItemEvent(inventory, type, p_147351_1_.func_149544_d(), click, action);
                }
                event.setCancelled(cancelled);
                Container oldContainer = this.field_147369_b.field_71070_bA;
                this.craftServer.getPluginManager().callEvent((Event)event);
                if (this.field_147369_b.field_71070_bA != oldContainer) {
                    return;
                }
                switch (event.getResult()) {
                    case ALLOW: 
                    case DEFAULT: {
                        itemstack = this.field_147369_b.field_71070_bA.func_184996_a(p_147351_1_.func_149544_d(), p_147351_1_.func_149543_e(), p_147351_1_.func_186993_f(), this.field_147369_b);
                        break;
                    }
                    case DENY: {
                        switch (action) {
                            case PICKUP_ALL: 
                            case MOVE_TO_OTHER_INVENTORY: 
                            case HOTBAR_MOVE_AND_READD: 
                            case HOTBAR_SWAP: 
                            case COLLECT_TO_CURSOR: 
                            case UNKNOWN: {
                                this.field_147369_b.func_71120_a(this.field_147369_b.field_71070_bA);
                                break;
                            }
                            case PICKUP_SOME: 
                            case PICKUP_HALF: 
                            case PICKUP_ONE: 
                            case PLACE_ALL: 
                            case PLACE_SOME: 
                            case PLACE_ONE: 
                            case SWAP_WITH_CURSOR: {
                                this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(-1, -1, this.field_147369_b.field_71071_by.func_70445_o()));
                                this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(this.field_147369_b.field_71070_bA.field_75152_c, p_147351_1_.func_149544_d(), this.field_147369_b.field_71070_bA.func_75139_a(p_147351_1_.func_149544_d()).func_75211_c()));
                                break;
                            }
                            case DROP_ALL_SLOT: 
                            case DROP_ONE_SLOT: {
                                this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(this.field_147369_b.field_71070_bA.field_75152_c, p_147351_1_.func_149544_d(), this.field_147369_b.field_71070_bA.func_75139_a(p_147351_1_.func_149544_d()).func_75211_c()));
                                break;
                            }
                            case DROP_ALL_CURSOR: 
                            case DROP_ONE_CURSOR: 
                            case CLONE_STACK: {
                                this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(-1, -1, this.field_147369_b.field_71071_by.func_70445_o()));
                                break;
                            }
                        }
                        return;
                    }
                }
                if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                    this.field_147369_b.func_71120_a(this.field_147369_b.field_71070_bA);
                }
            }
            if (net.minecraft.item.ItemStack.func_77989_b(p_147351_1_.func_149546_g(), itemstack)) {
                this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SConfirmTransactionPacket(p_147351_1_.func_149548_c(), p_147351_1_.func_149547_f(), true));
                this.field_147369_b.field_71137_h = true;
                this.field_147369_b.field_71070_bA.func_75142_b();
                this.field_147369_b.func_71113_k();
                this.field_147369_b.field_71137_h = false;
            } else {
                this.field_147372_n.put(this.field_147369_b.field_71070_bA.field_75152_c, p_147351_1_.func_149547_f());
                this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SConfirmTransactionPacket(p_147351_1_.func_149548_c(), p_147351_1_.func_149547_f(), false));
                this.field_147369_b.field_71070_bA.func_75128_a(this.field_147369_b, false);
                NonNullList<net.minecraft.item.ItemStack> nonnulllist1 = NonNullList.func_191196_a();
                for (int j = 0; j < this.field_147369_b.field_71070_bA.field_75151_b.size(); ++j) {
                    net.minecraft.item.ItemStack itemstack2 = this.field_147369_b.field_71070_bA.field_75151_b.get(j).func_75211_c();
                    nonnulllist1.add(itemstack2.func_190926_b() ? net.minecraft.item.ItemStack.field_190927_a : itemstack2);
                }
                this.field_147369_b.func_71110_a(this.field_147369_b.field_71070_bA, nonnulllist1);
            }
        }
    }

    public void func_194308_a(CPlaceRecipePacket p_194308_1_) {
        PacketThreadUtil.func_218796_a(p_194308_1_, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (!this.field_147369_b.func_175149_v() && this.field_147369_b.field_71070_bA.field_75152_c == p_194308_1_.func_194318_a() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && this.field_147369_b.field_71070_bA instanceof RecipeBookContainer) {
            this.field_147367_d.func_199529_aN().func_215367_a(p_194308_1_.func_199618_b()).ifPresent(p_241165_2_ -> ((RecipeBookContainer)this.field_147369_b.field_71070_bA).func_217056_a(p_194308_1_.func_194319_c(), (IRecipe<?>)p_241165_2_, this.field_147369_b));
        }
    }

    public void func_147338_a(CEnchantItemPacket p_147338_1_) {
        PacketThreadUtil.func_218796_a(p_147338_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_70610_aX()) {
            return;
        }
        this.field_147369_b.func_143004_u();
        if (this.field_147369_b.field_71070_bA.field_75152_c == p_147338_1_.func_149539_c() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && !this.field_147369_b.func_175149_v()) {
            this.field_147369_b.field_71070_bA.func_75140_a(this.field_147369_b, p_147338_1_.func_149537_d());
            this.field_147369_b.field_71070_bA.func_75142_b();
        }
    }

    public void func_147344_a(CCreativeInventoryActionPacket p_147344_1_) {
        PacketThreadUtil.func_218796_a(p_147344_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71134_c.func_73083_d()) {
            boolean flag2;
            BlockPos blockpos;
            TileEntity tileentity;
            boolean flag = p_147344_1_.func_149627_c() < 0;
            net.minecraft.item.ItemStack itemstack = p_147344_1_.func_149625_d();
            CompoundNBT compoundnbt = itemstack.func_179543_a("BlockEntityTag");
            if (!itemstack.func_190926_b() && compoundnbt != null && compoundnbt.func_74764_b("x") && compoundnbt.func_74764_b("y") && compoundnbt.func_74764_b("z") && this.field_147369_b.getBukkitEntity().hasPermission("minecraft.nbt.copy") && (tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos = new BlockPos(compoundnbt.func_74762_e("x"), compoundnbt.func_74762_e("y"), compoundnbt.func_74762_e("z")))) != null) {
                CompoundNBT compoundnbt1 = tileentity.func_189515_b(new CompoundNBT());
                compoundnbt1.func_82580_o("x");
                compoundnbt1.func_82580_o("y");
                compoundnbt1.func_82580_o("z");
                itemstack.func_77983_a("BlockEntityTag", compoundnbt1);
            }
            boolean flag1 = p_147344_1_.func_149627_c() >= 1 && p_147344_1_.func_149627_c() <= 45;
            boolean bl = flag2 = itemstack.func_190926_b() || itemstack.func_77952_i() >= 0 && itemstack.func_190916_E() <= 64 && !itemstack.func_190926_b();
            if (flag || flag1 && !net.minecraft.item.ItemStack.func_77989_b(this.field_147369_b.field_71069_bz.func_75139_a(p_147344_1_.func_149627_c()).func_75211_c(), p_147344_1_.func_149625_d())) {
                CraftInventoryView inventory = this.field_147369_b.field_71069_bz.getBukkitView();
                ItemStack item = CraftItemStack.asBukkitCopy((net.minecraft.item.ItemStack)p_147344_1_.func_149625_d());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (p_147344_1_.func_149627_c() < 36) {
                    type = p_147344_1_.func_149627_c() >= 5 && p_147344_1_.func_149627_c() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : p_147344_1_.func_149627_c(), item);
                this.craftServer.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy((ItemStack)event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (p_147344_1_.func_149627_c() >= 0) {
                            this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(this.field_147369_b.field_71069_bz.field_75152_c, p_147344_1_.func_149627_c(), this.field_147369_b.field_71069_bz.func_75139_a(p_147344_1_.func_149627_c()).func_75211_c()));
                            this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(-1, -1, net.minecraft.item.ItemStack.field_190927_a));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                if (itemstack.func_190926_b()) {
                    this.field_147369_b.field_71069_bz.func_75141_a(p_147344_1_.func_149627_c(), net.minecraft.item.ItemStack.field_190927_a);
                } else {
                    this.field_147369_b.field_71069_bz.func_75141_a(p_147344_1_.func_149627_c(), itemstack);
                }
                this.field_147369_b.field_71069_bz.func_75128_a(this.field_147369_b, true);
                this.field_147369_b.field_71069_bz.func_75142_b();
            } else if (flag && flag2 && this.field_147375_m < 200) {
                this.field_147375_m += 20;
                this.field_147369_b.func_71019_a(itemstack, true);
            }
        }
    }

    public void func_147339_a(CConfirmTransactionPacket p_147339_1_) {
        PacketThreadUtil.func_218796_a(p_147339_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_70610_aX()) {
            return;
        }
        int i = this.field_147369_b.field_71070_bA.field_75152_c;
        if (i == p_147339_1_.func_149532_c() && this.field_147372_n.getOrDefault(i, (short)(p_147339_1_.func_149533_d() + 1)) == p_147339_1_.func_149533_d() && !this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && !this.field_147369_b.func_175149_v()) {
            this.field_147369_b.field_71070_bA.func_75128_a(this.field_147369_b, true);
        }
    }

    public void func_147343_a(CUpdateSignPacket p_147343_1_) {
        PacketThreadUtil.func_218796_a(p_147343_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_70610_aX()) {
            return;
        }
        this.field_147369_b.func_143004_u();
        ServerWorld serverworld = this.field_147369_b.func_71121_q();
        BlockPos blockpos = p_147343_1_.func_179722_a();
        if (serverworld.func_175667_e(blockpos)) {
            BlockState blockstate = serverworld.func_180495_p(blockpos);
            TileEntity tileentity = serverworld.func_175625_s(blockpos);
            if (!(tileentity instanceof SignTileEntity)) {
                return;
            }
            SignTileEntity signtileentity = (SignTileEntity)tileentity;
            if (!signtileentity.func_145914_a() || signtileentity.signEditor == null || !signtileentity.signEditor.equals(this.field_147369_b.func_110124_au())) {
                field_147370_c.warn(i18n.get((String)"serverplaynethandler.13", (Object[])new Object[]{this.field_147369_b.func_195047_I_()}));
                this.func_147359_a((IPacket<?>)tileentity.func_189518_D_());
                return;
            }
            String[] astring = p_147343_1_.func_187017_b();
            Player player = this.craftServer.getPlayer(this.field_147369_b);
            int x = p_147343_1_.func_179722_a().func_177958_n();
            int y = p_147343_1_.func_179722_a().func_177956_o();
            int z = p_147343_1_.func_179722_a().func_177952_p();
            String[] lines = new String[4];
            for (int i = 0; i < astring.length; ++i) {
                lines[i] = SharedConstants.filterAllowedChatCharacters(astring[i]);
            }
            SignChangeEvent event = new SignChangeEvent((Block)((CraftBlock)player.getWorld().getBlockAt(x, y, z)), this.craftServer.getPlayer(this.field_147369_b), lines);
            this.craftServer.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                System.arraycopy(CraftSign.sanitizeLines((String[])event.getLines()), 0, signtileentity.field_145915_a, 0, 4);
                signtileentity.field_145916_j = false;
            }
            signtileentity.func_70296_d();
            serverworld.func_184138_a(blockpos, blockstate, blockstate, 3);
        }
    }

    public void func_147353_a(CKeepAlivePacket p_147353_1_) {
        PacketThreadUtil.func_218796_a(p_147353_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_194403_g && p_147353_1_.func_149460_c() == this.field_194404_h) {
            int i = (int)(Util.func_211177_b() - this.field_194402_f);
            this.field_147369_b.field_71138_i = (this.field_147369_b.field_71138_i * 3 + i) / 4;
            this.field_194403_g = false;
        } else if (!this.func_217264_d()) {
            this.func_194028_b((ITextComponent)((Object)new TranslationTextComponent("disconnect.timeout")));
        }
    }

    public void func_147348_a(CPlayerAbilitiesPacket p_147348_1_) {
        PacketThreadUtil.func_218796_a(p_147348_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71075_bZ.field_75101_c && this.field_147369_b.field_71075_bZ.field_75100_b != p_147348_1_.func_149488_d()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent(this.craftServer.getPlayer(this.field_147369_b), p_147348_1_.func_149488_d());
            this.craftServer.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.field_147369_b.field_71075_bZ.field_75100_b = p_147348_1_.func_149488_d();
            } else {
                this.field_147369_b.func_71016_p();
            }
        }
    }

    public void func_147352_a(CClientSettingsPacket p_147352_1_) {
        PacketThreadUtil.func_218796_a(p_147352_1_, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_147100_a(p_147352_1_);
    }

    public void func_217263_a(CSetDifficultyPacket p_217263_1_) {
        PacketThreadUtil.func_218796_a(p_217263_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_211513_k(2) || this.func_217264_d()) {
            this.field_147367_d.func_147139_a(p_217263_1_.func_218773_b(), false);
        }
    }

    public void func_217261_a(CLockDifficultyPacket p_217261_1_) {
        PacketThreadUtil.func_218796_a(p_217261_1_, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_211513_k(2) || this.func_217264_d()) {
            this.field_147367_d.func_213209_d(p_217261_1_.func_218776_b());
        }
    }

    public void func_147349_a(CCustomPayloadPacket p_147349_1_) {
        PacketThreadUtil.func_218796_a(p_147349_1_, this, this.field_147369_b.func_71121_q());
        NetworkHooks.onCustomPayload((ICustomPacket)p_147349_1_, (NetworkManager)this.field_147371_a);
        if (p_147349_1_.field_149562_a.equals(CUSTOM_REGISTER)) {
            try {
                String channels = p_147349_1_.field_149561_c.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    if (net.minecraft.util.StringUtils.func_151246_b((String)channel)) continue;
                    this.getPlayer().addChannel(channel);
                }
            }
            catch (Exception ex) {
                field_147370_c.error(i18n.get((String)"serverplaynethandler.14", (Object[])new Object[]{ex}));
                this.disconnect("Invalid payload REGISTER!");
            }
        } else if (p_147349_1_.field_149562_a.equals(CUSTOM_UNREGISTER)) {
            try {
                String channels = p_147349_1_.field_149561_c.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    if (net.minecraft.util.StringUtils.func_151246_b((String)channel)) continue;
                    this.getPlayer().removeChannel(channel);
                }
            }
            catch (Exception ex) {
                field_147370_c.error(i18n.get((String)"serverplaynethandler.15", (Object[])new Object[]{ex}));
                this.disconnect("Invalid payload UNREGISTER!");
            }
        } else {
            try {
                byte[] data = new byte[p_147349_1_.field_149561_c.readableBytes()];
                p_147349_1_.field_149561_c.readBytes(data);
                this.craftServer.getMessenger().dispatchIncomingMessage((Player)this.field_147369_b.getBukkitEntity(), p_147349_1_.field_149562_a.toString(), data);
            }
            catch (Exception ex) {
                field_147370_c.error(i18n.get((String)"serverplaynethandler.16", (Object[])new Object[]{ex}));
                this.disconnect("Invalid custom payload!");
            }
        }
    }

    public boolean isDisconnected() {
        return !this.field_147369_b.joining && !this.field_147371_a.func_150724_d() || this.processedDisconnect;
    }

    private /* synthetic */ void func_210161_a(ITextComponent textComponent, Future p_210161_2_) throws Exception {
        this.field_147371_a.func_150718_a(textComponent);
    }
}

