/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mohistmc.util.i18n.i18n;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VanillaPack
implements IResourcePack {
    public static Path field_199754_a;
    private static final Logger field_195784_b;
    public static Class<?> field_211688_b;
    private static final Map<ResourcePackType, FileSystem> field_217810_e;
    public final Set<String> field_195783_a;

    public VanillaPack(String ... p_i47912_1_) {
        this.field_195783_a = ImmutableSet.copyOf((Object[])p_i47912_1_);
    }

    @Override
    public InputStream func_195763_b(String p_195763_1_) throws IOException {
        if (!p_195763_1_.contains("/") && !p_195763_1_.contains("\\")) {
            Path path;
            if (field_199754_a != null && Files.exists(path = field_199754_a.resolve(p_195763_1_), new LinkOption[0])) {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            return this.func_200010_a(p_195763_1_);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    @Override
    public InputStream func_195761_a(ResourcePackType p_195761_1_, ResourceLocation p_195761_2_) throws IOException {
        InputStream inputstream = this.func_195782_c(p_195761_1_, p_195761_2_);
        if (inputstream != null) {
            return inputstream;
        }
        throw new FileNotFoundException(p_195761_2_.func_110623_a());
    }

    @Override
    public Collection<ResourceLocation> func_225637_a_(ResourcePackType p_225637_1_, String p_225637_2_, String p_225637_3_, int p_225637_4_, Predicate<String> p_225637_5_) {
        HashSet set = Sets.newHashSet();
        if (field_199754_a != null) {
            try {
                VanillaPack.func_229867_a_(set, p_225637_4_, p_225637_2_, field_199754_a.resolve(p_225637_1_.func_198956_a()), p_225637_3_, p_225637_5_);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (p_225637_1_ == ResourcePackType.CLIENT_RESOURCES) {
                Enumeration<URL> enumeration = null;
                try {
                    enumeration = field_211688_b.getClassLoader().getResources(p_225637_1_.func_198956_a() + "/");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (enumeration != null && enumeration.hasMoreElements()) {
                    try {
                        URI uri = enumeration.nextElement().toURI();
                        if (!"file".equals(uri.getScheme())) continue;
                        VanillaPack.func_229867_a_(set, p_225637_4_, p_225637_2_, Paths.get(uri), p_225637_3_, p_225637_5_);
                    }
                    catch (IOException | URISyntaxException uri) {}
                }
            }
        }
        try {
            URL url1 = VanillaPack.class.getResource("/" + p_225637_1_.func_198956_a() + "/.mcassetsroot");
            if (url1 == null) {
                field_195784_b.error(i18n.get((String)"vanillapack.2"));
                return set;
            }
            URI uri1 = url1.toURI();
            if ("file".equals(uri1.getScheme())) {
                URL url = new URL(url1.toString().substring(0, url1.toString().length() - ".mcassetsroot".length()));
                Path path = Paths.get(url.toURI());
                VanillaPack.func_229867_a_(set, p_225637_4_, p_225637_2_, path, p_225637_3_, p_225637_5_);
            } else if ("jar".equals(uri1.getScheme())) {
                Path path1 = field_217810_e.get(p_225637_1_).getPath("/" + p_225637_1_.func_198956_a(), new String[0]);
                VanillaPack.func_229867_a_(set, p_225637_4_, "minecraft", path1, p_225637_3_, p_225637_5_);
            } else {
                field_195784_b.error(i18n.get((String)"vanillapack.3", (Object[])new Object[]{uri1}));
            }
        }
        catch (FileNotFoundException | NoSuchFileException url1) {
        }
        catch (IOException | URISyntaxException urisyntaxexception) {
            field_195784_b.error(i18n.get((String)"vanillapack.4", (Object[])new Object[]{urisyntaxexception}));
        }
        return set;
    }

    private static void func_229867_a_(Collection<ResourceLocation> p_229867_0_, int p_229867_1_, String p_229867_2_, Path p_229867_3_, String p_229867_4_, Predicate<String> p_229867_5_) throws IOException {
        Path path = p_229867_3_.resolve(p_229867_2_);
        try (Stream<Path> stream = Files.walk(path.resolve(p_229867_4_), p_229867_1_, new FileVisitOption[0]);){
            stream.filter(p_229868_1_ -> !p_229868_1_.endsWith(".mcmeta") && Files.isRegularFile(p_229868_1_, new LinkOption[0]) && p_229867_5_.test(p_229868_1_.getFileName().toString())).map(p_229866_2_ -> new ResourceLocation(p_229867_2_, path.relativize((Path)p_229866_2_).toString().replaceAll("\\\\", "/"))).forEach(p_229867_0_::add);
        }
    }

    @Nullable
    protected InputStream func_195782_c(ResourcePackType p_195782_1_, ResourceLocation p_195782_2_) {
        Path path;
        String s = VanillaPack.func_223458_d(p_195782_1_, p_195782_2_);
        if (field_199754_a != null && Files.exists(path = field_199754_a.resolve(p_195782_1_.func_198956_a() + "/" + p_195782_2_.func_110624_b() + "/" + p_195782_2_.func_110623_a()), new LinkOption[0])) {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            URL url = VanillaPack.class.getResource(s);
            return VanillaPack.func_223459_a(s, url) ? this.getExtraInputStream(p_195782_1_, s) : null;
        }
        catch (IOException ioexception) {
            return VanillaPack.class.getResourceAsStream(s);
        }
    }

    private static String func_223458_d(ResourcePackType p_223458_0_, ResourceLocation p_223458_1_) {
        return "/" + p_223458_0_.func_198956_a() + "/" + p_223458_1_.func_110624_b() + "/" + p_223458_1_.func_110623_a();
    }

    private static boolean func_223459_a(String p_223459_0_, @Nullable URL p_223459_1_) throws IOException {
        return p_223459_1_ != null && (p_223459_1_.getProtocol().equals("jar") || FolderPack.func_195777_a((File)new File(p_223459_1_.getFile()), (String)p_223459_0_));
    }

    @Nullable
    protected InputStream func_200010_a(String p_200010_1_) {
        return this.getExtraInputStream(ResourcePackType.SERVER_DATA, "/" + p_200010_1_);
    }

    @Override
    public boolean func_195764_b(ResourcePackType p_195764_1_, ResourceLocation p_195764_2_) {
        Path path;
        String s = VanillaPack.func_223458_d(p_195764_1_, p_195764_2_);
        if (field_199754_a != null && Files.exists(path = field_199754_a.resolve(p_195764_1_.func_198956_a() + "/" + p_195764_2_.func_110624_b() + "/" + p_195764_2_.func_110623_a()), new LinkOption[0])) {
            return true;
        }
        try {
            URL url = VanillaPack.class.getResource(s);
            return VanillaPack.func_223459_a(s, url);
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    @Override
    public Set<String> func_195759_a(ResourcePackType p_195759_1_) {
        return this.field_195783_a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> p_195760_1_) throws IOException {
        try (InputStream inputstream = this.func_195763_b("pack.mcmeta");){
            T t = ResourcePack.func_195770_a(p_195760_1_, inputstream);
            return t;
        }
        catch (FileNotFoundException | RuntimeException runtimeexception) {
            return null;
        }
    }

    @Override
    public String func_195762_a() {
        return "Default";
    }

    @Override
    public void close() {
    }

    private InputStream getExtraInputStream(ResourcePackType type, String resource) {
        try {
            FileSystem fs = field_217810_e.get(type);
            if (fs != null) {
                return Files.newInputStream(fs.getPath(resource, new String[0]), new OpenOption[0]);
            }
            return VanillaPack.class.getResourceAsStream(resource);
        }
        catch (IOException e) {
            return VanillaPack.class.getResourceAsStream(resource);
        }
    }

    static {
        field_195784_b = LogManager.getLogger();
        field_217810_e = Util.func_200696_a(Maps.newHashMap(), p_217809_0_ -> {
            Class<VanillaPack> clazz = VanillaPack.class;
            synchronized (VanillaPack.class) {
                for (ResourcePackType resourcepacktype : ResourcePackType.values()) {
                    URL url = VanillaPack.class.getResource("/" + resourcepacktype.func_198956_a() + "/.mcassetsroot");
                    try {
                        FileSystem filesystem;
                        URI uri = url.toURI();
                        if (!"jar".equals(uri.getScheme())) continue;
                        try {
                            filesystem = FileSystems.getFileSystem(uri);
                        }
                        catch (FileSystemNotFoundException filesystemnotfoundexception) {
                            filesystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                        }
                        p_217809_0_.put(resourcepacktype, filesystem);
                    }
                    catch (IOException | URISyntaxException urisyntaxexception) {
                        field_195784_b.error(i18n.get((String)"vanillapack.1", (Object[])new Object[]{urisyntaxexception}));
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        });
    }
}

