/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsReportListener;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mohistmc.Metrics;
import com.mohistmc.configuration.MohistConfig;
import com.mohistmc.util.i18n.i18n;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.BooleanSupplier;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.MainThread;
import net.minecraft.network.rcon.QueryThread;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerPropertiesProvider;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.PendingCommand;
import net.minecraft.server.dedicated.ServerInfoMBean;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.server.gui.MinecraftServerGui;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.filter.ChatFilterClient;
import net.minecraft.util.text.filter.IChatFilter;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.server.console.TerminalHandler;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.io.IoBuilder;
import org.bukkit.command.BufferedCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.command.CraftRemoteConsoleCommandSender;
import org.bukkit.craftbukkit.v1_16_R3.util.ForwardLogHandler;
import org.bukkit.craftbukkit.v1_16_R3.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;

public class DedicatedServer
extends MinecraftServer
implements IServer {
    private static final org.apache.logging.log4j.Logger field_155771_h = LogManager.getLogger();
    private static final Pattern field_189647_l = Pattern.compile("^[a-fA-F0-9]{40}$");
    public final List<PendingCommand> field_71341_l = Collections.synchronizedList(Lists.newArrayList());
    private QueryThread field_71342_m;
    public final RConConsoleSource field_184115_n;
    private MainThread field_71339_n;
    public ServerPropertiesProvider field_71340_o;
    @Nullable
    private MinecraftServerGui field_213225_q;
    @Nullable
    private final ChatFilterClient field_244714_r;

    public DedicatedServer(Thread p_i232601_1_, DynamicRegistries.Impl p_i232601_2_, SaveFormat.LevelSave p_i232601_3_, ResourcePackList p_i232601_4_, DataPackRegistries p_i232601_5_, IServerConfiguration p_i232601_6_, ServerPropertiesProvider p_i232601_7_, DataFixer p_i232601_8_, MinecraftSessionService p_i232601_9_, GameProfileRepository p_i232601_10_, PlayerProfileCache p_i232601_11_, IChunkStatusListenerFactory p_i232601_12_) {
        super(p_i232601_1_, p_i232601_2_, p_i232601_3_, p_i232601_6_, p_i232601_4_, Proxy.NO_PROXY, p_i232601_8_, p_i232601_5_, p_i232601_9_, p_i232601_10_, p_i232601_11_, p_i232601_12_);
        this.field_71340_o = p_i232601_7_;
        this.field_184115_n = new RConConsoleSource(this);
        this.field_244714_r = null;
    }

    @Override
    public boolean func_71197_b() throws IOException {
        new MohistConfig().init();
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                if (TerminalHandler.handleCommands((DedicatedServer)DedicatedServer.this)) {
                    return;
                }
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                try {
                    System.in.available();
                }
                catch (IOException ex) {
                    return;
                }
                try {
                    while (!DedicatedServer.this.func_71241_aa() && DedicatedServer.this.func_71278_l()) {
                        String s3 = bufferedreader.readLine();
                        if (s3 == null) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                        if (s3.trim().length() <= 0) continue;
                        DedicatedServer.this.func_195581_a(s3, DedicatedServer.this.func_195573_aM());
                    }
                }
                catch (IOException ioexception1) {
                    field_155771_h.error(i18n.get((String)"dedicatedserver.1", (Object[])new Object[]{ioexception1}));
                }
            }
        };
        Logger global = Logger.getLogger("");
        global.setUseParentHandlers(false);
        for (Handler handler : global.getHandlers()) {
            global.removeHandler(handler);
        }
        global.addHandler((Handler)new ForwardLogHandler());
        org.apache.logging.log4j.Logger logger = LogManager.getRootLogger();
        System.setOut(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.WARN).buildPrintStream());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_155771_h));
        thread.start();
        field_155771_h.info(i18n.get((String)"dedicatedserver.26", (Object[])new Object[]{SharedConstants.func_215069_a().getName()}));
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            field_155771_h.warn(i18n.get((String)"dedicatedserver.2"));
        }
        field_155771_h.info(i18n.get((String)"dedicatedserver.3"));
        ServerProperties serverproperties = this.field_71340_o.func_219034_a();
        if (this.func_71264_H()) {
            this.func_71189_e("127.0.0.1");
        } else {
            this.func_71229_d(serverproperties.field_219007_a);
            this.func_190517_e(serverproperties.field_219008_b);
            this.func_71189_e(serverproperties.field_219009_c);
        }
        this.func_71188_g(serverproperties.field_219012_f);
        this.func_71245_h(serverproperties.field_219013_g);
        this.func_180507_a_(serverproperties.field_219014_h, this.func_184113_aK());
        this.func_71205_p(serverproperties.field_219015_i);
        this.func_104055_i(serverproperties.field_219016_j);
        super.func_143006_e((Integer)serverproperties.field_219005_R.get());
        this.func_205741_k(serverproperties.field_219017_k);
        this.field_240768_i_.func_230392_a_(serverproperties.field_219020_n);
        field_155771_h.info(i18n.get((String)"dedicatedserver.4", (Object[])new Object[]{serverproperties.field_219020_n}));
        InetAddress inetaddress = null;
        if (!this.func_71211_k().isEmpty()) {
            inetaddress = InetAddress.getByName(this.func_71211_k());
        }
        if (this.func_71215_F() < 0) {
            this.func_71208_b(serverproperties.field_219025_s);
        }
        this.func_244801_P();
        field_155771_h.info(i18n.get((String)"dedicatedserver.5", (Object[])new Object[]{this.func_71211_k().isEmpty() ? "*" : this.func_71211_k(), this.func_71215_F()}));
        try {
            this.func_147137_ag().func_151265_a(inetaddress, this.func_71215_F());
        }
        catch (IOException ioexception) {
            field_155771_h.warn(i18n.get((String)"dedicatedserver.6"));
            field_155771_h.warn(i18n.get((String)"dedicatedserver.7", (Object[])new Object[]{ioexception.toString()}));
            field_155771_h.warn(i18n.get((String)"dedicatedserver.8"));
            return false;
        }
        if (!this.func_71266_T()) {
            field_155771_h.warn(i18n.get((String)"dedicatedserver.9"));
            field_155771_h.warn(i18n.get((String)"dedicatedserver.10"));
            field_155771_h.warn(i18n.get((String)"dedicatedserver.11"));
            field_155771_h.warn(i18n.get((String)"dedicatedserver.12"));
        }
        if (this.func_152368_aE()) {
            this.func_152358_ax().func_152658_c();
        }
        if (!PreYggdrasilConverter.func_219587_e(this)) {
            return false;
        }
        this.func_184105_a(new DedicatedPlayerList(this, this.field_240767_f_, this.field_240766_e_));
        this.server.loadPlugins();
        this.server.enablePlugins(PluginLoadOrder.STARTUP);
        long i = Util.func_211178_c();
        this.func_71191_d(serverproperties.field_219026_t);
        SkullTileEntity.func_184293_a(this.func_152358_ax());
        SkullTileEntity.func_184294_a(this.func_147130_as());
        PlayerProfileCache.func_187320_a(this.func_71266_T());
        if (!ServerLifecycleHooks.handleServerAboutToStart((MinecraftServer)this)) {
            return false;
        }
        field_155771_h.info(i18n.get((String)"dedicatedserver.13", (Object[])new Object[]{this.func_230542_k__()}));
        this.func_240800_l__();
        long j = Util.func_211178_c() - i;
        String s = String.format(Locale.ROOT, "%.3fs", (double)j / 1.0E9);
        field_155771_h.info(i18n.get((String)"dedicatedserver.14", (Object[])new Object[]{s}));
        Metrics.MohistMetrics.startMetrics();
        this.field_211151_aa = Util.func_211177_b();
        if (serverproperties.field_219027_u != null) {
            this.func_200252_aR().func_223585_a(GameRules.field_223620_w).func_223570_a(serverproperties.field_219027_u, this);
        }
        if (serverproperties.field_219028_v) {
            field_155771_h.info(i18n.get((String)"dedicatedserver.15"));
            this.field_71342_m = QueryThread.func_242129_a((IServer)this);
        }
        if (serverproperties.field_219030_x) {
            field_155771_h.info(i18n.get((String)"dedicatedserver.16"));
            this.field_71339_n = MainThread.func_242130_a((IServer)this);
            this.remoteConsole = new CraftRemoteConsoleCommandSender(this.field_184115_n);
        }
        Items.field_190931_a.func_150895_a(ItemGroup.field_78027_g, NonNullList.func_191196_a());
        if (serverproperties.field_241079_P_) {
            ServerInfoMBean.func_233490_a_((MinecraftServer)this);
        }
        return ServerLifecycleHooks.handleServerStarting((MinecraftServer)this);
    }

    @Override
    public boolean func_230537_U_() {
        return this.func_213221_d_().field_219010_d && super.func_230537_U_();
    }

    @Override
    public boolean func_230536_N_() {
        return this.field_71340_o.func_219034_a().field_218992_E && super.func_230536_N_();
    }

    @Override
    public boolean func_230538_V_() {
        return this.field_71340_o.func_219034_a().field_219011_e && super.func_230538_V_();
    }

    public String func_184113_aK() {
        String s;
        ServerProperties serverproperties = this.field_71340_o.func_219034_a();
        if (!serverproperties.field_218989_B.isEmpty()) {
            s = serverproperties.field_218989_B;
            if (!Strings.isNullOrEmpty((String)serverproperties.field_218988_A)) {
                field_155771_h.warn(i18n.get((String)"dedicatedserver.17"));
            }
        } else if (!Strings.isNullOrEmpty((String)serverproperties.field_218988_A)) {
            field_155771_h.warn(i18n.get((String)"dedicatedserver.18"));
            s = serverproperties.field_218988_A;
        } else {
            s = "";
        }
        if (!s.isEmpty() && !field_189647_l.matcher(s).matches()) {
            field_155771_h.warn(i18n.get((String)"dedicatedserver.19"));
        }
        if (!serverproperties.field_219014_h.isEmpty() && s.isEmpty()) {
            field_155771_h.warn(i18n.get((String)"dedicatedserver.20"));
        }
        return s;
    }

    public ServerProperties func_213221_d_() {
        return this.field_71340_o.func_219034_a();
    }

    @Override
    public void func_230543_p_() {
        this.func_147139_a(this.func_213221_d_().field_219019_m, true);
    }

    @Override
    public boolean func_71199_h() {
        return this.func_213221_d_().field_218990_C;
    }

    @Override
    public CrashReport func_71230_b(CrashReport p_71230_1_) {
        p_71230_1_ = super.func_71230_b(p_71230_1_);
        p_71230_1_.func_85056_g().func_189529_a("Is Modded", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_230045_q_().orElse("Unknown (can't tell)")));
        p_71230_1_.func_85056_g().func_189529_a("Type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> "Dedicated Server (map_server.txt)"));
        return p_71230_1_;
    }

    @Override
    public Optional<String> func_230045_q_() {
        String s = this.getServerModName();
        return !"vanilla".equals(s) ? Optional.of("Definitely; Server brand changed to '" + s + "'") : Optional.empty();
    }

    @Override
    public void func_71240_o() {
        if (this.field_244714_r != null) {
            this.field_244714_r.close();
        }
        if (this.field_213225_q != null) {
            this.field_213225_q.func_219050_b();
        }
        if (this.field_71339_n != null) {
            this.field_71339_n.func_219591_b();
        }
        if (this.field_71342_m != null) {
            this.field_71342_m.func_219591_b();
        }
    }

    @Override
    public void func_71190_q(BooleanSupplier p_71190_1_) {
        super.func_71190_q(p_71190_1_);
        this.func_71333_ah();
    }

    @Override
    public boolean func_71255_r() {
        return this.func_213221_d_().field_218991_D;
    }

    @Override
    public void func_70000_a(Snooper p_70000_1_) {
        p_70000_1_.func_152768_a("whitelist_enabled", (Object)this.func_184103_al().func_72383_n());
        p_70000_1_.func_152768_a("whitelist_count", (Object)this.func_184103_al().func_152598_l().length);
        super.func_70000_a(p_70000_1_);
    }

    public void func_195581_a(String p_195581_1_, CommandSource p_195581_2_) {
        this.field_71341_l.add(new PendingCommand(p_195581_1_, p_195581_2_));
    }

    public void func_71333_ah() {
        MinecraftTimings.serverCommandTimer.startTiming();
        while (!this.field_71341_l.isEmpty()) {
            PendingCommand pendingcommand = this.field_71341_l.remove(0);
            ServerCommandEvent event = new ServerCommandEvent((CommandSender)this.console, pendingcommand.field_73702_a);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            pendingcommand = new PendingCommand(event.getCommand(), pendingcommand.field_73701_b);
            this.server.dispatchServerCommand((CommandSender)this.console, pendingcommand);
        }
        MinecraftTimings.serverCommandTimer.stopTiming();
    }

    @Override
    public boolean func_71262_S() {
        return true;
    }

    @Override
    public int func_241871_k() {
        return this.func_213221_d_().field_244379_I;
    }

    @Override
    public boolean func_181035_ah() {
        return this.func_213221_d_().field_218994_G;
    }

    @Override
    public DedicatedPlayerList func_184103_al() {
        return (DedicatedPlayerList)super.func_184103_al();
    }

    @Override
    public boolean func_71344_c() {
        return true;
    }

    public String func_71277_t() {
        return this.func_71211_k();
    }

    public int func_71234_u() {
        return this.func_71215_F();
    }

    public String func_71274_v() {
        return this.func_71273_Y();
    }

    public void func_120011_ar() {
        if (this.field_213225_q == null) {
            this.field_213225_q = MinecraftServerGui.func_219048_a(this);
        }
    }

    @Override
    public boolean func_71279_ae() {
        return this.field_213225_q != null;
    }

    @Override
    public boolean func_195565_a(GameType p_195565_1_, boolean p_195565_2_, int p_195565_3_) {
        return false;
    }

    @Override
    public boolean func_82356_Z() {
        return this.func_213221_d_().field_218995_H;
    }

    @Override
    public int func_82357_ak() {
        return this.func_213221_d_().field_218996_I;
    }

    @Override
    public boolean func_175579_a(ServerWorld p_175579_1_, BlockPos p_175579_2_, PlayerEntity p_175579_3_) {
        int j;
        if (p_175579_1_.func_234923_W_() != World.field_234918_g_) {
            return false;
        }
        if (this.func_184103_al().func_152603_m().func_152690_d()) {
            return false;
        }
        if (this.func_184103_al().func_152596_g(p_175579_3_.func_146103_bH())) {
            return false;
        }
        if (this.func_82357_ak() <= 0) {
            return false;
        }
        BlockPos blockpos = p_175579_1_.func_241135_u_();
        int i = MathHelper.func_76130_a((int)(p_175579_2_.func_177958_n() - blockpos.func_177958_n()));
        int k = Math.max(i, j = MathHelper.func_76130_a((int)(p_175579_2_.func_177952_p() - blockpos.func_177952_p())));
        return k <= this.func_82357_ak();
    }

    @Override
    public boolean func_230541_aj_() {
        return this.func_213221_d_().field_241080_Q_;
    }

    @Override
    public int func_110455_j() {
        return this.func_213221_d_().field_218997_J;
    }

    @Override
    public int func_223707_k() {
        return this.func_213221_d_().field_225395_K;
    }

    @Override
    public void func_143006_e(int p_143006_1_) {
        super.func_143006_e(p_143006_1_);
        this.field_71340_o.func_219033_a(p_213224_2_ -> (ServerProperties)p_213224_2_.field_219005_R.func_244381_a(this.func_244267_aX(), p_143006_1_));
    }

    @Override
    public boolean func_195569_l() {
        return this.func_213221_d_().field_219002_O;
    }

    @Override
    public boolean func_195041_r_() {
        return this.func_213221_d_().field_219003_P;
    }

    @Override
    public int func_175580_aG() {
        return this.func_213221_d_().field_219004_Q;
    }

    @Override
    public int func_175577_aI() {
        return this.func_213221_d_().field_219001_N;
    }

    protected boolean func_152368_aE() {
        boolean flag = false;
        for (int i = 0; !flag && i <= 2; ++i) {
            if (i > 0) {
                field_155771_h.warn(i18n.get((String)"dedicatedserver.21"));
                this.func_152369_aG();
            }
            flag = PreYggdrasilConverter.func_152724_a(this);
        }
        boolean flag1 = false;
        for (int j = 0; !flag1 && j <= 2; ++j) {
            if (j > 0) {
                field_155771_h.warn(i18n.get((String)"dedicatedserver.22"));
                this.func_152369_aG();
            }
            flag1 = PreYggdrasilConverter.func_152722_b(this);
        }
        boolean flag2 = false;
        for (int k = 0; !flag2 && k <= 2; ++k) {
            if (k > 0) {
                field_155771_h.warn(i18n.get((String)"dedicatedserver.23"));
                this.func_152369_aG();
            }
            flag2 = PreYggdrasilConverter.func_152718_c(this);
        }
        boolean flag3 = false;
        for (int l = 0; !flag3 && l <= 2; ++l) {
            if (l > 0) {
                field_155771_h.warn(i18n.get((String)"dedicatedserver.24"));
                this.func_152369_aG();
            }
            flag3 = PreYggdrasilConverter.func_152710_d(this);
        }
        boolean flag4 = false;
        for (int i1 = 0; !flag4 && i1 <= 2; ++i1) {
            if (i1 > 0) {
                field_155771_h.warn(i18n.get((String)"dedicatedserver.25"));
                this.func_152369_aG();
            }
            flag4 = PreYggdrasilConverter.func_152723_a(this);
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void func_152369_aG() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long func_175593_aQ() {
        return this.func_213221_d_().field_218998_K;
    }

    public String func_71258_A() {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.server.getPluginManager().getPlugins();
        result.append(this.server.getName());
        result.append(" on Bukkit ");
        result.append(this.server.getBukkitVersion());
        if (plugins.length > 0 && this.server.getQueryPlugins()) {
            result.append(": ");
            for (int i = 0; i < plugins.length; ++i) {
                if (i > 0) {
                    result.append("; ");
                }
                result.append(plugins[i].getDescription().getName());
                result.append(" ");
                result.append(plugins[i].getDescription().getVersion().replaceAll(";", ","));
            }
        }
        return result.toString();
    }

    public String func_71252_i(String p_71252_1_) {
        Waitable[] waitableArray = new Waitable[1];
        this.field_184115_n.func_70007_b();
        this.func_213167_f(() -> {
            RemoteServerCommandEvent event = new RemoteServerCommandEvent((CommandSender)this.remoteConsole, p_71252_1_);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (p_71252_1_.toLowerCase().startsWith("timings") && p_71252_1_.toLowerCase().matches("timings (report|paste|get|merged|seperate)")) {
                final BufferedCommandSender sender = new BufferedCommandSender();
                Waitable<String> waitable = new Waitable<String>(){

                    protected String evaluate() {
                        return sender.getBuffer();
                    }
                };
                waitableArray[0] = waitable;
                Timings.generateReport((TimingsReportListener)new TimingsReportListener((CommandSender)sender, (Runnable)waitable));
            } else {
                PendingCommand serverCommand = new PendingCommand(event.getCommand(), this.field_184115_n.func_195540_f());
                this.server.dispatchServerCommand((CommandSender)this.remoteConsole, serverCommand);
            }
        });
        if (waitableArray[0] != null) {
            Waitable waitable = waitableArray[0];
            try {
                return (String)waitable.get();
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Exception processing rcon command " + p_71252_1_, e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted processing rcon command " + p_71252_1_, e);
            }
        }
        return this.field_184115_n.func_70008_c();
    }

    public void func_213223_o(boolean p_213223_1_) {
        this.field_71340_o.func_219033_a(p_213222_2_ -> (ServerProperties)p_213222_2_.field_219006_S.func_244381_a(this.func_244267_aX(), p_213223_1_));
    }

    @Override
    public void func_71260_j() {
        super.func_71260_j();
        Util.func_240993_h_();
    }

    @Override
    public boolean func_213199_b(GameProfile p_213199_1_) {
        return false;
    }

    @Override
    public void func_145747_a(ITextComponent message, UUID p_145747_2_) {
        field_155771_h.info(message.getString());
    }

    @Override
    public int func_230512_b_(int p_230512_1_) {
        return this.func_213221_d_().field_241081_R_ * p_230512_1_ / 100;
    }

    public String func_230542_k__() {
        return this.field_71310_m.func_237282_a_();
    }

    @Override
    public boolean func_230540_aS_() {
        return this.field_71340_o.func_219034_a().field_241078_O_;
    }

    @Override
    @Nullable
    public IChatFilter func_244435_a(ServerPlayerEntity p_244435_1_) {
        return this.field_244714_r != null ? this.field_244714_r.func_244566_a(p_244435_1_.func_146103_bH()) : null;
    }

    @Override
    public CommandSender getBukkitSender(CommandSource wrapper) {
        return this.console;
    }
}

