/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.integrated;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.LanServerPingThread;
import net.minecraft.command.CommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedPlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.GameType;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.command.CommandSender;

@OnlyIn(value=Dist.CLIENT)
public class IntegratedServer
extends MinecraftServer {
    private static final Logger field_147148_h = LogManager.getLogger();
    private final Minecraft field_71349_l;
    private boolean field_71348_o;
    private int field_195580_l = -1;
    private LanServerPingThread field_71345_q;
    private UUID field_211528_n;

    public IntegratedServer(Thread p_i232494_1_, Minecraft p_i232494_2_, DynamicRegistries.Impl p_i232494_3_, SaveFormat.LevelSave p_i232494_4_, ResourcePackList p_i232494_5_, DataPackRegistries p_i232494_6_, IServerConfiguration p_i232494_7_, MinecraftSessionService p_i232494_8_, GameProfileRepository p_i232494_9_, PlayerProfileCache p_i232494_10_, IChunkStatusListenerFactory p_i232494_11_) {
        super(p_i232494_1_, p_i232494_3_, p_i232494_4_, p_i232494_7_, p_i232494_5_, p_i232494_2_.func_110437_J(), p_i232494_2_.func_184126_aj(), p_i232494_6_, p_i232494_8_, p_i232494_9_, p_i232494_10_, p_i232494_11_);
        this.func_71224_l(p_i232494_2_.func_110432_I().func_111285_a());
        this.func_71204_b(p_i232494_2_.func_71355_q());
        this.func_71191_d(256);
        this.func_184105_a(new IntegratedPlayerList(this, this.field_240767_f_, this.field_240766_e_));
        this.field_71349_l = p_i232494_2_;
    }

    @Override
    public boolean func_71197_b() {
        field_147148_h.info("Starting integrated minecraft server version " + SharedConstants.func_215069_a().getName());
        this.func_71229_d(true);
        this.func_71188_g(true);
        this.func_71245_h(true);
        this.func_244801_P();
        if (!ServerLifecycleHooks.handleServerAboutToStart((MinecraftServer)this)) {
            return false;
        }
        this.func_240800_l__();
        this.func_71205_p(this.func_71214_G() + " - " + this.func_240793_aU_().func_76065_j());
        return ServerLifecycleHooks.handleServerStarting((MinecraftServer)this);
    }

    @Override
    public void func_71217_p(BooleanSupplier p_71217_1_) {
        boolean flag = this.field_71348_o;
        this.field_71348_o = Minecraft.func_71410_x().func_147114_u() != null && Minecraft.func_71410_x().func_147113_T();
        IProfiler iprofiler = this.func_213185_aS();
        if (!flag && this.field_71348_o) {
            iprofiler.func_76320_a("autoSave");
            field_147148_h.info("Saving and pausing game...");
            this.func_184103_al().func_72389_g();
            this.func_213211_a(false, false, false);
            iprofiler.func_76319_b();
        }
        if (!this.field_71348_o) {
            super.func_71217_p(p_71217_1_);
            int i = Math.max(2, this.field_71349_l.field_71474_y.field_151451_c + -1);
            if (i != this.func_184103_al().func_72395_o()) {
                field_147148_h.info("Changing view distance to {}, from {}", (Object)i, (Object)this.func_184103_al().func_72395_o());
                this.func_184103_al().func_217884_a(i);
            }
        }
    }

    @Override
    public boolean func_195569_l() {
        return true;
    }

    @Override
    public boolean func_195041_r_() {
        return true;
    }

    @Override
    public CommandSender getBukkitSender(CommandSource p0) {
        return null;
    }

    @Override
    public File func_71238_n() {
        return this.field_71349_l.field_71412_D;
    }

    @Override
    public boolean func_71262_S() {
        return false;
    }

    @Override
    public int func_241871_k() {
        return 0;
    }

    @Override
    public boolean func_181035_ah() {
        return false;
    }

    @Override
    public void func_71228_a(CrashReport p_71228_1_) {
        this.field_71349_l.func_71404_a(p_71228_1_);
    }

    @Override
    public CrashReport func_71230_b(CrashReport p_71230_1_) {
        p_71230_1_ = super.func_71230_b(p_71230_1_);
        p_71230_1_.func_85056_g().func_71507_a("Type", "Integrated Server (map_client.txt)");
        p_71230_1_.func_85056_g().func_189529_a("Is Modded", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_230045_q_().orElse("Probably not. Jar signature remains and both client + server brands are untouched.")));
        return p_71230_1_;
    }

    @Override
    public Optional<String> func_230045_q_() {
        String s = ClientBrandRetriever.getClientModName();
        if (!s.equals("vanilla")) {
            return Optional.of("Definitely; Client brand changed to '" + s + "'");
        }
        s = this.getServerModName();
        if (!"vanilla".equals(s)) {
            return Optional.of("Definitely; Server brand changed to '" + s + "'");
        }
        return Minecraft.class.getSigners() == null ? Optional.of("Very likely; Jar signature invalidated") : Optional.empty();
    }

    @Override
    public void func_70000_a(Snooper p_70000_1_) {
        super.func_70000_a(p_70000_1_);
        p_70000_1_.func_152768_a("snooper_partner", (Object)this.field_71349_l.func_71378_E().func_80006_f());
    }

    @Override
    public boolean func_195565_a(GameType p_195565_1_, boolean p_195565_2_, int p_195565_3_) {
        try {
            this.func_147137_ag().func_151265_a(null, p_195565_3_);
            field_147148_h.info("Started serving on {}", (Object)p_195565_3_);
            this.field_195580_l = p_195565_3_;
            this.field_71345_q = new LanServerPingThread(this.func_71273_Y(), "" + p_195565_3_);
            this.field_71345_q.start();
            this.func_184103_al().func_152604_a(p_195565_1_);
            this.func_184103_al().func_72387_b(p_195565_2_);
            int i = this.func_211833_a(this.field_71349_l.field_71439_g.func_146103_bH());
            this.field_71349_l.field_71439_g.func_184839_n(i);
            for (ServerPlayerEntity serverplayerentity : this.func_184103_al().func_181057_v()) {
                this.func_195571_aL().func_197051_a(serverplayerentity);
            }
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    @Override
    public void func_71260_j() {
        super.func_71260_j();
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    @Override
    public void func_71263_m(boolean p_71263_1_) {
        if (this.func_71278_l()) {
            this.func_213167_f(() -> {
                for (ServerPlayerEntity serverplayerentity : Lists.newArrayList(this.func_184103_al().func_181057_v())) {
                    if (serverplayerentity.func_110124_au().equals(this.field_211528_n)) continue;
                    this.func_184103_al().func_72367_e(serverplayerentity);
                }
            });
        }
        super.func_71263_m(p_71263_1_);
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    @Override
    public boolean func_71344_c() {
        return this.field_195580_l > -1;
    }

    @Override
    public int func_71215_F() {
        return this.field_195580_l;
    }

    @Override
    public void func_71235_a(GameType p_71235_1_) {
        super.func_71235_a(p_71235_1_);
        this.func_184103_al().func_152604_a(p_71235_1_);
    }

    @Override
    public boolean func_82356_Z() {
        return true;
    }

    @Override
    public int func_110455_j() {
        return 2;
    }

    @Override
    public int func_223707_k() {
        return 2;
    }

    public void func_211527_b(UUID p_211527_1_) {
        this.field_211528_n = p_211527_1_;
    }

    @Override
    public boolean func_213199_b(GameProfile p_213199_1_) {
        return p_213199_1_.getName().equalsIgnoreCase(this.func_71214_G());
    }

    @Override
    public int func_230512_b_(int p_230512_1_) {
        return (int)(this.field_71349_l.field_71474_y.field_238329_c_ * (float)p_230512_1_);
    }

    @Override
    public boolean func_230540_aS_() {
        return this.field_71349_l.field_71474_y.field_241568_aS_;
    }
}

