/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mohistmc.util.i18n.i18n;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.management.UserList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spigotmc.SpigotConfig;

public class PlayerProfileCache {
    private static final Logger field_242114_a = LogManager.getLogger();
    private static boolean field_187322_c;
    private final Map<String, ProfileEntry> field_152661_c = Maps.newConcurrentMap();
    private final Map<UUID, ProfileEntry> field_152662_d = Maps.newConcurrentMap();
    private final GameProfileRepository field_187323_g;
    private final Gson field_152660_b = new GsonBuilder().create();
    private final File field_152665_g;
    private final AtomicLong field_242115_h = new AtomicLong();

    public PlayerProfileCache(GameProfileRepository p_i46836_1_, File p_i46836_2_) {
        this.field_187323_g = p_i46836_1_;
        this.field_152665_g = p_i46836_2_;
        Lists.reverse(this.func_242116_a()).forEach(this::func_242118_a);
    }

    private void func_242118_a(ProfileEntry p_242118_1_) {
        UUID uuid;
        GameProfile gameprofile = p_242118_1_.func_152668_a();
        p_242118_1_.func_242126_a(this.func_242123_d());
        String s = gameprofile.getName();
        if (s != null) {
            this.field_152661_c.put(s.toLowerCase(Locale.ROOT), p_242118_1_);
        }
        if ((uuid = gameprofile.getId()) != null) {
            this.field_152662_d.put(uuid, p_242118_1_);
        }
    }

    @Nullable
    private static GameProfile func_187319_a(GameProfileRepository p_187319_0_, String p_187319_1_) {
        final AtomicReference atomicreference = new AtomicReference();
        ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                atomicreference.set(p_onProfileLookupSucceeded_1_);
            }

            public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                atomicreference.set(null);
            }
        };
        p_187319_0_.findProfilesByNames(new String[]{p_187319_1_}, Agent.MINECRAFT, profilelookupcallback);
        GameProfile gameprofile = (GameProfile)atomicreference.get();
        if (!PlayerProfileCache.func_187321_d() && gameprofile == null) {
            UUID uuid = PlayerEntity.func_146094_a(new GameProfile((UUID)null, p_187319_1_));
            gameprofile = new GameProfile(uuid, p_187319_1_);
        }
        return gameprofile;
    }

    public static void func_187320_a(boolean p_187320_0_) {
        field_187322_c = p_187320_0_;
    }

    private static boolean func_187321_d() {
        return field_187322_c;
    }

    public void func_152649_a(GameProfile p_152649_1_) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        Date date = calendar.getTime();
        ProfileEntry playerprofilecache$profileentry = new ProfileEntry(p_152649_1_, date);
        this.func_242118_a(playerprofilecache$profileentry);
        if (!SpigotConfig.saveUserCacheOnStopOnly) {
            this.func_152658_c();
        }
    }

    private long func_242123_d() {
        return this.field_242115_h.incrementAndGet();
    }

    @Nullable
    public GameProfile func_152655_a(String p_152655_1_) {
        GameProfile gameprofile;
        String s = p_152655_1_.toLowerCase(Locale.ROOT);
        ProfileEntry playerprofilecache$profileentry = this.field_152661_c.get(s);
        boolean flag = false;
        if (playerprofilecache$profileentry != null && new Date().getTime() >= playerprofilecache$profileentry.field_152673_c.getTime()) {
            this.field_152662_d.remove(playerprofilecache$profileentry.func_152668_a().getId());
            this.field_152661_c.remove(playerprofilecache$profileentry.func_152668_a().getName().toLowerCase(Locale.ROOT));
            flag = true;
            playerprofilecache$profileentry = null;
        }
        if (playerprofilecache$profileentry != null) {
            playerprofilecache$profileentry.func_242126_a(this.func_242123_d());
            gameprofile = playerprofilecache$profileentry.func_152668_a();
        } else {
            gameprofile = PlayerProfileCache.func_187319_a(this.field_187323_g, p_152655_1_);
            if (gameprofile != null) {
                this.func_152649_a(gameprofile);
                flag = false;
            }
        }
        if (flag && !SpigotConfig.saveUserCacheOnStopOnly) {
            this.func_152658_c();
        }
        return gameprofile;
    }

    @Nullable
    public GameProfile func_152652_a(UUID p_152652_1_) {
        ProfileEntry playerprofilecache$profileentry = this.field_152662_d.get(p_152652_1_);
        if (playerprofilecache$profileentry == null) {
            return null;
        }
        playerprofilecache$profileentry.func_242126_a(this.func_242123_d());
        return playerprofilecache$profileentry.func_152668_a();
    }

    private static DateFormat func_242124_e() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ProfileEntry> func_242116_a() {
        ArrayList list = Lists.newArrayList();
        try (BufferedReader reader2222 = Files.newReader((File)this.field_152665_g, (Charset)StandardCharsets.UTF_8);){
            JsonArray jsonarray = (JsonArray)this.field_152660_b.fromJson((Reader)reader2222, JsonArray.class);
            if (jsonarray == null) {
                ArrayList arrayList = list;
                return arrayList;
            }
            DateFormat dateformat = PlayerProfileCache.func_242124_e();
            jsonarray.forEach(p_242122_2_ -> {
                ProfileEntry playerprofilecache$profileentry = PlayerProfileCache.func_242121_a(p_242122_2_, dateformat);
                if (playerprofilecache$profileentry != null) {
                    list.add(playerprofilecache$profileentry);
                }
            });
            return list;
        }
        catch (FileNotFoundException reader2222) {
            return list;
        }
        catch (JsonSyntaxException | NullPointerException ex) {
            UserList.field_152693_a.warn(i18n.get((String)"playerprofilecache.1"));
            this.field_152665_g.delete();
            return list;
        }
        catch (JsonParseException | IOException ioexception) {
            field_242114_a.warn("Failed to load profile cache {}", (Object)this.field_152665_g, (Object)ioexception);
        }
        return list;
    }

    public void func_152658_c() {
        JsonArray jsonarray = new JsonArray();
        DateFormat dateformat = PlayerProfileCache.func_242124_e();
        this.func_242117_a(SpigotConfig.userCacheCap).forEach(p_242120_2_ -> jsonarray.add(PlayerProfileCache.func_242119_a(p_242120_2_, dateformat)));
        String s = this.field_152660_b.toJson((JsonElement)jsonarray);
        try (BufferedWriter writer = Files.newWriter((File)this.field_152665_g, (Charset)StandardCharsets.UTF_8);){
            writer.write(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Stream<ProfileEntry> func_242117_a(int p_242117_1_) {
        return ImmutableList.copyOf(this.field_152662_d.values()).stream().sorted(Comparator.comparing(ProfileEntry::func_242128_c).reversed()).limit(p_242117_1_);
    }

    private static JsonElement func_242119_a(ProfileEntry p_242119_0_, DateFormat p_242119_1_) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("name", p_242119_0_.func_152668_a().getName());
        UUID uuid = p_242119_0_.func_152668_a().getId();
        jsonobject.addProperty("uuid", uuid == null ? "" : uuid.toString());
        jsonobject.addProperty("expiresOn", p_242119_1_.format(p_242119_0_.func_152670_b()));
        return jsonobject;
    }

    @Nullable
    private static ProfileEntry func_242121_a(JsonElement p_242121_0_, DateFormat p_242121_1_) {
        if (p_242121_0_.isJsonObject()) {
            JsonObject jsonobject = p_242121_0_.getAsJsonObject();
            JsonElement jsonelement = jsonobject.get("name");
            JsonElement jsonelement1 = jsonobject.get("uuid");
            JsonElement jsonelement2 = jsonobject.get("expiresOn");
            if (jsonelement != null && jsonelement1 != null) {
                String s = jsonelement1.getAsString();
                String s1 = jsonelement.getAsString();
                Date date = null;
                if (jsonelement2 != null) {
                    try {
                        date = p_242121_1_.parse(jsonelement2.getAsString());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (s1 != null && s != null && date != null) {
                    UUID uuid;
                    try {
                        uuid = UUID.fromString(s);
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                    return new ProfileEntry(new GameProfile(uuid, s1), date);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    static class ProfileEntry {
        private final GameProfile field_152672_b;
        private final Date field_152673_c;
        private volatile long field_242125_c;

        private ProfileEntry(GameProfile p_i241888_1_, Date p_i241888_2_) {
            this.field_152672_b = p_i241888_1_;
            this.field_152673_c = p_i241888_2_;
        }

        public GameProfile func_152668_a() {
            return this.field_152672_b;
        }

        public Date func_152670_b() {
            return this.field_152673_c;
        }

        public void func_242126_a(long p_242126_1_) {
            this.field_242125_c = p_242126_1_;
        }

        public long func_242128_c() {
            return this.field_242125_c;
        }
    }
}

