/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.BrewingStandBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.BrewingStandContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.BrewingStandFuelEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class BrewingStandTileEntity
extends LockableTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private static final int[] field_145941_a = new int[]{3};
    private static final int[] field_184277_f = new int[]{0, 1, 2, 3};
    private static final int[] field_145947_i = new int[]{0, 1, 2, 4};
    private NonNullList<net.minecraft.item.ItemStack> field_145945_j = NonNullList.func_191197_a(5, net.minecraft.item.ItemStack.field_190927_a);
    public int field_145946_k;
    private boolean[] field_145943_l;
    private Item field_145944_m;
    public int field_184278_m;
    private int lastTick = MinecraftServer.currentTick;
    private List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    protected final IIntArray field_213954_a = new IIntArray(){

        public int func_221476_a(int p_221476_1_) {
            switch (p_221476_1_) {
                case 0: {
                    return BrewingStandTileEntity.this.field_145946_k;
                }
                case 1: {
                    return BrewingStandTileEntity.this.field_184278_m;
                }
            }
            return 0;
        }

        public void func_221477_a(int p_221477_1_, int p_221477_2_) {
            switch (p_221477_1_) {
                case 0: {
                    BrewingStandTileEntity.this.field_145946_k = p_221477_2_;
                    break;
                }
                case 1: {
                    BrewingStandTileEntity.this.field_184278_m = p_221477_2_;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    @Override
    public List<net.minecraft.item.ItemStack> getContents() {
        return this.field_145945_j;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add((HumanEntity)who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public int func_70297_j_() {
        return this.maxStack;
    }

    public BrewingStandTileEntity() {
        super(TileEntityType.field_200981_l);
    }

    @Override
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.brewing");
    }

    @Override
    public int func_70302_i_() {
        return this.field_145945_j.size();
    }

    @Override
    public boolean func_191420_l() {
        for (net.minecraft.item.ItemStack itemstack : this.field_145945_j) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        boolean[] aboolean;
        net.minecraft.item.ItemStack itemstack = this.field_145945_j.get(4);
        if (this.field_184278_m <= 0 && itemstack.func_77973_b() == Items.field_151065_br) {
            BrewingStandFuelEvent event = new BrewingStandFuelEvent(this.field_145850_b.getWorld().getBlockAt(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), (ItemStack)CraftItemStack.asCraftMirror((net.minecraft.item.ItemStack)itemstack), 20);
            this.field_145850_b.getCBServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.field_184278_m = event.getFuelPower();
            if (this.field_184278_m > 0 && event.isConsuming()) {
                itemstack.func_190918_g(1);
            }
            this.func_70296_d();
        }
        boolean flag = this.func_145934_k();
        boolean flag1 = this.field_145946_k > 0;
        net.minecraft.item.ItemStack itemstack1 = this.field_145945_j.get(3);
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        this.lastTick = MinecraftServer.currentTick;
        if (flag1) {
            boolean flag2;
            this.field_145946_k -= elapsedTicks;
            boolean bl = flag2 = this.field_145946_k <= 0;
            if (flag2 && flag) {
                this.func_145940_l();
                this.func_70296_d();
            } else if (!flag) {
                this.field_145946_k = 0;
                this.func_70296_d();
            } else if (this.field_145944_m != itemstack1.func_77973_b()) {
                this.field_145946_k = 0;
                this.func_70296_d();
            }
        } else if (flag && this.field_184278_m > 0) {
            --this.field_184278_m;
            this.field_145946_k = 400;
            this.field_145944_m = itemstack1.func_77973_b();
            this.func_70296_d();
        }
        if (!this.field_145850_b.field_72995_K && !Arrays.equals(aboolean = this.func_174902_m(), this.field_145943_l)) {
            this.field_145943_l = aboolean;
            BlockState blockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (!(blockstate.func_177230_c() instanceof BrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.field_176451_a.length; ++i) {
                blockstate = (BlockState)blockstate.func_206870_a(BrewingStandBlock.field_176451_a[i], aboolean[i]);
            }
            this.field_145850_b.func_180501_a(this.field_174879_c, blockstate, 2);
        }
    }

    public boolean[] func_174902_m() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (this.field_145945_j.get(i).func_190926_b()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private boolean func_145934_k() {
        net.minecraft.item.ItemStack itemstack = this.field_145945_j.get(3);
        if (!itemstack.func_190926_b()) {
            return BrewingRecipeRegistry.canBrew(this.field_145945_j, (net.minecraft.item.ItemStack)itemstack, (int[])field_145947_i);
        }
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (!PotionBrewing.func_185205_a(itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            net.minecraft.item.ItemStack itemstack1 = this.field_145945_j.get(i);
            if (itemstack1.func_190926_b() || !PotionBrewing.func_185208_a(itemstack1, itemstack)) continue;
            return true;
        }
        return false;
    }

    private void func_145940_l() {
        if (ForgeEventFactory.onPotionAttemptBrew(this.field_145945_j)) {
            return;
        }
        net.minecraft.item.ItemStack itemstack = this.field_145945_j.get(3);
        InventoryHolder owner = this.getOwner();
        if (owner != null) {
            BrewEvent event = new BrewEvent(this.field_145850_b.getWorld().getBlockAt(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), (BrewerInventory)owner.getInventory(), this.field_184278_m);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        BrewingRecipeRegistry.brewPotions(this.field_145945_j, (net.minecraft.item.ItemStack)itemstack, (int[])field_145947_i);
        ForgeEventFactory.onPotionBrewed(this.field_145945_j);
        BlockPos blockpos = this.func_174877_v();
        if (itemstack.hasContainerItem()) {
            net.minecraft.item.ItemStack itemstack1 = itemstack.getContainerItem();
            itemstack.func_190918_g(1);
            if (itemstack.func_190926_b()) {
                itemstack = itemstack1;
            } else if (!this.field_145850_b.field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (net.minecraft.item.ItemStack)itemstack1);
            }
        } else {
            itemstack.func_190918_g(1);
        }
        this.field_145945_j.set(3, itemstack);
        this.field_145850_b.func_217379_c(1035, blockpos, 0);
    }

    @Override
    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.field_145945_j = NonNullList.func_191197_a(this.func_70302_i_(), net.minecraft.item.ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)p_230337_2_, this.field_145945_j);
        this.field_145946_k = p_230337_2_.func_74765_d("BrewTime");
        this.field_184278_m = p_230337_2_.func_74771_c("Fuel");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        p_189515_1_.func_74777_a("BrewTime", (short)this.field_145946_k);
        ItemStackHelper.func_191282_a((CompoundNBT)p_189515_1_, this.field_145945_j);
        p_189515_1_.func_74774_a("Fuel", (byte)this.field_184278_m);
        return p_189515_1_;
    }

    @Override
    public net.minecraft.item.ItemStack func_70301_a(int p_70301_1_) {
        return p_70301_1_ >= 0 && p_70301_1_ < this.field_145945_j.size() ? this.field_145945_j.get(p_70301_1_) : net.minecraft.item.ItemStack.field_190927_a;
    }

    @Override
    public net.minecraft.item.ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return ItemStackHelper.func_188382_a(this.field_145945_j, (int)p_70298_1_, (int)p_70298_2_);
    }

    @Override
    public net.minecraft.item.ItemStack func_70304_b(int p_70304_1_) {
        return ItemStackHelper.func_188383_a(this.field_145945_j, (int)p_70304_1_);
    }

    @Override
    public void func_70299_a(int p_70299_1_, net.minecraft.item.ItemStack p_70299_2_) {
        if (p_70299_1_ >= 0 && p_70299_1_ < this.field_145945_j.size()) {
            this.field_145945_j.set(p_70299_1_, p_70299_2_);
        }
    }

    @Override
    public boolean func_70300_a(PlayerEntity p_70300_1_) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(p_70300_1_.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    @Override
    public boolean func_94041_b(int p_94041_1_, net.minecraft.item.ItemStack p_94041_2_) {
        if (p_94041_1_ == 3) {
            return BrewingRecipeRegistry.isValidIngredient((net.minecraft.item.ItemStack)p_94041_2_);
        }
        Item item = p_94041_2_.func_77973_b();
        if (p_94041_1_ == 4) {
            return item == Items.field_151065_br;
        }
        return BrewingRecipeRegistry.isValidInput((net.minecraft.item.ItemStack)p_94041_2_) && this.func_70301_a(p_94041_1_).func_190926_b();
    }

    public int[] func_180463_a(Direction p_180463_1_) {
        if (p_180463_1_ == Direction.UP) {
            return field_145941_a;
        }
        return p_180463_1_ == Direction.DOWN ? field_184277_f : field_145947_i;
    }

    public boolean func_180462_a(int p_180462_1_, net.minecraft.item.ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return this.func_94041_b(p_180462_1_, p_180462_2_);
    }

    public boolean func_180461_b(int p_180461_1_, net.minecraft.item.ItemStack p_180461_2_, Direction p_180461_3_) {
        if (p_180461_1_ == 3) {
            return p_180461_2_.func_77973_b() == Items.field_151069_bo;
        }
        return true;
    }

    public void func_174888_l() {
        this.field_145945_j.clear();
    }

    @Override
    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return new BrewingStandContainer(p_213906_1_, p_213906_2_, this, this.field_213954_a);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

