/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ShulkerBoxContainer;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;

public class ShulkerBoxTileEntity
extends LockableLootTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private static final int[] field_190595_a = IntStream.range(0, 27).toArray();
    private NonNullList<ItemStack> field_190596_f = NonNullList.func_191197_a(27, ItemStack.field_190927_a);
    private int field_190598_h;
    private AnimationStatus field_190599_i = AnimationStatus.CLOSED;
    private float field_190600_j;
    private float field_190601_k;
    @Nullable
    private DyeColor field_190602_l;
    private boolean field_204400_o;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    public boolean opened;

    @Override
    public int func_70297_j_() {
        return this.maxStack;
    }

    @Override
    public List<ItemStack> getContents() {
        return this.field_190596_f;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add((HumanEntity)who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public ShulkerBoxTileEntity(@Nullable DyeColor p_i47242_1_) {
        super(TileEntityType.field_200993_x);
        this.field_190602_l = p_i47242_1_;
    }

    public ShulkerBoxTileEntity() {
        this((DyeColor)null);
        this.field_204400_o = true;
    }

    public void func_73660_a() {
        this.func_190583_o();
        if (this.field_190599_i == AnimationStatus.OPENING || this.field_190599_i == AnimationStatus.CLOSING) {
            this.func_190589_G();
        }
    }

    protected void func_190583_o() {
        this.field_190601_k = this.field_190600_j;
        switch (this.field_190599_i) {
            case CLOSED: {
                this.field_190600_j = 0.0f;
                break;
            }
            case OPENING: {
                this.field_190600_j += 0.1f;
                if (!(this.field_190600_j >= 1.0f)) break;
                this.func_190589_G();
                this.field_190599_i = AnimationStatus.OPENED;
                this.field_190600_j = 1.0f;
                this.func_213975_v();
                break;
            }
            case CLOSING: {
                this.field_190600_j -= 0.1f;
                if (!(this.field_190600_j <= 0.0f)) break;
                this.field_190599_i = AnimationStatus.CLOSED;
                this.field_190600_j = 0.0f;
                this.func_213975_v();
                break;
            }
            case OPENED: {
                this.field_190600_j = 1.0f;
            }
        }
    }

    public AnimationStatus func_190591_p() {
        return this.field_190599_i;
    }

    public AxisAlignedBB func_190584_a(BlockState p_190584_1_) {
        return this.func_190587_b(p_190584_1_.func_177229_b(ShulkerBoxBlock.field_190957_a));
    }

    public AxisAlignedBB func_190587_b(Direction p_190587_1_) {
        float f = this.func_190585_a(1.0f);
        return VoxelShapes.func_197868_b().func_197752_a().func_72321_a((double)(0.5f * f * (float)p_190587_1_.func_82601_c()), (double)(0.5f * f * (float)p_190587_1_.func_96559_d()), (double)(0.5f * f * (float)p_190587_1_.func_82599_e()));
    }

    private AxisAlignedBB func_190588_c(Direction p_190588_1_) {
        Direction direction = p_190588_1_.func_176734_d();
        return this.func_190587_b(p_190588_1_).func_191195_a((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e());
    }

    private void func_190589_G() {
        Direction direction;
        AxisAlignedBB axisalignedbb;
        List list;
        BlockState blockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (blockstate.func_177230_c() instanceof ShulkerBoxBlock && !(list = this.field_145850_b.func_72839_b(null, axisalignedbb = this.func_190588_c(direction = blockstate.func_177229_b(ShulkerBoxBlock.field_190957_a)).func_186670_a(this.field_174879_c))).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity.func_184192_z() == PushReaction.IGNORE) continue;
                double d0 = 0.0;
                double d1 = 0.0;
                double d2 = 0.0;
                AxisAlignedBB axisalignedbb1 = entity.func_174813_aQ();
                switch (direction.func_176740_k()) {
                    case X: {
                        d0 = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? axisalignedbb.field_72336_d - axisalignedbb1.field_72340_a : axisalignedbb1.field_72336_d - axisalignedbb.field_72340_a;
                        d0 += 0.01;
                        break;
                    }
                    case Y: {
                        d1 = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? axisalignedbb.field_72337_e - axisalignedbb1.field_72338_b : axisalignedbb1.field_72337_e - axisalignedbb.field_72338_b;
                        d1 += 0.01;
                        break;
                    }
                    case Z: {
                        d2 = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? axisalignedbb.field_72334_f - axisalignedbb1.field_72339_c : axisalignedbb1.field_72334_f - axisalignedbb.field_72339_c;
                        d2 += 0.01;
                    }
                }
                entity.func_213315_a(MoverType.SHULKER_BOX, new Vector3d(d0 * (double)direction.func_82601_c(), d1 * (double)direction.func_96559_d(), d2 * (double)direction.func_82599_e()));
            }
        }
    }

    @Override
    public int func_70302_i_() {
        return this.field_190596_f.size();
    }

    @Override
    public boolean func_145842_c(int p_145842_1_, int p_145842_2_) {
        if (p_145842_1_ == 1) {
            this.field_190598_h = p_145842_2_;
            if (p_145842_2_ == 0) {
                this.field_190599_i = AnimationStatus.CLOSING;
                this.func_213975_v();
            }
            if (p_145842_2_ == 1) {
                this.field_190599_i = AnimationStatus.OPENING;
                this.func_213975_v();
            }
            return true;
        }
        return super.func_145842_c(p_145842_1_, p_145842_2_);
    }

    private void func_213975_v() {
        this.func_195044_w().func_235734_a_(this.func_145831_w(), this.func_174877_v(), 3);
    }

    @Override
    public void func_174889_b(PlayerEntity p_174889_1_) {
        if (!p_174889_1_.func_175149_v()) {
            if (this.field_190598_h < 0) {
                this.field_190598_h = 0;
            }
            ++this.field_190598_h;
            if (this.opened) {
                return;
            }
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.field_190598_h);
            if (this.field_190598_h == 1) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_191262_fB, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    public void func_174886_c(PlayerEntity p_174886_1_) {
        if (!p_174886_1_.func_175149_v()) {
            --this.field_190598_h;
            if (this.opened) {
                return;
            }
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.field_190598_h);
            if (this.field_190598_h <= 0) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_191261_fA, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.shulkerBox");
    }

    @Override
    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.func_190586_e(p_230337_2_);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        return this.func_190580_f(p_189515_1_);
    }

    public void func_190586_e(CompoundNBT p_190586_1_) {
        this.field_190596_f = NonNullList.func_191197_a(this.func_70302_i_(), ItemStack.field_190927_a);
        if (!this.func_184283_b(p_190586_1_) && p_190586_1_.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((CompoundNBT)p_190586_1_, this.field_190596_f);
        }
    }

    public CompoundNBT func_190580_f(CompoundNBT p_190580_1_) {
        if (!this.func_184282_c(p_190580_1_)) {
            ItemStackHelper.func_191281_a((CompoundNBT)p_190580_1_, this.field_190596_f, (boolean)false);
        }
        return p_190580_1_;
    }

    @Override
    protected NonNullList<ItemStack> func_190576_q() {
        return this.field_190596_f;
    }

    @Override
    protected void func_199721_a(NonNullList<ItemStack> p_199721_1_) {
        this.field_190596_f = p_199721_1_;
    }

    public int[] func_180463_a(Direction p_180463_1_) {
        return field_190595_a;
    }

    public boolean func_180462_a(int p_180462_1_, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return !(Block.func_149634_a(p_180462_2_.func_77973_b()) instanceof ShulkerBoxBlock);
    }

    public boolean func_180461_b(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        return true;
    }

    public float func_190585_a(float p_190585_1_) {
        return MathHelper.func_219799_g((float)p_190585_1_, (float)this.field_190601_k, (float)this.field_190600_j);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public DyeColor func_190592_s() {
        if (this.field_204400_o) {
            this.field_190602_l = ShulkerBoxBlock.func_190954_c(this.func_195044_w().func_177230_c());
            this.field_204400_o = false;
        }
        return this.field_190602_l;
    }

    @Override
    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return new ShulkerBoxContainer(p_213906_1_, p_213906_2_, this);
    }

    public boolean func_235676_l_() {
        return this.field_190599_i == AnimationStatus.CLOSED;
    }

    @Override
    protected IItemHandler createUnSidedHandler() {
        return new SidedInvWrapper((ISidedInventory)this, Direction.UP);
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

