/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;

public class SignTileEntity
extends TileEntity
implements ICommandSource {
    public final ITextComponent[] field_145915_a = new ITextComponent[]{StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_};
    public boolean field_145916_j = true;
    private PlayerEntity field_145917_k;
    private final IReorderingProcessor[] field_212367_h = new IReorderingProcessor[4];
    private DyeColor field_214073_l = DyeColor.BLACK;
    public UUID signEditor;

    public SignTileEntity() {
        super(TileEntityType.field_200978_i);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        for (int i = 0; i < 4; ++i) {
            String s = ITextComponent.Serializer.func_150696_a(this.field_145915_a[i]);
            p_189515_1_.func_74778_a("Text" + (i + 1), s);
        }
        if (Boolean.getBoolean("convertLegacySigns")) {
            p_189515_1_.func_74757_a("Bukkit.isConverted", true);
        }
        p_189515_1_.func_74778_a("Color", this.field_214073_l.func_176762_d());
        return p_189515_1_;
    }

    @Override
    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        this.field_145916_j = false;
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.field_214073_l = DyeColor.func_204271_a(p_230337_2_.func_74779_i("Color"), DyeColor.BLACK);
        boolean oldSign = Boolean.getBoolean("convertLegacySigns") && !p_230337_2_.func_74767_n("Bukkit.isConverted");
        for (int i = 0; i < 4; ++i) {
            String s = p_230337_2_.func_74779_i("Text" + (i + 1));
            if (s != null && s.length() > 2048) {
                s = "\"\"";
            }
            try {
                if (oldSign && !this.isLoadingStructure) {
                    this.field_145915_a[i] = CraftChatMessage.fromString((String)s)[0];
                    continue;
                }
                IFormattableTextComponent itextcomponent = ITextComponent.Serializer.func_240643_a_(s.isEmpty() ? "\"\"" : s);
                if (this.field_145850_b instanceof ServerWorld) {
                    try {
                        this.field_145915_a[i] = TextComponentUtils.func_240645_a_((CommandSource)this.func_195539_a(null), (ITextComponent)itextcomponent, (Entity)null, (int)0);
                    }
                    catch (CommandSyntaxException commandsyntaxexception) {
                        this.field_145915_a[i] = itextcomponent;
                    }
                } else {
                    this.field_145915_a[i] = itextcomponent;
                }
            }
            catch (JsonParseException jsonParseException) {
                this.field_145915_a[i] = new StringTextComponent(s);
            }
            this.field_212367_h[i] = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_212366_a(int p_212366_1_) {
        return this.field_145915_a[p_212366_1_];
    }

    public void func_212365_a(int p_212365_1_, ITextComponent p_212365_2_) {
        this.field_145915_a[p_212365_1_] = p_212365_2_;
        this.field_212367_h[p_212365_1_] = null;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IReorderingProcessor func_242686_a(int p_242686_1_, Function<ITextComponent, IReorderingProcessor> p_242686_2_) {
        if (this.field_212367_h[p_242686_1_] == null && this.field_145915_a[p_242686_1_] != null) {
            this.field_212367_h[p_242686_1_] = p_242686_2_.apply(this.field_145915_a[p_242686_1_]);
        }
        return this.field_212367_h[p_242686_1_];
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 9, this.func_189517_E_());
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public boolean func_183000_F() {
        return true;
    }

    public boolean func_145914_a() {
        return this.field_145916_j;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_145913_a(boolean p_145913_1_) {
        this.field_145916_j = p_145913_1_;
        if (!p_145913_1_) {
            this.field_145917_k = null;
        }
    }

    public void func_145912_a(PlayerEntity p_145912_1_) {
        this.field_145917_k = p_145912_1_;
        this.signEditor = p_145912_1_ != null ? p_145912_1_.func_110124_au() : null;
    }

    public PlayerEntity func_145911_b() {
        return this.field_145917_k;
    }

    public boolean func_174882_b(PlayerEntity p_174882_1_) {
        for (ITextComponent itextcomponent : this.field_145915_a) {
            ClickEvent clickevent;
            Style style;
            Style style2 = style = itextcomponent == null ? null : itextcomponent.func_150256_b();
            if (style == null || style.func_150235_h() == null || (clickevent = style.func_150235_h()).func_150669_a() != ClickEvent.Action.RUN_COMMAND) continue;
            p_174882_1_.func_184102_h().func_195571_aL().func_197059_a(this.func_195539_a((ServerPlayerEntity)p_174882_1_), clickevent.func_150668_b());
        }
        return true;
    }

    @Override
    public void func_145747_a(ITextComponent component, UUID senderUUID) {
    }

    @Override
    public boolean func_195039_a() {
        return false;
    }

    @Override
    public boolean func_195040_b() {
        return false;
    }

    @Override
    public boolean func_195041_r_() {
        return false;
    }

    @Override
    public CommandSender getBukkitSender(CommandSource p0) {
        return p0.func_197022_f() != null ? p0.func_197022_f().getBukkitSender(p0) : new CraftBlockCommandSender(p0, (TileEntity)this);
    }

    public CommandSource func_195539_a(@Nullable ServerPlayerEntity p_195539_1_) {
        String s = p_195539_1_ == null ? "Sign" : p_195539_1_.func_200200_C_().getString();
        Object itextcomponent = p_195539_1_ == null ? new StringTextComponent("Sign") : p_195539_1_.func_145748_c_();
        return new CommandSource(this, Vector3d.func_237489_a_(this.field_174879_c), Vector2f.field_189974_a, (ServerWorld)this.field_145850_b, 2, s, (ITextComponent)itextcomponent, this.field_145850_b.func_73046_m(), p_195539_1_);
    }

    public DyeColor func_214066_f() {
        return this.field_214073_l;
    }

    public boolean func_214068_a(DyeColor p_214068_1_) {
        if (p_214068_1_ != this.func_214066_f()) {
            this.field_214073_l = p_214068_1_;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            return true;
        }
        return false;
    }
}

