/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.StringUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkullTileEntity
extends TileEntity
implements ITickableTileEntity {
    @Nullable
    private static PlayerProfileCache field_184298_j;
    @Nullable
    private static MinecraftSessionService field_184299_k;
    @Nullable
    public GameProfile field_152110_j;
    private int field_184296_h;
    private boolean field_184297_i;
    public static final ExecutorService executor;
    public static final LoadingCache<String, GameProfile> skinCache;

    public SkullTileEntity() {
        super(TileEntityType.field_200985_p);
    }

    public static void func_184293_a(PlayerProfileCache p_184293_0_) {
        field_184298_j = p_184293_0_;
    }

    public static void func_184294_a(MinecraftSessionService p_184294_0_) {
        field_184299_k = p_184294_0_;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        if (this.field_152110_j != null) {
            CompoundNBT compoundnbt = new CompoundNBT();
            NBTUtil.func_180708_a(compoundnbt, this.field_152110_j);
            p_189515_1_.func_218657_a("SkullOwner", compoundnbt);
        }
        return p_189515_1_;
    }

    @Override
    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        String s;
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        if (p_230337_2_.func_150297_b("SkullOwner", 10)) {
            this.func_195485_a(NBTUtil.func_152459_a(p_230337_2_.func_74775_l("SkullOwner")));
        } else if (p_230337_2_.func_150297_b("ExtraType", 8) && !StringUtils.func_151246_b((String)(s = p_230337_2_.func_74779_i("ExtraType")))) {
            this.func_195485_a(new GameProfile((UUID)null, s));
        }
    }

    public void func_73660_a() {
        BlockState blockstate = this.func_195044_w();
        if (blockstate.func_203425_a(Blocks.field_196716_eW) || blockstate.func_203425_a(Blocks.field_196715_eV)) {
            if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
                this.field_184297_i = true;
                ++this.field_184296_h;
            } else {
                this.field_184297_i = false;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_184295_a(float p_184295_1_) {
        return this.field_184297_i ? (float)this.field_184296_h + p_184295_1_ : (float)this.field_184296_h;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public GameProfile func_152108_a() {
        return this.field_152110_j;
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 4, SkullTileEntity.sanitizeTileEntityUUID(this.func_189517_E_()));
    }

    public static CompoundNBT sanitizeTileEntityUUID(CompoundNBT cmp) {
        CompoundNBT owner = cmp.func_74775_l("Owner");
        if (!owner.isEmpty()) {
            SkullTileEntity.sanitizeUUID(owner);
        }
        return cmp;
    }

    public static void sanitizeUUID(CompoundNBT owner) {
        String textures;
        CompoundNBT properties = owner.func_74775_l("Properties");
        ListNBT list = null;
        if (!properties.isEmpty()) {
            list = properties.func_150295_c("textures", 10);
        }
        if (list != null && !list.isEmpty() && (textures = ((CompoundNBT)list.get(0)).func_74779_i("Value")) != null && textures.length() > 3) {
            UUID uuid = UUID.nameUUIDFromBytes(textures.getBytes());
            owner.func_186854_a("Id", uuid);
            return;
        }
        owner.func_186854_a("Id", UUID.randomUUID());
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_195485_a(@Nullable GameProfile p_195485_1_) {
        this.field_152110_j = p_195485_1_;
        this.func_152109_d();
    }

    private void func_152109_d() {
        GameProfile profile = this.field_152110_j;
        SkullTileEntity.updateGameProfile(profile, new Predicate<GameProfile>(){

            public boolean apply(GameProfile input) {
                SkullTileEntity.this.field_152110_j = input;
                SkullTileEntity.this.func_70296_d();
                return false;
            }
        }, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Future<GameProfile> updateGameProfile(final GameProfile input, final Predicate<GameProfile> callback, boolean sync) {
        if (input != null && !StringUtils.func_151246_b((String)input.getName())) {
            if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
                callback.apply((Object)input);
                return Futures.immediateFuture((Object)input);
            }
            if (MinecraftServer.getServer() == null) {
                callback.apply((Object)input);
                return Futures.immediateFuture((Object)input);
            }
            GameProfile profile = (GameProfile)skinCache.getIfPresent((Object)input.getName().toLowerCase(Locale.ROOT));
            if (profile != null && Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null) != null) {
                callback.apply((Object)profile);
                return Futures.immediateFuture((Object)profile);
            }
            Callable<GameProfile> callable = new Callable<GameProfile>(){

                @Override
                public GameProfile call() {
                    final GameProfile profile = (GameProfile)skinCache.getUnchecked((Object)input.getName().toLowerCase(Locale.ROOT));
                    MinecraftServer.getServer().processQueue.add(new Runnable(){

                        @Override
                        public void run() {
                            if (profile == null) {
                                callback.apply((Object)input);
                            } else {
                                callback.apply((Object)profile);
                            }
                        }
                    });
                    return profile;
                }
            };
            if (!sync) return executor.submit(callable);
            try {
                return Futures.immediateFuture((Object)((GameProfile)callable.call()));
            }
            catch (Exception ex) {
                Throwables.throwIfUnchecked((Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        callback.apply((Object)input);
        return Futures.immediateFuture((Object)input);
    }

    @Nullable
    public static GameProfile func_174884_b(@Nullable GameProfile p_174884_0_) {
        return (GameProfile)Futures.getUnchecked(SkullTileEntity.updateGameProfile(p_174884_0_, (Predicate<GameProfile>)Predicates.alwaysTrue(), true));
    }

    static {
        executor = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setNameFormat("Head Conversion Thread - %1$d").build());
        skinCache = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterAccess(60L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, GameProfile>(){

            public GameProfile load(String key) throws Exception {
                final GameProfile[] profiles = new GameProfile[1];
                ProfileLookupCallback gameProfileLookup = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gp) {
                        profiles[0] = gp;
                    }

                    public void onProfileLookupFailed(GameProfile gp, Exception excptn) {
                        profiles[0] = gp;
                    }
                };
                MinecraftServer.getServer().func_152359_aw().findProfilesByNames(new String[]{key}, Agent.MINECRAFT, gameProfileLookup);
                GameProfile profile = profiles[0];
                if (profile == null) {
                    UUID uuid = PlayerEntity.func_146094_a(new GameProfile(null, key));
                    profile = new GameProfile(uuid, key);
                    gameProfileLookup.onProfileLookupSucceeded(profile);
                } else {
                    Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
                    if (property == null) {
                        profile = field_184299_k.fillProfileProperties(profile, true);
                    }
                }
                return profile;
            }
        });
    }
}

