/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StructureBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.Rotation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StructureBlockTileEntity
extends TileEntity {
    private ResourceLocation field_184420_a;
    public String field_184421_f = "";
    public String field_184422_g = "";
    public BlockPos field_184423_h = new BlockPos(0, 1, 0);
    public BlockPos field_184424_i = BlockPos.field_177992_a;
    public Mirror field_184425_j = Mirror.NONE;
    public Rotation field_184426_k = Rotation.NONE;
    public StructureMode field_184427_l = StructureMode.DATA;
    public boolean field_184428_m = true;
    private boolean field_189727_n;
    public boolean field_189728_o;
    public boolean field_189729_p = true;
    public float field_189730_q = 1.0f;
    public long field_189731_r;

    public StructureBlockTileEntity() {
        super(TileEntityType.field_200990_u);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 96.0;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        p_189515_1_.func_74778_a("name", this.func_189715_d());
        p_189515_1_.func_74778_a("author", this.field_184421_f);
        p_189515_1_.func_74778_a("metadata", this.field_184422_g);
        p_189515_1_.func_74768_a("posX", this.field_184423_h.func_177958_n());
        p_189515_1_.func_74768_a("posY", this.field_184423_h.func_177956_o());
        p_189515_1_.func_74768_a("posZ", this.field_184423_h.func_177952_p());
        p_189515_1_.func_74768_a("sizeX", this.field_184424_i.func_177958_n());
        p_189515_1_.func_74768_a("sizeY", this.field_184424_i.func_177956_o());
        p_189515_1_.func_74768_a("sizeZ", this.field_184424_i.func_177952_p());
        p_189515_1_.func_74778_a("rotation", this.field_184426_k.toString());
        p_189515_1_.func_74778_a("mirror", this.field_184425_j.toString());
        p_189515_1_.func_74778_a("mode", this.field_184427_l.toString());
        p_189515_1_.func_74757_a("ignoreEntities", this.field_184428_m);
        p_189515_1_.func_74757_a("powered", this.field_189727_n);
        p_189515_1_.func_74757_a("showair", this.field_189728_o);
        p_189515_1_.func_74757_a("showboundingbox", this.field_189729_p);
        p_189515_1_.func_74776_a("integrity", this.field_189730_q);
        p_189515_1_.func_74772_a("seed", this.field_189731_r);
        return p_189515_1_;
    }

    @Override
    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.func_184404_a(p_230337_2_.func_74779_i("name"));
        this.field_184421_f = p_230337_2_.func_74779_i("author");
        this.field_184422_g = p_230337_2_.func_74779_i("metadata");
        int i = MathHelper.func_76125_a((int)p_230337_2_.func_74762_e("posX"), (int)-48, (int)48);
        int j = MathHelper.func_76125_a((int)p_230337_2_.func_74762_e("posY"), (int)-48, (int)48);
        int k = MathHelper.func_76125_a((int)p_230337_2_.func_74762_e("posZ"), (int)-48, (int)48);
        this.field_184423_h = new BlockPos(i, j, k);
        int l = MathHelper.func_76125_a((int)p_230337_2_.func_74762_e("sizeX"), (int)0, (int)48);
        int i1 = MathHelper.func_76125_a((int)p_230337_2_.func_74762_e("sizeY"), (int)0, (int)48);
        int j1 = MathHelper.func_76125_a((int)p_230337_2_.func_74762_e("sizeZ"), (int)0, (int)48);
        this.field_184424_i = new BlockPos(l, i1, j1);
        try {
            this.field_184426_k = Rotation.valueOf((String)p_230337_2_.func_74779_i("rotation"));
        }
        catch (IllegalArgumentException illegalargumentexception2) {
            this.field_184426_k = Rotation.NONE;
        }
        try {
            this.field_184425_j = Mirror.valueOf((String)p_230337_2_.func_74779_i("mirror"));
        }
        catch (IllegalArgumentException illegalargumentexception1) {
            this.field_184425_j = Mirror.NONE;
        }
        try {
            this.field_184427_l = StructureMode.valueOf((String)p_230337_2_.func_74779_i("mode"));
        }
        catch (IllegalArgumentException illegalargumentexception) {
            this.field_184427_l = StructureMode.DATA;
        }
        this.field_184428_m = p_230337_2_.func_74767_n("ignoreEntities");
        this.field_189727_n = p_230337_2_.func_74767_n("powered");
        this.field_189728_o = p_230337_2_.func_74767_n("showair");
        this.field_189729_p = p_230337_2_.func_74767_n("showboundingbox");
        this.field_189730_q = p_230337_2_.func_74764_b("integrity") ? p_230337_2_.func_74760_g("integrity") : 1.0f;
        this.field_189731_r = p_230337_2_.func_74763_f("seed");
        this.func_189704_J();
    }

    private void func_189704_J() {
        BlockPos blockpos;
        BlockState blockstate;
        if (this.field_145850_b != null && (blockstate = this.field_145850_b.func_180495_p(blockpos = this.func_174877_v())).func_203425_a(Blocks.field_185779_df)) {
            this.field_145850_b.func_180501_a(blockpos, (BlockState)blockstate.func_206870_a(StructureBlock.field_185587_a, this.field_184427_l), 2);
        }
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 7, this.func_189517_E_());
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean func_189701_a(PlayerEntity p_189701_1_) {
        if (!p_189701_1_.func_195070_dx()) {
            return false;
        }
        if (p_189701_1_.func_130014_f_().field_72995_K) {
            p_189701_1_.func_189807_a(this);
        }
        return true;
    }

    public String func_189715_d() {
        return this.field_184420_a == null ? "" : this.field_184420_a.toString();
    }

    public String func_227014_f_() {
        return this.field_184420_a == null ? "" : this.field_184420_a.func_110623_a();
    }

    public boolean func_208404_d() {
        return this.field_184420_a != null;
    }

    public void func_184404_a(@Nullable String p_184404_1_) {
        this.func_210163_a(StringUtils.func_151246_b((String)p_184404_1_) ? null : ResourceLocation.func_208304_a(p_184404_1_));
    }

    public void func_210163_a(@Nullable ResourceLocation p_210163_1_) {
        this.field_184420_a = p_210163_1_;
    }

    public void func_189720_a(LivingEntity p_189720_1_) {
        this.field_184421_f = p_189720_1_.func_200200_C_().getString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos func_189711_e() {
        return this.field_184423_h;
    }

    public void func_184414_b(BlockPos p_184414_1_) {
        this.field_184423_h = p_184414_1_;
    }

    public BlockPos func_189717_g() {
        return this.field_184424_i;
    }

    public void func_184409_c(BlockPos p_184409_1_) {
        this.field_184424_i = p_184409_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Mirror func_189716_h() {
        return this.field_184425_j;
    }

    public void func_184411_a(Mirror p_184411_1_) {
        this.field_184425_j = p_184411_1_;
    }

    public Rotation func_189726_i() {
        return this.field_184426_k;
    }

    public void func_184408_a(Rotation p_184408_1_) {
        this.field_184426_k = p_184408_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_189708_j() {
        return this.field_184422_g;
    }

    public void func_184410_b(String p_184410_1_) {
        this.field_184422_g = p_184410_1_;
    }

    public StructureMode func_189700_k() {
        return this.field_184427_l;
    }

    public void func_184405_a(StructureMode p_184405_1_) {
        this.field_184427_l = p_184405_1_;
        BlockState blockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (blockstate.func_203425_a(Blocks.field_185779_df)) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)blockstate.func_206870_a(StructureBlock.field_185587_a, p_184405_1_), 2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_189724_l() {
        switch (this.func_189700_k()) {
            case SAVE: {
                this.func_184405_a(StructureMode.LOAD);
                break;
            }
            case LOAD: {
                this.func_184405_a(StructureMode.CORNER);
                break;
            }
            case CORNER: {
                this.func_184405_a(StructureMode.DATA);
                break;
            }
            case DATA: {
                this.func_184405_a(StructureMode.SAVE);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_189713_m() {
        return this.field_184428_m;
    }

    public void func_184406_a(boolean p_184406_1_) {
        this.field_184428_m = p_184406_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_189702_n() {
        return this.field_189730_q;
    }

    public void func_189718_a(float p_189718_1_) {
        this.field_189730_q = p_189718_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_189719_o() {
        return this.field_189731_r;
    }

    public void func_189725_a(long p_189725_1_) {
        this.field_189731_r = p_189725_1_;
    }

    public boolean func_184417_l() {
        BlockPos blockpos2;
        if (this.field_184427_l != StructureMode.SAVE) {
            return false;
        }
        BlockPos blockpos = this.func_174877_v();
        int i = 80;
        BlockPos blockpos1 = new BlockPos(blockpos.func_177958_n() - 80, 0, blockpos.func_177952_p() - 80);
        List<StructureBlockTileEntity> list = this.func_184418_a(blockpos1, blockpos2 = new BlockPos(blockpos.func_177958_n() + 80, 255, blockpos.func_177952_p() + 80));
        List<StructureBlockTileEntity> list1 = this.func_184415_a(list);
        if (list1.size() < 1) {
            return false;
        }
        MutableBoundingBox mutableboundingbox = this.func_184416_a(blockpos, list1);
        if (mutableboundingbox.field_78893_d - mutableboundingbox.field_78897_a > 1 && mutableboundingbox.field_78894_e - mutableboundingbox.field_78895_b > 1 && mutableboundingbox.field_78892_f - mutableboundingbox.field_78896_c > 1) {
            this.field_184423_h = new BlockPos(mutableboundingbox.field_78897_a - blockpos.func_177958_n() + 1, mutableboundingbox.field_78895_b - blockpos.func_177956_o() + 1, mutableboundingbox.field_78896_c - blockpos.func_177952_p() + 1);
            this.field_184424_i = new BlockPos(mutableboundingbox.field_78893_d - mutableboundingbox.field_78897_a - 1, mutableboundingbox.field_78894_e - mutableboundingbox.field_78895_b - 1, mutableboundingbox.field_78892_f - mutableboundingbox.field_78896_c - 1);
            this.func_70296_d();
            BlockState blockstate = this.field_145850_b.func_180495_p(blockpos);
            this.field_145850_b.func_184138_a(blockpos, blockstate, blockstate, 3);
            return true;
        }
        return false;
    }

    private List<StructureBlockTileEntity> func_184415_a(List<StructureBlockTileEntity> p_184415_1_) {
        Predicate<StructureBlockTileEntity> predicate = p_200665_1_ -> p_200665_1_.field_184427_l == StructureMode.CORNER && Objects.equals(this.field_184420_a, p_200665_1_.field_184420_a);
        return p_184415_1_.stream().filter(predicate).collect(Collectors.toList());
    }

    private List<StructureBlockTileEntity> func_184418_a(BlockPos p_184418_1_, BlockPos p_184418_2_) {
        ArrayList list = Lists.newArrayList();
        for (BlockPos blockpos : BlockPos.func_218278_a(p_184418_1_, p_184418_2_)) {
            TileEntity tileentity;
            BlockState blockstate = this.field_145850_b.func_180495_p(blockpos);
            if (!blockstate.func_203425_a(Blocks.field_185779_df) || (tileentity = this.field_145850_b.func_175625_s(blockpos)) == null || !(tileentity instanceof StructureBlockTileEntity)) continue;
            list.add((StructureBlockTileEntity)tileentity);
        }
        return list;
    }

    private MutableBoundingBox func_184416_a(BlockPos p_184416_1_, List<StructureBlockTileEntity> p_184416_2_) {
        MutableBoundingBox mutableboundingbox;
        if (p_184416_2_.size() > 1) {
            BlockPos blockpos = p_184416_2_.get(0).func_174877_v();
            mutableboundingbox = new MutableBoundingBox((Vector3i)blockpos, (Vector3i)blockpos);
        } else {
            mutableboundingbox = new MutableBoundingBox((Vector3i)p_184416_1_, (Vector3i)p_184416_1_);
        }
        for (StructureBlockTileEntity structureblocktileentity : p_184416_2_) {
            BlockPos blockpos1 = structureblocktileentity.func_174877_v();
            if (blockpos1.func_177958_n() < mutableboundingbox.field_78897_a) {
                mutableboundingbox.field_78897_a = blockpos1.func_177958_n();
            } else if (blockpos1.func_177958_n() > mutableboundingbox.field_78893_d) {
                mutableboundingbox.field_78893_d = blockpos1.func_177958_n();
            }
            if (blockpos1.func_177956_o() < mutableboundingbox.field_78895_b) {
                mutableboundingbox.field_78895_b = blockpos1.func_177956_o();
            } else if (blockpos1.func_177956_o() > mutableboundingbox.field_78894_e) {
                mutableboundingbox.field_78894_e = blockpos1.func_177956_o();
            }
            if (blockpos1.func_177952_p() < mutableboundingbox.field_78896_c) {
                mutableboundingbox.field_78896_c = blockpos1.func_177952_p();
                continue;
            }
            if (blockpos1.func_177952_p() <= mutableboundingbox.field_78892_f) continue;
            mutableboundingbox.field_78892_f = blockpos1.func_177952_p();
        }
        return mutableboundingbox;
    }

    public boolean func_184419_m() {
        return this.func_189712_b(true);
    }

    public boolean func_189712_b(boolean p_189712_1_) {
        if (this.field_184427_l == StructureMode.SAVE && !this.field_145850_b.field_72995_K && this.field_184420_a != null) {
            Template template;
            BlockPos blockpos = this.func_174877_v().func_177971_a(this.field_184423_h);
            ServerWorld serverworld = (ServerWorld)this.field_145850_b;
            TemplateManager templatemanager = serverworld.func_184163_y();
            try {
                template = templatemanager.func_200220_a(this.field_184420_a);
            }
            catch (ResourceLocationException resourcelocationexception1) {
                return false;
            }
            template.func_186254_a(this.field_145850_b, blockpos, this.field_184424_i, !this.field_184428_m, Blocks.field_189881_dj);
            template.func_186252_a(this.field_184421_f);
            if (p_189712_1_) {
                try {
                    return templatemanager.func_195429_b(this.field_184420_a);
                }
                catch (ResourceLocationException resourcelocationexception) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_242687_a(ServerWorld p_242687_1_) {
        return this.func_242688_a(p_242687_1_, true);
    }

    private static Random func_214074_b(long p_214074_0_) {
        return p_214074_0_ == 0L ? new Random(Util.func_211177_b()) : new Random(p_214074_0_);
    }

    public boolean func_242688_a(ServerWorld p_242688_1_, boolean p_242688_2_) {
        if (this.field_184427_l == StructureMode.LOAD && this.field_184420_a != null) {
            Template template;
            TemplateManager templatemanager = p_242688_1_.func_184163_y();
            try {
                template = templatemanager.func_200219_b(this.field_184420_a);
            }
            catch (ResourceLocationException resourcelocationexception) {
                return false;
            }
            return template == null ? false : this.func_242689_a(p_242688_1_, p_242688_2_, template);
        }
        return false;
    }

    public boolean func_242689_a(ServerWorld p_242689_1_, boolean p_242689_2_, Template p_242689_3_) {
        BlockPos blockpos1;
        boolean flag;
        BlockPos blockpos = this.func_174877_v();
        if (!StringUtils.func_151246_b((String)p_242689_3_.func_186261_b())) {
            this.field_184421_f = p_242689_3_.func_186261_b();
        }
        if (!(flag = this.field_184424_i.equals((Object)(blockpos1 = p_242689_3_.func_186259_a())))) {
            this.field_184424_i = blockpos1;
            this.func_70296_d();
            BlockState blockstate = p_242689_1_.func_180495_p(blockpos);
            p_242689_1_.func_184138_a(blockpos, blockstate, blockstate, 3);
        }
        if (p_242689_2_ && !flag) {
            return false;
        }
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(this.field_184425_j).func_186220_a(this.field_184426_k).func_186222_a(this.field_184428_m).func_186218_a((ChunkPos)null);
        if (this.field_189730_q < 1.0f) {
            placementsettings.func_215219_b().func_215222_a((StructureProcessor)new IntegrityProcessor(MathHelper.func_76131_a((float)this.field_189730_q, (float)0.0f, (float)1.0f))).func_189950_a(StructureBlockTileEntity.func_214074_b(this.field_189731_r));
        }
        BlockPos blockpos2 = blockpos.func_177971_a(this.field_184423_h);
        p_242689_3_.func_237144_a_((IServerWorld)((Object)p_242689_1_), blockpos2, placementsettings, StructureBlockTileEntity.func_214074_b(this.field_189731_r));
        return true;
    }

    public void func_189706_E() {
        if (this.field_184420_a != null) {
            ServerWorld serverworld = (ServerWorld)this.field_145850_b;
            TemplateManager templatemanager = serverworld.func_184163_y();
            templatemanager.func_189941_a(this.field_184420_a);
        }
    }

    public boolean func_189709_F() {
        if (this.field_184427_l == StructureMode.LOAD && !this.field_145850_b.field_72995_K && this.field_184420_a != null) {
            ServerWorld serverworld = (ServerWorld)this.field_145850_b;
            TemplateManager templatemanager = serverworld.func_184163_y();
            try {
                return templatemanager.func_200219_b(this.field_184420_a) != null;
            }
            catch (ResourceLocationException resourcelocationexception) {
                return false;
            }
        }
        return false;
    }

    public boolean func_189722_G() {
        return this.field_189727_n;
    }

    public void func_189723_d(boolean p_189723_1_) {
        this.field_189727_n = p_189723_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_189707_H() {
        return this.field_189728_o;
    }

    public void func_189703_e(boolean p_189703_1_) {
        this.field_189728_o = p_189703_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_189721_I() {
        return this.field_189729_p;
    }

    public void func_189710_f(boolean p_189710_1_) {
        this.field_189729_p = p_189710_1_;
    }

    public static enum UpdateCommand {
        UPDATE_DATA,
        SAVE_AREA,
        LOAD_AREA,
        SCAN_AREA;

    }
}

