/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum Direction implements IStringSerializable
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vector3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vector3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vector3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vector3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vector3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vector3i(1, 0, 0));

    private final int field_176748_g;
    private final int field_176759_h;
    private final int field_176760_i;
    private final String field_176757_j;
    private final Axis field_176758_k;
    private final AxisDirection field_176755_l;
    private final Vector3i field_176756_m;
    private static final Direction[] field_199792_n;
    private static final Map<String, Direction> field_176761_p;
    private static final Direction[] field_82609_l;
    private static final Direction[] field_176754_o;
    private static final Long2ObjectMap<Direction> field_218387_r;

    private Direction(int p_i46016_3_, int p_i46016_4_, int p_i46016_5_, String p_i46016_6_, AxisDirection p_i46016_7_, Axis p_i46016_8_, Vector3i p_i46016_9_) {
        this.field_176748_g = p_i46016_3_;
        this.field_176760_i = p_i46016_5_;
        this.field_176759_h = p_i46016_4_;
        this.field_176757_j = p_i46016_6_;
        this.field_176758_k = p_i46016_8_;
        this.field_176755_l = p_i46016_7_;
        this.field_176756_m = p_i46016_9_;
    }

    public static Direction[] func_196054_a(Entity p_196054_0_) {
        Direction direction2;
        float f = p_196054_0_.func_195050_f(1.0f) * ((float)Math.PI / 180);
        float f1 = -p_196054_0_.func_195046_g(1.0f) * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76126_a((float)f);
        float f3 = MathHelper.func_76134_b((float)f);
        float f4 = MathHelper.func_76126_a((float)f1);
        float f5 = MathHelper.func_76134_b((float)f1);
        boolean flag = f4 > 0.0f;
        boolean flag1 = f2 < 0.0f;
        boolean flag2 = f5 > 0.0f;
        float f6 = flag ? f4 : -f4;
        float f7 = flag1 ? -f2 : f2;
        float f8 = flag2 ? f5 : -f5;
        float f9 = f6 * f3;
        float f10 = f8 * f3;
        Direction direction = flag ? EAST : WEST;
        Direction direction1 = flag1 ? UP : DOWN;
        Direction direction3 = direction2 = flag2 ? SOUTH : NORTH;
        if (f6 > f8) {
            if (f7 > f9) {
                return Direction.func_196053_a(direction1, direction, direction2);
            }
            return f10 > f7 ? Direction.func_196053_a(direction, direction2, direction1) : Direction.func_196053_a(direction, direction1, direction2);
        }
        if (f7 > f10) {
            return Direction.func_196053_a(direction1, direction2, direction);
        }
        return f9 > f7 ? Direction.func_196053_a(direction2, direction, direction1) : Direction.func_196053_a(direction2, direction1, direction);
    }

    private static Direction[] func_196053_a(Direction p_196053_0_, Direction p_196053_1_, Direction p_196053_2_) {
        return new Direction[]{p_196053_0_, p_196053_1_, p_196053_2_, p_196053_2_.func_176734_d(), p_196053_1_.func_176734_d(), p_196053_0_.func_176734_d()};
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Direction func_229385_a_(Matrix4f p_229385_0_, Direction p_229385_1_) {
        Vector3i vector3i = p_229385_1_.func_176730_m();
        Vector4f vector4f = new Vector4f(vector3i.func_177958_n(), vector3i.func_177956_o(), vector3i.func_177952_p(), 0.0f);
        vector4f.func_229372_a_(p_229385_0_);
        return Direction.func_176737_a(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Quaternion func_229384_a_() {
        Quaternion quaternion = Vector3f.field_229179_b_.func_229187_a_(90.0f);
        switch (this) {
            case DOWN: {
                return Vector3f.field_229179_b_.func_229187_a_(180.0f);
            }
            case UP: {
                return Quaternion.field_227060_a_.func_227068_g_();
            }
            case NORTH: {
                quaternion.func_195890_a(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                return quaternion;
            }
            case SOUTH: {
                return quaternion;
            }
            case WEST: {
                quaternion.func_195890_a(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                return quaternion;
            }
        }
        quaternion.func_195890_a(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
        return quaternion;
    }

    public int func_176745_a() {
        return this.field_176748_g;
    }

    public int func_176736_b() {
        return this.field_176760_i;
    }

    public AxisDirection func_176743_c() {
        return this.field_176755_l;
    }

    public Direction func_176734_d() {
        return Direction.func_82600_a(this.field_176759_h);
    }

    public Direction func_176746_e() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
            case EAST: {
                return SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + this);
    }

    public Direction func_176735_f() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
            case EAST: {
                return NORTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + this);
    }

    public int func_82601_c() {
        return this.field_176756_m.func_177958_n();
    }

    public int func_96559_d() {
        return this.field_176756_m.func_177956_o();
    }

    public int func_82599_e() {
        return this.field_176756_m.func_177952_p();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3f func_229386_k_() {
        return new Vector3f(this.func_82601_c(), this.func_96559_d(), this.func_82599_e());
    }

    public String func_176742_j() {
        return this.field_176757_j;
    }

    public Axis func_176740_k() {
        return this.field_176758_k;
    }

    @Nullable
    public static Direction func_176739_a(@Nullable String p_176739_0_) {
        return p_176739_0_ == null ? null : field_176761_p.get(p_176739_0_.toLowerCase(Locale.ROOT));
    }

    public static Direction func_82600_a(int p_82600_0_) {
        return field_82609_l[MathHelper.func_76130_a((int)(p_82600_0_ % field_82609_l.length))];
    }

    public static Direction func_176731_b(int p_176731_0_) {
        return field_176754_o[MathHelper.func_76130_a((int)(p_176731_0_ % field_176754_o.length))];
    }

    @Nullable
    public static Direction func_218383_a(int p_218383_0_, int p_218383_1_, int p_218383_2_) {
        return (Direction)((Object)field_218387_r.get(BlockPos.func_218276_a(p_218383_0_, p_218383_1_, p_218383_2_)));
    }

    public static Direction func_176733_a(double p_176733_0_) {
        return Direction.func_176731_b(MathHelper.func_76128_c((double)(p_176733_0_ / 90.0 + 0.5)) & 3);
    }

    public static Direction func_211699_a(Axis p_211699_0_, AxisDirection p_211699_1_) {
        switch (p_211699_0_) {
            case X: {
                return p_211699_1_ == AxisDirection.POSITIVE ? EAST : WEST;
            }
            case Y: {
                return p_211699_1_ == AxisDirection.POSITIVE ? UP : DOWN;
            }
        }
        return p_211699_1_ == AxisDirection.POSITIVE ? SOUTH : NORTH;
    }

    public float func_185119_l() {
        return (this.field_176760_i & 3) * 90;
    }

    public static Direction func_239631_a_(Random p_239631_0_) {
        return Util.func_240989_a_(field_199792_n, p_239631_0_);
    }

    public static Direction func_210769_a(double p_210769_0_, double p_210769_2_, double p_210769_4_) {
        return Direction.func_176737_a((float)p_210769_0_, (float)p_210769_2_, (float)p_210769_4_);
    }

    public static Direction func_176737_a(float p_176737_0_, float p_176737_1_, float p_176737_2_) {
        Direction direction = NORTH;
        float f = Float.MIN_VALUE;
        for (Direction direction1 : field_199792_n) {
            float f1 = p_176737_0_ * (float)direction1.field_176756_m.func_177958_n() + p_176737_1_ * (float)direction1.field_176756_m.func_177956_o() + p_176737_2_ * (float)direction1.field_176756_m.func_177952_p();
            if (!(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }

    public String toString() {
        return this.field_176757_j;
    }

    public String func_176610_l() {
        return this.field_176757_j;
    }

    public static Direction func_181076_a(AxisDirection p_181076_0_, Axis p_181076_1_) {
        for (Direction direction : field_199792_n) {
            if (direction.func_176743_c() != p_181076_0_ || direction.func_176740_k() != p_181076_1_) continue;
            return direction;
        }
        throw new IllegalArgumentException("No such direction: " + p_181076_0_ + " " + p_181076_1_);
    }

    public Vector3i func_176730_m() {
        return this.field_176756_m;
    }

    public boolean func_243532_a(float p_243532_1_) {
        float f = p_243532_1_ * ((float)Math.PI / 180);
        float f1 = -MathHelper.func_76126_a((float)f);
        float f2 = MathHelper.func_76134_b((float)f);
        return (float)this.field_176756_m.func_177958_n() * f1 + (float)this.field_176756_m.func_177952_p() * f2 > 0.0f;
    }

    static {
        field_199792_n = Direction.values();
        field_176761_p = Arrays.stream(field_199792_n).collect(Collectors.toMap(Direction::func_176742_j, p_199787_0_ -> p_199787_0_));
        field_82609_l = (Direction[])Arrays.stream(field_199792_n).sorted(Comparator.comparingInt(p_199790_0_ -> p_199790_0_.field_176748_g)).toArray(Direction[]::new);
        field_176754_o = (Direction[])Arrays.stream(field_199792_n).filter(p_199786_0_ -> p_199786_0_.func_176740_k().func_176722_c()).sorted(Comparator.comparingInt(p_199789_0_ -> p_199789_0_.field_176760_i)).toArray(Direction[]::new);
        field_218387_r = (Long2ObjectMap)Arrays.stream(field_199792_n).collect(Collectors.toMap(p_218385_0_ -> new BlockPos(p_218385_0_.func_176730_m()).func_218275_a(), p_218384_0_ -> p_218384_0_, (p_218386_0_, p_218386_1_) -> {
            throw new IllegalArgumentException("Duplicate keys");
        }, Long2ObjectOpenHashMap::new));
    }

    public static enum Plane implements Iterable<Direction>,
    Predicate<Direction>
    {
        HORIZONTAL(new Direction[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z}),
        VERTICAL(new Direction[]{UP, DOWN}, new Axis[]{Axis.Y});

        private final Direction[] field_209387_c;
        private final Axis[] field_209388_d;

        private Plane(Direction[] p_i49393_3_, Axis[] p_i49393_4_) {
            this.field_209387_c = p_i49393_3_;
            this.field_209388_d = p_i49393_4_;
        }

        public Direction func_179518_a(Random p_179518_1_) {
            return Util.func_240989_a_(this.field_209387_c, p_179518_1_);
        }

        public Axis func_244803_b(Random p_244803_1_) {
            return Util.func_240989_a_(this.field_209388_d, p_244803_1_);
        }

        @Override
        public boolean test(@Nullable Direction p_test_1_) {
            return p_test_1_ != null && p_test_1_.func_176740_k().func_176716_d() == this;
        }

        @Override
        public Iterator<Direction> iterator() {
            return Iterators.forArray((Object[])this.field_209387_c);
        }

        public Stream<Direction> func_239636_a_() {
            return Arrays.stream(this.field_209387_c);
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int field_179528_c;
        private final String field_179525_d;

        private AxisDirection(int p_i46014_3_, String p_i46014_4_) {
            this.field_179528_c = p_i46014_3_;
            this.field_179525_d = p_i46014_4_;
        }

        public int func_179524_a() {
            return this.field_179528_c;
        }

        public String toString() {
            return this.field_179525_d;
        }

        public AxisDirection func_239635_c_() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }
    }

    public static enum Axis implements IStringSerializable,
    Predicate<Direction>
    {
        X("x"){

            @Override
            public int func_196052_a(int p_196052_1_, int p_196052_2_, int p_196052_3_) {
                return p_196052_1_;
            }

            @Override
            public double func_196051_a(double p_196051_1_, double p_196051_3_, double p_196051_5_) {
                return p_196051_1_;
            }
        }
        ,
        Y("y"){

            @Override
            public int func_196052_a(int p_196052_1_, int p_196052_2_, int p_196052_3_) {
                return p_196052_2_;
            }

            @Override
            public double func_196051_a(double p_196051_1_, double p_196051_3_, double p_196051_5_) {
                return p_196051_3_;
            }
        }
        ,
        Z("z"){

            @Override
            public int func_196052_a(int p_196052_1_, int p_196052_2_, int p_196052_3_) {
                return p_196052_3_;
            }

            @Override
            public double func_196051_a(double p_196051_1_, double p_196051_3_, double p_196051_5_) {
                return p_196051_5_;
            }
        };

        private static final Axis[] field_239633_e_;
        public static final Codec<Axis> field_239632_d_;
        private static final Map<String, Axis> field_176725_d;
        private final String field_176726_e;

        private Axis(String p_i49394_3_) {
            this.field_176726_e = p_i49394_3_;
        }

        @Nullable
        public static Axis func_176717_a(String p_176717_0_) {
            return field_176725_d.get(p_176717_0_.toLowerCase(Locale.ROOT));
        }

        public String func_176719_a() {
            return this.field_176726_e;
        }

        public boolean func_200128_b() {
            return this == Y;
        }

        public boolean func_176722_c() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.field_176726_e;
        }

        public static Axis func_239634_a_(Random p_239634_0_) {
            return Util.func_240989_a_(field_239633_e_, p_239634_0_);
        }

        @Override
        public boolean test(@Nullable Direction p_test_1_) {
            return p_test_1_ != null && p_test_1_.func_176740_k() == this;
        }

        public Plane func_176716_d() {
            switch (this) {
                case X: 
                case Z: {
                    return Plane.HORIZONTAL;
                }
                case Y: {
                    return Plane.VERTICAL;
                }
            }
            throw new Error("Someone's been tampering with the universe!");
        }

        public String func_176610_l() {
            return this.field_176726_e;
        }

        public abstract int func_196052_a(int var1, int var2, int var3);

        public abstract double func_196051_a(double var1, double var3, double var5);

        static {
            field_239633_e_ = Axis.values();
            field_239632_d_ = IStringSerializable.func_233023_a_(Axis::values, Axis::func_176717_a);
            field_176725_d = Arrays.stream(field_239633_e_).collect(Collectors.toMap(Axis::func_176719_a, p_199785_0_ -> p_199785_0_));
        }
    }
}

